/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7134;
import net.minecraft.class_7142;
import net.minecraft.class_7225;
import net.minecraft.class_7919;
import net.minecraft.class_7924;
import net.minecraft.class_8000;
import net.minecraft.class_8100;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.FlatWorldLayerSelector;
import wily.legacy.client.screen.LegacyFlatPresetsScreen;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyFlatWorldScreen
extends PanelVListScreen
implements ControlTooltip.Event {
    public final int maxOverworldHeight;
    protected List<class_5481> tooltipBoxLabel;
    private final Consumer<class_3232> applySettings;
    protected final class_8100 uiState;
    class_3232 generator;
    protected final TabList tabList;
    protected final RenderableVList displayLayers;
    protected final RenderableVList displayBiomes;
    protected final RenderableVList displayProperties;
    protected final List<class_6880<class_7059>> structuresOverrides;
    protected LayerButton movingLayer;

    public LegacyFlatWorldScreen(class_437 screen, class_8100 uiState, class_7225.class_7226<class_1959> biomeGetter, class_7225.class_7226<class_7059> structureGetter, Consumer<class_3232> consumer, class_3232 flatLevelGeneratorSettings) {
        super((class_437 s) -> Panel.createPanel(s, p -> p.appearance(282, Math.min(s.field_22790 - 48, 248)), p -> p.pos((s.field_22789 - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((class_437)s)) ? 194 : 0))) / 2, p.centeredTopPos((class_437)s))), (class_2561)class_2561.method_43471((String)"createWorld.customize.flat.title"));
        class_437 class_4372;
        this.tabList = new TabList(this.accessor).add(30, LegacyTabButton.Type.LEFT, (class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.layers"), b -> this.method_41843()).add(30, LegacyTabButton.Type.MIDDLE, (class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.biomes"), b -> this.method_41843()).add(30, LegacyTabButton.Type.RIGHT, (class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.properties"), b -> this.method_41843());
        this.displayLayers = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayBiomes = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayProperties = new RenderableVList(this.accessor);
        class_437 class_4373 = class_310.method_1551().field_1755;
        if (class_4373 instanceof WorldMoreOptionsScreen) {
            WorldMoreOptionsScreen s2 = (WorldMoreOptionsScreen)class_4373;
            class_4372 = s2;
        } else {
            class_4372 = screen;
        }
        this.parent = class_4372;
        this.uiState = uiState;
        this.applySettings = consumer;
        this.generator = flatLevelGeneratorSettings;
        this.maxOverworldHeight = uiState.method_48728().method_45689().method_30530(class_7924.field_41241).method_46746(class_7134.field_37666).map(l -> ((class_2874)l.comp_349()).comp_652()).orElse(384);
        this.structuresOverrides = new ArrayList(((class_6885)this.generator.method_41139().orElse(class_6885.method_40246((class_6880[])new class_6880[0]))).method_40239().toList());
        this.generator.method_14327().forEach(this::addLayer);
        biomeGetter.method_42017().forEach(this::addBiome);
        structureGetter.method_42017().forEach(this::addStructure);
        this.renderableVLists.clear();
        this.renderableVLists.add(this.displayLayers);
        this.renderableVLists.add(this.displayBiomes);
        this.renderableVLists.add(this.displayProperties);
        this.displayProperties.addRenderable((class_4068)new TickBox(0, 0, 260, 12, this.generator.field_24976, b -> LegacyComponents.DECORATIONS, b -> null, b -> {
            this.generator.field_24976 = b.selected;
        }));
        this.displayProperties.addRenderable((class_4068)new TickBox(0, 0, 260, 12, this.generator.field_24977, b -> LegacyComponents.LAVA_LAKES, b -> null, b -> {
            this.generator.field_24977 = b.selected;
        }));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.movingLayer != null || this.tabList.selectedTab != 0 || this.method_25399() == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()), () -> LegacyComponents.MOVE_LAYER).add(() -> this.movingLayer != null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> LegacyComponents.PRESETS).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> this.movingLayer != null ? null : LegacyComponents.SELECT_TAB).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(266) : ControllerBinding.LEFT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_UP).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(267) : ControllerBinding.RIGHT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_DOWN).addCompound(() -> {
            ControlTooltip.Icon[] iconArray;
            if (ControlType.getActiveType().isKbm()) {
                ControlTooltip.Icon[] iconArray2 = new ControlTooltip.Icon[3];
                iconArray2[0] = ControlTooltip.getKeyIcon(265);
                iconArray2[1] = ControlTooltip.SPACE_ICON;
                iconArray = iconArray2;
                iconArray2[2] = ControlTooltip.getKeyIcon(264);
            } else {
                ControlTooltip.Icon[] iconArray3 = new ControlTooltip.Icon[1];
                iconArray = iconArray3;
                iconArray3[0] = ControllerBinding.LEFT_STICK.getIcon();
            }
            return iconArray;
        }, () -> this.movingLayer == null ? null : LegacyComponents.MOVE_UP_DOWN);
    }

    public void addStructure(class_6880.class_6883<class_7059> structure) {
        ArrayList<class_2561> descr = new ArrayList<class_2561>();
        String nameKey = "structure." + structure.method_40237().method_29177().method_42094();
        String descriptionKey = nameKey + ".description";
        if (LegacyTipManager.hasTip(nameKey)) {
            descr.add((class_2561)class_2561.method_43471((String)nameKey));
        }
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((class_2561)class_2561.method_43471((String)descriptionKey));
        }
        MultilineTooltip t = descr.isEmpty() ? null : new MultilineTooltip(descr, 182);
        this.displayProperties.addRenderable((class_4068)new TickBox(0, 0, 260, 12, this.structuresOverrides.contains(structure), b -> descr.isEmpty() ? class_2561.method_43471((String)nameKey) : (class_2561)descr.get(0), b -> t, b -> {
            if (b.selected) {
                this.structuresOverrides.add((class_6880<class_7059>)structure);
            } else {
                this.structuresOverrides.remove(structure);
            }
        }));
    }

    public void addBiome(final class_6880.class_6883<class_1959> biome) {
        class_4264 b = new class_4264(0, 0, 260, 30, (class_2561)class_2561.method_43471((String)("biome." + biome.method_40237().method_29177().method_42094()))){

            public void method_25306() {
                LegacyFlatWorldScreen.this.generator.field_14081 = biome;
            }

            protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
                super.method_48579(guiGraphics, i, j, f);
                class_1799 s = LegacyBiomeOverride.getOrDefault(biome.method_40230()).icon();
                if (!s.method_7960()) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_46416((float)(this.method_46426() + 26), (float)(this.method_46427() + 5), 0.0f);
                    guiGraphics.method_51448().method_22905(1.25f, 1.25f, 1.25f);
                    guiGraphics.method_51427(s, 0, 0);
                    guiGraphics.method_51448().method_22909();
                }
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(TickBox.SPRITES[this.method_25367() ? 1 : 0], this.method_46426() + 6, this.method_46427() + (this.field_22759 - 12) / 2, 12, 12);
                if (LegacyFlatWorldScreen.this.generator.field_14081 == biome) {
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(TickBox.TICK, this.method_46426() + 6, this.method_46427() + (this.field_22759 - 12) / 2, 14, 12);
                }
                FactoryScreenUtil.disableBlend();
            }

            protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
                int k = this.method_46426() + 54;
                int l = this.method_46426() + this.method_25368();
                ScreenUtil.renderScrollingString(guiGraphics, font, this.method_25369(), k, this.method_46427(), l, this.method_46427() + this.method_25364(), j, true);
            }

            protected void method_47399(class_6382 narrationElementOutput) {
                this.method_37021(narrationElementOutput);
            }
        };
        this.displayBiomes.addRenderable((class_4068)b);
        ArrayList<class_2561> descr = new ArrayList<class_2561>();
        descr.add(b.method_25369());
        String descriptionKey = "biome." + biome.method_40237().method_29177().method_42094() + ".description";
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((class_2561)class_2561.method_43471((String)descriptionKey));
        }
        b.method_47400((class_7919)new MultilineTooltip(descr, 182));
    }

    public void addLayer(class_3229 flatLayerInfo) {
        this.addLayer(flatLayerInfo, 0);
    }

    public void addLayer(class_3229 flatLayerInfo, int index) {
        this.displayLayers.renderables.add(index, (class_4068)new LayerButton(0, 0, 270, 30, flatLayerInfo));
    }

    public int getAllLayersHeight() {
        int height = 0;
        for (class_4068 renderable : this.displayLayers.renderables) {
            if (!(renderable instanceof LayerButton)) continue;
            LayerButton layerButton = (LayerButton)renderable;
            height += layerButton.flatLayerInfo.method_14289();
        }
        return height;
    }

    public void removeLayer(int index) {
        this.displayLayers.renderables.remove(index);
    }

    public void switchLayers(class_4264 selected, class_4264 aimPlace) {
        int selectedIndex = this.displayLayers.renderables.indexOf(selected);
        int aimIndex = this.displayLayers.renderables.indexOf(aimPlace);
        this.displayLayers.renderables.set(aimIndex, (class_4068)selected);
        this.displayLayers.renderables.set(selectedIndex, (class_4068)aimPlace);
        this.method_48640();
        ScreenUtil.playSimpleUISound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
    }

    public void method_47412(class_7919 tooltip, class_8000 clientTooltipPositioner, boolean bl) {
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBoxLabel = tooltip.method_47405(this.field_22787);
        } else {
            super.method_47412(tooltip, clientTooltipPositioner, bl);
        }
    }

    public class_3232 settings() {
        return this.generator;
    }

    public void setPreset(class_3232 flatLevelGeneratorSettings) {
        this.generator = flatLevelGeneratorSettings;
        this.displayLayers.renderables.clear();
        this.generator.method_14327().forEach(this::addLayer);
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void method_25426() {
        if (this.movingLayer != null && this.tabList.selectedTab != 0) {
            this.tabList.selectedTab = 0;
        }
        this.method_37060((guiGraphics, i, j, f) -> {
            if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
                class_339 w;
                class_364 patt0$temp;
                if (this.tooltipBoxLabel != null && this.method_19355(i, j).map(g -> {
                    class_7919 class_79192;
                    if (g instanceof class_339) {
                        class_339 w = (class_339)g;
                        class_79192 = w.method_51254();
                    } else {
                        class_79192 = null;
                    }
                    return class_79192;
                }).isEmpty() && (!((patt0$temp = this.method_25399()) instanceof class_339) || (w = (class_339)patt0$temp).method_51254() == null)) {
                    this.tooltipBoxLabel = null;
                }
                ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + this.panel.width - 2, this.panel.y + 5, 194, this.panel.height - 10);
                if (this.tooltipBoxLabel != null) {
                    this.tooltipBoxLabel.forEach(c -> guiGraphics.method_35720(this.field_22793, c, this.panel.x + this.panel.width + 3, this.panel.y + 13 + 12 * this.tooltipBoxLabel.indexOf(c), 0xFFFFFF));
                }
            }
        });
        this.method_37063(this.tabList);
        super.method_25426();
        this.tabList.init(this.panel.x, this.panel.y - 24, this.panel.width);
        this.generator.method_14330();
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.method_37060((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 22);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.tabList.selectedTab);
    }

    @Override
    public boolean method_25401(double d, double e, double f, double g) {
        this.getRenderableVList().mouseScrolled(g);
        return super.method_25401(d, e, f, g);
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
        class_4264 b2;
        class_364 class_3642;
        super.method_25395(guiEventListener);
        if (this.movingLayer != null && (class_3642 = this.method_25399()) instanceof class_4264 && this.displayLayers.renderables.contains(b2 = (class_4264)class_3642) && this.method_25399() != this.movingLayer) {
            super.method_25395((class_364)this.movingLayer);
            this.switchLayers(this.movingLayer, b2);
        }
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.movingLayer == null) {
            if (this.tabList.controlTab(i)) {
                return true;
            }
            if (i == 79) {
                this.field_22787.method_1507((class_437)new LegacyFlatPresetsScreen((class_437)this, (class_7225.class_7226<class_7142>)this.uiState.method_48728().method_45689().method_30530(class_7924.field_41242), this.uiState.method_48728().comp_1030().comp_1011(), f -> this.setPreset(((class_7142)f.comp_349()).comp_560())));
            }
        }
        return super.method_25404(i, j, k);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.generator.method_14327().clear();
        this.displayLayers.renderables.forEach(r -> {
            if (r instanceof LayerButton) {
                LayerButton l = (LayerButton)r;
                this.generator.method_14327().add(0, l.flatLayerInfo);
            }
        });
        this.generator.method_14330();
        this.applySettings.accept(this.generator);
        this.generator.field_37145 = Optional.of(class_6885.method_40242(this.structuresOverrides));
    }

    public class LayerButton
    extends class_4264
    implements ControlTooltip.ActionHolder {
        public final class_3229 flatLayerInfo;

        public LayerButton(int i, int j, int k, int l, class_3229 flatLayerInfo) {
            super(i, j, k, l, (class_2561)flatLayerInfo.method_14286().method_26204().method_9518());
            this.flatLayerInfo = flatLayerInfo;
            class_1799 s = flatLayerInfo.method_14286().method_26204().method_8389().method_7854();
            ArrayList<class_2561> descr = new ArrayList<class_2561>();
            descr.add(this.method_25369());
            if (LegacyTipManager.hasTip(s)) {
                descr.add(ControlTooltip.SPACE);
                descr.add(LegacyTipManager.getTipComponent(s));
            }
            this.method_47400(new MultilineTooltip(descr, 182));
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            super.method_48579(guiGraphics, i, j, f);
            class_327 class_3272 = LegacyFlatWorldScreen.this.field_22793;
            class_5250 class_52502 = class_2561.method_43469((String)"legacy.menu.create_flat_world.layer_count", (Object[])new Object[]{this.flatLayerInfo.method_14289()});
            int n = this.method_46426() + 12;
            int n2 = this.method_46427() + 1;
            Objects.requireNonNull(LegacyFlatWorldScreen.this.field_22793);
            guiGraphics.method_27535(class_3272, (class_2561)class_52502, n, n2 + (this.field_22759 - 9) / 2, 0xFFFFFF);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(this.method_46426() + 39), (float)(this.method_46427() + 5), 0.0f);
            guiGraphics.method_51448().method_22905(1.25f, 1.25f, 1.25f);
            guiGraphics.method_51427(this.flatLayerInfo.method_14286().method_26204().method_8389().method_7854(), 0, 0);
            guiGraphics.method_51448().method_22909();
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            int k = this.method_46426() + 67;
            int l = this.method_46426() + this.method_25368();
            ScreenUtil.renderScrollingString(guiGraphics, font, this.method_25369(), k, this.method_46427(), l, this.method_46427() + this.method_25364(), j, true);
        }

        public void method_25365(boolean bl) {
            if (bl && LegacyFlatWorldScreen.this.movingLayer != null && LegacyFlatWorldScreen.this.movingLayer != this) {
                return;
            }
            super.method_25365(bl);
        }

        public boolean method_25404(int i, int j, int k) {
            if (i == 88) {
                LegacyFlatWorldScreen.this.movingLayer = this;
                return true;
            }
            return super.method_25404(i, j, k);
        }

        public void method_25306() {
            if (LegacyFlatWorldScreen.this.movingLayer != null) {
                if (this.method_25370()) {
                    LegacyFlatWorldScreen.this.movingLayer = null;
                }
                return;
            }
            final int allHeight = LegacyFlatWorldScreen.this.getAllLayersHeight();
            Legacy4J.LOGGER.warn((Object)allHeight);
            final int layerIndex = LegacyFlatWorldScreen.this.displayLayers.renderables.indexOf(this);
            LegacyFlatWorldScreen.this.field_22787.method_1507((class_437)new ConfirmationScreen(LegacyFlatWorldScreen.this, 230, 120, LegacyComponents.LAYER_OPTIONS, LegacyComponents.LAYER_MESSAGE, b -> {}){

                @Override
                protected void addButtons() {
                    this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.edit_layer"), b -> this.field_22787.method_1507((class_437)new FlatWorldLayerSelector(LegacyFlatWorldScreen.this, LayerButton.this.flatLayerInfo, f -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex);
                    }, LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight + LayerButton.this.flatLayerInfo.method_14289(), (class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.edit_layer")))).method_46434(this.panel.x + 15, this.panel.y + this.panel.height - 74, 200, 20).method_46431());
                    class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.add_layer"), b -> this.field_22787.method_1507((class_437)new FlatWorldLayerSelector((class_437)LegacyFlatWorldScreen.this, f -> LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex), LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight, (class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.add_layer")))).method_46434(this.panel.x + 15, this.panel.y + this.panel.height - 52, 200, 20).method_46431();
                    if (allHeight >= LegacyFlatWorldScreen.this.maxOverworldHeight) {
                        addButton.field_22763 = false;
                    }
                    this.renderableVList.addRenderable((class_4068)addButton);
                    this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.create_flat_world.delete_layer"), b -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        this.method_25419();
                    }).method_46434(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).method_46431());
                }
            });
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        @Override
        @Nullable
        public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 ? (LegacyFlatWorldScreen.this.movingLayer != null ? LegacyComponents.PLACE : LegacyComponents.LAYER_OPTIONS) : null);
        }
    }
}

