/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_642;
import net.minecraft.class_7532;
import net.minecraft.class_8573;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.screen.JoinGameScreen;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class FriendsServerRenderableList
extends ServerRenderableList {
    boolean ping = false;
    protected final FriendsListUpdate friendsListUpdate = friends -> this.updateServers();

    public FriendsServerRenderableList(UIAccessor accessor) {
        super(accessor);
    }

    @Override
    public void added() {
        WorldHost.ONLINE_FRIEND_UPDATES.add(this.friendsListUpdate);
    }

    @Override
    public void removed() {
        super.removed();
        WorldHost.ONLINE_FRIEND_UPDATES.remove(this.friendsListUpdate);
    }

    @Override
    public boolean hasOnlineFriends() {
        return !WorldHost.ONLINE_FRIENDS.isEmpty();
    }

    @Override
    public void updateLANServers() {
        if (!this.ping) {
            WorldHost.pingFriends();
            this.ping = true;
        }
        super.updateLANServers();
        class_156.method_18349().execute(() -> {
            WorldHost.ONLINE_FRIENDS.forEach((uuid, id) -> {
                final GameProfile profile = WorldHost.fetchProfile((MinecraftSessionService)this.minecraft.method_1495(), (UUID)uuid);
                class_4264 onlineButton = new class_4264(0, 0, 270, 30, (class_2561)class_2561.method_43470((String)profile.getName()), (OnlineFriend)id){
                    final class_642 serverData;
                    final class_8573 icon;
                    private byte @Nullable [] lastIconBytes;
                    final /* synthetic */ OnlineFriend val$id;
                    {
                        this.val$id = onlineFriend;
                        super(i, j, k, l, component);
                        this.serverData = new class_642("", "", class_642.class_8678.field_45611);
                        this.icon = class_8573.method_52202((class_1060)FriendsServerRenderableList.this.minecraft.method_1531(), (String)this.serverData.field_3761);
                    }

                    private boolean uploadServerIcon(@Nullable byte[] bs) {
                        if (bs == null) {
                            this.icon.method_52198();
                        } else {
                            try {
                                this.icon.method_52199(class_1011.method_49277((byte[])bs));
                            }
                            catch (Throwable throwable) {
                                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.field_3752, this.serverData.field_3761, throwable});
                                return false;
                            }
                        }
                        return true;
                    }

                    protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
                        ScreenUtil.renderScrollingString(guiGraphics, font, this.method_25369(), this.method_46426() + 35, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), j, true);
                    }

                    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float f) {
                        super.method_48579(guiGraphics, mouseX, mouseY, f);
                        this.updateServerInfo();
                        byte[] bs = this.serverData.method_49306();
                        if (!Arrays.equals(bs, this.lastIconBytes)) {
                            if (this.uploadServerIcon(bs)) {
                                this.lastIconBytes = bs;
                            } else {
                                this.serverData.method_49305(null);
                            }
                        }
                        if (this.serverData.method_49306() == null) {
                            class_7532.method_52722((class_332)guiGraphics, (class_8685)FriendsServerRenderableList.this.minecraft.method_1582().method_52862(profile), (int)(this.method_46426() + 5), (int)(this.method_46427() + 5), (int)20);
                        } else {
                            ServerRenderableList.drawIcon(guiGraphics, this.method_46426(), this.method_46427(), this.icon.method_52201());
                        }
                        if (((Boolean)((FriendsServerRenderableList)FriendsServerRenderableList.this).minecraft.field_1690.method_42446().method_41753()).booleanValue() || this.field_22762) {
                            guiGraphics.method_25294(this.method_46426() + 5, this.method_46427() + 5, this.method_46426() + 25, this.method_46427() + 25, -1601138544);
                            int u = mouseX - this.method_46426();
                            FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(u < 30 && u > 5 ? LegacySprites.JOIN_HIGHLIGHTED : LegacySprites.JOIN, this.method_46426(), this.method_46427(), 32, 32);
                        }
                    }

                    public void method_25306() {
                        if (this.method_25370()) {
                            FriendsServerRenderableList.this.minecraft.method_1507((class_437)new JoinGameScreen(FriendsServerRenderableList.this.getScreen(), this.serverData, b -> {
                                WorldHost.LOGGER.info("Requesting to join {}", (Object)profile.getId());
                                if (WorldHost.protoClient != null) {
                                    this.val$id.joinWorld(FriendsServerRenderableList.this.getScreen());
                                }
                            }));
                        }
                    }

                    private void updateServerInfo() {
                        this.serverData.field_3752 = profile.getName();
                        class_2926 metadata = (class_2926)WorldHost.ONLINE_FRIEND_PINGS.get(profile.getId());
                        if (metadata == null) {
                            this.serverData.field_3753 = class_2561.method_43473();
                            this.serverData.field_3757 = class_2561.method_43473();
                            return;
                        }
                        this.serverData.field_3757 = metadata.comp_1273();
                        metadata.comp_1275().ifPresentOrElse(version -> {
                            this.serverData.field_3760 = class_2561.method_43470((String)version.comp_1282());
                            this.serverData.field_3756 = version.comp_1283();
                        }, () -> {
                            this.serverData.field_3760 = class_2561.method_43471((String)"multiplayer.status.old");
                            this.serverData.field_3756 = 0;
                        });
                        metadata.comp_1274().ifPresentOrElse(players -> {
                            this.serverData.field_3753 = class_2561.method_43469((String)"multiplayer.status.player_count", (Object[])new Object[]{class_2561.method_43470((String)("" + players.comp_1280())).method_27692(class_124.field_1080), class_2561.method_43470((String)("" + players.comp_1279())).method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
                            this.serverData.field_41861 = players;
                            if (!players.comp_1281().isEmpty()) {
                                ArrayList<class_5250> playerList = new ArrayList<class_5250>(players.comp_1281().size());
                                for (GameProfile gameProfile : players.comp_1281()) {
                                    playerList.add(class_2561.method_43470((String)gameProfile.getName()));
                                }
                                if (players.comp_1281().size() < players.comp_1280()) {
                                    playerList.add(class_2561.method_43469((String)"multiplayer.status.and_more", (Object[])new Object[]{players.comp_1280() - players.comp_1281().size()}));
                                }
                                this.serverData.field_3762 = playerList;
                            } else {
                                this.serverData.field_3762 = List.of();
                            }
                        }, () -> {
                            this.serverData.field_3753 = class_2561.method_43471((String)"multiplayer.status.unknown").method_27692(class_124.field_1063);
                        });
                        metadata.comp_1276().ifPresent(favicon -> {
                            if (!Arrays.equals(favicon.comp_1278(), this.serverData.method_49306())) {
                                this.serverData.method_49305(favicon.comp_1278());
                            }
                        });
                    }

                    protected void method_47399(class_6382 narrationElementOutput) {
                        this.method_37021(narrationElementOutput);
                    }
                };
                this.addRenderable((class_4068)onlineButton);
                if (this.accessor.getChildren().contains(onlineButton)) {
                    this.minecraft.method_44713().method_47976((class_2561)class_2561.method_43469((String)"multiplayer.lan.server_found", (Object[])new Object[]{onlineButton.method_25369()}));
                }
            });
            if (!WorldHost.ONLINE_FRIENDS.isEmpty()) {
                this.accessor.reloadUI();
            }
        });
    }
}

