/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.entity.LegacyPlayer;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;

public record PlayerInfoSync(Sync sync, UUID player) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<PlayerInfoSync> ID = CommonNetwork.Identifier.create((class_2960)Legacy4J.createModLocation("player_info_sync_c2s"), PlayerInfoSync::new);

    public PlayerInfoSync(CommonNetwork.PlayBuf buf) {
        this((Sync)((class_9129)buf.get()).method_10818(Sync.class), ((class_9129)buf.get()).method_10790());
    }

    public PlayerInfoSync(Sync sync, class_1657 player) {
        this(sync, player.method_5667());
    }

    public PlayerInfoSync(Sync sync, GameProfile profile) {
        this(sync, profile.getId());
    }

    public static PlayerInfoSync askAll(class_1657 player) {
        return new PlayerInfoSync(Sync.ASK_ALL, player);
    }

    public static PlayerInfoSync classicCrafting(boolean classic, class_1657 player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_CRAFTING : Sync.LEGACY_CRAFTING, player);
    }

    public static PlayerInfoSync classicTrading(boolean classic, class_1657 player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_TRADING : Sync.LEGACY_TRADING, player);
    }

    public static PlayerInfoSync classicStonecutting(boolean classic, class_1657 player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_STONECUTTING : Sync.LEGACY_STONECUTTING, player);
    }

    public static PlayerInfoSync classicLoom(boolean classic, class_1657 player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_LOOM : Sync.LEGACY_LOOM, player);
    }

    public static PlayerInfoSync disableExhaustion(boolean disableExhaustion, GameProfile profile) {
        return new PlayerInfoSync(disableExhaustion ? Sync.DISABLE_EXHAUSTION : Sync.ENABLE_EXHAUSTION, profile);
    }

    public static PlayerInfoSync mayFlySurvival(boolean mayFlySurvival, GameProfile profile) {
        return new PlayerInfoSync(mayFlySurvival ? Sync.ENABLE_MAY_FLY_SURVIVAL : Sync.DISABLE_MAY_FLY_SURVIVAL, profile);
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((class_9129)buf.get()).method_10817((Enum)this.sync);
        ((class_9129)buf.get()).method_10797(this.player);
    }

    public static Map<String, Object> getWritableGameRules(final class_1928 gameRules) {
        final HashMap<String, Object> rules = new HashMap<String, Object>();
        gameRules.method_20744(new class_1928.class_4311(){

            public void method_27329(class_1928.class_4313<class_1928.class_4310> key, class_1928.class_4314<class_1928.class_4310> type) {
                rules.put(key.method_20771(), ((class_1928.class_4310)gameRules.method_20746(key)).method_20753());
            }

            public void method_27330(class_1928.class_4313<class_1928.class_4312> key, class_1928.class_4314<class_1928.class_4312> type) {
                rules.put(key.method_20771(), ((class_1928.class_4312)gameRules.method_20746(key)).method_20763());
            }
        });
        return rules;
    }

    public void apply(CommonNetwork.Payload.Context context) {
        class_1657 class_16572 = context.player();
        if (class_16572 instanceof class_3222) {
            class_3222 affectPlayer;
            class_3222 sp = (class_3222)class_16572;
            if (sp.method_5667().equals(this.player)) {
                switch (this.sync.ordinal()) {
                    case 0: {
                        CommonNetwork.sendToPlayer((class_3222)sp, (CommonNetwork.Payload)All.fromPlayerList(sp.field_13995));
                        break;
                    }
                    case 1: 
                    case 2: {
                        ((LegacyPlayer)sp).setCrafting(this.sync == Sync.CLASSIC_CRAFTING);
                        break;
                    }
                    case 7: 
                    case 8: {
                        ((LegacyPlayer)sp).setTrading(this.sync == Sync.CLASSIC_TRADING);
                        break;
                    }
                    case 9: 
                    case 10: {
                        ((LegacyPlayer)sp).setStonecutting(this.sync == Sync.CLASSIC_STONECUTTING);
                        break;
                    }
                    case 11: 
                    case 12: {
                        ((LegacyPlayer)sp).setLoom(this.sync == Sync.CLASSIC_LOOM);
                    }
                }
                affectPlayer = sp;
            } else {
                affectPlayer = sp.field_13995.method_3760().method_14602(this.player);
            }
            if (affectPlayer == null) {
                return;
            }
            if (sp.method_64475(2)) {
                switch (this.sync.ordinal()) {
                    case 3: 
                    case 4: {
                        ((LegacyPlayerInfo)affectPlayer).setDisableExhaustion(this.sync == Sync.DISABLE_EXHAUSTION);
                        break;
                    }
                    case 5: 
                    case 6: {
                        LegacyPlayerInfo.updateMayFlySurvival(affectPlayer, this.sync == Sync.ENABLE_MAY_FLY_SURVIVAL, true);
                    }
                }
            }
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    public static enum Sync {
        ASK_ALL,
        CLASSIC_CRAFTING,
        LEGACY_CRAFTING,
        DISABLE_EXHAUSTION,
        ENABLE_EXHAUSTION,
        ENABLE_MAY_FLY_SURVIVAL,
        DISABLE_MAY_FLY_SURVIVAL,
        CLASSIC_TRADING,
        LEGACY_TRADING,
        CLASSIC_STONECUTTING,
        LEGACY_STONECUTTING,
        CLASSIC_LOOM,
        LEGACY_LOOM;

    }

    public record All(Map<UUID, LegacyPlayerInfo> players, Map<String, Object> gameRules, class_1934 defaultGameType, CommonNetwork.Identifier<All> identifier) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<All> ID_C2S = CommonNetwork.Identifier.create((class_2960)Legacy4J.createModLocation("player_info_sync_all_c2s"), b -> new All((CommonNetwork.PlayBuf)b, ID_C2S));
        public static final CommonNetwork.Identifier<All> ID_S2C = CommonNetwork.Identifier.create((class_2960)Legacy4J.createModLocation("player_info_sync_all_s2c"), b -> new All((CommonNetwork.PlayBuf)b, ID_S2C));
        public static final List<class_1928.class_4313<class_1928.class_4310>> NON_OP_GAMERULES = new ArrayList<class_1928.class_4313>(List.of(class_1928.field_19387, LegacyGameRules.getTntExplodes(), class_1928.field_19391, class_1928.field_19392, class_1928.field_19395, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, LegacyGameRules.LEGACY_SWIMMING, class_1928.field_20638));

        public All(Map<String, Object> gameRules, CommonNetwork.Identifier<All> identifier) {
            this(Collections.emptyMap(), gameRules, class_1934.field_9215, identifier);
        }

        public All(CommonNetwork.PlayBuf buf, CommonNetwork.Identifier<All> identifier) {
            this(((class_9129)buf.get()).method_34069(HashMap::new, b -> b.method_10790(), b -> LegacyPlayerInfo.decode(buf)), ((class_9129)buf.get()).method_34069(HashMap::new, class_2540::method_19772, b -> {
                int type = b.method_10816();
                if (type == 0) {
                    return b.readBoolean();
                }
                return b.method_10816();
            }), (class_1934)((class_9129)buf.get()).method_10818(class_1934.class), identifier);
        }

        public static <T extends class_1928.class_4315<T>> void syncGamerule(class_1928.class_4313<T> key, T value, MinecraftServer server) {
            Integer objectValue;
            if (value instanceof class_1928.class_4312) {
                class_1928.class_4312 integer = (class_1928.class_4312)value;
                v0 = integer.method_20763();
            } else if (value instanceof class_1928.class_4310) {
                class_1928.class_4310 bool = (class_1928.class_4310)value;
                v0 = Boolean.valueOf(bool.method_20753());
            } else {
                v0 = objectValue = null;
            }
            if (server != null && objectValue != null) {
                All payload = new All(Collections.emptyMap(), Map.of(key.method_20771(), objectValue), server.method_3790(), ID_S2C);
                server.method_3760().method_14571().forEach(sp -> CommonNetwork.sendToPlayer((class_3222)sp, (CommonNetwork.Payload)payload));
            }
        }

        public static All fromPlayerList(MinecraftServer server) {
            return new All(server.method_3760().method_14571().stream().collect(Collectors.toMap(e -> e.method_7334().getId(), e -> (LegacyPlayerInfo)e)), PlayerInfoSync.getWritableGameRules(server.method_3767()), server.method_3790(), ID_S2C);
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((class_9129)buf.get()).method_34063(this.players, (b, u) -> b.method_10797(u), (b, info) -> LegacyPlayerInfo.encode(buf, info));
            ((class_9129)buf.get()).method_34063(this.gameRules, class_2540::method_10814, (b, obj) -> {
                b.method_10804(obj instanceof Boolean ? 0 : 1);
                if (obj instanceof Boolean) {
                    Boolean bol = (Boolean)obj;
                    b.method_52964(bol.booleanValue());
                } else if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    b.method_10804(i.intValue());
                }
            });
            ((class_9129)buf.get()).method_10817((Enum)this.defaultGameType);
        }

        public void apply(final CommonNetwork.Payload.Context context) {
            context.executor().executeWhen(() -> {
                if (context.isClient() && Legacy4JClient.hasModOnServer()) {
                    Legacy4JClient.defaultServerGameType = this.defaultGameType;
                    Legacy4JClient.updateLegacyPlayerInfos(this.players);
                    return true;
                }
                return false;
            });
            context.executor().execute(() -> {
                class_1928 class_19282;
                class_1657 class_16572 = context.player();
                if (class_16572 instanceof class_3222) {
                    class_3222 sp = (class_3222)class_16572;
                    class_19282 = sp.method_5682().method_3767();
                } else {
                    class_19282 = Legacy4JClient.gameRules;
                }
                final class_1928 displayRules = class_19282;
                displayRules.method_20744(new class_1928.class_4311(){

                    public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                        if (gameRules.containsKey(key.method_20771()) && (context.player().method_37908().field_9236 || NON_OP_GAMERULES.contains(key) || context.player().method_64475(2))) {
                            class_1928.class_4310 v;
                            Object object = gameRules.get(key.method_20771());
                            if (object instanceof Boolean) {
                                Boolean b = (Boolean)object;
                                object = displayRules.method_20746(key);
                                if (object instanceof class_1928.class_4310) {
                                    v = (class_1928.class_4310)object;
                                    v.method_20758(b.booleanValue(), null);
                                }
                            }
                            if ((object = gameRules.get(key.method_20771())) instanceof Integer) {
                                Integer i = (Integer)object;
                                object = displayRules.method_20746(key);
                                if (object instanceof class_1928.class_4312) {
                                    v = (class_1928.class_4312)object;
                                    v.method_35236(i.intValue(), null);
                                }
                            }
                        }
                    }
                });
            });
        }
    }
}

