/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_1074;
import net.minecraft.class_1131;
import net.minecraft.class_1134;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_412;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_639;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import net.minecraft.class_8573;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.ServerEditScreen;
import wily.legacy.client.screen.ServerOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class ServerRenderableList
extends RenderableVList {
    protected static final Logger LOGGER = LogUtils.getLogger();
    static final class_2960 INCOMPATIBLE = FactoryAPI.createVanillaLocation((String)"server_list/incompatible");
    static final class_2960 UNREACHABLE = FactoryAPI.createVanillaLocation((String)"server_list/unreachable");
    static final class_2960 PING_1 = FactoryAPI.createVanillaLocation((String)"server_list/ping_1");
    static final class_2960 PING_2 = FactoryAPI.createVanillaLocation((String)"server_list/ping_2");
    static final class_2960 PING_3 = FactoryAPI.createVanillaLocation((String)"server_list/ping_3");
    static final class_2960 PING_4 = FactoryAPI.createVanillaLocation((String)"server_list/ping_4");
    static final class_2960 PING_5 = FactoryAPI.createVanillaLocation((String)"server_list/ping_5");
    static final class_2960 PINGING_1 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_1");
    static final class_2960 PINGING_2 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_2");
    static final class_2960 PINGING_3 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_3");
    static final class_2960 PINGING_4 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_4");
    static final class_2960 PINGING_5 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_5");
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    static final class_2561 SCANNING_LABEL = class_2561.method_43471((String)"lanServer.scanning");
    static final class_2561 CANT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_27694(style -> style.method_36139(-65536));
    static final class_2561 CANT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27694(style -> style.method_36139(-65536));
    static final class_2561 INCOMPATIBLE_STATUS = class_2561.method_43471((String)"multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_STATUS = class_2561.method_43471((String)"multiplayer.status.no_connection");
    static final class_2561 PINGING_STATUS = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2561 ONLINE_STATUS = class_2561.method_43471((String)"multiplayer.status.online");
    private static final class_2960 ICON_MISSING = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_server.png");
    private static final class_2561 LAN_SERVER_HEADER = class_2561.method_43471((String)"lanServer.title");
    private static final class_2561 HIDDEN_ADDRESS_TEXT = class_2561.method_43471((String)"selectServer.hiddenAddress");
    public final class_641 servers;
    public final class_1134.class_1136 lanServerList;
    protected final class_310 minecraft;
    @Nullable
    public class_1134.class_1135 lanServerDetector;
    public List<class_1131> lanServers;

    public ServerRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = class_310.method_1551();
        this.servers = new class_641(this.minecraft);
        this.servers.method_2981();
        this.lanServerList = new class_1134.class_1136();
        this.updateServers();
    }

    public static void drawIcon(class_332 guiGraphics, int x, int y, int width, int height, class_2960 resourceLocation) {
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((class_332)guiGraphics).blit(resourceLocation, x, y, 0.0f, 0.0f, width, height, width, height);
        FactoryScreenUtil.disableBlend();
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        try {
            this.lanServerDetector = new class_1134.class_1135(this.lanServerList);
            this.lanServerDetector.start();
        }
        catch (Exception exception) {
            Legacy4J.LOGGER.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    public boolean hasOnlineFriends() {
        return false;
    }

    public void added() {
    }

    public void removed() {
        if (this.lanServerDetector != null) {
            this.lanServerDetector.interrupt();
            this.lanServerDetector = null;
        }
    }

    private class_2561 getMultiplayerDisabledReason() {
        if (this.minecraft.method_29043()) {
            return null;
        }
        if (this.minecraft.method_53518()) {
            return class_2561.method_43471((String)"title.multiplayer.disabled.banned.name");
        }
        BanDetails banDetails = this.minecraft.method_44647();
        if (banDetails != null) {
            return banDetails.expires() != null ? class_2561.method_43471((String)"title.multiplayer.disabled.banned.temporary") : class_2561.method_43471((String)"title.multiplayer.disabled.banned.permanent");
        }
        return class_2561.method_43471((String)"title.multiplayer.disabled");
    }

    public void updateServers() {
        this.renderables.clear();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/add_server"), (class_2561)class_2561.method_43471((String)"legacy.menu.add_server"), c -> this.minecraft.method_1507((class_437)new ServerEditScreen(this.getScreen(PlayGameScreen.class), new class_642(class_1074.method_4662((String)"selectServer.defaultName", (Object[])new Object[0]), "", class_642.class_8678.field_45611), true)));
        class_2561 component = this.getMultiplayerDisabledReason();
        class_7919 tooltip = component != null ? class_7919.method_47407((class_2561)component) : null;
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/realms"), (class_2561)class_2561.method_43471((String)"menu.online"), b -> this.minecraft.method_1507((class_437)new class_4325(this.getScreen())), tooltip);
        for (int i = 0; i < this.servers.method_2984(); ++i) {
            this.addRenderable((class_4068)new ServerButton(0, 0, 0, 30, i));
        }
        this.updateLANServers();
    }

    public void updateLANServers() {
        if (this.lanServers != null) {
            for (final class_1131 lanServer : this.lanServers) {
                CreationList.ContentButton lanButton = new CreationList.ContentButton(this, 0, 0, 0, 30, (class_2561)class_2561.method_43470((String)lanServer.method_4813())){

                    @Override
                    protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
                        int messageX = ServerRenderableList.this.accessor.getInteger(ServerRenderableList.this.name + ".buttonMessage.xOffset", 35);
                        guiGraphics.method_51439(ServerRenderableList.this.minecraft.field_1772, LAN_SERVER_HEADER, messageX, this.method_46427() + 1, -1, false);
                        guiGraphics.method_51433(ServerRenderableList.this.minecraft.field_1772, lanServer.method_4813(), messageX, this.method_46427() + 12, -8355712, false);
                        if (ServerRenderableList.this.minecraft.field_1690.field_1815) {
                            guiGraphics.method_51439(ServerRenderableList.this.minecraft.field_1772, HIDDEN_ADDRESS_TEXT, messageX, this.method_46427() + 12 + 11, 0x303030, false);
                        } else {
                            guiGraphics.method_51433(ServerRenderableList.this.minecraft.field_1772, lanServer.method_4812(), messageX, this.method_46427() + 12 + 11, 0x303030, false);
                        }
                    }

                    public void method_25306(class_11907 input) {
                        if (this.method_25370()) {
                            ServerRenderableList.this.joinLanServer(lanServer);
                        }
                    }
                };
                this.addRenderable((class_4068)lanButton);
                if (!this.getScreen().field_22786.contains((Object)lanButton)) continue;
                this.minecraft.method_44713().method_37015((class_2561)class_2561.method_43469((String)"multiplayer.lan.server_found", (Object[])new Object[]{class_2561.method_43473().method_10852(LAN_SERVER_HEADER).method_10852(class_5244.field_41874).method_27693(lanServer.method_4813())}));
            }
        } else {
            CreationList.ContentButton scanningButton = new CreationList.ContentButton(this, this, 0, 0, 0, 30, SCANNING_LABEL){

                @Override
                public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                    LegacyRenderUtil.drawGenericLoading(guiGraphics, this.method_46426() + x, this.method_46427() + y, (width - 2) / 3, 1);
                }

                @Override
                public void renderIconHighlight(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                }

                public void method_25306(class_11907 input) {
                }
            };
            this.addRenderable((class_4068)scanningButton);
            scanningButton.field_22763 = false;
        }
    }

    public void joinSelectedServer() {
        class_4068 r;
        int i;
        class_364 class_3642 = this.getScreen().method_25399();
        if (class_3642 instanceof class_4068 && (i = this.renderables.indexOf(r = (class_4068)class_3642)) > 0) {
            if (this.servers.method_2984() > i) {
                this.join(this.servers.method_2982(i));
            } else if (this.lanServers != null) {
                this.joinLanServer(this.lanServers.get(i - this.servers.method_2984()));
            }
        }
    }

    private void joinLanServer(class_1131 lanServer) {
        this.join(new class_642(lanServer.method_4813(), lanServer.method_4812(), class_642.class_8678.field_45609));
    }

    public void join(class_642 serverData) {
        class_412.method_36877((class_437)this.getScreen(), (class_310)this.minecraft, (class_639)class_639.method_2950((String)serverData.field_3761), (class_642)serverData, (boolean)false, null);
    }

    public class ServerButton
    extends CreationList.ContentButton
    implements ControlTooltip.ActionHolder {
        public final class_642 server;
        public final int serverIndex;
        public final class_8573 icon;
        private byte @Nullable [] lastIconBytes;
        private boolean showOnlinePlayersTooltip;
        @Nullable
        private class_2960 statusIcon;
        @Nullable
        private class_2561 statusIconTooltip;

        public ServerButton(int i, int j, int k, int l, int serverIndex) {
            super(ServerRenderableList.this, i, j, k, l, (class_2561)class_2561.method_43470((String)ServerRenderableList.this.servers.method_2982((int)serverIndex).field_3752));
            this.serverIndex = serverIndex;
            this.server = ServerRenderableList.this.servers.method_2982(serverIndex);
            this.icon = class_8573.method_52202((class_1060)ServerRenderableList.this.minecraft.method_1531(), (String)this.server.field_3761);
        }

        @Override
        public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            byte[] bs;
            super.renderIcon(guiGraphics, x, y, width, height, mouseX, mouseY);
            if (this.server.method_55825() == class_642.class_9083.field_47880) {
                this.server.method_55824(class_642.class_9083.field_47881);
                this.server.field_3757 = class_5244.field_39003;
                this.server.field_3753 = class_5244.field_39003;
                THREAD_POOL.submit(() -> {
                    try {
                        ServerRenderableList.this.getScreen(PlayGameScreen.class).getPinger().method_3003(this.server, () -> ServerRenderableList.this.minecraft.execute(this::updateServerList), () -> {
                            this.server.method_55824(this.server.field_3756 == class_155.method_16673().comp_4027() ? class_642.class_9083.field_47884 : class_642.class_9083.field_47883);
                            ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                        });
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.server.method_55824(class_642.class_9083.field_47882);
                        this.server.field_3757 = CANT_RESOLVE_TEXT;
                        ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception exception) {
                        this.server.method_55824(class_642.class_9083.field_47882);
                        this.server.field_3757 = CANT_CONNECT_TEXT;
                        ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            class_2561 component = !this.isCompatible() ? this.server.field_3760.method_27661().method_27692(class_124.field_1061) : this.server.field_3753;
            LegacyFontUtil.applySDFont(b -> {
                int q = ServerRenderableList.this.minecraft.field_1772.method_27525((class_5348)component);
                guiGraphics.method_51439(ServerRenderableList.this.minecraft.field_1772, component, this.method_46426() + this.method_25368() - q - 15 - 2, this.method_46427() + 3, -8355712, false);
                int s = mouseX - this.method_46426();
                int t = mouseY - this.method_46427();
                if (this.statusIconTooltip != null && s >= this.method_25368() - 15 && s <= this.method_25368() - 5 && t >= 2 && t <= 10) {
                    guiGraphics.method_51438(ServerRenderableList.this.minecraft.field_1772, this.statusIconTooltip, mouseX, mouseY);
                } else if (this.showOnlinePlayersTooltip && s >= this.method_25368() - q - 15 - 2 && s <= this.method_25368() - 15 - 2 && t >= 2 && t <= 10) {
                    guiGraphics.method_51434(ServerRenderableList.this.minecraft.field_1772, this.server.field_3762, mouseX, mouseY);
                }
            });
            if (this.pingCompleted()) {
                int p = (int)(class_156.method_658() / 100L + (long)this.serverIndex * 2L & 7L);
                if (p > 4) {
                    p = 8 - p;
                }
                switch (p) {
                    case 1: {
                        class_2960 class_29602 = PINGING_2;
                        break;
                    }
                    case 2: {
                        class_2960 class_29602 = PINGING_3;
                        break;
                    }
                    case 3: {
                        class_2960 class_29602 = PINGING_4;
                        break;
                    }
                    case 4: {
                        class_2960 class_29602 = PINGING_5;
                        break;
                    }
                    default: {
                        class_2960 class_29602 = this.statusIcon = PINGING_1;
                    }
                }
            }
            if (this.statusIcon != null) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(this.statusIcon, this.method_46426() + this.method_25368() - 15, this.method_46427() + 3, 10, 8);
            }
            if (!Arrays.equals(bs = this.server.method_49306(), this.lastIconBytes)) {
                if (this.uploadServerIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.server.method_49305(null);
                    this.updateServerList();
                }
            }
            ServerRenderableList.drawIcon(guiGraphics, this.method_46426() + x, this.method_46427() + y, width, height, this.icon.method_52201());
        }

        @Override
        public void renderIconHighlight(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            super.renderIconHighlight(guiGraphics, mouseX, mouseY, x, y, width, height);
            FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.method_46426() + x + width / 2, this.method_46427() + y, width / 2, height) ? LegacySprites.JOIN_HIGHLIGHTED : LegacySprites.JOIN, this.method_46426() + x, this.method_46427() + y, width, height);
            if (this.serverIndex > 0) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.method_46426() + x, this.method_46427() + y, width / 2, height / 2) ? LegacySprites.MOVE_UP_HIGHLIGHTED : LegacySprites.MOVE_UP, this.method_46426() + x, this.method_46427() + y, width, height);
            }
            if (this.serverIndex < ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().method_2984() - 1) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.method_46426() + x, this.method_46427() + y + height / 2, width / 2, height / 2) ? LegacySprites.MOVE_DOWN_HIGHLIGHTED : LegacySprites.MOVE_DOWN, this.method_46426() + x, this.method_46427() + y, width, height);
            }
        }

        public boolean pingCompleted() {
            return this.server.method_55825() == class_642.class_9083.field_47881;
        }

        public void refreshStatus() {
            this.showOnlinePlayersTooltip = false;
            switch (this.server.method_55825()) {
                case field_47880: 
                case field_47881: {
                    this.statusIcon = PING_1;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case field_47883: {
                    this.statusIcon = INCOMPATIBLE;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    this.showOnlinePlayersTooltip = true;
                    break;
                }
                case field_47882: {
                    this.statusIcon = UNREACHABLE;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case field_47884: {
                    this.statusIcon = this.server.field_3758 < 150L ? PING_5 : (this.server.field_3758 < 300L ? PING_4 : (this.server.field_3758 < 600L ? PING_3 : (this.server.field_3758 < 1000L ? PING_2 : PINGING_1)));
                    this.statusIconTooltip = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.server.field_3758});
                    this.showOnlinePlayersTooltip = true;
                }
            }
        }

        private boolean isCompatible() {
            return this.server.field_3756 == class_155.method_16673().comp_4027();
        }

        public void updateServerList() {
            ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().method_2987();
        }

        private boolean uploadServerIcon(@Nullable byte[] bs) {
            if (bs == null) {
                this.icon.method_52198();
            } else {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])bs));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.server.field_3752, this.server.field_3761, throwable});
                    return false;
                }
            }
            return true;
        }

        @Override
        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            LegacyFontUtil.applySDFont(b -> guiGraphics.method_27535(ServerRenderableList.this.minecraft.field_1772, this.method_25369(), this.method_46426() + ServerRenderableList.this.accessor.getInteger(ServerRenderableList.this.name + ".buttonMessage.xOffset", 35), this.method_46427() + 3, -1));
            if (this.method_25364() >= 30) {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)(this.method_46426() + 35), (float)(this.method_46427() + 10));
                guiGraphics.method_51448().scale(0.6666667f, 0.6666667f);
                List list = ServerRenderableList.this.minecraft.field_1772.method_1728((class_5348)this.server.field_3757, Math.max(this.field_22758 - 36, ServerRenderableList.this.minecraft.field_1772.method_27525((class_5348)this.server.field_3757) / 2 + 20));
                for (int p = 0; p < Math.min(2, list.size()); ++p) {
                    class_327 class_3272 = ServerRenderableList.this.minecraft.field_1772;
                    class_5481 class_54812 = (class_5481)list.get(p);
                    Objects.requireNonNull(ServerRenderableList.this.minecraft.field_1772);
                    Objects.requireNonNull(ServerRenderableList.this.minecraft.field_1772);
                    LegacyRenderUtil.renderScrollingString(guiGraphics, class_3272, class_54812, 0, 9 * p, this.field_22758 - 36, 11 + 9 * p, -8355712, false, ServerRenderableList.this.minecraft.field_1772.method_30880((class_5481)list.get(p)) * 2 / 3);
                }
                guiGraphics.method_51448().popMatrix();
            }
        }

        public void method_25348(class_11909 event, boolean bl) {
            int iconWidth = ServerRenderableList.this.accessor.getInteger(ServerRenderableList.this.name + ".buttonIcon.width", 20);
            int iconHeight = ServerRenderableList.this.accessor.getInteger(ServerRenderableList.this.name + ".buttonIcon.height", 20);
            int iconPos = (this.method_25364() - iconHeight) / 2;
            if (this.serverIndex > 0 && LegacyRenderUtil.isMouseOver(event.comp_4798(), event.comp_4799(), this.method_46426() + iconPos, this.method_46427() + iconPos, iconWidth / 2, iconHeight / 2)) {
                this.swap(this.serverIndex, this.serverIndex - 1);
                return;
            }
            if (this.serverIndex < ServerRenderableList.this.servers.method_2984() - 1 && LegacyRenderUtil.isMouseOver(event.comp_4798(), event.comp_4799(), this.method_46426() + iconPos, this.method_46427() + iconPos + iconHeight / 2, iconWidth / 2, iconHeight / 2)) {
                this.swap(this.serverIndex, this.serverIndex + 1);
                return;
            }
            if (LegacyRenderUtil.isMouseOver(event.comp_4798(), event.comp_4799(), this.method_46426() + iconPos, this.method_46427() + iconPos, iconWidth, iconHeight)) {
                ServerRenderableList.this.join(this.server);
            } else {
                super.method_25348(event, bl);
            }
        }

        public void method_25306(class_11907 input) {
            if (this.method_25370()) {
                ServerRenderableList.this.join(this.server);
            }
        }

        private void swap(int i, int j) {
            Object e;
            ServerRenderableList.this.servers.method_2985(i, j);
            ServerRenderableList.this.updateServers();
            ServerRenderableList.this.accessor.reloadUI();
            if (j < ServerRenderableList.this.renderables.size() && (e = ServerRenderableList.this.renderables.get(j)) instanceof class_364) {
                class_364 l = (class_364)e;
                ServerRenderableList.this.getScreen().method_25395(l);
            }
        }

        public boolean method_25404(class_11908 keyEvent) {
            if (keyEvent.method_74239() && (keyEvent.method_74235() && this.serverIndex < ServerRenderableList.this.servers.method_2984() - 1 || keyEvent.method_74234() && this.serverIndex > 0)) {
                this.swap(this.serverIndex, keyEvent.method_74235() ? this.serverIndex + 1 : this.serverIndex - 1);
                return true;
            }
            if (keyEvent.comp_4795() == 79) {
                ServerRenderableList.this.minecraft.method_1507((class_437)new ServerOptionsScreen(ServerRenderableList.this.getScreen(PlayGameScreen.class), this.server));
                ServerRenderableList.this.getScreen().method_25395((class_364)this);
                return true;
            }
            return super.method_25404(keyEvent);
        }

        protected class_5250 method_25360() {
            class_5250 mutableComponent = class_2561.method_43473();
            mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.server.field_3752}));
            mutableComponent.method_10852(class_5244.field_33850);
            switch (this.server.method_55825()) {
                case field_47883: {
                    mutableComponent.method_10852(INCOMPATIBLE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.server.field_3760}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.field_3757}));
                    break;
                }
                case field_47882: {
                    mutableComponent.method_10852(NO_CONNECTION_STATUS);
                    break;
                }
                case field_47881: {
                    mutableComponent.method_10852(PINGING_STATUS);
                    break;
                }
                default: {
                    mutableComponent.method_10852(ONLINE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.server.field_3758}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.field_3757}));
                    if (this.server.field_41861 == null) break;
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.server.field_41861.comp_1280(), this.server.field_41861.comp_1279()}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852(class_2564.method_37112((Collection)this.server.field_3762, (class_2561)class_2561.method_43470((String)", ")));
                }
            }
            return mutableComponent;
        }

        @Override
        @Nullable
        public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.method_25370() ? LegacyComponents.SERVER_OPTIONS : ControlTooltip.getSelectAction((class_364)this, c));
        }
    }
}

