/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.network.ClientAnimalInLoveSyncPayload;
import wily.legacy.network.ClientEffectActivationPayload;
import wily.legacy.network.ClientMerchantTradingPayload;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.ServerPlayerMissHitPayload;
import wily.legacy.network.TipCommand;
import wily.legacy.network.TopMessage;
import wily.legacy.util.ArmorStandPose;
import wily.legacy.util.ItemAccessor;

@Mod(value="legacy")
public class Legacy4J {
    public static final String MOD_ID = "legacy";
    public static final Supplier<String> VERSION = () -> FactoryAPIPlatform.getModInfo((String)MOD_ID).getVersion();
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy");
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinToggles.COMMON_STORAGE, (boolean)true);
    private static Collection<CommonNetwork.Payload> playerInitialPayloads = Collections.emptySet();

    public Legacy4J() {
        Legacy4J.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Legacy4JClient.init();
        }
    }

    public static List<Integer> getParsedVersion(String version) {
        String[] versions;
        ArrayList<Integer> parsedVersion = new ArrayList<Integer>();
        for (String s : versions = version.split("[.\\-]")) {
            int value;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            parsedVersion.add(value);
        }
        return parsedVersion;
    }

    public static boolean isNewerVersion(String actualVersion, String previous) {
        return Legacy4J.isNewerVersion(actualVersion, previous, 2);
    }

    public static boolean isNewerVersion(String actualVersion, String previous, int limitCount) {
        List<Integer> v = Legacy4J.getParsedVersion(actualVersion);
        List<Integer> v1 = Legacy4J.getParsedVersion(previous);
        int size = limitCount <= 0 ? v.size() : Math.min(limitCount, v.size());
        for (int i = 0; i < size; ++i) {
            if (v.get(i) <= (v1.size() <= i ? 0 : v1.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("common"), (FactoryConfig.StorageHandler)LegacyCommonOptions.COMMON_STORAGE);
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("mixin_common"), (FactoryConfig.StorageHandler)MIXIN_CONFIGS_STORAGE);
        LegacyRegistries.register();
        LegacyGameRules.init();
        FactoryEvent.registerPayload(r -> {
            r.register(false, ClientAdvancementsPayload.ID);
            r.register(false, ClientAnimalInLoveSyncPayload.ID);
            r.register(false, ClientEffectActivationPayload.ID);
            r.register(true, ClientMerchantTradingPayload.ID_C2S);
            r.register(false, ClientMerchantTradingPayload.ID_S2C);
            r.register(true, PlayerInfoSync.ID);
            r.register(true, PlayerInfoSync.All.ID_C2S);
            r.register(false, PlayerInfoSync.All.ID_S2C);
            r.register(true, ServerMenuCraftPayload.ID);
            r.register(true, ServerOpenClientMenuPayload.ID);
            r.register(true, ServerPlayerMissHitPayload.ID);
            r.register(false, TipCommand.Payload.ID);
            r.register(false, TipCommand.EntityPayload.ID);
            r.register(false, TopMessage.Payload.ID);
        });
        ArmorStandPose.init();
        ItemAccessor.of(Items.f_42502_).setMaxStackSize(64);
        ItemAccessor.of(Items.f_42701_).setRecordLengthInTicks(330);
        FactoryEvent.registerCommands((dispatcher, context, selection) -> TipCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, context, selection));
        FactoryEvent.setup(Legacy4J::setup);
        FactoryEvent.tagsLoaded(Legacy4J::tagsLoaded);
        FactoryEvent.serverStarted(Legacy4J::onServerStart);
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(Legacy4J::onServerPlayerJoin);
        FactoryEvent.PlayerEvent.RELOAD_RESOURCES_EVENT.register(Legacy4J::onResourcesReload);
    }

    public static ResourceLocation createModLocation(String path) {
        return FactoryAPI.createLocation((String)MOD_ID, (String)path);
    }

    public static InteractionResult defaultPassInteraction() {
        return InteractionResult.PASS;
    }

    public static InteractionResult successInteraction() {
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult consumeInteraction() {
        return InteractionResult.CONSUME;
    }

    public static void setup() {
        LegacyCommonOptions.COMMON_STORAGE.load();
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        Map emptyCauldron = CauldronInteraction.f_175606_;
        Map waterCauldron = CauldronInteraction.f_175607_;
        CauldronInteraction emptyCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Holder p = BuiltInRegistries.f_256980_.m_263177_((Object)PotionUtils.m_43579_((ItemStack)itemStack));
            if (p.m_203334_() == Potions.f_43598_) {
                return Legacy4J.defaultPassInteraction();
            }
            level.m_46597_(blockPos, Blocks.f_152476_.m_49966_());
            level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.potion = p;
                be.lastPotionItemUsed = itemStack.m_220173_();
                be.m_6596_();
            });
            if (!level.f_46443_) {
                Item item = itemStack.m_41720_();
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                level.m_5594_(null, blockPos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157769_, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        emptyCauldron.put(Items.f_42589_, emptyCauldronPotion);
        emptyCauldron.put(Items.f_42736_, emptyCauldronPotion);
        emptyCauldron.put(Items.f_42739_, emptyCauldronPotion);
        waterCauldron.put(Items.f_42590_, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            if (opt.isEmpty() || opt.map(be -> be.waterColor).orElse(null) != null) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.f_46443_) {
                Item item = itemStack.m_41720_();
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Legacy4J.setItemStackPotion(new ItemStack(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed), ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.m_5594_(null, blockPos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        CauldronInteraction waterCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            Holder p = BuiltInRegistries.f_256980_.m_263177_((Object)PotionUtils.m_43579_((ItemStack)itemStack));
            if (p.m_203334_() == Potions.f_43598_ || (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3 && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p))) {
                return Legacy4J.defaultPassInteraction();
            }
            if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                level.m_46597_(blockPos, Blocks.f_50256_.m_49966_());
                if (!((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                    level.m_5594_(null, blockPos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                } else {
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = null;
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).m_6596_();
                }
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed = itemStack.m_220173_();
                level.m_5594_(null, blockPos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.f_46443_) {
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                level.m_142346_(null, GameEvent.f_157769_, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        waterCauldron.put(Items.f_42589_, waterCauldronPotion);
        waterCauldron.put(Items.f_42736_, waterCauldronPotion);
        waterCauldron.put(Items.f_42739_, waterCauldronPotion);
        waterCauldron.put(Items.f_42412_, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            BlockEntity patt0$temp = level.m_7702_(blockPos);
            if (!(patt0$temp instanceof WaterCauldronBlockEntity) || (be = (WaterCauldronBlockEntity)patt0$temp).hasWater()) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.f_46443_) {
                int l = (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                int arrowCount = Math.min(itemStack.m_41613_(), l < 3 ? l * 16 : 64);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(arrowCount);
                }
                ItemStack tippedArrow = Legacy4J.setItemStackPotion(new ItemStack((ItemLike)Items.f_42738_, arrowCount), be.potion);
                player.m_150109_().m_150079_(tippedArrow);
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                int i = (int)Math.min(3.0, Math.ceil((double)arrowCount / 16.0));
                BlockState blockState2 = l - i == 0 ? Blocks.f_50256_.m_49966_() : (BlockState)blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(i));
                level.m_46597_(blockPos, blockState2);
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState2));
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        for (DyeColor color : DyeColor.values()) {
            waterCauldron.put(DyeItem.m_41082_((DyeColor)color), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (!(itemStack.m_41720_() instanceof DyeItem) || opt.isEmpty() || !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).hasWater()) {
                    return Legacy4J.defaultPassInteraction();
                }
                int dyeColor = Legacy4J.getDyeColor(color);
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null ? Integer.valueOf(dyeColor) : Integer.valueOf(Legacy4J.mixColors(List.of(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor, Integer.valueOf(dyeColor)).iterator()));
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).m_6596_();
                return level.f_46443_ ? Legacy4J.successInteraction() : Legacy4J.consumeInteraction();
            });
        }
        DispenserBlock.m_52672_((ItemLike)Blocks.f_50077_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource blockSource, ItemStack itemStack) {
                this.m_123573_(blockSource.m_7727_().m_46469_().m_46207_(LegacyGameRules.TNT_EXPLODES));
                if (this.m_123570_()) {
                    BlockPos blockPos = blockSource.m_7961_().m_121945_((Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    TntBlock.m_57433_((Level)blockSource.m_7727_(), (BlockPos)blockPos);
                    blockSource.m_7727_().m_142346_(null, GameEvent.f_157810_, blockSource.m_7961_());
                    itemStack.m_41774_(1);
                }
                return itemStack;
            }

            protected void m_123387_(BlockSource blockSource, Direction direction) {
                if (this.m_123570_()) {
                    super.m_123387_(blockSource, direction);
                }
            }
        });
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                EntityType entityType = ((SpawnEggItem)itemStack.m_41720_()).m_43228_(null);
                try {
                    if (entityType.m_20592_(blockSource.m_7727_(), itemStack, null, blockSource.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false) != null) {
                        itemStack.m_41774_(1);
                        blockSource.m_7727_().m_142346_(null, GameEvent.f_157810_, blockSource.m_7961_());
                    }
                }
                catch (Exception var6) {
                    f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.m_7961_(), (Object)var6);
                    return ItemStack.f_41583_;
                }
                return itemStack;
            }
        };
        for (SpawnEggItem spawnEggItem : SpawnEggItem.m_43233_()) {
            DispenserBlock.m_52672_((ItemLike)spawnEggItem, (DispenseItemBehavior)defaultDispenseItemBehavior);
        }
        Legacy4J.registerDyedWaterCauldronInteraction(waterCauldron);
    }

    public static boolean isChunkPosVisibleInSquare(int centerX, int centerZ, int viewDistance, int x, int z, boolean offset) {
        int n = Math.max(0, Math.abs(x - centerX) - 1);
        int o = Math.max(0, Math.abs(z - centerZ) - 1);
        long p = Math.max(0, Math.max(n, o) - (offset ? 1 : 0));
        long q = Math.min(n, o);
        return Math.max(p, q) < (long)viewDistance;
    }

    public static ItemStack setItemStackPotion(ItemStack stack, Holder<Potion> potion) {
        return PotionUtils.m_43549_((ItemStack)stack, (Potion)((Potion)potion.m_203334_()));
    }

    public static void addPotionTooltip(Holder<Potion> potion, List<Component> tooltipList, float f) {
        PotionUtils.m_257410_((List)((Potion)potion.m_203334_()).m_43488_(), tooltipList, (float)f);
    }

    public static int getDyeColor(DyeColor dyeColor) {
        return ColorUtil.colorFromFloat((float[])dyeColor.m_41068_());
    }

    public static float getItemDamageModifier(ItemStack stack) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            if (stack.m_41720_() instanceof SwordItem) {
                return 1.0f;
            }
            if (stack.m_41720_() instanceof ShovelItem) {
                return -0.5f;
            }
            if (stack.m_41720_() instanceof PickaxeItem) {
                return 1.0f;
            }
            if (stack.m_41720_() instanceof AxeItem) {
                if (stack.m_150930_(Items.f_42428_)) {
                    return -4.0f;
                }
                if (stack.m_150930_(Items.f_42391_) || stack.m_150930_(Items.f_42396_)) {
                    return -2.0f;
                }
                return -3.0f;
            }
        }
        return 0.0f;
    }

    public static void tagsLoaded() {
    }

    public static void registerDyedWaterCauldronInteraction(Map<Item, CauldronInteraction> waterCauldron) {
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        BuiltInRegistries.f_257033_.m_206115_().forEach(i -> {
            if (!Legacy4J.isDyeableItem((Holder<Item>)i)) {
                return;
            }
            waterCauldron.put((Item)i.m_203334_(), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).hasWater() || ((DyeableLeatherItem)itemStack.m_41720_()).m_41113_(itemStack) && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null)) {
                    return Legacy4J.defaultPassInteraction();
                }
                if (!level.f_46443_) {
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                    if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null) {
                        ((DyeableLeatherItem)itemStack.m_41720_()).m_41123_(itemStack);
                    } else {
                        Legacy4J.dyeItem(itemStack, ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor);
                    }
                    LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                }
                return Legacy4J.successInteraction();
            });
        });
    }

    public static Vec3 getRelativeMovement(LivingEntity entity, float f, Vec3 vec3, int relRot) {
        double d = (vec3 = Legacy4J.getNormal(vec3, Math.toRadians(relRot))).m_82556_();
        if (d < 1.0E-7) {
            return Vec3.f_82478_;
        }
        Vec3 vec32 = (d > 1.0 ? vec3.m_82541_() : vec3).m_82490_((double)f);
        double angle = Math.toRadians(relRot == 0 ? (double)entity.m_146908_() : (double)(Math.round(entity.m_146908_() / (float)relRot) * relRot));
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new Vec3(vec32.f_82479_ * cos - vec32.f_82481_ * sin, vec32.f_82480_, vec32.f_82481_ * cos + vec32.f_82479_ * sin);
    }

    public static Vec3 getNormal(Vec3 vec3, double relRot) {
        if (relRot == 0.0) {
            return vec3;
        }
        double angleRad = Math.atan2(vec3.f_82481_, vec3.f_82479_);
        double quantizedAngle = (double)Math.round(angleRad / relRot) * relRot;
        double length = vec3.m_82553_();
        return new Vec3(length * Math.cos(quantizedAngle), vec3.f_82480_, length * Math.sin(quantizedAngle));
    }

    public static boolean canRepair(ItemStack repairItem, ItemStack ingredient) {
        return repairItem.m_150930_(ingredient.m_41720_()) && repairItem.m_41613_() == 1 && ingredient.m_41613_() == 1 && repairItem.m_41720_().m_41465_() && !ingredient.m_41793_();
    }

    public static boolean isDyeableItem(Holder<Item> item) {
        return item.m_203334_() instanceof DyeableLeatherItem;
    }

    public static ItemStack dyeItem(ItemStack itemStack, int color) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        DyeableLeatherItem dyeableLeatherItem = null;
        Item item = itemStack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            dyeableLeatherItem = (DyeableLeatherItem)item;
            if (dyeableLeatherItem.m_41113_(itemStack)) {
                colors.add(dyeableLeatherItem.m_41121_(itemStack));
            }
            colors.add(color);
        }
        if (dyeableLeatherItem != null) {
            dyeableLeatherItem.m_41115_(itemStack, Legacy4J.mixColors(colors.iterator()));
        }
        return itemStack;
    }

    public static int mixColors(Iterator<Integer> colors) {
        float h;
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        Iterator<Integer> it = colors;
        while (it.hasNext()) {
            Integer color = it.next();
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            h = (float)(color & 0xFF) / 255.0f;
            i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
            is[0] = is[0] + (int)(f * 255.0f);
            is[1] = is[1] + (int)(g * 255.0f);
            is[2] = is[2] + (int)(h * 255.0f);
            ++j;
        }
        int k = is[0] / j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        int n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public static boolean itemHasValidPatterns(ItemStack stack) {
        int count = Legacy4J.getItemPatternsCount(stack);
        return count > 0 && count <= 6;
    }

    public static int getItemPatternsCount(ItemStack stack) {
        CompoundTag beTag = stack.m_41737_("BlockEntityTag");
        return beTag == null ? 0 : (beTag.m_128441_("Patterns") ? beTag.m_128437_("Patterns", 10).size() : -1);
    }

    public static void onServerPlayerJoin(ServerPlayer p) {
        if (p.m_20194_() == null) {
            return;
        }
        int pos = 0;
        boolean b = true;
        block0: while (b) {
            b = false;
            for (ServerPlayer player : p.f_8924_.m_6846_().m_11314_()) {
                if (player == p || ((LegacyPlayerInfo)player).getIdentifierIndex() != pos) continue;
                ++pos;
                b = true;
                continue block0;
            }
        }
        ((LegacyPlayerInfo)p).setIdentifierIndex(pos);
        CommonNetwork.sendToPlayers((Collection)p.m_20194_().m_6846_().m_11314_().stream().filter(sp -> sp != p).collect(Collectors.toSet()), (CommonNetwork.Payload)new PlayerInfoSync.All(Map.of(p.m_20148_(), (LegacyPlayerInfo)p), Collections.emptyMap(), p.f_8924_.m_130008_(), PlayerInfoSync.All.ID_S2C));
        CommonNetwork.forceEnabledPlayer((ServerPlayer)p, () -> {
            CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)PlayerInfoSync.All.fromPlayerList(p.m_20194_()));
            playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)payload));
        });
        if (!p.f_8924_.m_6982_()) {
            Legacy4JClient.serverPlayerJoin(p);
        }
    }

    public static void onServerStart(MinecraftServer server) {
        playerInitialPayloads = Legacy4J.createPlayerInitialPayloads(server);
        LegacyWorldOptions.WORLD_STORAGE.withServerFile(server, "legacy_data.json").load();
    }

    public static void onResourcesReload(PlayerList playerList) {
        Legacy4J.onServerStart(playerList.m_7873_());
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayers((Collection)playerList.m_11314_(), (CommonNetwork.Payload)payload));
    }

    public static Collection<CommonNetwork.Payload> createPlayerInitialPayloads(MinecraftServer server) {
        HashSet<CommonNetwork.Payload> payloads = new HashSet<CommonNetwork.Payload>();
        payloads.add(new ClientAdvancementsPayload(server.m_129889_().m_136028_().stream().collect(Collectors.toMap(Advancement::m_138327_, Advancement::m_138313_))));
        return payloads;
    }

    public static void copySaveToDirectory(InputStream stream, File directory) {
        if (directory.exists()) {
            FileUtils.deleteQuietly((File)directory);
        }
        try (ZipInputStream inputStream = new ZipInputStream(stream);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                int len;
                File newFile = new File(directory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

