/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;

public class ControllerBinding<T extends BindingState> {
    public static final Map<String, ControllerBinding<?>> map = new ListMap();
    public static final Codec<ControllerBinding<?>> CODEC = Codec.STRING.xmap(map::get, ControllerBinding::getKey);
    public static final Codec<Optional<ControllerBinding<?>>> OPTIONAL_CODEC = Codec.STRING.xmap(s -> s.equals("none") ? Optional.empty() : Optional.ofNullable(map.get(s)), b -> b.map(ControllerBinding::getKey).orElse("none"));
    private static final Map<ControllerBinding<?>, Function<Options, List<KeyMapping>>> defaultKeyMappingByBinding = new HashMap();
    public final Function<ControllerBinding<T>, T> stateConstructor;
    public final T bindingState;
    public final boolean isBindable;
    private final String key;
    public static final ControllerBinding<BindingState.Button> DOWN_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("down_button", (ArbitrarySupplier<Button>)((ArbitrarySupplier)() -> (Boolean)LegacyOptions.invertControllerButtons.get() != false ? Button.RIGHT : Button.DOWN)), o -> List.of(o.f_92089_));
    public static final ControllerBinding<BindingState.Button> RIGHT_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("right_button", (ArbitrarySupplier<Button>)((ArbitrarySupplier)() -> (Boolean)LegacyOptions.invertControllerButtons.get() != false ? Button.DOWN : Button.RIGHT)), o -> List.of(o.f_92094_));
    public static final ControllerBinding<BindingState.Button> LEFT_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("left_button", Button.LEFT), o -> List.of(Legacy4JClient.keyCrafting));
    public static final ControllerBinding<BindingState.Button> UP_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("up_button", Button.UP), o -> List.of(o.f_92092_));
    public static final ControllerBinding<BindingState.Button> BACK = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("back", Button.BACK), o -> List.of(Legacy4JClient.keyHostOptions));
    public static final ControllerBinding<BindingState.Button> GUIDE = ControllerBinding.register(ControllerBinding.createButton("guide", Button.GUIDE));
    public static final ControllerBinding<BindingState.Button> START = ControllerBinding.register(ControllerBinding.createButton("start", Button.START));
    public static final ControllerBinding<BindingState.Axis> LEFT_STICK = ControllerBinding.register(new ControllerBinding<BindingState.Axis>("left_stick", c -> BindingState.Axis.createStick(c, () -> Float.valueOf(((Double)LegacyOptions.leftStickDeadZone.get()).floatValue()), (a, s) -> {}, true), false));
    public static final ControllerBinding<BindingState.Axis> RIGHT_STICK = ControllerBinding.register(new ControllerBinding<BindingState.Axis>("right_stick", c -> BindingState.Axis.createStick(c, () -> Float.valueOf(((Double)LegacyOptions.rightStickDeadZone.get()).floatValue()), ControllerManager::updatePlayerCamera, false), false));
    public static final ControllerBinding<BindingState.Button> LEFT_STICK_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("left_stick_button", Button.LEFT_STICK), o -> List.of(o.f_92103_));
    public static final ControllerBinding<BindingState.Button> RIGHT_STICK_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("right_stick_button", Button.RIGHT_STICK), o -> List.of(o.f_92090_));
    public static final ControllerBinding<BindingState.Button> LEFT_BUMPER = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("left_bumper", Button.LEFT_BUMPER), o -> List.of(Legacy4JClient.keyCycleHeldLeft));
    public static final ControllerBinding<BindingState.Button> RIGHT_BUMPER = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("right_bumper", Button.RIGHT_BUMPER), o -> List.of(Legacy4JClient.keyCycleHeldRight));
    public static final ControllerBinding<BindingState.Axis> LEFT_TRIGGER = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState.Axis>("left_trigger", c -> BindingState.Axis.createTrigger(c, () -> Float.valueOf(((Double)LegacyOptions.leftTriggerDeadZone.get()).floatValue()), true)), o -> List.of(o.f_92095_));
    public static final ControllerBinding<BindingState.Axis> RIGHT_TRIGGER = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState.Axis>("right_trigger", c -> BindingState.Axis.createTrigger(c, () -> Float.valueOf(((Double)LegacyOptions.rightTriggerDeadZone.get()).floatValue()), false)), o -> List.of(o.f_92096_));
    public static final ControllerBinding<BindingState.Button> DPAD_UP = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("dpad_up", Button.DPAD_UP), o -> List.of(Legacy4JClient.keyFlyUp));
    public static final ControllerBinding<BindingState.Button> DPAD_DOWN = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("dpad_down", Button.DPAD_DOWN), o -> List.of(Legacy4JClient.keyFlyDown));
    public static final ControllerBinding<BindingState.Button> DPAD_LEFT = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("dpad_left", Button.DPAD_LEFT), o -> List.of(Legacy4JClient.keyFlyLeft));
    public static final ControllerBinding<BindingState.Button> DPAD_RIGHT = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("dpad_right", Button.DPAD_RIGHT), o -> List.of(Legacy4JClient.keyFlyRight));
    public static final ControllerBinding<BindingState.Button> TOUCHPAD_BUTTON = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("touchpad_button", Button.TOUCHPAD), o -> List.of(o.f_92098_));
    public static final ControllerBinding<BindingState.Button> CAPTURE = ControllerBinding.registerWithDefaults(ControllerBinding.createButton("capture", Button.CAPTURE), o -> List.of(o.f_92102_));
    public static final ControllerBinding<BindingState.Button> LSL_BUTTON = ControllerBinding.register(ControllerBinding.createButton("lsl_button", Button.LSL));
    public static final ControllerBinding<BindingState.Button> LSR_BUTTON = ControllerBinding.register(ControllerBinding.createButton("lsr_button", Button.LSR));
    public static final ControllerBinding<BindingState.Button> RSL_BUTTON = ControllerBinding.register(ControllerBinding.createButton("rsl_button", Button.RSL));
    public static final ControllerBinding<BindingState.Button> RSR_BUTTON = ControllerBinding.register(ControllerBinding.createButton("rsr_button", Button.RSR));
    public static final ControllerBinding<BindingState> LEFT_STICK_UP = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState>("left_stick_up", c -> BindingState.create(c, h -> ControllerBinding.LEFT_STICK.state().y <= -LEFT_STICK.state().getDeadZone())), o -> List.of(o.f_92085_));
    public static final ControllerBinding<BindingState> LEFT_STICK_DOWN = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState>("left_stick_down", c -> BindingState.create(c, h -> ControllerBinding.LEFT_STICK.state().y >= LEFT_STICK.state().getDeadZone())), o -> List.of(o.f_92087_));
    public static final ControllerBinding<BindingState> LEFT_STICK_RIGHT = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState>("left_stick_right", c -> BindingState.create(c, h -> ControllerBinding.LEFT_STICK.state().x >= LEFT_STICK.state().getDeadZone())), o -> List.of(o.f_92088_));
    public static final ControllerBinding<BindingState> LEFT_STICK_LEFT = ControllerBinding.registerWithDefaults(new ControllerBinding<BindingState>("left_stick_left", c -> BindingState.create(c, h -> ControllerBinding.LEFT_STICK.state().x <= -LEFT_STICK.state().getDeadZone())), o -> List.of(o.f_92086_));
    public static final ControllerBinding<BindingState> RIGHT_STICK_UP = ControllerBinding.register(new ControllerBinding<BindingState>("right_stick_up", c -> BindingState.create(c, h -> ControllerBinding.RIGHT_STICK.state().y <= -RIGHT_STICK.state().getDeadZone())));
    public static final ControllerBinding<BindingState> RIGHT_STICK_DOWN = ControllerBinding.register(new ControllerBinding<BindingState>("right_stick_down", c -> BindingState.create(c, h -> ControllerBinding.RIGHT_STICK.state().y >= RIGHT_STICK.state().getDeadZone())));
    public static final ControllerBinding<BindingState> RIGHT_STICK_RIGHT = ControllerBinding.register(new ControllerBinding<BindingState>("right_stick_right", c -> BindingState.create(c, h -> ControllerBinding.RIGHT_STICK.state().x >= RIGHT_STICK.state().getDeadZone())));
    public static final ControllerBinding<BindingState> RIGHT_STICK_LEFT = ControllerBinding.register(new ControllerBinding<BindingState>("right_stick_left", c -> BindingState.create(c, h -> ControllerBinding.RIGHT_STICK.state().x <= -RIGHT_STICK.state().getDeadZone())));

    public ControllerBinding(String key, Function<ControllerBinding<T>, T> stateConstructor, boolean isBindable) {
        this.key = key;
        this.stateConstructor = stateConstructor;
        this.bindingState = (BindingState)((Object)stateConstructor.apply(this));
        this.isBindable = isBindable;
    }

    public T state() {
        return this.bindingState;
    }

    public ControllerBinding(String key, Function<ControllerBinding<T>, T> stateConstructor) {
        this(key, stateConstructor, true);
    }

    public String getKey() {
        return this.key;
    }

    public ControllerBinding<T> getMapped() {
        return this;
    }

    public ControlTooltip.LegacyIcon getIcon() {
        return ControlType.getActiveControllerType().getIcons().get(this.getMapped().getKey());
    }

    public static ControllerBinding<BindingState.Button> createButton(String key, final ArbitrarySupplier<Button> button) {
        return new ControllerBinding<BindingState.Button>(key, c -> new BindingState.Button((ControllerBinding<?>)c, button)){

            @Override
            public ControllerBinding<BindingState.Button> getMapped() {
                return ((Button)((Object)button.get())).binding;
            }
        };
    }

    public static ControllerBinding<BindingState.Button> createButton(String key, Button button, boolean isBindable) {
        return new ControllerBinding<BindingState.Button>(key, c -> new BindingState.Button((ControllerBinding<?>)c, (ArbitrarySupplier<Button>)((ArbitrarySupplier)() -> button)), isBindable);
    }

    public static ControllerBinding<BindingState.Button> createButton(String key, Button button) {
        return ControllerBinding.createButton(key, button, true);
    }

    public static <B extends ControllerBinding<?>> B register(B binding) {
        map.put(binding.getKey(), binding);
        return binding;
    }

    private static <B extends ControllerBinding<?>> B registerWithDefaults(B binding, Function<Options, List<KeyMapping>> defaultKeyMappings) {
        defaultKeyMappingByBinding.put(binding, defaultKeyMappings);
        return ControllerBinding.register(binding);
    }

    public static void setupDefaultBindings(Minecraft minecraft) {
        defaultKeyMappingByBinding.forEach((binding, optionsListFunction) -> {
            for (KeyMapping keyMapping : (List)optionsListFunction.apply(minecraft.f_91066_)) {
                LegacyKeyMapping.of(keyMapping).setDefaultBinding(binding);
                LegacyKeyMapping.of(keyMapping).setBinding(binding);
            }
        });
    }

    public static enum Button {
        DOWN(DOWN_BUTTON),
        RIGHT(RIGHT_BUTTON),
        LEFT(LEFT_BUTTON),
        UP(UP_BUTTON),
        BACK(BACK),
        GUIDE(GUIDE),
        START(START),
        LEFT_STICK(LEFT_STICK_BUTTON),
        RIGHT_STICK(RIGHT_STICK_BUTTON),
        LEFT_BUMPER(LEFT_BUMPER),
        RIGHT_BUMPER(RIGHT_BUMPER),
        DPAD_UP(DPAD_UP),
        DPAD_DOWN(DPAD_DOWN),
        DPAD_LEFT(DPAD_LEFT),
        DPAD_RIGHT(DPAD_RIGHT),
        TOUCHPAD(TOUCHPAD_BUTTON),
        CAPTURE(CAPTURE),
        LSL(LSL_BUTTON),
        LSR(LSR_BUTTON),
        RSL(RSL_BUTTON),
        RSR(RSR_BUTTON);

        public final ControllerBinding<BindingState.Button> binding;

        private Button(ControllerBinding<BindingState.Button> binding) {
            this.binding = binding;
        }
    }

    public static enum Axis {
        LEFT_STICK_X,
        LEFT_STICK_Y,
        RIGHT_STICK_X,
        RIGHT_STICK_Y,
        LEFT_TRIGGER,
        RIGHT_TRIGGER;

    }
}

