/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class KeyboardScreen
extends OverlayPanelScreen {
    public static final Component KEYBOARD = Component.m_237115_((String)"legacy.menu.keyboard");
    private final Supplier<GuiEventListener> listenerSupplier;
    protected RenderableVList renderableVList;
    protected RenderableVList leftKeyBar;
    protected RenderableVList rightKeyBar;
    public boolean shift;
    protected boolean shiftLock;
    protected final LegacyScrollRenderer scrollRenderer;
    protected final KeyButton shiftButton;
    protected final KeyButton upButton;
    protected final KeyButton downButton;
    protected final KeyButton rightButton;
    protected final KeyButton leftButton;
    protected final KeyButton backspaceButton;
    protected final KeyButton confirmButton;
    protected int lastX;
    protected int lastY;
    protected int xDiff;
    protected int yDiff;

    public KeyboardScreen(Supplier<GuiEventListener> listener, Screen parent) {
        this(60, listener, parent);
    }

    public KeyboardScreen(int yOffset, Supplier<GuiEventListener> listener, Screen parent) {
        this((Screen s, Panel p) -> p.centeredLeftPos((Screen)s), (s, p) -> Math.min(p.centeredTopPos((Screen)s) + yOffset, s.f_96544_ - p.height), listener, parent);
    }

    public KeyboardScreen(BiFunction<Screen, Panel, Integer> leftPosGetter, BiFunction<Screen, Panel, Integer> topPosGetter, Supplier<GuiEventListener> listener, Screen parent) {
        this((Screen s) -> Panel.createPanel(s, p -> p.appearance(LegacySprites.PANEL, 385, 154), p -> p.pos((Integer)leftPosGetter.apply((Screen)s, (Panel)((Object)p)), (Integer)topPosGetter.apply((Screen)s, (Panel)((Object)p)))), listener, parent);
    }

    public KeyboardScreen(Function<Screen, Panel> panelConstructor, Supplier<GuiEventListener> listener, Screen parent) {
        super(parent, panelConstructor, CommonComponents.f_237098_);
        this.renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> 1);
        this.leftKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.rightKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.shift = false;
        this.shiftLock = false;
        this.scrollRenderer = new LegacyScrollRenderer();
        this.lastX = 0;
        this.lastY = 0;
        this.xDiff = 0;
        this.yDiff = 0;
        this.listenerSupplier = listener;
        this.renderableVList.forceWidth = false;
        this.transparentBackground = false;
        LegacyResourceManager.keyboardButtonBuilders.forEach(b -> this.renderableVList.addRenderable((Renderable)b.build(this)));
        this.leftButton = new KeyButton(263, this.listenerSupplier, ControllerBinding.LEFT_BUMPER, LegacySprites.SCROLL_LEFT);
        this.leftKeyBar.addRenderable((Renderable)this.leftButton);
        this.rightButton = new KeyButton(262, this.listenerSupplier, ControllerBinding.RIGHT_BUMPER, LegacySprites.SCROLL_RIGHT);
        this.rightKeyBar.addRenderable((Renderable)this.rightButton);
        this.upButton = new KeyButton(265, 20, this.listenerSupplier, null, LegacySprites.SCROLL_UP);
        this.leftKeyBar.addRenderable((Renderable)this.upButton);
        this.downButton = new KeyButton(264, 20, this.listenerSupplier, null, LegacySprites.SCROLL_DOWN);
        this.leftKeyBar.addRenderable((Renderable)this.downButton);
        this.shiftButton = new KeyButton(340, this.listenerSupplier, LegacyResourceManager.shiftBinding, LegacySprites.SHIFT){
            long lastRelease;

            @Override
            public boolean playSoundOnClick() {
                return this.pressTime == 0 && !KeyboardScreen.this.shiftLock;
            }

            @Override
            public void onRelease() {
                long millis = Util.m_137550_();
                if (!KeyboardScreen.this.shiftLock) {
                    if (this.pressTime >= 6 || millis - this.lastRelease <= 300L) {
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SHIFT_LOCK.get(), 1.0f);
                        KeyboardScreen.this.shiftLock = true;
                    }
                    KeyboardScreen.this.shift = !KeyboardScreen.this.shift || KeyboardScreen.this.shiftLock;
                } else {
                    KeyboardScreen.this.shiftLock = false;
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SHIFT_UNLOCK.get(), 1.0f);
                }
                this.lastRelease = millis;
                super.onRelease();
            }

            @Override
            public ResourceLocation getSprite() {
                return KeyboardScreen.this.shiftLock ? LegacySprites.BUTTON_SLOT_SELECTED : super.getSprite();
            }
        };
        this.leftKeyBar.addRenderable((Renderable)this.shiftButton);
        this.backspaceButton = new KeyButton(259, this.listenerSupplier, ControllerBinding.LEFT_BUTTON, LegacySprites.BACK){

            @Override
            public SoundEvent getDownSoundEvent() {
                return (SoundEvent)LegacyRegistries.BACKSPACE.get();
            }
        };
        this.rightKeyBar.addRenderable((Renderable)this.backspaceButton);
        this.confirmButton = new KeyButton(257, this.listenerSupplier, ControllerBinding.START, TickBox.TICK){

            @Override
            public void m_5691_() {
                KeyboardScreen.this.m_7379_();
            }
        };
        this.rightKeyBar.addRenderable((Renderable)this.confirmButton);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? null : ControllerBinding.RIGHT_STICK.getIcon(), () -> LegacyComponents.MOVE_KEYBOARD);
    }

    public static boolean isOpenKey(int i) {
        return i == 335 && !Legacy4JClient.controllerManager.isControllerTheLastInput() || i == 257 && Legacy4JClient.controllerManager.isControllerTheLastInput();
    }

    public static KeyboardScreen fromStaticListener(GuiEventListener listener, Screen parent) {
        KeyboardScreen keyboardScreen;
        if (listener instanceof LayoutElement) {
            LayoutElement e = (LayoutElement)listener;
            keyboardScreen = new KeyboardScreen((s, p) -> Math.max(0, Math.min(e.m_252754_() + (e.m_5711_() - p.width) / 2, s.f_96543_ - p.width)), (s, p) -> Math.max(0, Math.min(s.f_96544_ - (e.m_252907_() + e.m_93694_()) >= p.height ? e.m_252907_() + e.m_93694_() + 4 : e.m_252907_() - p.m_93694_() - 4, s.f_96544_ - p.height)), () -> listener, parent);
        } else {
            keyboardScreen = new KeyboardScreen(() -> listener, parent);
        }
        return keyboardScreen;
    }

    @Override
    protected void m_7856_() {
        Renderable renderable;
        this.panel.init();
        this.lastX = this.panel.m_252754_();
        this.lastY = this.panel.m_252907_();
        this.panel.m_264152_(this.lastX + this.xDiff, this.lastY + this.yDiff);
        this.renderableVList.init(this.panel.m_252754_() + (this.panel.m_5711_() - 259) / 2, this.panel.m_252907_() + 28, 268, 124);
        this.leftKeyBar.init(this.panel.m_252754_() + 6, this.panel.m_252907_() + 27, 50, 0);
        this.rightKeyBar.init(this.panel.m_252754_() + this.panel.m_5711_() - 56, this.panel.m_252907_() + 27, 50, 0);
        if (this.m_7222_() == null && !this.renderableVList.renderables.isEmpty() && (renderable = this.renderableVList.renderables.get(0)) instanceof GuiEventListener) {
            GuiEventListener l = (GuiEventListener)renderable;
            this.m_7522_(l);
        }
    }

    public void m_6574_(Minecraft minecraft, int i, int j) {
        this.m_7379_();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof CharButton) {
            CharButton c = (CharButton)guiEventListener;
            c.renderTooltip(guiGraphics, i, j, f);
        }
    }

    public boolean m_5534_(char c, int i) {
        for (Renderable renderable : this.renderableVList.renderables) {
            CharButton b;
            if (!(renderable instanceof CharButton) || !(b = (CharButton)renderable).matches(c)) continue;
            this.m_7522_((GuiEventListener)b);
            break;
        }
        return super.m_5534_(c, i);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.renderableVList.keyPressed(i)) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.8f);
        this.panel.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)((float)this.panel.m_252754_() + 4.5f), (double)this.panel.m_252907_() + 25.5, 0.0);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 53, 123);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.panel.m_5711_() - 62, 0, 53, 123);
        guiGraphics.m_280168_().m_252880_(-4.5f, 0.0f, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, (this.panel.m_5711_() - 267) / 2, -1, 267, 125);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.panel.m_252754_() + ((float)this.panel.m_5711_() - (float)this.f_96547_.m_92852_((FormattedText)KEYBOARD) * 1.5f) / 2.0f, (float)(this.panel.m_252907_() + 8), 0.0f);
        guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
        guiGraphics.m_280614_(this.f_96547_, KEYBOARD, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public void bindingStateTick(BindingState state) {
        this.m_6702_().forEach(r -> {
            if (r instanceof ActionButton) {
                ActionButton a = (ActionButton)((Object)r);
                if (state.is(a.binding)) {
                    if (state.canClick()) {
                        a.m_7435_(this.f_96541_.m_91106_());
                        a.m_5691_();
                    } else if (state.released) {
                        a.onRelease();
                    }
                }
            }
        });
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis a = (BindingState.Axis)state;
            if (state.canClick(20)) {
                if (state.canClick()) {
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
                }
                this.xDiff = Math.max(0, Math.min(this.panel.m_252754_() + Math.round(a.x * 4.0f), this.f_96543_ - this.panel.m_5711_())) - this.lastX;
                this.yDiff = Math.max(0, Math.min(this.panel.m_252907_() + Math.round(a.y * 4.0f), this.f_96544_ - this.panel.m_93694_())) - this.lastY;
                this.m_267719_();
            }
        }
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    public static class KeyButton
    extends ActionButton {
        public final int key;
        private final Supplier<GuiEventListener> keyListener;

        public KeyButton(int key, Supplier<GuiEventListener> keyListener, ControllerBinding binding, ResourceLocation iconSprite) {
            this(key, 40, keyListener, binding, iconSprite);
        }

        @Override
        public boolean playSoundOnClick() {
            return true;
        }

        public KeyButton(int key, int height, Supplier<GuiEventListener> keyListener, ControllerBinding binding, ResourceLocation iconSprite) {
            super(50, height, CommonComponents.f_237098_, binding, iconSprite);
            this.key = key;
            this.keyListener = keyListener;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.getSprite(), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
            RenderSystem.enableBlend();
            this.m_280139_(guiGraphics, Minecraft.m_91087_().f_91062_, ScreenUtil.getDefaultTextColor(!this.m_198029_()));
            RenderSystem.disableBlend();
        }

        public ResourceLocation getSprite() {
            return this.m_198029_() ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT;
        }

        @Override
        public void m_5691_() {
            super.m_5691_();
            GuiEventListener l = this.keyListener.get();
            if (l != null) {
                l.m_93692_(true);
                l.m_7933_(this.key, 0, 0);
            }
        }
    }

    public class CharButton
    extends ActionButton {
        private final String chars;
        private final String shiftChars;
        private final SoundEvent downSound;
        private int selectedChar;

        public CharButton(int width, String chars, String shiftChars, ControllerBinding binding, ResourceLocation iconSprite, SoundEvent downSound) {
            super(width, 20, CommonComponents.f_237098_, binding, iconSprite);
            this.selectedChar = 0;
            this.chars = chars;
            this.shiftChars = shiftChars;
            this.downSound = downSound;
        }

        public boolean matches(char c) {
            return this.chars.contains(String.valueOf(c)) || this.shiftChars != null && this.shiftChars.contains(String.valueOf(c));
        }

        public void renderTooltip(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.pressTime >= 6 && this.getSelectedChars().length() > 1) {
                int width = 18;
                char[] chars = this.getSelectedChars().toCharArray();
                for (int i1 = 0; i1 < chars.length; ++i1) {
                    String s = String.valueOf(chars[i1]);
                    width += KeyboardScreen.this.f_96547_.m_92895_(s) + (i1 == 0 ? 0 : 2);
                }
                int diffX = 0;
                ScreenUtil.renderPointerPanel(guiGraphics, this.m_252754_() + (this.m_5711_() - width) / 2, this.m_252907_() - 17, width, 15);
                for (char c : chars) {
                    String s = String.valueOf(c);
                    guiGraphics.m_280488_(KeyboardScreen.this.f_96547_, s, this.m_252754_() + (this.m_5711_() - width) / 2 + diffX + 9, this.m_252907_() - 14, c == this.getSelectedChar() ? 0xFFFF00 : 0xFFFFFF);
                    diffX += KeyboardScreen.this.f_96547_.m_92895_(s) + 2;
                }
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.m_252754_() + (this.m_5711_() - width) / 2 + 2, this.m_252907_() - 15);
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.m_252754_() + (this.m_5711_() - width) / 2 + width - 9, this.m_252907_() - 15);
            }
        }

        @Override
        public SoundEvent getDownSoundEvent() {
            return this.downSound == null ? super.getDownSoundEvent() : this.downSound;
        }

        public boolean m_7933_(int i, int j, int k) {
            if ((i == 263 || i == 262) && this.pressTime >= 6) {
                this.selectedChar = Stocker.cyclic((int)0, (int)(this.selectedChar + (i == 262 ? 1 : -1)), (int)this.getSelectedChars().length());
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        public void m_93692_(boolean bl) {
            super.m_93692_(bl);
            if (!bl && this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Override
        public void onRelease() {
            GuiEventListener l = KeyboardScreen.this.listenerSupplier.get();
            if (l != null) {
                KeyboardScreen.this.parent.m_7522_(l);
                l.m_5534_(this.getSelectedChar(), 0);
            }
            if (this.shiftChars != null && KeyboardScreen.this.shift && !KeyboardScreen.this.shiftLock) {
                KeyboardScreen.this.shift = false;
            }
            this.selectedChar = 0;
            super.onRelease();
        }

        public char getSelectedChar() {
            String characters;
            return characters.charAt((characters = this.getSelectedChars()).length() > this.selectedChar ? this.selectedChar : 0);
        }

        public String getSelectedChars() {
            return this.shiftChars != null && (Screen.m_96638_() || KeyboardScreen.this.shift) ? this.shiftChars : this.chars;
        }

        public Component m_6035_() {
            return Component.m_237113_((String)String.valueOf(this.getSelectedChar()));
        }
    }

    public static abstract class ActionButton
    extends AbstractButton {
        public final ControllerBinding binding;
        private final ResourceLocation iconSprite;
        public int pressTime = 0;

        public ActionButton(int k, int l, Component component, ControllerBinding binding, ResourceLocation iconSprite) {
            super(0, 0, k, l, component);
            this.binding = binding;
            this.iconSprite = iconSprite;
        }

        public void onRelease() {
            this.pressTime = 0;
        }

        public void m_5691_() {
            ++this.pressTime;
        }

        public void m_7435_(SoundManager soundManager) {
            if (this.playSoundOnClick()) {
                ScreenUtil.playSimpleUISound(this.getDownSoundEvent(), 1.0f);
            }
        }

        public boolean playSoundOnClick() {
            return this.pressTime == 0;
        }

        public SoundEvent getDownSoundEvent() {
            return (SoundEvent)LegacyRegistries.ACTION.get();
        }

        public void m_7691_(double d, double e) {
            if (this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            return super.m_264064_(focusNavigationEvent);
        }

        public boolean m_7920_(int i, int j, int k) {
            if (this.f_93623_ && this.f_93624_ && CommonInputs.m_278691_((int)i) && this.pressTime > 0) {
                this.onRelease();
                return true;
            }
            return false;
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            int bindingOffset = 0;
            if (this.binding != null && Legacy4JClient.controllerManager.connectedController != null) {
                bindingOffset = this.binding.getIcon().render(guiGraphics, this.m_252754_() + i, this.m_252907_() + (this.m_93694_() - 9) / 2 + 1, true, false);
            }
            if (this.iconSprite == null) {
                ActionButton.m_280138_((GuiGraphics)guiGraphics, (Font)font, (Component)this.m_6035_(), (int)(this.m_252754_() + i + bindingOffset), (int)this.m_252907_(), (int)(this.m_252754_() + this.m_5711_() - i), (int)(this.m_252907_() + this.m_93694_()), (int)j);
            } else {
                TextureAtlasSprite sprite = FactoryGuiGraphics.getSprites().f_118884_.f_118264_.getOrDefault(this.iconSprite, null);
                if (sprite == null) {
                    return;
                }
                try (SpriteContents contents = sprite.m_245424_();){
                    RenderSystem.enableBlend();
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.iconSprite, this.m_252754_() + (this.m_5711_() - contents.m_246492_()) / 2 + Math.max(0, i + bindingOffset - (this.m_5711_() - contents.m_246492_()) / 2), this.m_252907_() + (this.m_93694_() - contents.m_245330_()) / 2, contents.m_246492_(), contents.m_245330_());
                    RenderSystem.disableBlend();
                }
            }
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }

    public record CharButtonBuilder(int width, String chars, String shiftChars, ControllerBinding binding, ResourceLocation iconSprite, SoundEvent downSound) {
        public CharButton build(KeyboardScreen screen) {
            KeyboardScreen keyboardScreen = screen;
            Objects.requireNonNull(keyboardScreen);
            return keyboardScreen.new CharButton(this.width, this.chars, this.shiftChars, this.binding, this.iconSprite, this.downSound);
        }
    }
}

