/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.Legacy4J;
import wily.legacy.config.LegacyCommonOptions;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    @Final
    public static DecimalFormat f_41584_;
    @Unique
    private static final UUID BASE_ATTACK_DAMAGE_UUID;

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=0))
    public ChatFormatting getTooltipLines(ChatFormatting arg) {
        return ChatFormatting.GOLD;
    }

    @Unique
    private DecimalFormat getLegacyDecimalFormat(DecimalFormat instance) {
        instance.setMinimumFractionDigits(FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? 1 : 0);
        return instance;
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;getId()Ljava/util/UUID;"))
    private UUID getTooltipLines(AttributeModifier instance) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? null : instance.m_22209_();
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false, ordinal=6))
    private boolean getTooltipLines(List instance, Object e) {
        return FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? false : instance.add(e);
    }

    @ModifyExpressionValue(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;getAmount()D")})
    private double addModifierTooltip(double original, @Local(ordinal=0) Map.Entry<Attribute, AttributeModifier> entry, @Local(ordinal=0) List<Component> list) {
        double d = (double)(entry.getValue().m_22209_().equals(BASE_ATTACK_DAMAGE_UUID) ? Legacy4J.getItemDamageModifier((ItemStack)this) : 0.0f) + original;
        if (d == 0.0 && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + entry.getValue().m_22217_().m_22235_()), (Object[])new Object[]{this.getLegacyDecimalFormat(f_41584_).format(d), Component.m_237115_((String)entry.getKey().m_22087_())}).m_130940_(ChatFormatting.GRAY));
        }
        return d;
    }

    @ModifyReceiver(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/text/DecimalFormat;format(D)Ljava/lang/String;")})
    private DecimalFormat addModifierTooltip(DecimalFormat instance, double v) {
        return this.getLegacyDecimalFormat(instance);
    }

    @Inject(method={"getAttributeModifiers"}, at={@At(value="RETURN")}, cancellable=true)
    private void getAttributeModifiers(EquipmentSlot equipmentSlot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        Multimap attributes = (Multimap)cir.getReturnValue();
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) && attributes.containsKey((Object)Attributes.f_22283_)) {
            ListMultimap newAttributes = Multimaps.newListMultimap(new LinkedHashMap(), ArrayList::new);
            newAttributes.putAll(attributes);
            newAttributes.removeAll((Object)Attributes.f_22283_);
            cir.setReturnValue((Object)newAttributes);
        }
    }

    static {
        BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    }
}

