/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.cauldron;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.init.LegacyRegistries;

@Mixin(value={LayeredCauldronBlock.class})
public abstract class LayeredCauldronBlockMixin
extends AbstractCauldronBlock
implements EntityBlock {
    public LayeredCauldronBlockMixin(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> interactionMap) {
        super(properties, interactionMap);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (LegacyRegistries.isInvalidCauldron(blockState, level, blockPos) && player.m_21120_(interactionHand).m_41720_() instanceof BucketItem) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.m_60713_(Blocks.f_152476_)) {
            return;
        }
        level.m_141902_(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
            if (be.potion == null || be.hasWater()) {
                return;
            }
            int i = PotionUtils.m_43559_((Potion)((Potion)be.potion.m_203334_()));
            double d = (double)(i >> 16 & 0xFF) / 255.0;
            double e = (double)(i >> 8 & 0xFF) / 255.0;
            double f = (double)(i & 0xFF) / 255.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (2.0 * level.f_46441_.m_188500_() - 1.0) / 4.0 + (double)blockPos.m_123341_(), level.f_46441_.m_188500_() + (double)blockPos.m_123342_(), (2.0 * level.f_46441_.m_188500_() - 1.0) / 4.0 + (double)blockPos.m_123343_(), d, e, f);
        });
    }

    @Inject(method={"handlePrecipitation"}, at={@At(value="HEAD")}, cancellable=true)
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos blockPos, Biome.Precipitation precipitation, CallbackInfo ci) {
        if (LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
            ci.cancel();
        }
    }

    @Inject(method={"receiveStalactiteDrip"}, at={@At(value="HEAD")}, cancellable=true)
    public void receiveStalactiteDrip(BlockState blockState, Level level, BlockPos blockPos, Fluid fluid, CallbackInfo ci) {
        if (LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
            ci.cancel();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return blockState.m_60713_(Blocks.f_152476_) ? new WaterCauldronBlockEntity(blockPos, blockState) : null;
    }
}

