/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;

public record ClientAnimalInLoveSyncPayload(int entityID, int inLove, int age) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ClientAnimalInLoveSyncPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_in_love"), ClientAnimalInLoveSyncPayload::new);

    public ClientAnimalInLoveSyncPayload(CommonNetwork.PlayBuf buf) {
        this(((FriendlyByteBuf)buf.get()).m_130242_(), ((FriendlyByteBuf)buf.get()).m_130242_(), ((FriendlyByteBuf)buf.get()).m_130242_());
    }

    public static ClientAnimalInLoveSyncPayload of(Animal animal) {
        return new ClientAnimalInLoveSyncPayload(animal.m_19879_(), animal.m_27591_(), animal.m_146764_());
    }

    public static void sync(Animal entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            ClientAnimalInLoveSyncPayload packet = null;
            for (ServerPlayer player : l.m_7654_().m_6846_().m_11314_()) {
                if (player.m_9236_() != entity.m_9236_() || !(player.m_20270_((Entity)entity) < (float)(l.m_7654_().m_6846_().m_11312_() * 16))) continue;
                CommonNetwork.sendToPlayer((ServerPlayer)player, packet == null ? ClientAnimalInLoveSyncPayload.of(entity) : packet);
            }
        }
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).m_130130_(this.entityID());
        ((FriendlyByteBuf)buf.get()).m_130130_(this.inLove);
        ((FriendlyByteBuf)buf.get()).m_130130_(this.age);
    }

    public void apply(CommonNetwork.SecureExecutor executor, Supplier<Player> p) {
        Entity entity = p.get().m_9236_().m_6815_(this.entityID);
        if (entity instanceof Animal) {
            Animal e = (Animal)entity;
            e.m_27601_(this.inLove);
            e.m_146762_(this.age);
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }
}

