/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.ClientEntityAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.MCAccount;

public class ScreenUtil {
    public static final ResourceLocation GUI_ATLAS = FactoryAPI.createVanillaLocation((String)"textures/atlas/gui.png");
    private static final Minecraft mc = Minecraft.m_91087_();
    public static long lastHotbarSelectionChange = -1L;
    public static long animatedCharacterTime;
    public static long remainingAnimatedCharacterTime;
    public static int lastHotbarSelection;
    protected static final LogoRenderer logoRenderer;
    public static final PanoramaRenderer panoramaRenderer;
    public static final LegacyIconHolder iconHolderRenderer;
    public static final ResourceLocation MINECRAFT;
    public static final ResourceLocation PANORAMA_DAY;
    public static final ResourceLocation PANORAMA_NIGHT;
    public static final ResourceLocation MENU_BACKGROUND;
    public static final ResourceLocation LOADING_BACKGROUND;
    public static final Bearer<Integer> actualPlayerTabWidth;
    public static final Bearer<Integer> actualPlayerTabHeight;

    public static void renderPointerPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.blitTranslucentOverlaySprite(graphics, LegacySprites.POINTER_PANEL, x, y, width, height);
    }

    public static void blitTranslucentOverlaySprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
        ScreenUtil.blitTranslucentSprite(graphics, sprite, x, y, width, height);
        FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
    }

    public static void blitTranslucentSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, x, y, width, height);
        RenderSystem.disableBlend();
    }

    public static void renderPanelTranslucentRecess(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.blitTranslucentSprite(graphics, LegacySprites.PANEL_TRANSLUCENT_RECESS, x, y, width, height);
    }

    public static void renderTiles(ResourceLocation location, GuiGraphics graphics, int x, int y, int width, int height, float dp) {
        mc.m_91097_().m_118506_(GUI_ATLAS).m_117966_();
        GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        if ((double)dp != 1.0) {
            graphics.m_280168_().m_85841_(1.0f / dp, 1.0f / dp, 1.0f / dp);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(location, 0, 0, (int)((float)width * dp), (int)((float)height * dp));
        graphics.m_280168_().m_85849_();
        GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
    }

    public static void drawAutoSavingIcon(GuiGraphics graphics, int x, int y) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_CHEST, x * 2, y * 2, 48, 48);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        double heightAnim = (double)Util.m_137550_() / 50.0 % 11.0;
        graphics.m_280168_().m_85837_((double)x + 5.5, (double)(y - 8) - (heightAnim > 5.0 ? 10.0 - heightAnim : heightAnim), 0.0);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_ARROW, 0, 0, 13, 16);
        graphics.m_280168_().m_85849_();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics) {
        ScreenUtil.renderDefaultBackground(accessor, guiGraphics, true);
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean title) {
        ScreenUtil.renderDefaultBackground(accessor, guiGraphics, false, title, true);
    }

    public static boolean isVisualNight() {
        return ScreenUtil.mc.f_91073_ != null && ScreenUtil.mc.f_91073_.m_46462_();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean forcePanorama, boolean title, boolean username) {
        if (ScreenUtil.mc.f_91073_ == null || accessor.getBoolean("forcePanorama", Boolean.valueOf(forcePanorama)).booleanValue()) {
            ScreenUtil.renderPanorama(guiGraphics, 1.0f, FactoryAPIClient.getPartialTick());
        } else {
            ScreenUtil.renderTransparentBackground(guiGraphics);
        }
        if (accessor.getBoolean("hasTitle", Boolean.valueOf(title)).booleanValue()) {
            ScreenUtil.renderLogo(guiGraphics);
        }
        if (accessor.getBoolean("hasUsername", Boolean.valueOf(username)).booleanValue()) {
            ScreenUtil.renderUsername(guiGraphics);
        }
    }

    public static void renderLogo(GuiGraphics guiGraphics) {
        logoRenderer.m_280037_(guiGraphics, guiGraphics.m_280182_(), 1.0f);
    }

    public static void renderLegacyLogo(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(((float)guiGraphics.m_280182_() - 285.5f) / 2.0f, 30.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(mc.m_91098_().m_213713_(MINECRAFT).isPresent() ? MINECRAFT : ControlType.getActiveType().getMinecraftLogo(), 0, 0, 0.0f, 0.0f, 571, 138, 571, 138);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    public static void renderTransparentBackground(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, graphics.m_280182_(), graphics.m_280206_(), graphics.m_280182_(), graphics.m_280206_());
        RenderSystem.disableBlend();
    }

    public static void renderUsername(GuiGraphics graphics) {
        if (ScreenUtil.mc.f_91073_ != null) {
            return;
        }
        String username = MCAccount.isOfflineUser() ? I18n.m_118938_((String)"legacy.menu.offline_user", (Object[])new Object[]{mc.m_91094_().m_92546_()}) : mc.m_91094_().m_92546_();
        graphics.m_280488_(ScreenUtil.mc.f_91062_, username, graphics.m_280182_() - 33 - ScreenUtil.mc.f_91062_.m_92895_(username), graphics.m_280206_() - 27, 0xFFFFFF);
    }

    public static void renderPanorama(GuiGraphics guiGraphics, float speed, float partialTick) {
        if (((Boolean)LegacyOptions.legacyPanorama.get()).booleanValue()) {
            ScreenUtil.renderLegacyPanorama(guiGraphics);
        } else {
            panoramaRenderer.m_110003_(partialTick, speed);
        }
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics) {
        ScreenUtil.renderLegacyPanorama(guiGraphics, ScreenUtil.isVisualNight());
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics, boolean isNight) {
        RenderSystem.depthMask((boolean)false);
        guiGraphics.m_280163_(isNight ? PANORAMA_NIGHT : PANORAMA_DAY, 0, 0, ((Double)ScreenUtil.mc.f_91066_.m_245201_().m_231551_()).floatValue() * (float)Util.m_137550_() * (float)guiGraphics.m_280206_() / 360.0f / 66.32f, 1.0f, guiGraphics.m_280182_(), guiGraphics.m_280206_() + 2, guiGraphics.m_280206_() * 820 / 144, guiGraphics.m_280206_() + 2);
        RenderSystem.depthMask((boolean)true);
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, Component component, int x, int y, int color, int outlineColor, float outline) {
        ScreenUtil.drawOutlinedString(graphics, font, component.m_7532_(), x, y, color, outlineColor, outline);
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int color, int outlineColor, float outline) {
        ScreenUtil.drawStringOutline(graphics, font, formattedCharSequence, x, y, outlineColor, outline);
        graphics.m_280649_(font, formattedCharSequence, x, y, color, false);
    }

    public static void drawStringOutline(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int outlineColor, float outline) {
        float[] translations;
        for (float t : translations = new float[]{0.0f, outline, -outline}) {
            for (float t1 : translations) {
                if (t == 0.0f && t1 == 0.0f) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(t, t1, 0.0f);
                graphics.m_280649_(font, formattedCharSequence, x, y, outlineColor, false);
                graphics.m_280168_().m_85849_();
            }
        }
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double x, double y, int width, int height) {
        return mouseX >= x && mouseX < x + (double)width && mouseY >= y && mouseY < y + (double)height;
    }

    public static void applyHUDScale(GuiGraphics graphics) {
        graphics.m_280168_().m_85841_(3.0f / ScreenUtil.getHUDScale(), 3.0f / ScreenUtil.getHUDScale(), 3.0f / ScreenUtil.getHUDScale());
    }

    public static void prepareHUDRender(GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, ScreenUtil.getHUDOpacity());
        graphics.m_280168_().m_85837_(0.0, ScreenUtil.getHUDDistance(), 0.0);
        RenderSystem.enableBlend();
    }

    public static void finalizeHUDRender(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    public static boolean hasClassicCrafting() {
        return (Boolean)LegacyOptions.classicCrafting.get();
    }

    public static boolean hasMixedCrafting() {
        return ((Boolean)LegacyOptions.forceMixedCrafting.get() != false || !FactoryAPIClient.hasModOnServer) && (Boolean)LegacyOptions.classicCrafting.get() == false;
    }

    public static float getHUDScale() {
        return Math.max(1.5f, (float)(4 - (Integer)LegacyOptions.hudScale.get()));
    }

    public static float getHUDSize() {
        return 6.0f + 3.0f / ScreenUtil.getHUDScale() * (float)(35 + (ScreenUtil.mc.f_91072_.m_105205_() ? Math.max(2, Mth.m_14165_((double)((Math.max(ScreenUtil.mc.f_91074_.m_21133_(Attributes.f_22276_), (double)Math.max((float)ScreenUtil.mc.f_91065_.f_92974_, ScreenUtil.mc.f_91074_.m_21223_())) + (double)ScreenUtil.mc.f_91074_.m_6103_()) / 20.0)) + (ScreenUtil.mc.f_91074_.m_21230_() > 0 ? 1 : 0)) * 10 : 0));
    }

    public static double getHUDDistance() {
        return -((Double)LegacyOptions.hudDistance.get()).doubleValue() * (22.5 + ((Boolean)LegacyOptions.inGameTooltips.get() != false ? 17.5 : 0.0));
    }

    public static float getHUDOpacity() {
        float f = (float)(Util.m_137550_() - lastHotbarSelectionChange) / 1200.0f;
        return ScreenUtil.getInterfaceOpacity() <= 0.8f ? Math.min(0.8f, ScreenUtil.getInterfaceOpacity() + (1.0f - ScreenUtil.getInterfaceOpacity()) * (f >= 3.0f ? Math.max(4.0f - f, 0.0f) : 1.0f)) : ScreenUtil.getInterfaceOpacity();
    }

    public static boolean hasTooltipBoxes() {
        return (Boolean)LegacyOptions.tooltipBoxes.get();
    }

    public static boolean hasTooltipBoxes(UIAccessor accessor) {
        return ScreenUtil.hasTooltipBoxes() && accessor.getBoolean("hasTooltipBox", Boolean.valueOf(true)) != false;
    }

    public static float getInterfaceOpacity() {
        return ((Double)LegacyOptions.hudOpacity.get()).floatValue();
    }

    public static int getDefaultTextColor(boolean forceWhite) {
        return !forceWhite ? (Integer)CommonColor.HIGHLIGHTED_WIDGET_TEXT.get() : (Integer)CommonColor.WIDGET_TEXT.get();
    }

    public static int getDefaultTextColor() {
        return ScreenUtil.getDefaultTextColor(false);
    }

    public static boolean hasProgrammerArt() {
        return mc.m_91099_().m_10524_().stream().anyMatch(p -> p.m_10446_().equals("programmer_art"));
    }

    public static void playSimpleUISound(SoundEvent sound, float volume, float pitch, boolean randomPitch) {
        RandomSource source = SoundInstance.m_235150_();
        mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound.m_11660_(), SoundSource.MASTER, volume, pitch + (randomPitch ? (source.m_188501_() - 0.5f) / 10.0f : 0.0f), source, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void playSimpleUISound(SoundEvent sound, float pitch, boolean randomPitch) {
        ScreenUtil.playSimpleUISound(sound, 1.0f, pitch, randomPitch);
    }

    public static void playSimpleUISound(SoundEvent sound, float pitch) {
        ScreenUtil.playSimpleUISound(sound, pitch, false);
    }

    public static void playSimpleUISound(SoundEvent sound, boolean randomPitch) {
        ScreenUtil.playSimpleUISound(sound, 1.0f, randomPitch);
    }

    public static void drawGenericLoading(GuiGraphics graphics, int x, int y) {
        RenderSystem.enableBlend();
        for (int i = 0; i < 8; ++i) {
            float alpha;
            int v = (i + 1) * 100;
            int n = (i + 3) * 100;
            float l = (float)Util.m_137550_() / 4.0f % 1000.0f;
            float f = l >= (float)(v - 100) ? (l <= (float)v ? l / (float)v : ((float)n - l) / 200.0f) : (alpha = 0.0f);
            if (!(alpha > 0.0f)) continue;
            FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, alpha);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.LOADING_BLOCK, x + (i <= 2 ? i : (i >= 4 ? (i == 7 ? 0 : 6 - i) : 2)) * 27, y + (i <= 2 ? 0 : (i == 3 || i == 7 ? 1 : 2)) * 27, 21, 21);
        }
        RenderSystem.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).clearColor();
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component component, int j, int k, int l, int m, int n, boolean shadow) {
        ScreenUtil.renderScrollingString(guiGraphics, font, component.m_7532_(), j, k, l, m, n, shadow);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow) {
        ScreenUtil.renderScrollingString(guiGraphics, font, charSequence, j, k, l, m, n, shadow, font.m_92724_(charSequence));
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow, int stringWidth) {
        Objects.requireNonNull(font);
        int p = (k + m - 9) / 2 + 1;
        int q = l - j;
        if (stringWidth > q) {
            int r = stringWidth - q;
            double d = (double)Util.m_137550_() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.m_14139_((double)f, (double)0.0, (double)r);
            guiGraphics.m_280588_(j, k, l, m);
            guiGraphics.m_280649_(font, charSequence, j - (int)g, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
            guiGraphics.m_280618_();
        } else {
            guiGraphics.m_280649_(font, charSequence, j, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
        }
    }

    public static void secureTranslucentRender(GuiGraphics graphics, boolean translucent, float alpha, Consumer<Boolean> render) {
        if (!translucent) {
            render.accept(false);
            return;
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).pushBufferSource((MultiBufferSource.BufferSource)BufferSourceWrapper.translucent(FactoryGuiGraphics.of((GuiGraphics)graphics).getBufferSource()));
        graphics.m_280262_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        render.accept(true);
        RenderSystem.disableBlend();
        graphics.m_280262_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).popBufferSource();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHovering(Slot slot, int leftPos, int topPos, double d, double e) {
        double d2;
        double d3;
        LegacyIconHolder holder = iconHolderRenderer.slotBounds(slot);
        int width = holder.m_5711_();
        int height = holder.m_93694_();
        double xCorner = (double)holder.getXCorner() + holder.offset.m_7096_();
        double yCorner = (double)holder.getYCorner() + holder.offset.m_7098_();
        d -= (double)leftPos;
        if (!(d3 >= xCorner)) return false;
        if (!(d < xCorner + (double)width)) return false;
        e -= (double)topPos;
        if (!(d2 >= yCorner)) return false;
        if (!(e < yCorner + (double)height)) return false;
        return true;
    }

    public static void renderEntity(GuiGraphics guiGraphics, float x, float y, int size, float partialTicks, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity) {
        ScreenUtil.renderEntity(guiGraphics, x, y, size, partialTicks, vector3f, quaternionf, quaternionf2, entity, false);
    }

    public static void renderEntity(GuiGraphics guiGraphics, float x, float y, int size, float partialTicks, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity, boolean forceSize) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)x, (double)y, 50.0);
        float h = forceSize ? Math.max(1.0f, Math.max(entity.m_20205_(), entity.m_20206_())) : 1.0f;
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)size / h, (float)size / h, (float)(-size) / h));
        guiGraphics.m_280168_().m_252880_(vector3f.x, vector3f.y, vector3f.z);
        guiGraphics.m_280168_().m_252781_(quaternionf);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.m_252923_(quaternionf2);
        }
        entityRenderDispatcher.m_114468_(false);
        entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, guiGraphics.m_280168_(), (MultiBufferSource)FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource(), 0xF000F0);
        guiGraphics.m_280262_();
        entityRenderDispatcher.m_114468_(true);
        guiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, LivingEntity livingEntity) {
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        guiGraphics.m_280588_(i, j, k, l);
        float p = (float)Math.atan((n - g) / 40.0f);
        float q = (float)Math.atan((o - h) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.f_20883_;
        float s = livingEntity.m_146908_();
        float t = livingEntity.m_146909_();
        float u = livingEntity.f_20886_;
        float v = livingEntity.f_20885_;
        livingEntity.f_20883_ = 180.0f + p * 20.0f;
        livingEntity.m_146922_(180.0f + p * 40.0f);
        livingEntity.m_146926_(-q * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.m_20206_() / 2.0f + f, 0.0f);
        ScreenUtil.renderEntity(guiGraphics, n, o, m, 1.0f, vector3f, quaternionf, quaternionf2, (Entity)livingEntity);
        livingEntity.f_20883_ = r;
        livingEntity.m_146922_(s);
        livingEntity.m_146926_(t);
        livingEntity.f_20886_ = u;
        livingEntity.f_20885_ = v;
        guiGraphics.m_280618_();
    }

    public static void renderLocalPlayerHead(GuiGraphics guiGraphics, int x, int y, int size) {
        if (ScreenUtil.mc.f_91074_ == null) {
            return;
        }
        PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)ScreenUtil.mc.f_91074_.m_108560_(), (int)x, (int)y, (int)size);
    }

    public static double getInterfaceResolution() {
        return 1.5 - (Double)LegacyOptions.interfaceResolution.get();
    }

    public static double getGuiScale() {
        int h = (Boolean)LegacyOptions.autoResolution.get() != false ? ScreenUtil.getStandardHeight() : mc.m_91268_().m_85442_();
        return (double)h / 360.0 * ScreenUtil.getTweakedHeightScale(h) * (Double)CommonValue.SCALE_MULTIPLIER.get();
    }

    public static double getTweakedHeightScale(int height) {
        if (((Boolean)LegacyOptions.autoResolution.get()).booleanValue()) {
            if (height == 1080) {
                return 0.999623452;
            }
            if (height % 720 != 0) {
                return 1.001;
            }
            return 1.0;
        }
        return ScreenUtil.getInterfaceResolution();
    }

    public static int getStandardHeight() {
        return Math.round((float)mc.m_91268_().m_85442_() / 180.0f) * 180;
    }

    public static boolean is720p() {
        return ScreenUtil.getStandardHeight() <= 720;
    }

    public static float getTextScale() {
        return (Boolean)LegacyOptions.legacyItemTooltipScaling.get() != false ? Math.max(0.6666667f, Math.min(720.0f / (float)ScreenUtil.getStandardHeight(), 1.3333334f)) : 1.0f;
    }

    public static float getChatSafeZone() {
        return 29.0f * ((Double)LegacyOptions.hudDistance.get()).floatValue();
    }

    public static int getSelectedItemTooltipLines() {
        return (Integer)LegacyOptions.selectedItemTooltipLines.get() == 0 ? 0 : (Integer)LegacyOptions.selectedItemTooltipLines.get() + ((Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? 1 : 0);
    }

    public static void renderAnimatedCharacter(GuiGraphics guiGraphics) {
        block6: {
            LivingEntity character;
            block7: {
                boolean hasRemainingTime;
                block8: {
                    Entity entity = mc.m_91288_();
                    if (!(entity instanceof LivingEntity)) break block6;
                    character = (LivingEntity)entity;
                    boolean bl = hasRemainingTime = character.m_20142_() || character.m_6047_() || character.m_21255_() || character.m_6067_() || !(character instanceof Player);
                    if (!((Boolean)LegacyOptions.animatedCharacter.get()).booleanValue()) break block7;
                    if (hasRemainingTime) break block8;
                    if (!(character instanceof Player)) break block7;
                    Player p = (Player)character;
                    if (!p.m_150110_().f_35935_) break block7;
                }
                if (!character.m_5803_()) {
                    animatedCharacterTime = Util.m_137550_();
                    long l = remainingAnimatedCharacterTime = hasRemainingTime ? 450L : 0L;
                }
            }
            if (Util.m_137550_() - animatedCharacterTime <= remainingAnimatedCharacterTime) {
                float xRot = character.m_146909_();
                float xRotO = character.f_19860_;
                if (!character.m_21255_()) {
                    character.f_19860_ = -2.5f;
                    character.m_146926_(-2.5f);
                }
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(32.0f, character.m_21255_() ? 44.0f : 18.0f, -200.0f);
                ScreenUtil.applyHUDScale(guiGraphics);
                float f = (Boolean)LegacyOptions.smoothAnimatedCharacter.get() != false ? FactoryAPIClient.getPartialTick() : 0.0f;
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(false);
                ScreenUtil.renderEntity(guiGraphics, 10.0f, character.m_21255_() ? -character.m_5686_(f) / 180.0f * 40.0f : 36.0f, 12, f, new Vector3f(), new Quaternionf().rotationXYZ(-0.08726647f, (165.0f - Mth.m_14179_((float)f, (float)character.f_20884_, (float)character.f_20883_)) * (float)Math.PI / 180.0f, (float)Math.PI), null, (Entity)character);
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(true);
                guiGraphics.m_280168_().m_85849_();
                character.m_146926_(xRot);
                character.f_19860_ = xRotO;
            }
        }
    }

    public static void renderContainerEffects(GuiGraphics guiGraphics, int leftPos, int topPos, int imageWidth, int imageHeight, int mouseX, int mouseY) {
        int x = leftPos + imageWidth + 3;
        int l = guiGraphics.m_280182_() - x;
        Collection collection = ScreenUtil.mc.f_91074_.m_21220_();
        if (collection.isEmpty() || l < 32) {
            return;
        }
        boolean bl = l >= 129;
        int m = 31;
        if (imageHeight < collection.size() * 28) {
            m = imageHeight / collection.size();
        }
        List iterable = Ordering.natural().sortedCopy((Iterable)collection);
        int y = topPos + imageHeight - 28;
        for (MobEffectInstance mobEffectInstance : iterable) {
            ScreenUtil.renderPointerPanel(guiGraphics, x, y, bl ? 129 : 28, 28);
            if (bl) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(x + 25), (float)(y + 7), 0.0f);
                Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                    Component effect = ScreenUtil.getEffectName(mobEffectInstance);
                    if (!b.booleanValue()) {
                        guiGraphics.m_280168_().m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
                    }
                    guiGraphics.m_280430_(ScreenUtil.mc.f_91062_, effect, 0, 0, 0xFFFFFF);
                    guiGraphics.m_280168_().m_252880_(0.0f, 10.0f * (b != false ? 1.0f : 1.5f), 0.0f);
                    guiGraphics.m_280430_(ScreenUtil.mc.f_91062_, MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f), 0, 0, 0x7F7F7F);
                });
                guiGraphics.m_280168_().m_85849_();
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(x + (bl ? 3 : 5), y + 5, 0, 18, 18, mc.m_91306_().m_118732_(mobEffectInstance.m_19544_()));
            y -= m;
        }
        if (!bl && mouseX >= x && mouseX <= x + 28) {
            MobEffectInstance mobEffectInstance;
            int n = topPos + imageHeight - 28;
            mobEffectInstance = null;
            for (MobEffectInstance mobEffectInstance2 : iterable) {
                if (mouseY >= n && mouseY <= n + m) {
                    mobEffectInstance = mobEffectInstance2;
                }
                n -= m;
            }
            if (mobEffectInstance != null) {
                List<Component> list = List.of(ScreenUtil.getEffectName(mobEffectInstance), MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f));
                guiGraphics.m_280677_(ScreenUtil.mc.f_91062_, list, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = mobEffectInstance.m_19544_().m_19482_().m_6881_();
        if (mobEffectInstance.m_19564_() >= 1 && mobEffectInstance.m_19564_() <= 9) {
            MutableComponent var10000 = mutableComponent.m_7220_(CommonComponents.f_263701_);
            int var10001 = mobEffectInstance.m_19564_();
            var10000.m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        return stack.m_41651_((Player)ScreenUtil.mc.f_91074_, (TooltipFlag)((Boolean)LegacyOptions.advancedHeldItemTooltip.get() != false ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_));
    }

    public static void renderHUDTooltip(GuiGraphics guiGraphics, int shift) {
        if (!FactoryGuiElement.SELECTED_ITEM_NAME.isVisible(FactoryScreenUtil.getGuiAccessor()) || ScreenUtil.getSelectedItemTooltipLines() == 0) {
            return;
        }
        ScreenUtil.prepareHUDRender(guiGraphics);
        guiGraphics.m_280168_().m_252880_(0.0f, (float)guiGraphics.m_280206_() - Math.max((float)shift, ScreenUtil.getHUDSize()), 0.0f);
        FactoryAPIClient.getProfiler().m_6180_("selectedItemName");
        if (GuiAccessor.getInstance().getToolHighlightTimer() > 0 && !GuiAccessor.getInstance().getLastToolHighlight().m_41619_()) {
            Font font = Objects.requireNonNullElse(IClientItemExtensions.of((ItemStack)GuiAccessor.getInstance().getLastToolHighlight()).getFont(GuiAccessor.getInstance().getLastToolHighlight(), IClientItemExtensions.FontContext.SELECTED_ITEM_NAME), ScreenUtil.mc.f_91062_);
            List<Component> tooltip = ScreenUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight());
            tooltip.removeIf(c -> c.getString().isBlank());
            Object2IntMap tooltipLines = (Object2IntMap)tooltip.stream().limit(ScreenUtil.getSelectedItemTooltipLines()).map(c -> tooltip.indexOf(c) == ScreenUtil.getSelectedItemTooltipLines() - 1 && (Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? ControlTooltip.MORE : c).collect(Collectors.toMap(Function.identity(), arg_0 -> ((Font)font).m_92852_(arg_0), (a, b) -> b, Object2IntLinkedOpenHashMap::new));
            int l = Math.min((int)((float)GuiAccessor.getInstance().getToolHighlightTimer() * 256.0f / 10.0f), 255);
            if (l > 0) {
                int height = (Integer)LegacyOptions.selectedItemTooltipSpacing.get() * (tooltipLines.size() - 1);
                guiGraphics.m_280168_().m_252880_(0.0f, (float)(-height), 0.0f);
                if (!((Boolean)ScreenUtil.mc.f_91066_.m_231827_().m_231551_()).booleanValue()) {
                    int backgroundWidth = tooltipLines.values().intStream().max().orElse(0) + 4;
                    int backgroundX = (guiGraphics.m_280182_() - backgroundWidth) / 2;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, (float)l / 255.0f);
                    ScreenUtil.renderPointerPanel(guiGraphics, backgroundX, -4, backgroundWidth, height + 15);
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
                }
                tooltipLines.forEach((mutableComponent, width) -> {
                    int x = (guiGraphics.m_280182_() - width) / 2;
                    guiGraphics.m_280430_(font, mutableComponent, x, 0, 0xFFFFFF + (l << 24));
                    guiGraphics.m_280168_().m_252880_(0.0f, (float)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue(), 0.0f);
                });
            }
        }
        FactoryAPIClient.getProfiler().m_7238_();
        ScreenUtil.finalizeHUDRender(guiGraphics);
    }

    public static void renderGuiEffects(GuiGraphics guiGraphics) {
        Collection collection = ScreenUtil.mc.f_91074_.m_21220_();
        if (!FactoryGuiElement.EFFECTS.isVisible(FactoryScreenUtil.getGuiAccessor()) || collection.isEmpty()) {
            return;
        }
        int i = 0;
        int j = 0;
        float backAlpha = ScreenUtil.getHUDOpacity();
        MobEffectTextureManager mobEffectTextureManager = mc.m_91306_();
        for (MobEffectInstance mobEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            Holder mobEffect = BuiltInRegistries.f_256974_.m_263177_((Object)mobEffectInstance.m_19544_());
            if (!mobEffectInstance.m_19575_()) continue;
            int k = guiGraphics.m_280182_() - 55;
            int l = 18;
            if (mc.m_91402_()) {
                l += 15;
            }
            if (((MobEffect)mobEffect.m_203334_()).m_19486_()) {
                k -= 24 * ++i;
            } else {
                k -= 24 * ++j;
                l += 24;
            }
            float f = 1.0f;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, backAlpha);
            ScreenUtil.renderPointerPanel(guiGraphics, k, l, 24, 24);
            if (mobEffectInstance.m_267633_(200)) {
                int m = mobEffectInstance.m_19557_();
                f = Mth.m_14036_((float)((float)m / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)m * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)(10 - m / 20) / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            RenderSystem.enableBlend();
            TextureAtlasSprite textureAtlasSprite = mobEffectTextureManager.m_118732_((MobEffect)mobEffect.m_203334_());
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, f * backAlpha);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(k + 3, l + 3, 0, 18, 18, textureAtlasSprite);
            RenderSystem.disableBlend();
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTopText(GuiGraphics guiGraphics, TopMessage topMessage, int y, float scale, int ticks) {
        if (topMessage != null && ticks < topMessage.ticksOnScreen()) {
            RenderSystem.disableDepthTest();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)guiGraphics.m_280182_() / 2.0f, (float)y, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            if (topMessage.pulse()) {
                float pulse = (float)Util.m_137550_() / 400.0f % 1.0f;
                pulse = 1.0f + (pulse > 0.5f ? 1.0f - pulse : pulse) / 10.0f;
                guiGraphics.m_280168_().m_85841_(pulse, pulse, pulse);
            }
            guiGraphics.m_280168_().m_252880_((float)(-ScreenUtil.mc.f_91062_.m_92852_((FormattedText)topMessage.message())) / 2.0f, 0.0f, 0.0f);
            float maxFade = Math.min(topMessage.ticksOnScreen(), 20);
            float fade = topMessage.fade() ? Math.min(1.0f, ((float)topMessage.ticksOnScreen() - ((float)ticks + FactoryAPIClient.getPartialTick())) / maxFade) : 1.0f;
            guiGraphics.m_280614_(ScreenUtil.mc.f_91062_, topMessage.message(), 0, 0, fade < 1.0f ? ColorUtil.withAlpha((int)topMessage.baseColor(), (float)fade) : topMessage.baseColor(), topMessage.shadow());
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.enableDepthTest();
        }
    }

    public static float getFlyingViewRollingRotation(float original) {
        if (((Boolean)LegacyOptions.flyingViewRolling.get()).booleanValue() && ScreenUtil.mc.f_91074_ != null && ScreenUtil.mc.f_91074_.m_21255_()) {
            float f = FactoryAPIClient.getGamePartialTick((boolean)false);
            Vec3 vec3 = ScreenUtil.mc.f_91074_.m_20252_(f);
            Vec3 vec32 = ScreenUtil.mc.f_91074_.m_272267_(f);
            double d = vec32.m_165925_();
            double e = vec3.m_165925_();
            if (d > 0.0 && e > 0.0) {
                int dir = (int)(-Math.signum(vec32.f_82479_ * vec3.f_82481_ - vec32.f_82481_ * vec3.f_82479_));
                float z = (float)Math.min(0.39269908169872414, Math.acos((vec32.f_82479_ * vec3.f_82479_ + vec32.f_82481_ * vec3.f_82481_) / Math.sqrt(d * e)) / 2.5);
                if (z > 0.0f) {
                    return (float)dir * z;
                }
            }
        }
        return original;
    }

    public static void renderGameOverlay(GuiGraphics graphics) {
        PostChain gammaEffect;
        if (!MinecraftAccessor.getInstance().hasGameLoaded()) {
            return;
        }
        float partialTick = FactoryAPIClient.getPartialTick();
        boolean canRenderElement = ScreenUtil.mc.f_91080_ != null || !ScreenUtil.mc.f_91066_.f_92062_;
        LegacyTip tip = LegacyTipManager.getActualTip();
        if ((!LegacyTipManager.tips.isEmpty() || tip != null) && canRenderElement) {
            if (tip == null) {
                tip = LegacyTipManager.updateTip();
            }
            tip.m_252865_(graphics.m_280182_() - tip.m_5711_() - 30);
            tip.m_88315_(graphics, 0, 0, partialTick);
            if (tip.visibility == Toast.Visibility.HIDE) {
                LegacyTipManager.updateTip();
            }
        }
        if (((Boolean)ScreenUtil.mc.f_91066_.m_231834_().m_231551_()).booleanValue() && canRenderElement && (ScreenUtil.mc.f_91065_.f_193828_ > 0.0f || ScreenUtil.mc.f_91065_.f_193829_ > 0.0f) && (double)Mth.m_14036_((float)Mth.m_14179_((float)FactoryAPIClient.getPartialTick(), (float)ScreenUtil.mc.f_91065_.f_193829_, (float)ScreenUtil.mc.f_91065_.f_193828_), (float)0.0f, (float)1.0f) > 0.02) {
            RenderSystem.disableDepthTest();
            ScreenUtil.drawAutoSavingIcon(graphics, graphics.m_280182_() - 66, 44);
            RenderSystem.enableDepthTest();
        }
        if (GLFW.glfwGetInputMode((long)mc.m_91268_().m_85439_(), (int)208897) == 212994 && !Legacy4JClient.controllerManager.isCursorDisabled && !LegacyOptions.hasSystemCursor()) {
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(Legacy4JClient.controllerManager.getPointerX() + (double)LegacyTipManager.getTipXDiff(), Legacy4JClient.controllerManager.getPointerY(), 4000.0);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(mc.m_91268_().m_85443_() >= 1920 ? LegacySprites.POINTER : LegacySprites.SMALL_POINTER, -8, -8, 16, 16);
            graphics.m_280168_().m_85849_();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
        if ((gammaEffect = Legacy4JClient.getGammaEffect()) != null && ((Boolean)LegacyOptions.displayLegacyGamma.get()).booleanValue()) {
            float gamma = ((Double)LegacyOptions.legacyGamma.get()).floatValue();
            graphics.m_280262_();
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            gammaEffect.f_110009_.forEach(p -> p.m_110074_().m_108960_("gamma").m_5985_(gamma >= 0.5f ? (gamma - 0.5f) * 1.12f + 1.08f : gamma * 0.96f + 0.6f));
            gammaEffect.m_110023_(partialTick);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    public static Screen getInitialScreen() {
        TitleScreen titleScreen = new TitleScreen(((Boolean)LegacyOptions.titleScreenFade.get()).booleanValue());
        if (((Boolean)LegacyOptions.skipInitialSaveWarning.get()).booleanValue()) {
            return titleScreen;
        }
        return ConfirmationScreen.createSaveInfoScreen((Screen)titleScreen);
    }

    static {
        lastHotbarSelection = -1;
        logoRenderer = new LogoRenderer(false);
        panoramaRenderer = new PanoramaRenderer(TitleScreen.f_96716_);
        iconHolderRenderer = new LegacyIconHolder();
        MINECRAFT = Legacy4J.createModLocation("textures/gui/title/minecraft.png");
        PANORAMA_DAY = Legacy4J.createModLocation("textures/gui/title/panorama_day.png");
        PANORAMA_NIGHT = Legacy4J.createModLocation("textures/gui/title/panorama_night.png");
        MENU_BACKGROUND = Legacy4J.createModLocation("textures/gui/menu_background.png");
        LOADING_BACKGROUND = Legacy4J.createModLocation("textures/gui/loading_background.png");
        actualPlayerTabWidth = Bearer.of((Object)0);
        actualPlayerTabHeight = Bearer.of((Object)0);
    }
}

