/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Unique;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.legacy.client.CommonColor;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyStonecutterScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event {
    public static final Vec3 DISPLAY_OFFSET = new Vec3(0.5, 0.0, 0.0);
    protected List<RecipeIconHolder<StonecutterRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<StonecutterRecipe>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<StonecutterRecipe>>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> filteredRecipesByGroup = Collections.emptyList();
    protected Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected List<Optional<Ingredient>> ingredientSlot = Collections.singletonList(Optional.empty());
    protected int selectedCraftingButton = 0;
    private boolean onlyCraftableRecipes;
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    private final ContainerListener listener;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);

    public LegacyStonecutterScreen(LegacyCraftingMenu abstractContainerMenu, final Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        List<RecipeInfo> allRecipes = CommonRecipeManager.byType((RecipeType)RecipeType.STONECUTTING).stream().map(h -> RecipeInfo.create(h.id(), (StonecutterRecipe)h.value(), LegacyCraftingMenu.getRecipeOptionalIngredients(h.value()), ((StonecutterRecipe)h.value()).assemble(null, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()))).toList();
        StoneCuttingGroupManager.listing.values().forEach(l -> {
            ArrayList group = new ArrayList();
            l.forEach(v -> v.addRecipes(allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h)))::iterator, group::add));
            if (!group.isEmpty()) {
                this.recipesByGroup.add(group);
            }
        });
        allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h))).forEach(h -> this.recipesByGroup.add(Collections.singletonList(h)));
        this.addCraftingButtons();
        this.onlyCraftableRecipes = true;
        this.listener = new ContainerListener(){

            public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                if (LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                    LegacyStonecutterScreen.this.filteredRecipesByGroup = LegacyStonecutterScreen.this.recipesByGroup.stream().map(l -> l.stream().filter(r -> RecipeMenu.canCraft(r.getOptionalIngredients(), inventory, abstractContainerMenu.getCarried())).toList()).filter(l -> !l.isEmpty()).toList();
                    LegacyStonecutterScreen.this.craftingButtons.get(LegacyStonecutterScreen.this.selectedCraftingButton).updateRecipeDisplay();
                }
            }

            public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
            }
        };
        this.listener.slotChanged(this.menu, 0, ItemStack.EMPTY);
        this.onlyCraftableRecipes = false;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    public void init() {
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        if (this.selectedCraftingButton < this.craftingButtons.size()) {
            this.setFocused(this.craftingButtons.get(this.selectedCraftingButton));
        }
        this.craftingButtons.forEach(b -> {
            b.setPos(this.leftPos + 13 + this.craftingButtons.indexOf(b) * 27, this.topPos + 38);
            this.addRenderableWidget((GuiEventListener)b);
        });
        this.craftingButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        guiGraphics.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, (515 - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, 109, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 9, this.topPos + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 176, this.topPos + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.leftPos + 79, this.topPos + 158, 22, 15);
        if ((Integer)this.craftingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 45);
        }
        if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + 337, this.topPos + 45);
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
        this.craftingButtons.get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, f);
        this.craftingButtons.forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    public void removed() {
        super.removed();
        ((LegacyCraftingMenu)this.menu).removeSlotListener(this.listener);
    }

    @Unique
    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<StonecutterRecipe> h = new RecipeIconHolder<StonecutterRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyStonecutterScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<StonecutterRecipe> rcp) {
                    if (rcp == null || LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                        return true;
                    }
                    LegacyStonecutterScreen.this.compactInventoryList.clear();
                    RecipeMenu.handleCompactInventoryList(LegacyStonecutterScreen.this.compactInventoryList, Minecraft.getInstance().player.getInventory(), ((LegacyCraftingMenu)LegacyStonecutterScreen.this.menu).getCarried());
                    return LegacyCraftingScreen.canCraft(LegacyStonecutterScreen.this.compactInventoryList, this.isFocused() && this.getFocusedRecipe() == rcp ? LegacyStonecutterScreen.this.ingredientSlot : rcp.getOptionalIngredients(), null);
                }

                @Override
                public List<RecipeInfo<StonecutterRecipe>> getFocusedRecipes() {
                    if (!(this.isFocused() && this.isValidIndex() && this.canScroll())) {
                        this.focusedRecipes = null;
                    } else if (this.focusedRecipes == null) {
                        this.focusedRecipes = new ArrayList<RecipeInfo<StonecutterRecipe>>(this.getRecipes());
                    }
                    return this.focusedRecipes == null ? this.getRecipes() : this.focusedRecipes;
                }

                @Override
                protected List<RecipeInfo<StonecutterRecipe>> getRecipes() {
                    List<List<RecipeInfo<StonecutterRecipe>>> list = LegacyStonecutterScreen.this.onlyCraftableRecipes ? LegacyStonecutterScreen.this.filteredRecipesByGroup : LegacyStonecutterScreen.this.recipesByGroup;
                    return list.size() <= (Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : list.get((Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<StonecutterRecipe> rcp) {
                    LegacyStonecutterScreen.this.ingredientSlot = rcp == null ? Collections.singletonList(Optional.empty()) : rcp.getOptionalIngredients();
                }

                @Override
                protected void toggleCraftableRecipes() {
                    LegacyStonecutterScreen.this.listener.slotChanged(LegacyStonecutterScreen.this.menu, 0, ItemStack.EMPTY);
                    LegacyStonecutterScreen.this.onlyCraftableRecipes = !LegacyStonecutterScreen.this.onlyCraftableRecipes;
                }

                @Override
                public boolean keyPressed(int i, int j, int k) {
                    if (this.controlCyclicNavigation(i, index, LegacyStonecutterScreen.this.craftingButtons, LegacyStonecutterScreen.this.craftingButtonsOffset, LegacyStonecutterScreen.this.scrollRenderer, (Screen)LegacyStonecutterScreen.this)) {
                        return true;
                    }
                    return super.keyPressed(i, j, k);
                }

                @Override
                public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
                    super.renderTooltip(minecraft, graphics, i, j);
                    if (this.isFocused()) {
                        if (!LegacyStonecutterScreen.this.ingredientSlot.isEmpty() && ScreenUtil.isMouseOver(i, j, LegacyStonecutterScreen.this.leftPos + 38, LegacyStonecutterScreen.this.topPos + 149, 36, 36)) {
                            this.renderTooltip(minecraft, graphics, 2.getActualItem(LegacyStonecutterScreen.this.ingredientSlot.get(0)), i, j);
                        }
                        if (ScreenUtil.isMouseOver(i, j, LegacyStonecutterScreen.this.leftPos + 110, LegacyStonecutterScreen.this.topPos + 149, 36, 36)) {
                            this.renderTooltip(minecraft, graphics, this.getFocusedResult(), i, j);
                        }
                    }
                }

                @Override
                public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                    boolean warning = !this.canCraft(this.getFocusedRecipe());
                    ScreenUtil.iconHolderRenderer.itemHolder(LegacyStonecutterScreen.this.leftPos + 38, LegacyStonecutterScreen.this.topPos + 149, 36, 36, 2.getActualItem(LegacyStonecutterScreen.this.ingredientSlot.get(0)), !LegacyStonecutterScreen.this.onlyCraftableRecipes && !LegacyStonecutterScreen.this.ingredientSlot.get(0).isEmpty() && warning, DISPLAY_OFFSET).render(graphics, i, j, f);
                    ScreenUtil.iconHolderRenderer.itemHolder(LegacyStonecutterScreen.this.leftPos + 110, LegacyStonecutterScreen.this.topPos + 149, 36, 36, this.getFocusedResult(), warning, DISPLAY_OFFSET).render(graphics, i, j, f);
                    if (this.getFocusedRecipe() != null) {
                        Component resultName = this.getFocusedRecipe().getName();
                        ScreenUtil.renderScrollingString(graphics, LegacyStonecutterScreen.this.font, resultName, LegacyStonecutterScreen.this.leftPos + 11 + Math.max(163 - LegacyStonecutterScreen.this.font.width((FormattedText)resultName), 0) / 2, LegacyStonecutterScreen.this.topPos + 114, LegacyStonecutterScreen.this.leftPos + 170, LegacyStonecutterScreen.this.topPos + 125, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
                    }
                    super.renderSelection(graphics, i, j, f);
                }
            };
            this.craftingButtons.add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
            h.allowItemDecorations = false;
        }
    }
}

