/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.ControlType;
import wily.legacy.client.GlobalPacks;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacyLanguageScreen;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVListScreen;
import wily.legacy.client.screen.ScreenSection;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.util.LegacyComponents;

public class OptionsScreen
extends PanelVListScreen {
    public Screen advancedOptionsScreen;

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component) {
        super(parent, panelConstructor, component);
    }

    public OptionsScreen(Screen parent, Section section) {
        this(parent, LegacyOptions.advancedOptionsMode.get() == LegacyOptions.AdvancedOptionsMode.MERGE && section.advancedSection.isPresent() ? ((Section)section.advancedSection.get()).panelConstructor() : section.panelConstructor(), section.title());
        section.elements().forEach(c -> c.accept(this));
        section.advancedSection.ifPresent(s -> {
            switch ((LegacyOptions.AdvancedOptionsMode)((Object)((Object)LegacyOptions.advancedOptionsMode.get()))) {
                case DEFAULT: {
                    this.withAdvancedOptions(s.build(this));
                    break;
                }
                case MERGE: {
                    s.elements().forEach(c -> c.accept(this));
                }
            }
        });
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, Renderable ... renderables) {
        this(parent, panelConstructor, component);
        this.renderableVList.addRenderables(renderables);
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, FactoryConfig<?> ... options) {
        this(parent, panelConstructor, component);
        this.renderableVList.addOptions(options);
    }

    public OptionsScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component, Stream<FactoryConfig<?>> options) {
        this(parent, panelConstructor, component);
        this.renderableVList.addOptions(options);
    }

    public OptionsScreen withAdvancedOptions(Function<OptionsScreen, Screen> advancedOptionsFunction) {
        return this.withAdvancedOptions(advancedOptionsFunction.apply(this));
    }

    public OptionsScreen withAdvancedOptions(Screen screen) {
        this.advancedOptionsScreen = screen;
        return this;
    }

    @Override
    public boolean keyPressed(int i, int j, int k) {
        if (super.keyPressed(i, j, k)) {
            return true;
        }
        if (i == 79 && this.advancedOptionsScreen != null) {
            this.minecraft.setScreen(this.advancedOptionsScreen);
            return true;
        }
        return false;
    }

    public static void setupSelectorControlTooltips(ControlTooltip.Renderer renderer, Screen screen) {
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(0)}) : null, () -> ControlTooltip.getKeyMessage(0, screen));
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> ControlTooltip.getKeyMessage(88, screen));
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(79, screen));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        OptionsScreen.setupSelectorControlTooltips(renderer, this);
        renderer.replace(6, i -> i, c -> c == null ? (this.advancedOptionsScreen == null ? null : LegacyComponents.SHOW_ADVANCED_OPTIONS) : c);
    }

    public record Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements, ArbitrarySupplier<Section> advancedSection, BiFunction<Screen, Section, OptionsScreen> sectionBuilder) implements ScreenSection<OptionsScreen>
    {
        private static final Minecraft mc = Minecraft.getInstance();
        public static final List<Section> list = new ArrayList<Section>();
        public static final Section GAME_OPTIONS = Section.add(new Section((Component)Component.translatable((String)"legacy.menu.game_options"), s -> Panel.centered(s, 250, 162), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.options.autoJump()), LegacyOptions.of(Section.mc.options.bobView()), LegacyOptions.flyingViewRolling, LegacyOptions.hints, LegacyOptions.autoSaveInterval), o -> o.renderableVList.addRenderables(new Renderable[]{RenderableVListScreen.openScreenButton((Component)Component.translatable((String)"options.language"), () -> new LegacyLanguageScreen((Screen)o, mc.getLanguageManager())).build(), RenderableVListScreen.openScreenButton((Component)Component.translatable((String)"legacy.menu.mods"), () -> new ModsScreen((Screen)o)).build()}), o -> {
            if (Section.mc.level == null && !mc.hasSingleplayerServer()) {
                o.renderableVList.addOptions(LegacyOptions.createWorldDifficulty);
            }
        })), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_GAME_OPTIONS)));
        public static final Section ADVANCED_GAME_OPTIONS = new Section((Component)Component.translatable((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{GAME_OPTIONS.title()}), s -> Panel.centered(s, 250, 172), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.selectedControlType, LegacyOptions.lockControlTypeChange, LegacyOptions.unfocusedInputs, LegacyOptions.autoSaveWhenPaused, LegacyOptions.directSaveLoad, LegacyOptions.saveCache, LegacyOptions.legacyCreativeBlockPlacing, LegacyOptions.cursorMode, LegacyOptions.invertedFrontCameraPitch, LegacyOptions.skipIntro, LegacyOptions.skipInitialSaveWarning, LegacyOptions.vanillaTutorial, LegacyOptions.of(Section.mc.options.realmsNotifications()), LegacyOptions.of(Section.mc.options.allowServerListing())), o -> {
            if (Section.mc.level == null) {
                LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> o.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b -> c.sync())));
            }
        }, o -> o.renderableVList.addRenderables(new Renderable[]{RenderableVListScreen.openScreenButton(LegacyComponents.RESET_KNOWN_BLOCKS_TITLE, () -> ConfirmationScreen.createResetKnownListingScreen(o, LegacyComponents.RESET_KNOWN_BLOCKS_TITLE, LegacyComponents.RESET_KNOWN_BLOCKS_MESSAGE, Legacy4JClient.knownBlocks)).build(), RenderableVListScreen.openScreenButton(LegacyComponents.RESET_KNOWN_ENTITIES_TITLE, () -> ConfirmationScreen.createResetKnownListingScreen(o, LegacyComponents.RESET_KNOWN_ENTITIES_TITLE, LegacyComponents.RESET_KNOWN_ENTITIES_MESSAGE, Legacy4JClient.knownEntities)).build()}))));
        public static final Section AUDIO = Section.add(new Section((Component)Component.translatable((String)"legacy.menu.audio"), s -> Panel.centered(s, 250, 88, 0, -30), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(Streams.concat((Stream[])new Stream[]{Arrays.stream(SoundSource.values()).filter(s -> s.ordinal() <= 1).sorted(Comparator.comparingInt(s -> s == SoundSource.MUSIC ? 0 : 1)).map(s -> LegacyOptions.of(Section.mc.options.getSoundSourceOptionInstance(s))), Stream.of(LegacyOptions.caveSounds, LegacyOptions.minecartSounds)})))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_AUDIO)));
        public static final Section ADVANCED_AUDIO = new Section((Component)Component.translatable((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{AUDIO.title()}), s -> Panel.centered(s, 250, 198, 0, 30), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(Stream.concat(Stream.of(Section.mc.options.soundDevice()), Arrays.stream(SoundSource.values()).filter(ss -> ss.ordinal() > 1).map(arg_0 -> ((Options)Section.mc.options).getSoundSourceOptionInstance(arg_0))).map(LegacyOptions::of)))));
        public static final Section GRAPHICS = Section.add(new Section((Component)Component.translatable((String)"legacy.menu.graphics"), s -> Panel.centered(s, 250, 222, 0, 24), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.options.cloudStatus()), LegacyOptions.of(Section.mc.options.graphicsMode())), o -> o.renderableVList.addLinkedOptions(LegacyOptions.displayLegacyGamma, Supplier::get, LegacyOptions.legacyGamma), o -> o.renderableVList.addOptions(LegacyOptions.of(Section.mc.options.gamma()), LegacyOptions.of(Section.mc.options.ambientOcclusion())))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_GRAPHICS), (p, s) -> {
            final GlobalPacks.Selector globalPackSelector = GlobalPacks.Selector.resources(0, 0, 230, 45, false);
            final PackAlbum.Selector selector = PackAlbum.Selector.resources(0, 0, 230, 45, false);
            OptionsScreen screen = new OptionsScreen((Screen)p, (Section)s){
                int selectorTooltipVisibility;
                boolean finishedAnimation;
                {
                    super(parent, section);
                    this.selectorTooltipVisibility = 0;
                    this.finishedAnimation = false;
                }

                @Override
                public void onClose() {
                    super.onClose();
                    globalPackSelector.applyChanges();
                    selector.applyChanges(true);
                }

                @Override
                protected void panelInit() {
                    super.panelInit();
                    this.panel.x -= Math.round(Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f * 80.0f);
                }

                private float getSelectorTooltipVisibility() {
                    return this.selectorTooltipVisibility == 0 ? (float)this.selectorTooltipVisibility : (float)this.selectorTooltipVisibility + FactoryAPIClient.getPartialTick();
                }

                @Override
                public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                    super.renderDefaultBackground(guiGraphics, i, j, f);
                    if (this.selectorTooltipVisibility > 0) {
                        if (this.getFocused() != globalPackSelector) {
                            selector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel, Math.round((1.0f - Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f) * -161.0f));
                        } else {
                            globalPackSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel, Math.round((1.0f - Math.min(10.0f, this.getSelectorTooltipVisibility()) / 10.0f) * -161.0f));
                        }
                        guiGraphics.pose().translate(0.0f, 0.0f, 0.03f);
                    }
                }

                public void tick() {
                    if ((this.getFocused() == selector || this.getFocused() == globalPackSelector || this.selectorTooltipVisibility > 0) && this.selectorTooltipVisibility < 10) {
                        ++this.selectorTooltipVisibility;
                    }
                    if (!this.finishedAnimation && this.selectorTooltipVisibility > 0) {
                        this.repositionElements();
                        if (this.selectorTooltipVisibility == 10) {
                            this.finishedAnimation = true;
                        }
                    }
                    super.tick();
                }
            };
            screen.renderableVList.addRenderables(new Renderable[]{globalPackSelector, selector});
            return screen;
        }));
        public static final Section ADVANCED_GRAPHICS = new Section((Component)Component.translatable((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{GRAPHICS.title()}), s -> Panel.centered(s, 250, 215, 0, 20), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.of(Section.createResolutionOptionInstance()), LegacyOptions.of(Section.mc.options.biomeBlendRadius()), LegacyOptions.of(Section.mc.options.renderDistance()), LegacyOptions.of(Section.mc.options.prioritizeChunkUpdates()), LegacyOptions.of(Section.mc.options.simulationDistance()), LegacyOptions.overrideTerrainFogStart, LegacyOptions.terrainFogStart, LegacyOptions.overrideTerrainFogEnd, LegacyOptions.terrainFogEnd, LegacyOptions.legacySkyShape, LegacyOptions.fastLeavesWhenBlocked, LegacyOptions.fastLeavesCustomModels, LegacyOptions.mapsWithCoords, LegacyOptions.of(Section.mc.options.framerateLimit()), LegacyOptions.of(Section.mc.options.enableVsync()), LegacyOptions.of(Section.mc.options.inactivityFpsLimit()), LegacyOptions.displayNameTagBorder, LegacyOptions.itemLightingInHand, LegacyOptions.loyaltyLines, LegacyOptions.merchantTradingIndicator, LegacyOptions.legacyBabyVillagerHead, LegacyOptions.legacyDrownedAnimation, LegacyOptions.legacyEntityFireTint, LegacyOptions.vehicleCameraRotation, LegacyOptions.create(Section.mc.options.rotateWithMinecart()), LegacyOptions.defaultParticlePhysics, LegacyOptions.headFollowsTheCamera, LegacyOptions.enhancedPistonMovingRenderer, FactoryOptions.RANDOM_BLOCK_ROTATIONS, LegacyOptions.of(Section.mc.options.fullscreen()), LegacyOptions.of(Section.mc.options.particles()), LegacyOptions.of(Section.mc.options.mipmapLevels()), FactoryOptions.NEAREST_MIPMAP_SCALING, LegacyOptions.of(Section.mc.options.entityShadows()), LegacyOptions.of(Section.mc.options.screenEffectScale()), LegacyOptions.of(Section.mc.options.entityDistanceScaling()), LegacyOptions.of(Section.mc.options.fov()), LegacyOptions.of(Section.mc.options.fovEffectScale()), LegacyOptions.of(Section.mc.options.darknessEffectScale()), LegacyOptions.of(Section.mc.options.glintSpeed()), LegacyOptions.legacyEvokerFangs, LegacyOptions.of(Section.mc.options.glintStrength())), o -> Legacy4JClient.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> o.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c))))));
        public static final Section USER_INTERFACE = Section.add(new Section((Component)Component.translatable((String)"legacy.menu.user_interface"), s -> Panel.centered(s, 250, 200, 0, 18), new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(LegacyOptions.displayHUD, LegacyOptions.displayHand, LegacyOptions.of(Section.mc.options.showAutosaveIndicator()), LegacyOptions.showVanillaRecipeBook, LegacyOptions.tooltipBoxes, LegacyOptions.hudOpacity, LegacyOptions.of(Section.mc.options.attackIndicator()), LegacyOptions.hudScale, LegacyOptions.hudDistance), o -> o.renderableVList.addLinkedOptions(LegacyOptions.autoResolution, b -> (Boolean)b.get() == false, LegacyOptions.interfaceResolution), o -> o.renderableVList.addOptions(LegacyOptions.inGameTooltips, LegacyOptions.animatedCharacter, LegacyOptions.smoothAnimatedCharacter, LegacyOptions.interfaceSensitivity, LegacyOptions.classicCrafting, LegacyOptions.classicTrading, LegacyOptions.classicStonecutting, LegacyOptions.classicLoom, LegacyOptions.forceMixedCrafting, LegacyOptions.modCraftingTabs, LegacyOptions.vanillaTabs, LegacyOptions.searchCreativeTab, LegacyOptions.of(Section.mc.options.operatorItemsTab())), o -> o.getRenderableVList().addLinkedOptions(LegacyOptions.legacyItemTooltips, Supplier::get, LegacyOptions.legacyItemTooltipScaling), o -> o.getRenderableVList().addOptions(LegacyOptions.vignette, LegacyOptions.of(Section.mc.options.narrator()), LegacyOptions.of(Section.mc.options.showSubtitles()), LegacyOptions.of(Section.mc.options.highContrast())))), (ArbitrarySupplier<Section>)((ArbitrarySupplier)() -> ADVANCED_USER_INTERFACE)));
        public static final Section ADVANCED_USER_INTERFACE = new Section((Component)Component.translatable((String)"legacy.menu.settings.advanced_options", (Object[])new Object[]{USER_INTERFACE.title()}), USER_INTERFACE.panelConstructor(), LegacyOptions.legacyCreativeTab, LegacyOptions.invertedCrosshair, LegacyOptions.selectedItemTooltipLines, LegacyOptions.itemTooltipEllipsis, LegacyOptions.selectedItemTooltipSpacing, LegacyOptions.legacyOverstackedItems, LegacyOptions.displayMultipleControlsFromAction, LegacyOptions.advancedHeldItemTooltip, LegacyOptions.autoSaveCountdown, LegacyOptions.displayControlTooltips, LegacyOptions.controlTooltipDisplay, LegacyOptions.hudDelay, LegacyOptions.systemMessagesAsOverlay, LegacyOptions.legacyIntroAndReloading, LegacyOptions.titleScreenFade, LegacyOptions.titleScreenVersionText, LegacyOptions.legacyPanorama, LegacyOptions.menusWithBackground, LegacyOptions.legacyLoadingAndConnecting, LegacyOptions.of(Section.mc.options.notificationDisplayTime()), LegacyOptions.of(Section.mc.options.damageTiltStrength()), LegacyOptions.of(Section.mc.options.glintSpeed()), LegacyOptions.of(Section.mc.options.glintStrength()), LegacyOptions.of(Section.mc.options.hideLightningFlash()), LegacyOptions.of(Section.mc.options.darkMojangStudiosBackground()), LegacyOptions.of(Section.mc.options.panoramaSpeed()), LegacyOptions.of(Section.mc.options.narratorHotkey()), LegacyOptions.of(Section.mc.options.chatVisibility()), LegacyOptions.of(Section.mc.options.chatColors()), LegacyOptions.of(Section.mc.options.chatLinks()), LegacyOptions.of(Section.mc.options.chatLinksPrompt()), LegacyOptions.of(Section.mc.options.backgroundForChatOnly()), LegacyOptions.of(Section.mc.options.chatOpacity()), LegacyOptions.of(Section.mc.options.textBackgroundOpacity()), LegacyOptions.of(Section.mc.options.chatScale()), LegacyOptions.of(Section.mc.options.chatLineSpacing()), LegacyOptions.of(Section.mc.options.chatDelay()), LegacyOptions.of(Section.mc.options.chatWidth()), LegacyOptions.of(Section.mc.options.chatHeightFocused()), LegacyOptions.of(Section.mc.options.chatHeightUnfocused()), LegacyOptions.of(Section.mc.options.narrator()), LegacyOptions.of(Section.mc.options.autoSuggestions()), LegacyOptions.of(Section.mc.options.hideMatchedNames()), LegacyOptions.of(Section.mc.options.reducedDebugInfo()), LegacyOptions.of(Section.mc.options.onlyShowSecureChat()));

        public Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements, ArbitrarySupplier<Section> advancedSection) {
            this(title, panelConstructor, elements, advancedSection, OptionsScreen::new);
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, List<Consumer<OptionsScreen>> elements) {
            this(title, panelConstructor, elements, (ArbitrarySupplier<Section>)ArbitrarySupplier.empty());
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, ArbitrarySupplier<Section> advancedSection, FactoryConfig<?> ... options) {
            this(title, panelConstructor, new ArrayList<Consumer<OptionsScreen>>(List.of(o -> o.renderableVList.addOptions(options))), advancedSection);
        }

        public Section(Component title, Function<Screen, Panel> panelConstructor, FactoryConfig<?> ... optionInstances) {
            this(title, panelConstructor, (ArbitrarySupplier<Section>)ArbitrarySupplier.empty(), optionInstances);
        }

        public static OptionInstance<?> createResolutionOptionInstance() {
            Monitor monitor = mc.getWindow().findBestMonitor();
            int j = monitor == null ? -1 : mc.getWindow().getPreferredFullscreenVideoMode().map(arg_0 -> ((Monitor)monitor).getVideoModeIndex(arg_0)).orElse(-1);
            return new OptionInstance("options.fullscreen.resolution", OptionInstance.noTooltip(), (component, integer) -> {
                if (monitor == null) {
                    return Component.translatable((String)"options.fullscreen.unavailable");
                }
                if (integer == -1) {
                    return Options.genericValueLabel((Component)component, (Component)Component.translatable((String)"options.fullscreen.current"));
                }
                VideoMode videoMode = monitor.getMode(integer.intValue());
                return Options.genericValueLabel((Component)component, (Component)Component.translatable((String)"options.fullscreen.entry", (Object[])new Object[]{videoMode.getWidth(), videoMode.getHeight(), videoMode.getRefreshRate(), videoMode.getRedBits() + videoMode.getGreenBits() + videoMode.getBlueBits()}));
            }, (OptionInstance.ValueSet)new OptionInstance.IntRange(-1, monitor != null ? monitor.getModeCount() - 1 : -1), (Object)j, integer -> {
                if (monitor == null) {
                    return;
                }
                mc.getWindow().setPreferredFullscreenVideoMode(integer == -1 ? Optional.empty() : Optional.of(monitor.getMode(integer.intValue())));
            });
        }

        public static Section add(Section section) {
            list.add(section);
            return section;
        }

        @Override
        public OptionsScreen build(Screen parent) {
            return this.sectionBuilder.apply(parent, this);
        }
    }
}

