/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.util.ScreenUtil;

public class TickBox
extends AbstractButton {
    public static final ResourceLocation[] SPRITES = new ResourceLocation[]{Legacy4J.createModLocation("widget/tickbox"), Legacy4J.createModLocation("widget/tickbox_hovered")};
    public static final ResourceLocation TICK = Legacy4J.createModLocation("widget/tick");
    protected final Function<Boolean, Component> message;
    protected Function<Boolean, Tooltip> tooltip;
    private final Consumer<TickBox> onPress;
    public boolean selected;

    public TickBox(int i, int j, int width, int height, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress) {
        super(i, j, width, height, message.apply(false));
        this.selected = initialState;
        this.message = message;
        this.tooltip = tooltip;
        this.onPress = onPress;
        this.setTooltip(tooltip.apply(this.selected));
    }

    public TickBox(int i, int j, int width, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress) {
        this(i, j, width, 12, initialState, message, tooltip, onPress);
    }

    public TickBox(int i, int j, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress) {
        this(i, j, 200, initialState, message, tooltip, onPress);
    }

    public void onPress() {
        this.selected = !this.selected;
        this.onPress.accept(this);
        this.setTooltip(this.tooltip.apply(this.selected));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        this.setAlpha(this.active ? 1.0f : 0.5f);
        Minecraft minecraft = Minecraft.getInstance();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        FactoryScreenUtil.enableDepthTest();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(SPRITES[this.isHoveredOrFocused() ? 1 : 0], this.getX(), this.getY(), 12, 12);
        if (this.selected) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TICK, this.getX(), this.getY(), 14, 12);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.pose().pushPose();
        if (!this.isHoveredOrFocused()) {
            guiGraphics.pose().translate(0.5f, 0.5f, 0.0f);
        }
        this.renderString(guiGraphics, minecraft.font, this.isHoveredOrFocused() ? ScreenUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get());
        guiGraphics.pose().popPose();
    }

    public Component getMessage() {
        return this.message.apply(this.selected);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            MutableComponent component = this.createNarrationMessage();
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
        ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 13, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), i, this.isHoveredOrFocused());
    }
}

