/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.network.ClientAnimalInLoveSyncPayload;

@Mixin(value={Animal.class})
public abstract class AnimalMixin
extends AgeableMob {
    @Unique
    int lastInlove = 0;
    @Shadow
    private int inLove;

    @Shadow
    public abstract void setInLoveTime(int var1);

    protected AnimalMixin(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
    }

    @Redirect(method={"aiStep"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/animal/Animal;inLove:I", opcode=181))
    public void aiStep(Animal instance, int value) {
        if (!this.level().isClientSide) {
            this.setInLoveTime(value);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void aiStep(CallbackInfo ci) {
        if (this.lastInlove != this.inLove) {
            ClientAnimalInLoveSyncPayload.sync((Animal)this);
        }
        this.lastInlove = this.inLove;
    }

    @Inject(method={"canFallInLove"}, at={@At(value="HEAD")}, cancellable=true)
    public void aiStep(CallbackInfoReturnable<Boolean> cir) {
        if (this.age != 0) {
            cir.setReturnValue((Object)false);
        }
    }
}

