/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.LegacySprites;

@Mixin(value={EditBox.class})
public abstract class EditBoxMixin
extends AbstractWidget
implements ControlTooltip.ActionHolder {
    @Shadow
    private long focusedTime;
    @Shadow
    private int cursorPos;
    @Shadow
    private int displayPos;
    @Shadow
    @Final
    private Font font;
    @Shadow
    private String value;
    @Shadow
    private int textColor;

    @Shadow
    public abstract int getInnerWidth();

    @Shadow
    public abstract boolean isBordered();

    @Redirect(method={"<init>(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/network/chat/Component;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/EditBox;textColor:I", opcode=181))
    private void init(EditBox instance, int value) {
        this.textColor = (Integer)CommonColor.WIDGET_TEXT.get();
    }

    public EditBoxMixin(int i, int j, int k, int l, Component component) {
        super(i, j, k, l, component);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        Screen screen = Minecraft.getInstance().screen;
        if (KeyboardScreen.isOpenKey(i) && screen != null) {
            Minecraft.getInstance().setScreen((Screen)KeyboardScreen.fromStaticListener((GuiEventListener)this, screen));
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onClick(double d, double e, CallbackInfo ci) {
        Screen screen = Minecraft.getInstance().screen;
        if (Screen.hasShiftDown() || Legacy4JClient.controllerManager.isControllerTheLastInput()) {
            Minecraft.getInstance().setScreen((Screen)KeyboardScreen.fromStaticListener((GuiEventListener)this, screen));
            ci.cancel();
        }
    }

    @Redirect(method={"renderWidget"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;isBordered()Z"))
    private boolean renderWidget(EditBox instance, GuiGraphics guiGraphics) {
        if (this.isBordered()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TEXT_FIELD, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            if (this.isHoveredOrFocused()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.HIGHLIGHTED_TEXT_FIELD, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2);
            }
        }
        return false;
    }

    @ModifyArg(method={"renderWidget"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V", ordinal=0), index=5)
    public int renderWidget(int i) {
        return (Integer)CommonColor.WIDGET_TEXT.get() | 0xFF000000;
    }

    @ModifyVariable(method={"renderWidget"}, at=@At(value="STORE"), ordinal=1)
    public boolean renderWidget(boolean bl) {
        int l = this.cursorPos - this.displayPos;
        String string = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        return l >= 0 && l <= string.length() && this.isFocused() && (Util.getMillis() - this.focusedTime) / 180L % 2L == 0L;
    }

    @Redirect(method={"renderWidget"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", ordinal=1))
    public int renderWidget(GuiGraphics instance, Font arg, String string, int i, int j, int k, boolean bl) {
        instance.pose().pushPose();
        instance.pose().translate((float)(i - (this.cursorPos == 0 ? 3 : 4)), (float)j + 8.5f, 0.0f);
        instance.pose().scale(6.0f, 1.5f, 1.0f);
        instance.fill(0, 0, 1, 1, (Integer)CommonColor.WIDGET_TEXT.get() | 0xFF000000);
        instance.pose().popPose();
        return 0;
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return this.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, ControlTooltip::getKeyboardAction) : null;
    }
}

