/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.entity.PlayerYBobbing;
import wily.legacy.util.ScreenUtil;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    private boolean hasWorldScreenshot;
    @Shadow
    private ItemStack itemActivationItem;

    @Shadow
    protected abstract void takeAutoScreenshot(Path var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;flush()V")})
    private void render(CallbackInfo ci, @Local(ordinal=0) GuiGraphics graphics) {
        ScreenUtil.renderGameOverlay(graphics);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.itemActivationItem == null && Legacy4JClient.itemActivationRenderReplacement != null) {
            Legacy4JClient.itemActivationRenderReplacement = null;
        }
    }

    @Inject(method={"renderItemActivationAnimation"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawSpecial(Ljava/util/function/Consumer;)V")}, cancellable=true)
    private void renderItemActivationAnimation(GuiGraphics guiGraphics, float f, CallbackInfo ci) {
        if (Legacy4JClient.itemActivationRenderReplacement != null) {
            ci.cancel();
            Legacy4JClient.itemActivationRenderReplacement.render(guiGraphics, 0, 0, f);
            guiGraphics.pose().popPose();
        }
    }

    @Inject(method={"bobView"}, at={@At(value="RETURN")})
    private void bobView(PoseStack poseStack, float f, CallbackInfo ci) {
        float xAngle = PlayerYBobbing.getAngle(this.minecraft, f);
        if (xAngle != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(xAngle));
        }
    }

    @Inject(method={"shouldRenderBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderLevel(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)LegacyOptions.displayHUD.get()).booleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyExpressionValue(method={"renderLevel"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/GameRenderer;renderHand:Z")})
    private boolean renderLevel(boolean original) {
        return original && (Boolean)LegacyOptions.displayHand.get() != false;
    }

    @ModifyExpressionValue(method={"tryTakeScreenshotIfNeeded"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/renderer/GameRenderer;hasWorldScreenshot:Z")})
    private boolean canTakeWorldIcon(boolean original) {
        return original && !Legacy4JClient.retakeWorldIcon;
    }

    @Redirect(method={"tryTakeScreenshotIfNeeded"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"))
    private void tryTakeScreenshotIfNeeded(Optional<Path> instance, Consumer<? super Path> action) {
        instance.ifPresent(path -> {
            if (!Legacy4JClient.retakeWorldIcon && Files.isRegularFile(path, new LinkOption[0])) {
                this.hasWorldScreenshot = true;
            } else {
                this.takeAutoScreenshot((Path)path);
                Legacy4JClient.retakeWorldIcon = false;
            }
        });
    }
}

