/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.util.ScreenUtil;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;

    @Shadow
    public abstract PoseStack pose();

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @Unique
    GuiGraphics self() {
        return (GuiGraphics)this;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderItemDecorationsHead(Font font, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        Legacy4JClient.legacyFont = false;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void renderItemDecorationsTail(Font font, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        Legacy4JClient.legacyFont = true;
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTooltipInternal(Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, ResourceLocation location, CallbackInfo ci) {
        ClientTooltipComponent tooltipComponent;
        int t;
        if (!((Boolean)LegacyOptions.legacyItemTooltips.get()).booleanValue()) {
            return;
        }
        ci.cancel();
        if (list.isEmpty()) {
            return;
        }
        int k = 0;
        int l = 0;
        for (ClientTooltipComponent tooltipComponent2 : list) {
            k = Math.max(tooltipComponent2.getWidth(font), k);
            l += tooltipComponent2.getHeight(font);
        }
        Vector2ic vector2ic = clientTooltipPositioner.positionTooltip(this.guiWidth(), this.guiHeight(), i, j, (int)((float)k * ScreenUtil.getTextScale()), (int)((float)l * ScreenUtil.getTextScale()));
        int p = vector2ic.x();
        int q = vector2ic.y();
        this.pose.pushPose();
        this.pose.translate(0.0f, 0.0f, 800.0f);
        if (p == (int)Legacy4JClient.controllerManager.getPointerX() && q == (int)Legacy4JClient.controllerManager.getPointerY()) {
            this.pose.translate(Legacy4JClient.controllerManager.getPointerX() - (double)i, Legacy4JClient.controllerManager.getPointerY() - (double)j, 0.0);
        }
        ScreenUtil.renderPointerPanel(this.self(), p - Math.round(5.0f * ScreenUtil.getTextScale()), q - Math.round(9.0f * ScreenUtil.getTextScale()), Math.round((float)(k + 11) * ScreenUtil.getTextScale()), Math.round((float)(l + 13) * ScreenUtil.getTextScale()));
        this.pose.translate((float)p, (float)q, 0.0f);
        FactoryScreenUtil.disableDepthTest();
        this.pose.scale(ScreenUtil.getTextScale(), ScreenUtil.getTextScale(), 1.0f);
        int s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.renderText(font, 0, s, this.pose.last().pose(), this.bufferSource);
            s += tooltipComponent.getHeight(font);
        }
        s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.renderImage(font, 0, s, k, l, this.self());
            s += tooltipComponent.getHeight(font);
        }
        FactoryScreenUtil.enableDepthTest();
        this.pose.popPose();
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void renderItem(LivingEntity livingEntity, Level level, ItemStack itemStack, int i, int j, int k, int l, CallbackInfo ci) {
        LegacyMenuAccess m;
        Screen screen;
        float g = (float)itemStack.getPopTime() - FactoryAPIClient.getGamePartialTick((boolean)true);
        if (g > 0.0f && (this.minecraft.screen == null || (screen = this.minecraft.screen) instanceof LegacyMenuAccess && (m = (LegacyMenuAccess)screen).allowItemPopping())) {
            float h = 1.0f + g / 5.0f;
            this.pose().translate((float)(i + 8), (float)(j + 12), 0.0f);
            this.pose().scale(1.0f / h, (h + 1.0f) / 2.0f, 1.0f);
            this.pose().translate((float)(-(i + 8)), (float)(-(j + 12)), 0.0f);
            if (this.minecraft.player != null && !this.minecraft.player.getInventory().getNonEquipmentItems().contains((Object)itemStack)) {
                itemStack.setPopTime(itemStack.getPopTime() - 1);
            }
        }
    }

    @ModifyArg(method={"renderTooltipInternal"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", ordinal=0), index=2)
    private float renderTooltipInternal(float z) {
        return 800.0f;
    }

    @Redirect(method={"renderItemCount"}, at=@At(value="INVOKE", target="Ljava/lang/String;valueOf(I)Ljava/lang/String;"))
    private String renderItemDecorationsTail(int i, Font font, ItemStack itemStack) {
        return i > itemStack.getMaxStackSize() && (Boolean)LegacyOptions.legacyOverstackedItems.get() != false ? I18n.get((String)"legacy.container.overstack", (Object[])new Object[]{itemStack.getMaxStackSize()}) : String.valueOf(i);
    }
}

