/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.inventory.LegacySlot;
import wily.legacy.inventory.LegacySlotDisplay;

@Mixin(value={Slot.class})
public abstract class SlotMixin
implements LegacySlot {
    @Mutable
    @Shadow
    @Final
    public int x;
    @Mutable
    @Shadow
    @Final
    public int y;
    @Unique
    private int defaultX;
    @Unique
    private int defaultY;
    private LegacySlotDisplay display = LegacySlotDisplay.VANILLA;
    private ItemStack lastItemStack = ItemStack.EMPTY;
    private long lastItemStackChange;

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setChanged();

    @Override
    public LegacySlotDisplay getDisplay() {
        return this.display;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Container container, int i, int j, int k, CallbackInfo ci) {
        this.defaultX = this.x;
        this.defaultY = this.y;
    }

    @Inject(method={"getItem"}, at={@At(value="RETURN")}, cancellable=true)
    public void getItem(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack override;
        ItemStack s = (ItemStack)cir.getReturnValue();
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.containerMenu.slots.contains((Object)this) && !ItemStack.matches((ItemStack)s, (ItemStack)this.lastItemStack) && this.lastItemStackChange != Util.getMillis()) {
            this.lastItemStackChange = Util.getMillis();
            this.lastItemStack = s.copy();
            this.setChanged();
        }
        if ((override = LegacySlotDisplay.of((Slot)this).getItemOverride()) != null) {
            cir.setReturnValue((Object)override);
        }
    }

    @Override
    public void setDisplay(LegacySlotDisplay slot) {
        this.display = slot;
        if (slot == LegacySlotDisplay.VANILLA) {
            this.x = this.defaultX;
            this.y = this.defaultY;
        }
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }
}

