/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.init.LegacyGameRules;

@Mixin(value={TntBlock.class})
public class TntBlockMixin {
    private static final AABB tntDetectBounding = new AABB(-50.0, -50.0, -50.0, 50.0, 50.0, 50.0);

    @ModifyExpressionValue(method={"prime(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private static boolean explode(boolean original, Level level, BlockPos pos) {
        ServerLevel serverLevel;
        return original && level instanceof ServerLevel && (((GameRules.IntegerValue)(serverLevel = (ServerLevel)level).getGameRules().getRule(LegacyGameRules.TNT_LIMIT)).get() == 0 || level.getEntitiesOfClass(PrimedTnt.class, tntDetectBounding.move(pos)).size() < ((GameRules.IntegerValue)serverLevel.getGameRules().getRule(LegacyGameRules.TNT_LIMIT)).get());
    }

    @Inject(method={"wasExploded"}, at={@At(value="HEAD")}, cancellable=true)
    private void wasExploded(ServerLevel level, BlockPos blockPos, Explosion explosion, CallbackInfo ci) {
        if (((GameRules.IntegerValue)level.getGameRules().getRule(LegacyGameRules.TNT_LIMIT)).get() > 0 && level.getEntitiesOfClass(PrimedTnt.class, tntDetectBounding.move(blockPos)).size() >= ((GameRules.IntegerValue)level.getGameRules().getRule(LegacyGameRules.TNT_LIMIT)).get()) {
            ci.cancel();
        }
    }
}

