/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.beacon;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={BeaconScreen.class})
public abstract class BeaconScreenMixin
extends AbstractContainerScreen<BeaconMenu> {
    @Shadow
    @Final
    private List<BeaconScreen.BeaconButton> beaconButtons;
    @Shadow
    @Final
    private static Component PRIMARY_EFFECT_LABEL;
    @Shadow
    @Final
    private static Component SECONDARY_EFFECT_LABEL;
    private static final Item[] DISPLAY_ITEMS;

    public BeaconScreenMixin(BeaconMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    private BeaconScreen self() {
        return (BeaconScreen)this;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        BeaconScreen.BeaconPowerButton beaconPowerButton;
        Holder mobEffect;
        int l;
        ci.cancel();
        this.imageWidth = 260;
        this.imageHeight = 255;
        super.init();
        for (int i = 0; i < ((BeaconMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((BeaconMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 141, 129);
                continue;
            }
            if (i < ((BeaconMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 36 + (s.getContainerSlot() - 9) % 9 * 21, 155 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 36 + s.getContainerSlot() * 21, 223);
        }
        this.beaconButtons.clear();
        BeaconScreen beaconScreen = this.self();
        Objects.requireNonNull(beaconScreen);
        BeaconScreen.BeaconConfirmButton confirmButton = new BeaconScreen.BeaconConfirmButton(this, beaconScreen, this.leftPos + 202, this.topPos + 127){
            {
                BeaconScreen beaconScreen = x0;
                Objects.requireNonNull(beaconScreen);
                super(beaconScreen, i, j);
            }

            protected void renderIcon(GuiGraphics guiGraphics) {
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_CONFIRM, this.getX() + 4, this.getY() + 4, 14, 14);
                FactoryScreenUtil.disableBlend();
            }
        };
        this.addRenderableWidget((GuiEventListener)confirmButton);
        this.beaconButtons.add((BeaconScreen.BeaconButton)confirmButton);
        for (int i = 0; i <= 2; ++i) {
            int j = ((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, i)).size();
            for (l = 0; l < j; ++l) {
                mobEffect = (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, i), l);
                BeaconScreen beaconScreen2 = this.self();
                Objects.requireNonNull(beaconScreen2);
                beaconPowerButton = new BeaconScreen.BeaconPowerButton(beaconScreen2, this.leftPos + 59 + (j > 1 ? l * 27 : 13), this.topPos + 38 + i * 30, mobEffect, true, i);
                beaconPowerButton.active = false;
                this.addRenderableWidget((GuiEventListener)beaconPowerButton);
                this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton);
            }
        }
        int j = ((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 3)).size() + 1;
        int k = j > 1 ? 0 : 13;
        for (l = 0; l < j - 1; ++l) {
            mobEffect = (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 3), l);
            BeaconScreen beaconScreen3 = this.self();
            Objects.requireNonNull(beaconScreen3);
            beaconPowerButton = new BeaconScreen.BeaconPowerButton(beaconScreen3, this.leftPos + 164 + l * 27 + k, this.topPos + 68, mobEffect, false, 3);
            beaconPowerButton.active = false;
            this.addRenderableWidget((GuiEventListener)beaconPowerButton);
            this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton);
        }
        BeaconScreen beaconScreen4 = this.self();
        Objects.requireNonNull(beaconScreen4);
        BeaconScreen.BeaconUpgradePowerButton beaconPowerButton2 = new BeaconScreen.BeaconUpgradePowerButton(beaconScreen4, this.leftPos + 165 + (j - 1) * 24 - k / 2, this.topPos + 68, (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 0), 0));
        beaconPowerButton2.visible = false;
        this.addRenderableWidget((GuiEventListener)beaconPowerButton2);
        this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton2);
    }

    @Unique
    private <T> T getFrom(List<T> list, int i) {
        return list.get(i);
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        guiGraphics.drawString(this.font, PRIMARY_EFFECT_LABEL, 9 + (121 - this.font.width((FormattedText)PRIMARY_EFFECT_LABEL)) / 2, 13, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.drawString(this.font, SECONDARY_EFFECT_LABEL, 133 + (121 - this.font.width((FormattedText)SECONDARY_EFFECT_LABEL)) / 2, 13, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 8, this.topPos + 9, 120, 115);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 132, this.topPos + 9, 120, 115);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_1, this.leftPos + 32, this.topPos + 39, 20, 19);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_2, this.leftPos + 32, this.topPos + 69, 20, 19);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_3, this.leftPos + 32, this.topPos + 97, 20, 19);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_4, this.leftPos + 180, this.topPos + 42, 20, 19);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 15), (float)(this.topPos + 129), 100.0f);
        guiGraphics.pose().scale(1.125f, 1.125f, 1.125f);
        for (Item displayItem : DISPLAY_ITEMS) {
            guiGraphics.renderItem(new ItemStack((ItemLike)displayItem), 0, 0);
            guiGraphics.pose().translate(18.0f, 0.0f, 0.0f);
        }
        guiGraphics.pose().popPose();
    }

    static {
        DISPLAY_ITEMS = new Item[]{Items.NETHERITE_INGOT, Items.EMERALD, Items.DIAMOND, Items.GOLD_INGOT, Items.IRON_INGOT};
    }
}

