/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={EnchantmentScreen.class})
public abstract class EnchantmentScreenMixin
extends AbstractContainerScreen<EnchantmentMenu> {
    @Shadow
    private BookModel bookModel;

    @Shadow
    protected abstract void renderBook(GuiGraphics var1, int var2, int var3, float var4);

    public EnchantmentScreenMixin(EnchantmentMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
        this.imageWidth = 215;
        this.imageHeight = 217;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 104;
        this.titleLabelX = 14;
        this.titleLabelY = 10;
        super.init();
        for (int i = 0; i < ((EnchantmentMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((EnchantmentMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 19, 66, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.ENCHANTING_SLOT;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 50, 66);
                continue;
            }
            if (i < ((EnchantmentMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 115 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 185);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        for (int l = 0; l < 3; ++l) {
            double f = d - ((double)this.leftPos + 80.5);
            double g = e - ((double)this.topPos + 23.5 + (double)(21 * l));
            if (!(f >= 0.0 && g >= 0.0 && f < 120.0 && g < 21.0 && ((EnchantmentMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l))) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, l);
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.mouseClicked(d, e, i));
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 79, this.topPos + 22, 123, 66);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 2), (float)(this.topPos + 4), 0.0f);
        guiGraphics.pose().scale(1.25f, 1.25f, 1.25f);
        this.renderBook(guiGraphics, 0, 0, f);
        guiGraphics.pose().popPose();
        EnchantmentNames.getInstance().initSeed((long)((EnchantmentMenu)this.menu).getEnchantmentSeed());
        int m = ((EnchantmentMenu)this.menu).getGoldCount();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos + 80.5f, (float)this.topPos + 2.5f, 0.0f);
        for (int n = 0; n < 3; ++n) {
            guiGraphics.pose().translate(0.0f, 21.0f, 0.0f);
            int enchantCost = ((EnchantmentMenu)this.menu).costs[n];
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ENCHANTMENT_BUTTON_EMPTY, 0, 0, 120, 21);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.DISABLED_LEVEL_SPRITES[n], -1, -1, 24, 24);
            if (enchantCost == 0) continue;
            String string = "" + enchantCost;
            int r = 86 - this.font.width(string);
            FormattedText formattedText = EnchantmentNames.getInstance().getRandomName(this.font, r);
            int s = (Integer)CommonColor.ENCHANTMENT_TEXT.get();
            if (!(m >= n + 1 && this.minecraft.player.experienceLevel >= enchantCost || this.minecraft.player.getAbilities().instabuild)) {
                guiGraphics.drawWordWrap(this.font, formattedText, 24, 3, r, (s & 0xFEFEFE) >> 1, false);
                s = (Integer)CommonColor.INSUFFICIENT_EXPERIENCE_TEXT.get();
            } else {
                double t = (double)i - ((double)this.leftPos + 80.5);
                double u = (double)j - ((double)this.topPos + 23.5 + (double)(21 * n));
                if (t >= 0.0 && u >= 0.0 && t < 120.0 && u < 21.0) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ENCHANTMENT_BUTTON_SELECTED, 0, 0, 120, 21);
                    s = (Integer)CommonColor.HIGHLIGHTED_ENCHANTMENT_TEXT.get();
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ENCHANTMENT_BUTTON_ACTIVE, 0, 0, 120, 21);
                }
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ENABLED_LEVEL_SPRITES[n], -1, -1, 24, 24);
                guiGraphics.drawWordWrap(this.font, formattedText, 24, 3, r, s, false);
                s = (Integer)CommonColor.EXPERIENCE_TEXT.get();
            }
            guiGraphics.drawString(this.font, string, 120 - this.font.width(string), 12, s);
        }
        guiGraphics.pose().popPose();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
        boolean bl = this.minecraft.player.getAbilities().instabuild;
        int k = ((EnchantmentMenu)this.menu).getGoldCount();
        for (int l = 0; l < 3; ++l) {
            int m = ((EnchantmentMenu)this.menu).costs[l];
            Optional optional = this.minecraft.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(((EnchantmentMenu)this.menu).enchantClue[l]);
            int n = ((EnchantmentMenu)this.menu).levelClue[l];
            int o = l + 1;
            double t = (double)i - ((double)this.leftPos + 80.5);
            double u = (double)j - ((double)this.topPos + 23.5 + (double)(21 * l));
            if (!(t >= 0.0 && u >= 0.0 && t < 120.0 && u < 21.0 && m > 0 && n >= 0 && !optional.isEmpty())) continue;
            ArrayList list = Lists.newArrayList();
            ((Holder.Reference)optional.get()).value();
            list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{Enchantment.getFullname((Holder)((Holder)optional.get()), (int)n)}).withStyle(ChatFormatting.WHITE));
            if (!bl) {
                list.add(CommonComponents.EMPTY);
                if (this.minecraft.player.experienceLevel < m) {
                    list.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{((EnchantmentMenu)this.menu).costs[l]}).withStyle(ChatFormatting.RED));
                } else {
                    MutableComponent mutableComponent = o == 1 ? Component.translatable((String)"container.enchant.lapis.one") : Component.translatable((String)"container.enchant.lapis.many", (Object[])new Object[]{o});
                    list.add(mutableComponent.withStyle(k >= o ? ChatFormatting.GRAY : ChatFormatting.RED));
                    MutableComponent mutableComponent2 = o == 1 ? Component.translatable((String)"container.enchant.level.one") : Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{o});
                    list.add(mutableComponent2.withStyle(ChatFormatting.GRAY));
                }
            }
            guiGraphics.renderComponentTooltip(this.font, (List)list, i, j);
            break;
        }
    }
}

