/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.merchant;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.LegacyMerchantScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.inventory.LegacyMerchantOffer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={MerchantScreen.class})
public abstract class MerchantScreenMixin
extends AbstractContainerScreen<MerchantMenu> {
    private LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    @Shadow
    private int scrollOff;
    @Shadow
    @Final
    private static Component DEPRECATED_TOOLTIP;
    @Shadow
    private int shopItem;
    @Shadow
    private boolean isDragging;
    @Shadow
    @Final
    private static Component TRADES_LABEL;
    private static final LegacySlotDisplay SLOTS_DISPLAY;

    @Shadow
    protected abstract void renderAndDecorateCostA(GuiGraphics var1, ItemStack var2, ItemStack var3, int var4, int var5);

    @Shadow
    protected abstract void renderButtonArrows(GuiGraphics var1, MerchantOffer var2, int var3, int var4);

    @Shadow
    protected abstract void postButtonClick();

    public MerchantScreenMixin(MerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 330;
        this.imageHeight = 202;
        this.inventoryLabelX = 131;
        this.inventoryLabelY = 85;
        super.init();
        for (int i = 0; i < ((MerchantMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((MerchantMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 165, 44, SLOTS_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 195, 44, SLOTS_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 258, 39, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < ((MerchantMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 132 + (s.getContainerSlot() - 9) % 9 * 21, 98 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 132 + s.getContainerSlot() * 21, 166);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        MerchantOffers merchantOffers = ((MerchantMenu)this.menu).getOffers();
        if (!merchantOffers.isEmpty()) {
            MerchantOffer merchantOffer;
            int index;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.leftPos + 8.5f, (float)this.topPos + 22.5f, 0.0f);
            for (index = 0; index < 9 && index + this.scrollOff < merchantOffers.size(); ++index) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(index + this.scrollOff == this.shopItem ? LegacySprites.BUTTON_SLOT_SELECTED : (ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 8.5f, (float)this.topPos + 22.5f + (float)(index * 18), 102, 18) ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT), 0, 0, 102, 18);
                merchantOffer = (MerchantOffer)merchantOffers.get(index + this.scrollOff);
                ItemStack itemStack = merchantOffer.getBaseCostA();
                ItemStack itemStack2 = merchantOffer.getCostA();
                ItemStack itemStack3 = merchantOffer.getCostB();
                ItemStack itemStack4 = merchantOffer.getResult();
                this.renderAndDecorateCostA(guiGraphics, itemStack2, itemStack, 10, 1);
                if (!itemStack3.isEmpty()) {
                    guiGraphics.renderFakeItem(itemStack3, 35, 1);
                    guiGraphics.renderItemDecorations(this.font, itemStack3, 35, 1);
                }
                this.renderButtonArrows(guiGraphics, merchantOffer, -4, 1);
                if (((LegacyMerchantOffer)merchantOffer).getRequiredLevel() > ((MerchantMenu)this.menu).getTraderLevel()) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, 52, 1, 16, 16);
                }
                guiGraphics.renderFakeItem(itemStack4, 68, 1);
                guiGraphics.renderItemDecorations(this.font, itemStack4, 68, 1);
                guiGraphics.pose().translate(0.0f, 18.0f, 0.0f);
            }
            guiGraphics.pose().popPose();
            for (index = 0; index < 9 && index + this.scrollOff < merchantOffers.size(); ++index) {
                merchantOffer = (MerchantOffer)merchantOffers.get(index + this.scrollOff);
                int diffY = index * 18;
                if (ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 18.5f, (float)(this.topPos + diffY) + 23.5f, 16, 16)) {
                    guiGraphics.renderTooltip(this.font, merchantOffer.getCostA(), i, j);
                    continue;
                }
                if (!merchantOffer.getCostB().isEmpty() && ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 43.5f, (float)(this.topPos + diffY) + 23.5f, 16, 16)) {
                    guiGraphics.renderTooltip(this.font, merchantOffer.getCostB(), i, j);
                    continue;
                }
                if (!ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 76.5f, (float)(this.topPos + diffY) + 23.5f, 16, 16)) continue;
                guiGraphics.renderTooltip(this.font, merchantOffer.getResult(), i, j);
            }
            MerchantOffer merchantOffer2 = (MerchantOffer)merchantOffers.get(this.shopItem);
            if (this.shopItem - this.scrollOff < 9 && this.shopItem - this.scrollOff >= 0 && merchantOffer2.isOutOfStock() && this.isHovering(7, 21 + 18 * (this.shopItem - this.scrollOff), 105, 18, i, j) && ((MerchantMenu)this.menu).canRestock()) {
                guiGraphics.renderTooltip(this.font, DEPRECATED_TOOLTIP, i, j);
            }
        }
        this.renderTooltip(guiGraphics, i, j);
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        int k = ((MerchantMenu)this.menu).getTraderLevel();
        if (k > 0 && k <= 5 && ((MerchantMenu)this.menu).showProgressBar()) {
            MutableComponent component = LegacyMerchantScreen.getMerchantTile(this.title, k);
            guiGraphics.drawString(this.font, (Component)component, 131 + (189 - this.font.width((FormattedText)component)) / 2, 10, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else {
            guiGraphics.drawString(this.font, this.title, 131 + (189 - this.font.width((FormattedText)this.title)) / 2, 10, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.drawString(this.font, TRADES_LABEL, 7 + (105 - this.font.width((FormattedText)TRADES_LABEL)) / 2, 10, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        this.isDragging = false;
        for (int index = 0; index < 9; ++index) {
            boolean hovered = false;
            if (index + this.scrollOff < ((MerchantMenu)this.menu).getOffers().size() && !(hovered = ScreenUtil.isMouseOver(d, e, (float)this.leftPos + 8.5f, (float)this.topPos + 22.5f + (float)(index * 18), 102, 18))) continue;
            if (!hovered) break;
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
            if (this.shopItem == index + this.scrollOff && ((LegacyMerchantOffer)((MerchantMenu)this.menu).getOffers().get(index + this.scrollOff)).getRequiredLevel() <= ((MerchantMenu)this.menu).getTraderLevel()) {
                this.postButtonClick();
            } else {
                this.shopItem = index + this.scrollOff;
            }
            cir.setReturnValue((Object)true);
            return;
        }
        if (((MerchantMenu)this.menu).getOffers().size() > 9 && ScreenUtil.isMouseOver(d, e, this.leftPos + 115, this.topPos + 21, 13, 165)) {
            this.isDragging = true;
        }
        cir.setReturnValue((Object)super.mouseClicked(d, e, i));
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseDragged(double d, double e, int i, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        if (this.isDragging) {
            int oldScroll = this.scrollOff;
            this.scrollOff = (int)Math.round(Math.max(0.0, Math.min((e - (double)(this.topPos + 18)) / 165.0, (double)(((MerchantMenu)this.menu).getOffers().size() - 9))));
            if (this.scrollOff != oldScroll) {
                this.scrollRenderer.updateScroll(oldScroll - this.scrollOff > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            }
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)super.mouseDragged(d, e, i, f, g));
        }
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseScrolled(double d, double e, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        if (((MerchantMenu)this.menu).getOffers().size() > 9) {
            int j = ((MerchantMenu)this.menu).getOffers().size() - 9;
            int oldScroll = this.scrollOff;
            this.scrollOff = Mth.clamp((int)((int)((double)this.scrollOff - Math.signum(g))), (int)0, (int)j);
            if (this.scrollOff != oldScroll) {
                this.scrollRenderer.updateScroll(oldScroll - this.scrollOff > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            }
        }
        cir.setReturnValue((Object)true);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (CommonInputs.selected((int)i) && this.shopItem + this.scrollOff < ((MerchantMenu)this.menu).getOffers().size()) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
            this.postButtonClick();
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 7, this.topPos + 21, 105, 165);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 219.5, (double)this.topPos + 42.5, 0.0);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 115), (float)(this.topPos + 21), 0.0f);
        if (((MerchantMenu)this.menu).getOffers().size() > 9) {
            if (this.scrollOff != ((MerchantMenu)this.menu).getOffers().size() - 9) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, 169);
            }
            if (this.scrollOff > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f);
        }
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 13, 165);
        guiGraphics.pose().translate(-2.0f, -1.0f + (((MerchantMenu)this.menu).getOffers().size() > 9 ? 151.5f * (float)this.scrollOff / (float)(((MerchantMenu)this.menu).getOffers().size() - 9) : 0.0f), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
        guiGraphics.pose().popPose();
        if (((MerchantMenu)this.menu).showProgressBar()) {
            int k = ((MerchantMenu)this.menu).getTraderLevel();
            int l = ((MerchantMenu)this.menu).getTraderXp();
            if (k >= 5) {
                return;
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.leftPos + 144.5, (double)(this.topPos + 21), 0.0);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_BACKGROUND, 0, 0, 0, 161, 4);
            int m = VillagerData.getMinXpPerLevel((int)k);
            if (l < m || !VillagerData.canLevelUp((int)k)) {
                guiGraphics.pose().popPose();
                return;
            }
            float v = 161.0f / (float)(VillagerData.getMaxXpPerLevel((int)k) - m);
            int o = Math.min(Mth.floor((float)(v * (float)(l - m))), 161);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_CURRENT, 161, 4, 0, 0, 0, 0, 0, o, 4);
            int p = ((MerchantMenu)this.menu).getFutureTraderXp();
            if (p > 0) {
                int q = Math.min(Mth.floor((float)((float)p * v)), 161 - o);
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_RESULT, 161, 4, o, 0, o, 0, 0, q, 4);
            }
            guiGraphics.pose().popPose();
        }
    }

    static {
        SLOTS_DISPLAY = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 23;
            }
        };
    }
}

