/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RegisterPresetEditorsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.commons.io.FileUtils;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.SpectatorGuiAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.Legacy4J;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.client.BackupConfirmScreenAccessor;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.DisconnectedScreenAccessor;
import wily.legacy.client.KnownListing;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyCraftingTabListing;
import wily.legacy.client.LegacyCreativeTabListing;
import wily.legacy.client.LegacyMixinOptions;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.LegacyTipOverride;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.LevelRendererAccessor;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.HostOptionsScreen;
import wily.legacy.client.screen.HowToPlayScreen;
import wily.legacy.client.screen.LeaderboardsScreen;
import wily.legacy.client.screen.Legacy4JSettingsScreen;
import wily.legacy.client.screen.LegacyBuffetWorldScreen;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyFlatWorldScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyLoomScreen;
import wily.legacy.client.screen.LegacyMerchantScreen;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.LegacyStonecutterScreen;
import wily.legacy.client.screen.MixedCraftingScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.init.LegacyUIElementTypes;
import wily.legacy.inventory.LegacyPistonMovingBlockEntity;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.TopMessage;
import wily.legacy.util.MCAccount;
import wily.legacy.util.ScreenUtil;

public class Legacy4JClient {
    public static boolean isNewerVersion = false;
    public static boolean isNewerMinecraftVersion = false;
    public static final List<Runnable> whenResetOptions = new ArrayList<Runnable>();
    public static LevelStorageSource currentWorldSource;
    public static boolean legacyFont;
    public static boolean forceVanillaFontShadowColor;
    public static ResourceLocation defaultFontOverride;
    public static ControlType lastControlType;
    public static boolean manualSave;
    public static boolean saveExit;
    public static boolean retakeWorldIcon;
    public static LegacyLoadingScreen legacyLoadingScreen;
    public static Renderable itemActivationRenderReplacement;
    public static final LegacyTipManager legacyTipManager;
    public static final LegacyCreativeTabListing.Manager legacyCreativeListingManager;
    public static final LegacyCraftingTabListing.Manager legacyCraftingListingManager;
    public static final LegacyBiomeOverride.Manager legacyBiomeOverrides;
    public static final LegacyWorldTemplate.Manager legacyWorldTemplateManager;
    public static final LegacyTipOverride.Manager legacyTipOverridesManager;
    public static final LegacyResourceManager legacyResourceManager;
    public static final StoneCuttingGroupManager stoneCuttingGroupManager;
    public static final LoomTabListing.Manager loomListingManager;
    public static final ControlTooltip.GuiManager controlTooltipGuiManager;
    public static final LeaderboardsScreen.Manager leaderBoardListingManager;
    public static final HowToPlayScreen.Manager howToPlaySectionManager;
    public static ControllerManager controllerManager;
    public static final Map<Block, ResourceLocation> fastLeavesModels;
    public static KnownListing<Block> knownBlocks;
    public static KnownListing<EntityType<?>> knownEntities;
    public static GameType defaultServerGameType;
    public static GameRules gameRules;
    public static Consumer<ServerPlayer> serverPlayerJoinConsumer;
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE;
    public static PostChain gammaEffect;
    public static final RenderType GHAST_SHOOTING_GLOW;
    public static final RenderType DROWNED_GLOW;
    public static final Map<Optional<ResourceKey<WorldPreset>>, PresetEditor> VANILLA_PRESET_EDITORS;
    public static final KeyMapping keyCrafting;
    public static final KeyMapping keyCycleHeldLeft;
    public static final KeyMapping keyCycleHeldRight;
    public static final KeyMapping keyToggleCursor;
    public static KeyMapping keyHostOptions;
    public static KeyMapping keyLegacy4JSettings;
    public static KeyMapping keyFlyUp;
    public static KeyMapping keyFlyDown;
    public static KeyMapping keyFlyLeft;
    public static KeyMapping keyFlyRight;

    public static float[] getVisualPlayerColor(LegacyPlayerInfo info) {
        return Legacy4JClient.getVisualPlayerColor(info.getIdentifierIndex() >= 0 ? info.getIdentifierIndex() : info.legacyMinecraft$getProfile().getId().hashCode());
    }

    public static PostChain getGammaEffect() {
        return gammaEffect;
    }

    public static float[] getVisualPlayerColor(int i) {
        PlayerIdentifier playerIdentifier = PlayerIdentifier.of(i);
        if (PlayerIdentifier.list.containsKey(i)) {
            return new float[]{(float)(playerIdentifier.color() >> 16 & 0xFF) / 255.0f, (float)(playerIdentifier.color() >> 8 & 0xFF) / 255.0f, (float)(playerIdentifier.color() & 0xFF) / 255.0f};
        }
        float r = (float)(playerIdentifier.color() >> 16 & 0xFF) * (0.8f + (float)(i % 15) / 30.0f) / 255.0f;
        float g = (float)(playerIdentifier.color() >> 8 & 0xFF) * (1.2f - (float)(i % 16) / 32.0f) / 255.0f;
        float b = (float)(playerIdentifier.color() & 0xFF) * (0.8f + (float)(i % 17) / 34.0f) / 255.0f;
        return new float[]{r, g, b};
    }

    public static void updateLegacyPlayerInfos(Map<UUID, LegacyPlayerInfo> map) {
        Minecraft minecraft = Minecraft.m_91087_();
        map.forEach((s, i) -> {
            PlayerInfo patt0$temp;
            if (minecraft.m_91403_() != null && (patt0$temp = minecraft.m_91403_().m_104949_(s)) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo info = (LegacyPlayerInfo)patt0$temp;
                info.copyFrom((LegacyPlayerInfo)i);
            }
        });
        LeaderboardsScreen.refreshStatsBoards(minecraft);
        Screen screen = minecraft.f_91080_;
        if (screen instanceof LeaderboardsScreen) {
            LeaderboardsScreen s2 = (LeaderboardsScreen)screen;
            if (LeaderboardsScreen.statsBoards.get((int)s2.selectedStatBoard).statsList.isEmpty()) {
                minecraft.m_201446_(() -> s2.changeStatBoard(false));
            }
        }
        if (minecraft.f_91074_ != null) {
            LegacyOptions.classicCrafting.set((Object)((Boolean)LegacyOptions.classicCrafting.get()));
            LegacyOptions.classicTrading.set((Object)((Boolean)LegacyOptions.classicTrading.get()));
            LegacyOptions.classicStonecutting.set((Object)((Boolean)LegacyOptions.classicStonecutting.get()));
            LegacyOptions.classicLoom.set((Object)((Boolean)LegacyOptions.classicLoom.get()));
        }
    }

    public static void displayActivationAnimation(Renderable renderable) {
        itemActivationRenderReplacement = renderable;
        Minecraft.m_91087_().f_91063_.m_109113_(ItemStack.f_41583_);
    }

    public static void applyFontOverrideIf(boolean b, ResourceLocation override, Consumer<Boolean> fontRender) {
        if (b) {
            defaultFontOverride = override;
        }
        fontRender.accept(b);
        if (b) {
            defaultFontOverride = null;
        }
    }

    public static LevelStorageSource getLevelStorageSource() {
        return (Boolean)LegacyOptions.saveCache.get() != false ? currentWorldSource : Minecraft.m_91087_().m_91392_();
    }

    public static boolean hasSaveSystem(Minecraft minecraft) {
        return minecraft.m_91091_() && !minecraft.m_91402_() && !minecraft.m_91092_().m_7035_() && Legacy4JClient.isCurrentWorldSource(minecraft.m_91092_().f_129744_);
    }

    public static boolean isCurrentWorldSource(LevelStorageSource.LevelStorageAccess storageSource) {
        return storageSource.m_197394_(Level.f_46428_).getParent().equals(currentWorldSource.m_78257_());
    }

    public static boolean playerHasInfiniteMaterials() {
        return Minecraft.m_91087_().f_91072_.m_105290_();
    }

    public static void saveLevel(LevelStorageSource.LevelStorageAccess storageSource) {
        if (Legacy4JClient.isCurrentWorldSource(storageSource)) {
            Legacy4JClient.copySaveBtwSources(storageSource, Minecraft.m_91087_().m_91392_());
        }
    }

    public static void displayEffectActivationAnimation(MobEffect effect) {
        Legacy4JClient.displayActivationAnimation((guiGraphics, i, j, f) -> {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(0, 1, 0, 1, -1, Minecraft.m_91087_().m_91306_().m_118732_(effect));
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.5f, 0.5f, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            guiGraphics.m_280168_().m_252880_(-0.5f, -0.5f, 0.0f);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(0, 0, 0, 1, 1, Minecraft.m_91087_().m_91306_().m_118732_(effect));
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85849_();
        });
    }

    public static Screen getReplacementScreen(Screen screen) {
        if (!((Boolean)LegacyMixinOptions.legacyTitleScreen.get()).booleanValue()) {
            return screen;
        }
        if (screen instanceof JoinMultiplayerScreen) {
            return new PlayGameScreen((Screen)new TitleScreen(), 2);
        }
        if (screen instanceof DisconnectedScreen) {
            DisconnectedScreen s = (DisconnectedScreen)screen;
            return ConfirmationScreen.createInfoScreen(Legacy4JClient.getReplacementScreen(DisconnectedScreenAccessor.of(s).getParent()), s.m_96636_(), DisconnectedScreenAccessor.of(s).getReason());
        }
        if (screen instanceof AlertScreen) {
            final AlertScreen s = (AlertScreen)screen;
            return new ConfirmationScreen(Minecraft.m_91087_().f_91080_, 230, 97, s.m_96636_(), s.f_238618_, LegacyScreen::m_7379_){

                @Override
                protected void addButtons() {
                    this.okButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), b -> s2.f_95515_.run()).m_252987_(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).m_253136_();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                }

                public boolean m_6913_() {
                    return s.m_6913_();
                }
            };
        }
        if (screen instanceof BackupConfirmScreen) {
            final BackupConfirmScreen s = (BackupConfirmScreen)screen;
            return new ConfirmationScreen(Minecraft.m_91087_().f_91080_, 230, 141 + (BackupConfirmScreenAccessor.of(s).hasCacheErase() ? 14 : 0), s.m_96636_(), BackupConfirmScreenAccessor.of(s).getDescription(), LegacyScreen::m_7379_){
                boolean eraseCache;
                {
                    super(parent, imageWidth, baseHeight, title, message, okAction);
                    this.eraseCache = false;
                }

                @Override
                protected void addButtons() {
                    if (BackupConfirmScreenAccessor.of(s).hasCacheErase()) {
                        this.renderableVList.addRenderable((Renderable)new TickBox(this.panel.x + 15, this.panel.y + this.panel.height - 88, this.eraseCache, b -> Component.m_237115_((String)"selectWorld.backupEraseCache"), b -> null, b -> {
                            this.eraseCache = b.selected;
                        }));
                    }
                    this.okButton = Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.backupJoinConfirmButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(true, this.eraseCache)).m_253136_();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                    this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.backupJoinSkipButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(false, this.eraseCache)).m_253136_());
                    this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.m_7379_()).m_253136_());
                }
            };
        }
        return screen;
    }

    public static void preTick(Minecraft minecraft) {
        boolean left;
        ReplaceableScreen r;
        Screen screen;
        ControlType activeControlType = ControlType.getActiveType();
        if (lastControlType != activeControlType) {
            if (lastControlType != null) {
                ((ControlType.UpdateEvent)ControlType.UpdateEvent.EVENT.invoker).change(lastControlType, activeControlType);
            }
            lastControlType = activeControlType;
        }
        if ((screen = minecraft.f_91080_) instanceof ReplaceableScreen && (r = (ReplaceableScreen)screen).canReplace()) {
            minecraft.m_91152_(r.getReplacement());
        }
        if (((Boolean)LegacyOptions.unfocusedInputs.get()).booleanValue()) {
            minecraft.m_7440_(true);
        }
        while (keyCrafting.m_90859_()) {
            if (minecraft.f_91074_ != null && (minecraft.f_91074_.m_7500_() || minecraft.f_91074_.m_5833_())) {
                if (minecraft.f_91074_.m_5833_()) {
                    minecraft.f_91065_.m_93085_().m_94793_();
                    continue;
                }
                minecraft.m_91152_(CreativeModeScreen.getActualCreativeScreenInstance(minecraft));
                continue;
            }
            if (ScreenUtil.hasClassicCrafting()) {
                minecraft.m_91301_().m_120564_();
                minecraft.m_91152_((Screen)new InventoryScreen((Player)minecraft.f_91074_));
                continue;
            }
            screen = minecraft.f_91077_;
            if (screen instanceof BlockHitResult && minecraft.f_91073_.m_8055_((r = (BlockHitResult)screen).m_82425_()).m_60734_() instanceof CraftingTableBlock) {
                minecraft.f_91072_.m_233732_(minecraft.f_91074_, InteractionHand.MAIN_HAND, (BlockHitResult)r);
                continue;
            }
            if (ScreenUtil.hasMixedCrafting()) {
                minecraft.m_91152_(MixedCraftingScreen.playerCraftingScreen((Player)minecraft.f_91074_));
                continue;
            }
            CommonNetwork.sendToServer((CommonNetwork.Payload)ServerOpenClientMenuPayload.playerCrafting());
        }
        while (keyHostOptions.m_90859_()) {
            minecraft.m_91152_((Screen)new HostOptionsScreen());
        }
        while (keyLegacy4JSettings.m_90859_()) {
            minecraft.m_91152_((Screen)new Legacy4JSettingsScreen(Minecraft.m_91087_().f_91080_));
        }
        while ((left = keyCycleHeldLeft.m_90859_()) || keyCycleHeldRight.m_90859_()) {
            if (minecraft.f_91074_ == null) continue;
            if (minecraft.f_91074_.m_5833_()) {
                if (!minecraft.f_91065_.m_93085_().m_94768_()) continue;
                minecraft.f_91065_.m_93085_().m_205380_(left ? -1 : 1);
                continue;
            }
            minecraft.f_91074_.m_150109_().m_35988_(left ? 1.0 : -1.0);
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            TopMessage.tick();
        }
    }

    public static void postTick(Minecraft minecraft) {
        if (minecraft.f_91073_ != null && minecraft.f_91080_ == null && ((Boolean)LegacyOptions.hints.get()).booleanValue() && LegacyTipManager.getActualTip() == null) {
            EntityHitResult r;
            Entity e;
            HitResult hit = minecraft.f_91077_;
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockState state = minecraft.f_91073_.m_8055_(blockHitResult.m_82425_());
                if (!state.m_60795_() && !(state.m_60734_() instanceof LiquidBlock) && state.m_60734_().m_5456_() instanceof BlockItem && !knownBlocks.contains(state.m_60734_()) && LegacyTipManager.setTip(LegacyTipManager.getTip(state.m_60734_().m_5456_().m_7968_()))) {
                    knownBlocks.add(state.m_60734_());
                }
            } else if (hit instanceof EntityHitResult && !knownEntities.contains((e = (r = (EntityHitResult)hit).m_82443_()).m_6095_()) && LegacyTipManager.setTip(LegacyTipManager.getTip(e))) {
                knownEntities.add(r.m_82443_().m_6095_());
            }
        }
    }

    public static void postScreenInit(Screen screen) {
        if (screen.m_7222_() != null && !screen.m_6702_().contains(screen.m_7222_())) {
            screen.m_7522_(null);
        }
        if ((Minecraft.m_91087_().m_264529_().m_264505_() || Legacy4JClient.controllerManager.connectedController != null || controllerManager.getCursorMode().isNever()) && !controllerManager.getCursorMode().isAlways()) {
            ComponentPath path;
            Controller.Event e = Controller.Event.of(screen);
            if (e.disableCursorOnInit() && !controllerManager.getCursorMode().isAlways()) {
                controllerManager.disableCursor();
            }
            if (Legacy4JClient.controllerManager.isCursorDisabled && (!e.disableCursorOnInit() || controllerManager.getCursorMode().isAlways())) {
                controllerManager.enableCursorAndScheduleReset();
            }
            if (!(screen.m_7222_() != null && screen.m_7222_().m_93696_() || (path = screen.m_264064_((FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN))) == null)) {
                path.m_264432_(true);
            }
        }
        controllerManager.resetCursor();
    }

    public static void clientPlayerJoin(LocalPlayer p) {
        gameRules = new GameRules();
        LegacyCreativeTabListing.rebuildVanillaCreativeTabsItems(Minecraft.m_91087_());
    }

    public static void serverPlayerJoin(ServerPlayer player) {
        if (serverPlayerJoinConsumer != null) {
            serverPlayerJoinConsumer.accept(player);
            serverPlayerJoinConsumer = null;
        }
    }

    public static void init() {
        ControlType.UpdateEvent.EVENT.register((last, actual) -> {
            UIAccessor uiAccessor = Minecraft.m_91087_().f_91080_ == null ? FactoryScreenUtil.getGuiAccessor() : FactoryScreenUtil.getScreenAccessor();
            uiAccessor.reloadUI();
            LegacyTipManager.rebuildActual();
        });
        FactoryAPIClient.registerKeyMapping(registry -> {
            registry.accept(keyCrafting);
            registry.accept(keyHostOptions);
            registry.accept(keyLegacy4JSettings);
            registry.accept(keyCycleHeldLeft);
            registry.accept(keyCycleHeldRight);
            registry.accept(keyToggleCursor);
            registry.accept(keyFlyUp);
            registry.accept(keyFlyDown);
            registry.accept(keyFlyLeft);
            registry.accept(keyFlyRight);
        });
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyCreativeListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyCraftingListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyWorldTemplateManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipOverridesManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyBiomeOverrides);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyResourceManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)stoneCuttingGroupManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)loomListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)controlTooltipGuiManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)leaderBoardListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)howToPlaySectionManager);
        FactoryAPIClient.setup(m -> {
            MCAccount.loadAll();
            controllerManager.setup((Minecraft)m);
            FactoryOptions.NEAREST_MIPMAP_SCALING.set((Object)true);
            FactoryOptions.RANDOM_BLOCK_ROTATIONS.set((Object)false);
            knownBlocks = new KnownListing(BuiltInRegistries.f_256975_, m.f_91069_.toPath());
            knownEntities = new KnownListing(BuiltInRegistries.f_256780_, m.f_91069_.toPath());
            currentWorldSource = LevelStorageSource.m_78242_((Path)m.f_91069_.toPath().resolve("current-world"));
            ControllerBinding.setupDefaultBindings(m);
            LegacyOptions.CLIENT_STORAGE.load();
            FactoryAPIClient.registerRenderType((RenderType)RenderType.m_110457_(), (Block[])new Block[]{(Block)LegacyRegistries.SHRUB.get()});
            FactoryAPIClient.registerRenderType((RenderType)RenderType.m_110466_(), (Block[])new Block[]{Blocks.f_49990_});
            String[] nonScaledElements = new String[]{FactoryGuiElement.SELECTED_ITEM_NAME.name(), FactoryGuiElement.OVERLAY_MESSAGE.name(), FactoryGuiElement.SPECTATOR_TOOLTIP.name()};
            ArbitrarySupplier hudScale = () -> Float.valueOf(3.0f / ScreenUtil.getHUDScale());
            ArbitrarySupplier crosshairScale = () -> {
                float f;
                if (ScreenUtil.getStandardHeight() >= 1080) {
                    switch ((Integer)LegacyOptions.hudScale.get()) {
                        case 1: 
                        case 2: {
                            f = 0.9f;
                            break;
                        }
                        default: {
                            f = 1.0f;
                            break;
                        }
                    }
                } else {
                    f = 1.0f;
                }
                return Float.valueOf(f);
            };
            UIAccessor accessor = FactoryScreenUtil.getGuiAccessor();
            FactoryGuiElement.HOTBAR.pre().register(guiGraphics -> {
                int newSelection;
                ScreenUtil.renderAnimatedCharacter(guiGraphics);
                int n = newSelection = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_150109_().f_35977_ : -1;
                if (ScreenUtil.lastHotbarSelection >= 0 && ScreenUtil.lastHotbarSelection != newSelection) {
                    ScreenUtil.lastHotbarSelectionChange = Util.m_137550_();
                }
                ScreenUtil.lastHotbarSelection = newSelection;
                if ((double)ColorUtil.getAlpha((int)FactoryGuiElement.HOTBAR.getColor(accessor)) < 1.0) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).pushBufferSource((MultiBufferSource.BufferSource)BufferSourceWrapper.translucent(FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource()));
                }
            });
            FactoryGuiElement.HOTBAR.post().register(guiGraphics -> {
                if ((double)ColorUtil.getAlpha((int)FactoryGuiElement.HOTBAR.getColor(accessor)) < 1.0) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).popBufferSource();
                }
                if (Minecraft.m_91087_().f_91074_ != null) {
                    ControlTooltip.Renderer.of(Minecraft.m_91087_().f_91065_).m_88315_(guiGraphics, 0, 0, FactoryAPIClient.getPartialTick());
                }
                ScreenUtil.renderTopText(guiGraphics, TopMessage.small, 21, 1.0f, TopMessage.smallTicks);
                ScreenUtil.renderTopText(guiGraphics, TopMessage.medium, 37, 1.5f, TopMessage.mediumTicks);
            });
            FactoryGuiElement.SPECTATOR_HOTBAR.pre().register(guiGraphics -> {
                legacyFont = false;
                ScreenUtil.renderAnimatedCharacter(guiGraphics);
            });
            FactoryGuiElement.SPECTATOR_HOTBAR.post().register(guiGraphics -> {
                legacyFont = true;
            });
            accessor.getStaticDefinitions().add(UIDefinition.createBeforeInit(a -> {
                if (!((Boolean)LegacyMixinOptions.legacyGui.get()).booleanValue()) {
                    return;
                }
                a.getElements().put((Object)(FactoryGuiElement.VIGNETTE.name() + ".isVisible"), () -> false);
                a.getElements().put((Object)"isGuiVisible", () -> Minecraft.m_91087_().f_91080_ == null);
                a.getElements().put((Object)"hud.scaleX", (Object)hudScale);
                a.getElements().put((Object)"hud.scaleY", (Object)hudScale);
                a.getElements().put((Object)"hud.scaleZ", (Object)hudScale);
                a.getElements().put((Object)"hud.translateX", () -> Minecraft.m_91087_().m_91268_().m_85445_() / 2);
                a.getElements().put((Object)"hud.scaledTranslateX", () -> -Minecraft.m_91087_().m_91268_().m_85445_() / 2);
                a.getElements().put((Object)"hud.translateY", () -> (double)Minecraft.m_91087_().m_91268_().m_85446_() + ScreenUtil.getHUDDistance());
                a.getElements().put((Object)"hud.scaledTranslateY", () -> -Minecraft.m_91087_().m_91268_().m_85446_());
                a.getElements().put((Object)"hud.renderColor", () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)ScreenUtil.getHUDOpacity()));
                a.getElements().put((Object)(FactoryGuiElement.BOSSHEALTH.name() + ".renderColor"), () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)ScreenUtil.getInterfaceOpacity()));
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleX"), (Object)crosshairScale);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleY"), (Object)crosshairScale);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaleZ"), (Object)crosshairScale);
                a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.translateY", (Object)false);
                a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.scaledTranslateY", (Object)false);
                a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_HOTBAR.name() + ".translateY"), () -> (22.0 - ScreenUtil.getHUDDistance()) * (double)(1.0f - SpectatorGuiAccessor.getInstance().getVisibility()));
                a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_TOOLTIP.name() + ".translateY"), () -> (22.0 - ScreenUtil.getHUDDistance()) * (double)(1.0f - SpectatorGuiAccessor.getInstance().getVisibility()) + 35.0 - (double)ScreenUtil.getHUDSize() + ScreenUtil.getHUDDistance());
                for (String element : nonScaledElements) {
                    a.putStaticElement(element + ".hud.translateX", (Object)false);
                    a.putStaticElement(element + ".hud.translateY", (Object)false);
                    a.putStaticElement(element + ".hud.scaledTranslateX", (Object)false);
                    a.putStaticElement(element + ".hud.scaledTranslateY", (Object)false);
                    a.putStaticElement(element + ".hud.scale", (Object)false);
                }
                a.getElements().put((Object)(FactoryGuiElement.OVERLAY_MESSAGE.name() + ".translateY"), () -> ScreenUtil.getHUDDistance() + 72.0 - (double)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue() - (double)ScreenUtil.getHUDSize() - (double)(GuiAccessor.getInstance().getLastToolHighlight().m_41619_() || GuiAccessor.getInstance().getToolHighlightTimer() <= 0 || ScreenUtil.getSelectedItemTooltipLines() == 0 ? 0 : (Math.min(ScreenUtil.getSelectedItemTooltipLines() + 1, ScreenUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight()).stream().filter(c -> !c.getString().isEmpty()).mapToInt(c -> 1).sum()) - 1) * (Integer)LegacyOptions.selectedItemTooltipSpacing.get()));
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".translateY"), () -> Minecraft.m_91087_().m_91268_().m_85446_() / 2);
                a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaledTranslateY"), () -> -Minecraft.m_91087_().m_91268_().m_85446_() / 2);
            }));
        });
        FactoryAPIClient.registerBlockColor(registry -> {
            registry.accept((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? GrassColor.m_276205_() : BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos), (Block)LegacyRegistries.SHRUB.get());
            registry.accept((blockState, blockAndTintGetter, blockPos, i) -> {
                if (blockAndTintGetter != null && blockPos != null) {
                    LegacyPistonMovingBlockEntity e;
                    BlockEntity blockEntity = blockAndTintGetter.m_7702_(blockPos);
                    if (blockEntity instanceof LegacyPistonMovingBlockEntity && (e = (LegacyPistonMovingBlockEntity)blockEntity).getRenderingBlockEntity() != null && ((Boolean)LegacyOptions.enhancedPistonMovingRenderer.get()).booleanValue()) {
                        blockEntity = e.getRenderingBlockEntity();
                    }
                    if (blockEntity instanceof WaterCauldronBlockEntity) {
                        WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)blockEntity;
                        if (!be.hasWater()) {
                            return PotionUtils.m_43564_((Collection)((Potion)be.potion.m_203334_()).m_43488_());
                        }
                        if (be.waterColor != null) {
                            return be.waterColor;
                        }
                    }
                    return BiomeColors.m_108811_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                }
                return -1;
            }, Blocks.f_152476_);
        });
        fastLeavesModels.put(Blocks.f_50050_, FactoryAPI.createVanillaLocation((String)"fast_oak_leaves"));
        fastLeavesModels.put(Blocks.f_50051_, FactoryAPI.createVanillaLocation((String)"fast_spruce_leaves"));
        fastLeavesModels.put(Blocks.f_50052_, FactoryAPI.createVanillaLocation((String)"fast_birch_leaves"));
        fastLeavesModels.put(Blocks.f_50053_, FactoryAPI.createVanillaLocation((String)"fast_jungle_leaves"));
        fastLeavesModels.put(Blocks.f_50054_, FactoryAPI.createVanillaLocation((String)"fast_acacia_leaves"));
        fastLeavesModels.put(Blocks.f_271115_, FactoryAPI.createVanillaLocation((String)"fast_cherry_leaves"));
        fastLeavesModels.put(Blocks.f_50055_, FactoryAPI.createVanillaLocation((String)"fast_dark_oak_leaves"));
        fastLeavesModels.put(Blocks.f_220838_, FactoryAPI.createVanillaLocation((String)"fast_mangrove_leaves"));
        fastLeavesModels.put(Blocks.f_152470_, FactoryAPI.createVanillaLocation((String)"fast_azalea_leaves"));
        fastLeavesModels.put(Blocks.f_152471_, FactoryAPI.createVanillaLocation((String)"fast_flowering_azalea_leaves"));
        FactoryAPIClient.registerExtraModels(register -> fastLeavesModels.values().forEach(register));
        FactoryAPIClient.registerItemColor(registry -> {
            registry.accept((item, i) -> -13544529, (Item)LegacyRegistries.WATER.get());
            registry.accept((itemStack, i) -> GrassColor.m_276205_(), ((Block)LegacyRegistries.SHRUB.get()).m_5456_());
        });
        FactoryAPIClient.registerMenuScreen(registry -> {
            registry.register((MenuType)LegacyRegistries.CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::craftingScreen);
            registry.register((MenuType)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::playerCraftingScreen);
            registry.register((MenuType)LegacyRegistries.LOOM_PANEL_MENU.get(), LegacyLoomScreen::new);
            registry.register((MenuType)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), LegacyStonecutterScreen::new);
            registry.register((MenuType)LegacyRegistries.MERCHANT_MENU.get(), LegacyMerchantScreen::new);
        });
        FactoryAPIClient.preTick(Legacy4JClient::preTick);
        FactoryAPIClient.postTick(Legacy4JClient::postTick);
        FactoryAPIClient.PlayerEvent.JOIN_EVENT.register(Legacy4JClient::clientPlayerJoin);
        FactoryAPIClient.STOPPING.register(m -> {
            knownBlocks.save();
            knownEntities.save();
            PackAlbum.applyDefaultResourceAlbum();
            LegacyOptions.lastLoadedVersion.set((Object)Legacy4J.VERSION.get());
            LegacyOptions.lastLoadedMinecraftVersion.set((Object)SharedConstants.m_183709_().m_132493_());
            LegacyOptions.CLIENT_STORAGE.save();
        });
        FactoryEvent.ServerSave.EVENT.register((server, log, flush, force) -> {
            retakeWorldIcon = true;
            knownBlocks.save();
            knownEntities.save();
        });
        FactoryEvent.registerBuiltInPacks(registry -> {
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"legacy_waters"), true);
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"console_aspects"), false);
            if (FactoryAPI.getLoader().isForgeLike()) {
                registry.register("programmer_art", FactoryAPI.createLocation((String)"legacy", (String)"programmer_art"), (Component)Component.m_237115_((String)"legacy.builtin.console_programmer"), Pack.Position.TOP, false);
                registry.register("high_contrast", FactoryAPI.createLocation((String)"legacy", (String)"high_contrast"), (Component)Component.m_237115_((String)"legacy.builtin.high_contrast"), Pack.Position.TOP, false);
            }
        });
        FactoryAPIClient.uiDefinitionManager.staticList.add(UIDefinition.createBeforeInit(a -> {
            CommonValue.COMMON_VALUES.forEach((s, c) -> a.getElements().put((Object)("commonValue." + (String)(s.m_135827_().equals("minecraft") ? "" : s.m_135827_() + ".") + s.m_135815_()), (Object)c));
            CommonColor.COMMON_COLORS.forEach((s, c) -> a.getElements().put((Object)("commonColor." + (String)(s.m_135827_().equals("minecraft") ? "" : s.m_135827_() + ".") + s.m_135815_()), (Object)c));
            ControlTooltip.commonIcons.forEach((s, i) -> a.getElements().put((Object)("controlIcon." + s), (Object)i.map(ControlTooltip.ComponentIcon::getComponent)));
            for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
                a.getElements().put((Object)("controlIcon." + keyMapping.m_90860_()), () -> ControlTooltip.getIconComponentFromKeyMapping(LegacyKeyMapping.of(keyMapping)));
            }
            a.getElements().put((Object)"interfaceResolution", ScreenUtil::getInterfaceResolution);
            ControlType.types.forEach((s, c) -> a.getElements().put((Object)("activeControlType." + s), () -> ControlType.getActiveType().equals(c)));
        }));
        LegacyUIElementTypes.init();
        FactoryAPIClient.registerRenderLayer(r -> {
            EntityRenderer patt1$temp;
            GhastRenderer renderer;
            EntityRenderer patt0$temp = r.getEntityRenderer(EntityType.f_20453_);
            if (patt0$temp instanceof GhastRenderer) {
                renderer = (GhastRenderer)patt0$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<Ghast, GhastModel<Ghast>>((RenderLayerParent)renderer){

                    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, Ghast ghast, float f, float g, float h, float j, float k, float l) {
                        if (!ghast.m_32756_()) {
                            return;
                        }
                        super.m_6494_(poseStack, multiBufferSource, i, (Entity)ghast, f, g, h, j, k, l);
                    }

                    public RenderType m_5708_() {
                        return GHAST_SHOOTING_GLOW;
                    }
                });
            }
            if ((patt1$temp = r.getEntityRenderer(EntityType.f_20562_)) instanceof DrownedRenderer) {
                renderer = (DrownedRenderer)patt1$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<Drowned, DrownedModel<Drowned>>((RenderLayerParent)renderer){

                    public RenderType m_5708_() {
                        return DROWNED_GLOW;
                    }
                });
            }
        });
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterPresetEditorsEvent.class, e -> VANILLA_PRESET_EDITORS.forEach((o, presetEditor) -> o.ifPresent(worldPresetResourceKey -> e.register(worldPresetResourceKey, presetEditor))));
        FactoryAPIClient.PlayerEvent.DISCONNECTED_EVENT.register(p -> PackAlbum.applyDefaultResourceAlbum());
        FactoryAPIClient.registerConfigScreen((ModInfo)FactoryAPIPlatform.getModInfo((String)"legacy"), Legacy4JSettingsScreen::new);
        FactoryAPIClient.registerDefaultConfigScreen((String)"minecraft", s -> new OptionsScreen(s, Minecraft.m_91087_().f_91066_));
    }

    public static void updateChunks() {
        FactoryAPIClient.SECURE_EXECUTOR.execute(() -> Minecraft.m_91087_().f_91060_.m_109818_());
    }

    public static void updateSkyShape() {
        FactoryAPIClient.SECURE_EXECUTOR.execute(() -> ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).updateSkyBuffers());
    }

    public static void buildLegacySkyDisc(VertexConsumer consumer, float f) {
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -256; l <= 384; l += 64) {
                float g = k;
                float f1 = k + 64;
                consumer.m_5483_((double)g, (double)f, (double)l).m_5752_();
                consumer.m_5483_((double)f1, (double)f, (double)l).m_5752_();
                consumer.m_5483_((double)f1, (double)f, (double)(l + 64)).m_5752_();
                consumer.m_5483_((double)g, (double)f, (double)(l + 64)).m_5752_();
            }
        }
    }

    public static BakedModel getFastLeavesModelReplacement(BlockGetter blockGetter, BlockPos pos, BlockState blockState, BakedModel model) {
        boolean fastGraphics;
        boolean bl = fastGraphics = Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FAST;
        if (((Boolean)LegacyOptions.fastLeavesCustomModels.get()).booleanValue() && blockState.m_60734_() instanceof LeavesBlock && fastLeavesModels.containsKey(blockState.m_60734_()) && (fastGraphics || ((Boolean)LegacyOptions.fastLeavesWhenBlocked.get()).booleanValue())) {
            if (!fastGraphics && blockGetter != null) {
                for (Direction value : Direction.values()) {
                    BlockPos relative = pos.m_121945_(value);
                    BlockState relativeBlockState = blockGetter.m_8055_(relative);
                    if (relativeBlockState.m_60734_() instanceof LeavesBlock || relativeBlockState.m_60804_(blockGetter, relative)) continue;
                    return model;
                }
            }
            return FactoryAPIClient.getExtraModel((ResourceLocation)fastLeavesModels.get(blockState.m_60734_()));
        }
        return model;
    }

    public static int getEffectiveRenderDistance() {
        return Minecraft.m_91087_().f_91066_.m_193772_();
    }

    public static void onClientPlayerInfoChange() {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof HostOptionsScreen) {
            HostOptionsScreen s = (HostOptionsScreen)screen;
            s.reloadPlayerButtons();
        } else {
            screen = minecraft.f_91080_;
            if (screen instanceof LeaderboardsScreen) {
                LeaderboardsScreen s = (LeaderboardsScreen)screen;
                s.rebuildRenderableVList(minecraft);
                s.m_267719_();
            }
        }
    }

    public static boolean canSkipIntro(float timer) {
        return timer % (float)LegacyResourceManager.INTROS.size() >= (float)LegacyResourceManager.INTROS.size() - 0.01f || (Boolean)LegacyOptions.skipIntro.get() != false || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)257) || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) == 1 || ControllerBinding.DOWN_BUTTON.state().pressed;
    }

    public static void resetOptions(Minecraft minecraft) {
        whenResetOptions.forEach(Runnable::run);
        for (KeyMapping keyMapping : minecraft.f_91066_.f_92059_) {
            keyMapping.m_90848_(keyMapping.m_90861_());
            LegacyKeyMapping.of(keyMapping).setBinding(LegacyKeyMapping.of(keyMapping).getDefaultBinding());
            KeyMapping.m_90854_();
        }
        LegacyOptions.CLIENT_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        LegacyOptions.CLIENT_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        minecraft.f_91066_.m_92169_();
    }

    public static String manageAvailableSaveDirName(Consumer<File> copy, Predicate<String> exists, LevelStorageSource source, String levelId) {
        String destId = Legacy4JClient.manageAvailableName(exists, levelId);
        copy.accept(source.m_78257_().resolve(destId).toFile());
        return destId;
    }

    public static String manageAvailableName(Predicate<String> exists, String saveDirName) {
        StringBuilder builder = new StringBuilder(saveDirName);
        int repeat = 0;
        while (exists.test(String.valueOf(builder) + (repeat > 0 ? String.format(" (%s)", repeat) : ""))) {
            ++repeat;
        }
        if (repeat > 0) {
            builder.append(String.format(" (%s)", repeat));
        }
        return builder.toString();
    }

    public static String importSaveFile(InputStream saveInputStream, Predicate<String> exists, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> Legacy4J.copySaveToDirectory(saveInputStream, f), exists, source, saveDirName);
    }

    public static String importSaveFile(InputStream saveInputStream, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.importSaveFile(saveInputStream, arg_0 -> ((LevelStorageSource)source).m_78255_(arg_0), source, saveDirName);
    }

    public static String copySaveFile(Path savePath, LevelStorageSource source, String saveDirName) {
        return Legacy4JClient.manageAvailableSaveDirName(f -> {
            try {
                FileUtils.copyDirectory((File)savePath.toFile(), (File)f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, arg_0 -> ((LevelStorageSource)source).m_78255_(arg_0), source, saveDirName);
    }

    public static void copySaveBtwSources(LevelStorageSource.LevelStorageAccess sendSource, LevelStorageSource destSource) {
        try {
            File destLevelDirectory = destSource.m_78257_().resolve(sendSource.m_78277_()).toFile();
            if (destLevelDirectory.exists()) {
                FileUtils.deleteQuietly((File)destLevelDirectory);
            }
            FileUtils.copyDirectory((File)sendSource.m_197394_(Level.f_46428_).toFile(), (File)destLevelDirectory, p -> !p.getName().equals("session.lock"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Pair<Integer, Component> tryParsePort(String string) {
        if (string.isBlank()) {
            return Pair.of((Object)HttpUtil.m_13939_(), null);
        }
        try {
            int port = Integer.parseInt(string);
            if (port < 1024 || port > 65535) {
                return Pair.of((Object)port, (Object)Component.m_237110_((String)"lanServer.port.invalid.new", (Object[])new Object[]{1024, 65535}));
            }
            if (!HttpUtil.m_257796_((int)port)) {
                return Pair.of((Object)port, (Object)Component.m_237110_((String)"lanServer.port.unavailable.new", (Object[])new Object[]{1024, 65535}));
            }
            return Pair.of((Object)port, null);
        }
        catch (NumberFormatException numberFormatException) {
            return Pair.of((Object)HttpUtil.m_13939_(), (Object)Component.m_237110_((String)"lanServer.port.invalid.new", (Object[])new Object[]{1024, 65535}));
        }
    }

    static {
        legacyFont = true;
        forceVanillaFontShadowColor = false;
        defaultFontOverride = null;
        manualSave = false;
        saveExit = false;
        retakeWorldIcon = false;
        legacyLoadingScreen = new LegacyLoadingScreen();
        itemActivationRenderReplacement = null;
        legacyTipManager = new LegacyTipManager();
        legacyCreativeListingManager = new LegacyCreativeTabListing.Manager();
        legacyCraftingListingManager = new LegacyCraftingTabListing.Manager();
        legacyBiomeOverrides = new LegacyBiomeOverride.Manager();
        legacyWorldTemplateManager = new LegacyWorldTemplate.Manager();
        legacyTipOverridesManager = new LegacyTipOverride.Manager();
        legacyResourceManager = new LegacyResourceManager();
        stoneCuttingGroupManager = new StoneCuttingGroupManager();
        loomListingManager = new LoomTabListing.Manager();
        controlTooltipGuiManager = new ControlTooltip.GuiManager();
        leaderBoardListingManager = new LeaderboardsScreen.Manager();
        howToPlaySectionManager = new HowToPlayScreen.Manager();
        controllerManager = new ControllerManager();
        fastLeavesModels = new HashMap<Block, ResourceLocation>();
        MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinOptions.CLIENT_MIXIN_STORAGE, (boolean)false);
        GHAST_SHOOTING_GLOW = RenderType.m_110488_((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/ghast/ghast_shooting_glow.png"));
        DROWNED_GLOW = RenderType.m_110488_((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/zombie/drowned_glow.png"));
        VANILLA_PRESET_EDITORS = new HashMap<Optional<ResourceKey>, PresetEditor>(Map.of(Optional.of(WorldPresets.f_226438_), (createWorldScreen, settings) -> {
            ChunkGenerator chunkGenerator = settings.f_243796_().m_246737_();
            RegistryAccess.Frozen registryAccess = settings.m_246480_();
            HolderLookup.RegistryLookup biomeGetter = registryAccess.m_255025_(Registries.f_256952_);
            HolderLookup.RegistryLookup structureGetter = registryAccess.m_255025_(Registries.f_256998_);
            HolderLookup.RegistryLookup placeFeatureGetter = registryAccess.m_255025_(Registries.f_256988_);
            return new LegacyFlatWorldScreen((Screen)createWorldScreen, createWorldScreen.m_267748_(), (HolderLookup.RegistryLookup<Biome>)biomeGetter, (HolderLookup.RegistryLookup<StructureSet>)structureGetter, flatLevelGeneratorSettings -> createWorldScreen.m_267748_().m_267717_(PresetEditor.m_232967_((FlatLevelGeneratorSettings)flatLevelGeneratorSettings)), chunkGenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkGenerator).m_64191_() : FlatLevelGeneratorSettings.m_254980_((HolderGetter)biomeGetter, (HolderGetter)structureGetter, (HolderGetter)placeFeatureGetter));
        }, Optional.of(WorldPresets.f_226441_), (createWorldScreen, settings) -> new LegacyBuffetWorldScreen(createWorldScreen, (HolderLookup.RegistryLookup<Biome>)settings.m_246480_().m_255025_(Registries.f_256952_), holder -> createWorldScreen.m_267748_().m_267717_(PresetEditor.m_232952_((Holder)holder)))));
        keyCrafting = new KeyMapping("legacy.key.crafting", 69, "key.categories.inventory");
        keyCycleHeldLeft = new KeyMapping("legacy.key.cycleHeldLeft", 267, "key.categories.inventory");
        keyCycleHeldRight = new KeyMapping("legacy.key.cycleHeldRight", 266, "key.categories.inventory");
        keyToggleCursor = new KeyMapping("legacy.key.toggleCursor", -1, "key.categories.misc");
        keyHostOptions = new KeyMapping("legacy.key.host_options", 72, "key.categories.misc");
        keyLegacy4JSettings = new KeyMapping("legacy.key.legacy4JSettings", 89, "key.categories.misc");
        keyFlyUp = new KeyMapping("legacy.key.flyUp", 265, "key.categories.movement");
        keyFlyDown = new KeyMapping("legacy.key.flyDown", 264, "key.categories.movement");
        keyFlyLeft = new KeyMapping("legacy.key.flyLeft", 263, "key.categories.movement");
        keyFlyRight = new KeyMapping("legacy.key.flyRight", 262, "key.categories.movement");
    }
}

