/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.util.ScreenUtil;

public class LegacyTip
extends SimpleLayoutRenderable
implements Toast,
Controller.Event {
    protected final AdvancedTextWidget tipLabel = new AdvancedTextWidget(FactoryScreenUtil.getGuiAccessor());
    public Toast.Visibility visibility = Toast.Visibility.SHOW;
    public Component title = null;
    protected boolean centered = false;
    protected Minecraft minecraft = Minecraft.m_91087_();
    protected Screen initScreen;
    public long disappearTime;
    public long createdTime;
    public Supplier<Boolean> canRemove;
    public LegacyIconHolder holder;

    public LegacyTip(Component tip, int width, int height) {
        super(width, height);
        this.initScreen = this.minecraft.f_91080_;
        this.disappearTime = -1L;
        this.createdTime = Util.m_137550_();
        this.canRemove = () -> false;
        this.holder = null;
        this.tip(tip);
    }

    public LegacyTip(Component title, Component tip) {
        this(tip, 250, 0);
        this.title(title);
        this.height = (title == null ? 26 : 38) + this.tipLabel.m_93694_();
        this.m_253211_(25);
        this.canRemove(() -> this.initScreen != this.minecraft.f_91080_);
    }

    public LegacyTip(Component tip) {
        this(null, tip);
    }

    public LegacyTip canRemove(Supplier<Boolean> canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    public LegacyTip title(Component title) {
        this.title = CommonComponents.f_237098_.equals((Object)title) ? null : title;
        return this;
    }

    public LegacyTip centered() {
        this.centered = true;
        return this;
    }

    public LegacyTip tip(Component tip) {
        this.tipLabel.withLines(tip, this.width - 26);
        return this.disappearTime((long)tip.getString().toCharArray().length * 80L);
    }

    public LegacyTip disappearTime(long disappearTime) {
        if (disappearTime >= 0L) {
            this.createdTime = Util.m_137550_();
            this.disappearTime = disappearTime;
        }
        return this;
    }

    public LegacyTip itemStack(ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            this.height += 32;
            if (this.holder == null) {
                this.holder = new LegacyIconHolder(32, 32);
                this.holder.allowItemDecorations = false;
            }
            this.holder.m_252865_((this.width - 32) / 2);
            this.holder.m_253211_(13 + this.tipLabel.m_93694_() + (this.title == null ? 0 : 12));
            this.holder.itemIcon = itemStack;
        }
        return this;
    }

    public int m_7828_() {
        return this.m_5711_();
    }

    public int m_94899_() {
        return this.m_93694_();
    }

    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent toastComponent, long l) {
        this.renderTip(guiGraphics, 0, 0, 0.0f, l);
        return this.visibility;
    }

    public int m_243110_() {
        return Math.min(5, super.m_243110_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderTip(guiGraphics, i, j, f, Util.m_137550_() - this.createdTime);
    }

    public void renderTip(GuiGraphics guiGraphics, int i, int j, float f, float l) {
        if (this.canRemove.get().booleanValue() || l >= (float)this.disappearTime) {
            this.visibility = Toast.Visibility.HIDE;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 800.0f);
        ScreenUtil.renderPointerPanel(guiGraphics, 0, 0, this.m_5711_(), this.m_93694_());
        if (this.title != null) {
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.title, 13, 13, ((Integer)CommonColor.TIP_TITLE_TEXT.get()).intValue());
        }
        this.tipLabel.centered(this.centered).withShadow(this.centered).withPos(13, this.title == null ? 13 : 25).m_88315_(guiGraphics, i, j, f);
        if (this.holder != null) {
            this.holder.m_88315_(guiGraphics, i, j, f);
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

