/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyCreativeTabListing;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.TabList;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;

public class CreativeModeScreen
extends EffectRenderingInventoryScreen<CreativeModeMenu>
implements Controller.Event,
ControlTooltip.Event {
    protected Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList tabList = new TabList((List<LegacyTabButton>)new PagedList(this.page, 8));
    protected final Panel panel;
    public static final Container creativeModeGrid = new SimpleContainer(50);
    private CreativeInventoryListener listener;
    protected boolean hasClickedOutside;
    public final List<Stocker.Sizeable> tabsScrolledList = new ArrayList<Stocker.Sizeable>();
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final List<List<ItemStack>> displayListing = new ArrayList<List<ItemStack>>();
    protected final Stocker.Sizeable arrangement = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected final EditBox searchBox;
    boolean canRemoveSearch;

    public CreativeModeScreen(Player player) {
        super((AbstractContainerMenu)new CreativeModeMenu(player), player.m_150109_(), (Component)Component.m_237119_());
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, LegacyComponents.SEARCH_ITEMS);
        this.canRemoveSearch = false;
        this.searchBox.m_94151_(s -> {
            this.fillCreativeGrid();
            this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab).set(Integer.valueOf(0));
        });
        this.searchBox.m_94199_(50);
        LegacyCreativeTabListing.rebuildVanillaCreativeTabsItems(Minecraft.m_91087_());
        for (LegacyCreativeTabListing tab : LegacyCreativeTabListing.map.values()) {
            this.displayListing.add(tab.displayItems().stream().map(Supplier::get).filter(i -> !i.m_41619_() && i.m_246617_(Minecraft.m_91087_().m_91403_().m_247016_())).toList());
            this.tabList.addTabButton(39, 0, tab.icon(), tab.name(), b -> this.pressCommonTab());
        }
        BuiltInRegistries.f_279662_.m_123024_().filter(CreativeModeScreen::canDisplayVanillaCreativeTab).forEach(c -> {
            List<ItemStack> displayItems;
            if (c.m_257962_() == CreativeModeTab.Type.HOTBAR) {
                displayItems = new ArrayList();
                for (int i = 0; i < 9; ++i) {
                    Hotbar hotbar = Minecraft.m_91087_().m_91303_().m_90806_(i);
                    if (hotbar.isEmpty()) {
                        for (int j = 0; j < 10; ++j) {
                            if (j == i) {
                                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42516_);
                                Component component = Minecraft.m_91087_().f_91066_.f_92056_[i].m_90863_();
                                Component component2 = Minecraft.m_91087_().f_91066_.f_92057_.m_90863_();
                                itemStack.m_41698_("CustomCreativeLock");
                                itemStack.m_41714_((Component)Component.m_237110_((String)"inventory.hotbarInfo", (Object[])new Object[]{component2, component}));
                                displayItems.add(itemStack);
                                continue;
                            }
                            displayItems.add(ItemStack.f_41583_);
                        }
                        continue;
                    }
                    displayItems.addAll((Collection<ItemStack>)hotbar);
                    displayItems.add(ItemStack.f_41583_);
                }
            } else {
                displayItems = List.copyOf(c.m_260957_());
            }
            this.displayListing.add(displayItems);
            this.tabList.addTabButton(39, 0, LegacyTabButton.iconOf(c.m_40787_()), c.m_40786_(), b -> this.pressCommonTab());
        });
        if (((Boolean)LegacyOptions.searchCreativeTab.get()).booleanValue()) {
            this.displayListing.add(List.copyOf(CreativeModeTabs.m_258007_().m_260957_()));
            this.tabList.addTabButton(39, 0, LegacyTabButton.iconOf(LegacySprites.SEARCH), LegacyComponents.SEARCH_ITEMS, b -> {
                this.canRemoveSearch = (Integer)this.arrangement.get() != 2 && !this.canRemoveSearch;
                this.arrangement.set(Integer.valueOf(2));
                this.m_267719_();
            });
        }
        player.f_36096_ = this.f_97732_;
        this.panel = Panel.createPanel((Screen)this, p -> p.appearance(LegacySprites.CREATIVE_PANEL, 321, 212), p -> p.pos(p.centeredLeftPos((Screen)this), Math.max(33, (this.f_96544_ - 179) / 2)));
        this.displayListing.forEach(t -> this.tabsScrolledList.add(new Stocker.Sizeable(Integer.valueOf(0))));
    }

    public void pressCommonTab() {
        if (this.canRemoveSearch) {
            this.canRemoveSearch = false;
            this.arrangement.set(Integer.valueOf(0));
            this.m_267719_();
        } else {
            this.fillCreativeGrid();
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.replace(2, i -> ControlType.getActiveType().isKbm() && this.canClearQuickSelect() ? ControlTooltip.getKeyIcon(88) : i, a -> this.canClearQuickSelect() ? LegacyComponents.CLEAR_QUICK_SELECT : a).replace(3, i -> i, a -> this.f_97734_ != null && this.f_97734_.m_6657_() && this.f_97734_.f_40218_ != creativeModeGrid ? LegacyComponents.CLEAR : a).add(() -> this.page.max > 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.ComponentIcon.compoundOf(ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public boolean canClearQuickSelect() {
        return this.f_97734_ == null || this.f_97734_.f_40218_ == this.f_96541_.f_91074_.m_150109_() && !this.f_97734_.m_6657_();
    }

    public static AbstractContainerScreen<?> getActualCreativeScreenInstance(Minecraft minecraft) {
        return (Boolean)LegacyOptions.legacyCreativeTab.get() != false ? new CreativeModeScreen((Player)minecraft.f_91074_) : new CreativeModeInventoryScreen((Player)minecraft.f_91074_, minecraft.f_91074_.f_108617_.m_247016_(), ((Boolean)minecraft.f_91066_.m_257871_().m_231551_()).booleanValue());
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.listener);
        }
    }

    public static boolean canDisplayVanillaCreativeTab(CreativeModeTab c) {
        ResourceLocation location = BuiltInRegistries.f_279662_.m_7981_((Object)c);
        return !(!c.m_257497_() || c.m_257962_() != CreativeModeTab.Type.CATEGORY && c.m_257962_() != CreativeModeTab.Type.HOTBAR || location == null || (Boolean)LegacyOptions.vanillaTabs.get() == false && location.m_135827_().equals("minecraft") && !location.equals((Object)CreativeModeTabs.f_256837_.m_135782_()));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!Legacy4JClient.playerHasInfiniteMaterials()) {
            this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
            return;
        }
        this.m_142416_(this.tabList);
        this.m_169394_((Renderable)this.panel);
        this.panel.init();
        this.f_97726_ = this.panel.width;
        this.f_97727_ = this.panel.height;
        this.f_97735_ = this.panel.x;
        this.f_97736_ = this.panel.y;
        if ((Integer)this.arrangement.get() == 2) {
            this.searchBox.m_264152_(this.panel.m_252754_() + (this.panel.m_5711_() - this.searchBox.m_5711_()) / 2 - 6, this.panel.m_252907_() + 7);
            this.m_142416_((GuiEventListener)this.searchBox);
        }
        this.f_96541_.f_91074_.f_36095_.m_38943_((ContainerListener)this.listener);
        this.listener = new CreativeInventoryListener(this.f_96541_);
        this.f_96541_.f_91074_.f_36095_.m_38893_((ContainerListener)this.listener);
        this.tabList.init(this.panel.x, this.panel.y - 33, this.panel.width, (t, i) -> {
            int index = this.tabList.tabButtons.indexOf(t);
            t.type = index == 0 ? 0 : (index >= 7 ? 2 : 1);
            t.offset = b -> {
                if (!t.selected) {
                    return new Vec3(0.0, 1.5, 0.0);
                }
                return Vec3.f_82478_;
            };
            t.m_93674_(41);
            t.m_252865_(t.m_252754_() - this.tabList.tabButtons.indexOf(t));
        });
        this.fillCreativeGrid();
    }

    public void fillCreativeGrid() {
        if (this.displayListing.isEmpty()) {
            return;
        }
        List<ItemStack> list = this.displayListing.get((Integer)this.page.get() * 8 + this.tabList.selectedTab);
        if ((Integer)this.arrangement.get() != 0 && ((Integer)this.arrangement.get() == 1 || !this.searchBox.m_94155_().isEmpty() && this.f_96541_.m_91403_() != null)) {
            list = (Integer)this.arrangement.get() == 1 ? list.stream().sorted(Comparator.comparing(i -> i.m_41611_().getString())).toList() : CreativeModeScreen.getItemsSearchResult(this.f_96541_, this.searchBox.m_94155_());
        }
        for (int i2 = 0; i2 < creativeModeGrid.m_6643_(); ++i2) {
            int index = (Integer)this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab).get() * 50 + i2;
            creativeModeGrid.m_6836_(i2, list.size() > index ? list.get(index) : ItemStack.f_41583_);
        }
        this.tabsScrolledList.get((int)(((Integer)this.page.get()).intValue() * 8 + this.tabList.selectedTab)).max = Math.max(0, (list.size() - 1) / creativeModeGrid.m_6643_());
    }

    public static List<ItemStack> getItemsSearchResult(Minecraft minecraft, String value) {
        return value.startsWith("#") ? minecraft.m_231372_(SearchRegistry.f_119942_).m_6293_(value.substring(1).toLowerCase(Locale.ROOT)) : minecraft.m_231372_(SearchRegistry.f_119941_).m_6293_(value.toLowerCase(Locale.ROOT));
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_ + 296.5f, (float)this.f_97736_ + 27.5f, 0.0f);
        Stocker.Sizeable scroll = this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab);
        if (scroll.max > 0) {
            if ((Integer)scroll.get() != scroll.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, 139);
            }
            if ((Integer)scroll.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f);
        }
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 13, 135);
        guiGraphics.m_280168_().m_252880_(-2.0f, -1.0f + (scroll.max > 0 ? (float)((Integer)scroll.get()).intValue() * 121.5f / (float)scroll.max : 0.0f), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
        FactoryScreenUtil.disableBlend();
        guiGraphics.m_280168_().m_85849_();
        this.m_280072_(guiGraphics, i, j);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        if ((Integer)this.arrangement.get() == 2) {
            return;
        }
        Component tabTitle = this.tabList.tabButtons.get(this.tabList.selectedTab).m_6035_();
        guiGraphics.m_280614_(this.f_96547_, tabTitle, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)tabTitle)) / 2, 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
    }

    public boolean m_6050_(double d, double e, double g) {
        if (super.m_6050_(d, e, g)) {
            return true;
        }
        int i = (int)(-Math.signum(g));
        Stocker.Sizeable scroll = this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab);
        if (scroll.max > 0 || (Integer)scroll.get() > 0) {
            int lastScrolled = (Integer)scroll.get();
            scroll.set(Integer.valueOf(Math.max(0, Math.min((Integer)scroll.get() + i, scroll.max))));
            if (lastScrolled != (Integer)scroll.get()) {
                this.scrollRenderer.updateScroll(i > 0 ? ScreenDirection.DOWN : ScreenDirection.UP);
                this.fillCreativeGrid();
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.searchBox.m_93696_() && !this.searchBox.m_5953_(d, e)) {
            this.m_7522_(null);
        }
        if (this.canClearQuickSelect() && i == 1) {
            return false;
        }
        this.updateCreativeGridScroll(d, e, i);
        return super.m_6375_(d, e, i);
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        this.updateCreativeGridScroll(d, e, i);
        return super.m_7979_(d, e, i, f, g);
    }

    public void updateCreativeGridScroll(double d, double e, int i) {
        float x = (float)this.f_97735_ + 297.5f;
        float y = (float)this.f_97736_ + 28.5f;
        if (i == 0 && d >= (double)x && d < (double)(x + 11.0f) && e >= (double)y && e < (double)(y + 133.0f)) {
            Stocker.Sizeable scrolledList = this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab);
            int lastScroll = (Integer)scrolledList.get();
            scrolledList.set(Integer.valueOf((int)Math.round((double)scrolledList.max * (e - (double)y) / 133.0)));
            if (lastScroll != (Integer)scrolledList.get()) {
                this.scrollRenderer.updateScroll((Integer)scrolledList.get() - lastScroll > 0 ? ScreenDirection.DOWN : ScreenDirection.UP);
                this.fillCreativeGrid();
            }
        }
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.tabList.controlTab(i)) {
            return true;
        }
        if (i != 256 && this.searchBox.m_93696_()) {
            return this.searchBox.m_7933_(i, j, k);
        }
        if (CreativeModeScreen.m_96638_() && this.tabList.controlPage(this.page, i == 263, i == 262)) {
            this.m_267719_();
        }
        if (i == 88 && this.canClearQuickSelect()) {
            for (int n = 36; n < 45; ++n) {
                this.f_96541_.f_91072_.m_105241_(ItemStack.f_41583_, n);
            }
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    protected void m_6597_(@Nullable Slot slot, int i, int j, ClickType clickType) {
        boolean bl = clickType == ClickType.QUICK_MOVE;
        ClickType clickType2 = clickType = i == -999 && clickType == ClickType.PICKUP ? ClickType.THROW : clickType;
        if (slot != null || clickType == ClickType.QUICK_CRAFT) {
            if (slot != null && !slot.m_8010_((Player)this.f_96541_.f_91074_)) {
                return;
            }
            if (clickType != ClickType.QUICK_CRAFT && slot.f_40218_ == creativeModeGrid) {
                ItemStack itemStack = ((CreativeModeMenu)this.f_97732_).m_142621_();
                ItemStack itemStack2 = slot.m_7993_();
                if (clickType == ClickType.SWAP) {
                    if (!itemStack2.m_41619_()) {
                        this.f_96541_.f_91074_.m_150109_().m_6836_(j, itemStack2.m_255036_(itemStack2.m_41741_()));
                        this.f_96541_.f_91074_.f_36095_.m_38946_();
                    }
                    return;
                }
                if (clickType == ClickType.CLONE) {
                    if (((CreativeModeMenu)this.f_97732_).m_142621_().m_41619_() && slot.m_6657_()) {
                        ItemStack itemStack3 = slot.m_7993_();
                        ((CreativeModeMenu)this.f_97732_).m_142503_(itemStack3.m_255036_(itemStack3.m_41741_()));
                    }
                    return;
                }
                if (clickType == ClickType.THROW) {
                    if (!itemStack2.m_41619_()) {
                        ItemStack itemStack3 = itemStack2.m_255036_(j == 0 ? 1 : itemStack2.m_41741_());
                        this.f_96541_.f_91074_.m_36176_(itemStack3, true);
                        this.f_96541_.f_91072_.m_105239_(itemStack3);
                    }
                    return;
                }
                if (!itemStack.m_41619_() && !itemStack2.m_41619_() && FactoryItemUtil.equalItems((ItemStack)itemStack, (ItemStack)itemStack2)) {
                    if (j == 0) {
                        if (bl) {
                            itemStack.m_41764_(itemStack.m_41741_());
                        } else if (itemStack.m_41613_() < itemStack.m_41741_()) {
                            itemStack.m_41769_(1);
                        }
                    } else {
                        itemStack.m_41774_(1);
                    }
                } else if (itemStack2.m_41619_() || !itemStack.m_41619_()) {
                    if (j == 0) {
                        ((CreativeModeMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
                    } else if (!((CreativeModeMenu)this.f_97732_).m_142621_().m_41619_()) {
                        ((CreativeModeMenu)this.f_97732_).m_142621_().m_41774_(1);
                    }
                } else {
                    ItemStack stack = itemStack2.m_255036_(bl ? itemStack2.m_41741_() : itemStack2.m_41613_());
                    if (!((CreativeModeMenu)this.f_97732_).m_38903_(stack, 50, 59, false) && !stack.m_41619_()) {
                        ((CreativeModeMenu)this.f_97732_).m_142503_(stack);
                        ((LegacyMenuAccess)((Object)this)).movePointerToSlot((Slot)((CreativeModeMenu)this.f_97732_).f_38839_.get(58));
                    }
                    ((CreativeModeMenu)this.f_97732_).inventoryMenu.m_38946_();
                }
            } else {
                ItemStack itemStack = slot == null ? ItemStack.f_41583_ : ((CreativeModeMenu)this.f_97732_).m_38853_(slot.f_40219_).m_7993_();
                ((CreativeModeMenu)this.f_97732_).m_150399_(slot == null ? i : slot.f_40219_, j, clickType, (Player)this.f_96541_.f_91074_);
                if (AbstractContainerMenu.m_38947_((int)j) == 2) {
                    for (int m = 0; m < 9; ++m) {
                        this.f_96541_.f_91072_.m_105241_(((CreativeModeMenu)this.f_97732_).m_38853_(50 + m).m_7993_(), 36 + m);
                    }
                } else if (slot != null) {
                    ItemStack itemStack2 = ((CreativeModeMenu)this.f_97732_).m_38853_(slot.f_40219_).m_7993_();
                    this.f_96541_.f_91072_.m_105241_(itemStack2, slot.f_40219_ - ((CreativeModeMenu)this.f_97732_).f_38839_.size() + 9 + 36);
                    int l = 50 + j;
                    if (clickType == ClickType.SWAP) {
                        this.f_96541_.f_91072_.m_105241_(itemStack, l - ((CreativeModeMenu)this.f_97732_).f_38839_.size() + 9 + 36);
                    } else if (clickType == ClickType.THROW && !itemStack.m_41619_()) {
                        ItemStack itemStack4 = itemStack.m_255036_(j == 0 ? 1 : itemStack.m_41741_());
                        this.f_96541_.f_91074_.m_36176_(itemStack4, true);
                        this.f_96541_.f_91072_.m_105239_(itemStack4);
                    }
                    this.f_96541_.f_91074_.f_36095_.m_38946_();
                }
            }
        } else if (!((CreativeModeMenu)this.f_97732_).m_142621_().m_41619_() && this.hasClickedOutside) {
            if (j == 0) {
                this.f_96541_.f_91074_.m_36176_(((CreativeModeMenu)this.f_97732_).m_142621_(), true);
                this.f_96541_.f_91072_.m_105239_(((CreativeModeMenu)this.f_97732_).m_142621_());
                ((CreativeModeMenu)this.f_97732_).m_142503_(ItemStack.f_41583_);
            }
            if (j == 1) {
                ItemStack itemStack = ((CreativeModeMenu)this.f_97732_).m_142621_().m_41620_(1);
                this.f_96541_.f_91074_.m_36176_(itemStack, true);
                this.f_96541_.f_91072_.m_105239_(itemStack);
            }
        }
    }

    protected boolean m_7467_(double d, double e, int i, int j, int k) {
        this.hasClickedOutside = super.m_7467_(d, e, i, j, k) && !this.tabList.m_5953_(d, e);
        return this.hasClickedOutside;
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            if (s.pressed && s.canClick() && this.tabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y))) {
                this.m_267719_();
            }
        }
    }

    public static class CreativeModeMenu
    extends AbstractContainerMenu {
        private final AbstractContainerMenu inventoryMenu;

        public CreativeModeMenu(Player player) {
            super(null, 0);
            this.inventoryMenu = player.f_36095_;
            for (int h = 0; h < 5; ++h) {
                for (int x = 0; x < 10; ++x) {
                    this.m_38897_(LegacySlotDisplay.override(new Slot(creativeModeGrid, h * 10 + x, 21 + x * 27, 29 + h * 27){

                        public boolean m_8010_(Player player) {
                            return super.m_8010_(player) && !this.m_7993_().m_41619_() ? this.m_7993_().m_246617_(player.m_9236_().m_246046_()) && this.m_7993_().m_41737_("CustomCreativeLock") == null : this.m_7993_().m_41619_();
                        }
                    }, new LegacySlotDisplay(){

                        @Override
                        public int getWidth() {
                            return 27;
                        }
                    }));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(LegacySlotDisplay.override(new Slot((Container)player.m_150109_(), x, 35 + x * 27, 176), new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 27;
                    }
                }));
            }
        }

        public ItemStack m_7648_(Player player, int i) {
            Slot slot;
            if (i >= this.f_38839_.size() - 9 && i < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(i)) != null && slot.m_6657_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(Player player) {
            return true;
        }

        public boolean m_5882_(ItemStack itemStack, Slot slot) {
            return slot.f_40218_ != creativeModeGrid;
        }

        public boolean m_5622_(Slot slot) {
            return slot.f_40218_ != creativeModeGrid;
        }

        public ItemStack m_142621_() {
            return this.inventoryMenu.m_142621_();
        }

        public void m_142503_(ItemStack itemStack) {
            this.inventoryMenu.m_142503_(itemStack);
        }
    }
}

