/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public abstract class CustomRecipeIconHolder
extends LegacyIconHolder
implements ControlTooltip.ActionHolder {
    private final Minecraft minecraft;
    ItemStack nextItem = ItemStack.f_41583_;
    ItemStack previousItem = ItemStack.f_41583_;
    List<ItemStack> addedIngredientsItems = null;
    Predicate<CustomRecipeIconHolder> canAddIngredient = h -> true;
    final ItemStack defaultItem;

    public abstract Component getDisplayName();

    abstract ItemStack nextItem();

    abstract ItemStack previousItem();

    abstract int findInventoryMatchSlot();

    abstract void updateRecipe();

    abstract LegacyScrollRenderer getScrollRenderer();

    public ItemStack nextItem(Inventory inventory, Predicate<ItemStack> isValid) {
        int i;
        NonNullList items = inventory.f_35974_;
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i < items.size(); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        for (i = 0; i < Math.max(0, items.indexOf(this.itemIcon)); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack previousItem(Inventory inventory, Predicate<ItemStack> isValid) {
        int i;
        NonNullList items = inventory.f_35974_;
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i >= 0; --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        for (i = items.size() - 1; i >= Math.max(0, items.indexOf(this.itemIcon)); --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack nextItem(List<ItemStack> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) + 1), (int)itemStacks.size()));
    }

    public ItemStack previousItem(List<ItemStack> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) - 1), (int)itemStacks.size()));
    }

    public CustomRecipeIconHolder(ItemStack defaultItem) {
        super(27, 27);
        this.minecraft = Minecraft.m_91087_();
        this.allowItemDecorations = false;
        this.defaultItem = this.itemIcon = defaultItem;
    }

    public CustomRecipeIconHolder() {
        this(ItemStack.f_41583_);
    }

    public void init() {
        this.itemIcon = this.defaultItem;
    }

    public void applyAddedIngredients() {
        if (this.addedIngredientsItems == null || this.addedIngredientsItems.isEmpty()) {
            return;
        }
        int index = 0;
        for (int i1 = 0; i1 < this.getIngredientsGrid().size() && index < this.addedIngredientsItems.size(); ++i1) {
            Optional<Ingredient> ing = this.getIngredientsGrid().get(i1);
            if (ing.isPresent()) continue;
            this.getIngredientsGrid().set(i1, Optional.of(StackIngredient.of((boolean)false, (ItemStack)this.addedIngredientsItems.get(index))));
            ++index;
        }
    }

    public boolean applyNextItemIfAbsent() {
        return false;
    }

    public CustomRecipeIconHolder enableAddIngredients() {
        this.addedIngredientsItems = new ArrayList<ItemStack>();
        return this;
    }

    public CustomRecipeIconHolder enableAddIngredients(Predicate<CustomRecipeIconHolder> canAddIngredient) {
        this.canAddIngredient = canAddIngredient;
        return this.enableAddIngredients();
    }

    @Override
    public void m_93692_(boolean bl) {
        if (bl) {
            this.updateRecipe();
        }
        super.m_93692_(bl);
    }

    public abstract boolean canCraft();

    public abstract List<Optional<Ingredient>> getIngredientsGrid();

    public ItemStack assembleCraftingResult(Level level, CraftingContainer container) {
        container.m_6211_();
        for (int i = 0; i < this.getIngredientsGrid().size(); ++i) {
            if (!this.getIngredientsGrid().get(i).isPresent()) continue;
            container.m_6836_(i, FactoryIngredient.of((Ingredient)this.getIngredientsGrid().get(i).get()).getStacks()[0]);
        }
        return CommonRecipeManager.getResultFor((RecipeType)RecipeType.f_44107_, (Container)container, (Level)level).orElse(ItemStack.f_41583_);
    }

    @Override
    public void onPress() {
        if (this.m_93696_()) {
            if (this.canCraft()) {
                this.craft();
                this.updateRecipe();
            } else {
                ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
            }
        }
    }

    public void craft() {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(this.getRecipeId(), List.copyOf(this.getIngredientsGrid()), -1, Screen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
    }

    public Optional<ResourceLocation> getRecipeId() {
        return Optional.empty();
    }

    public boolean m_6050_(double d, double e, double g) {
        int i = (int)Math.signum(g);
        if (this.m_93696_() && !this.nextItem.m_41619_() && i > 0 || !this.previousItem.m_41619_() && i < 0) {
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = i > 0 ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return false;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        if (this.itemIcon.m_41619_() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon) || this.m_93696_()) {
            this.nextItem = this.nextItem();
            this.previousItem = this.previousItem();
        }
        if ((this.itemIcon.m_41619_() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon)) && !this.nextItem.m_41619_()) {
            this.itemIcon = this.nextItem;
            if (this.m_93696_()) {
                this.updateRecipe();
            }
        }
        super.m_88315_(graphics, i, j, f);
    }

    protected boolean hasItem() {
        return this.hasItem(this.itemIcon);
    }

    protected boolean hasItem(ItemStack stack) {
        return !stack.m_41619_() && this.minecraft.f_91074_.m_150109_().f_35974_.stream().filter(s -> FactoryItemUtil.equalItems((ItemStack)s, (ItemStack)stack)).mapToInt(ItemStack::m_41613_).sum() >= stack.m_41613_();
    }

    @Override
    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        ScreenUtil.secureTranslucentRender(graphics, !this.itemIcon.m_41619_() && !this.hasItem(this.itemIcon), 0.5f, u -> this.renderItem(graphics, this.itemIcon, this.m_252754_(), this.m_252907_(), false));
    }

    public boolean canAddIngredient() {
        return this.hasItem(this.itemIcon) && this.addedIngredientsItems != null && this.canAddIngredient.test(this) && this.getIngredientsGrid().stream().anyMatch(Optional::isEmpty);
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (i == 79 && this.canAddIngredient()) {
            this.addedIngredientsItems.add(this.itemIcon.m_255036_(1));
            this.updateRecipe();
            return true;
        }
        if (i == 88 && this.addedIngredientsItems != null && !this.addedIngredientsItems.isEmpty()) {
            this.addedIngredientsItems.remove(this.addedIngredientsItems.size() - 1);
            this.updateRecipe();
            return true;
        }
        if (!this.nextItem.m_41619_() && i == 265 || !this.previousItem.m_41619_() && i == 264) {
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = i == 265 ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
        Screen screen;
        super.renderSelection(graphics, i, j, f);
        if (!this.itemIcon.m_41619_() && this.hasItem(this.itemIcon) && (screen = this.minecraft.f_91080_) instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)screen;
            int matchSlot = this.findInventoryMatchSlot();
            if (matchSlot > 0) {
                Slot s = a.m_6262_().m_38853_(matchSlot);
                ScreenUtil.iconHolderRenderer.slotBounds(a.getMenuRectangle().m_274563_(), a.getMenuRectangle().m_274449_(), s).renderHighlight(graphics);
            }
        }
        graphics.m_280168_().m_85836_();
        this.applyOffset(graphics);
        if (!this.previousItem.m_41619_() && this.previousItem != this.itemIcon || !this.nextItem.m_41619_() && this.nextItem != this.itemIcon) {
            this.getScrollRenderer().renderScroll(graphics, ScreenDirection.UP, this.m_252754_() + 5, this.m_252907_() - 14);
            this.getScrollRenderer().renderScroll(graphics, ScreenDirection.DOWN, this.m_252754_() + 5, this.m_252907_() + 31);
        }
        graphics.m_280168_().m_85849_();
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.m_93696_() && this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.m_93696_() && this.canAddIngredient() ? LegacyComponents.ADD : null));
    }
}

