/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.material.Fluids;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ItemViewerScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.util.LegacySprites;

public class FlatWorldLayerSelector
extends ItemViewerScreen {
    private final Consumer<FlatWorldLayerSelector> applyLayer;
    protected final int maxLayerHeight;
    protected Block selectedLayer = Blocks.f_50016_;
    protected final LegacySliderButton<Integer> layerSlider;
    protected ItemStack displayLayer = ItemStack.f_41583_;

    public FlatWorldLayerSelector(Screen parent, Consumer<FlatWorldLayerSelector> applyLayer, int maxLayerHeight, Component component) {
        super(parent, s -> Panel.centered(s, 325, 245), component);
        this.applyLayer = applyLayer;
        this.maxLayerHeight = maxLayerHeight;
        this.layerSlider = LegacySliderButton.createFromIntRange(this.panel.x + 21, this.panel.y + 167, 271, 16, b -> Component.m_237115_((String)"legacy.menu.create_flat_world.layer_height"), b -> null, (Integer)1, 1, maxLayerHeight, b -> {});
    }

    @Override
    protected void addLayerItems() {
        BuiltInRegistries.f_257020_.m_123024_().filter(f -> f.m_6859_() != null && (f == Fluids.f_76191_ || f.m_7444_(f.m_76145_()))).forEach(f -> {
            Item i = f.m_76145_().m_76188_().m_60734_().m_5456_();
            if (i instanceof BlockItem) {
                this.layerItems.add(i.m_7968_());
            } else {
                this.layerItems.add(f.m_6859_().m_7968_());
            }
        });
        BuiltInRegistries.f_256975_.forEach(b -> {
            if (b instanceof LiquidBlock) {
                return;
            }
            Item i = Item.f_41373_.getOrDefault(b, null);
            if (i != null) {
                this.layerItems.add(i.m_7968_());
            }
        });
    }

    public FlatWorldLayerSelector(Screen parent, FlatLayerInfo editLayer, Consumer<FlatWorldLayerSelector> applyLayer, int maxLayerHeight, Component component) {
        this(parent, applyLayer, maxLayerHeight, component);
        this.selectedLayer = editLayer.m_70344_().m_60734_();
        this.displayLayer = editLayer.m_70344_().m_60734_().m_5456_().m_7968_();
        this.layerSlider.setObjectValue(editLayer.m_70337_());
    }

    public FlatLayerInfo getFlatLayerInfo() {
        return new FlatLayerInfo(this.layerSlider.getObjectValue().intValue(), this.selectedLayer);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.layerSlider.m_264152_(this.panel.x + 21, this.panel.y + 167);
        this.m_142416_((GuiEventListener)this.layerSlider);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), b -> {
            this.applyLayer.accept(this);
            this.m_7379_();
        }).m_252987_(this.panel.x + 57, this.panel.y + 216, 200, 20).m_253136_());
    }

    @Override
    protected void slotClicked(Slot slot) {
        Block block;
        this.displayLayer = slot.m_7993_();
        Item item = slot.m_7993_().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            block = item2.m_40614_();
        } else {
            item = slot.m_7993_().m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                block = ItemContainerPlatform.getBucketFluid((BucketItem)bucket).m_76145_().m_76188_().m_60734_();
            } else {
                block = Blocks.f_50016_;
            }
        }
        this.selectedLayer = block;
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 20, this.panel.y + 187, 275, 27);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.panel.x + (this.panel.width - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2, this.panel.y + 8, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        MutableComponent layerCount = Component.m_237110_((String)"legacy.menu.create_flat_world.layer_count", (Object[])new Object[]{this.layerSlider.getObjectValue()});
        guiGraphics.m_280614_(this.f_96547_, (Component)layerCount, this.panel.x + 49 - this.f_96547_.m_92852_((FormattedText)layerCount), this.panel.y + 197, 0xFFFFFF, true);
        guiGraphics.m_280614_(this.f_96547_, (Component)this.selectedLayer.m_49954_(), this.panel.x + 70, this.panel.y + 197, 0xFFFFFF, true);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(this.panel.x + 50), (float)(this.panel.y + 190), 0.0f);
        guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
        guiGraphics.m_280480_(this.displayLayer, 0, 0);
        guiGraphics.m_280168_().m_85849_();
    }
}

