/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.compat.WorldHostFriendsScreen;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class HostOptionsScreen
extends PanelVListScreen {
    public static final Component HOST_OPTIONS = Component.m_237115_((String)"legacy.menu.host_options");
    public static final Component PLAYERS_INVITE = Component.m_237115_((String)"legacy.menu.players_invite");
    protected final Component title;
    protected float oldAlpha = HostOptionsScreen.getDefaultOpacity();
    protected float alpha = HostOptionsScreen.getDefaultOpacity();
    protected boolean shouldFade = false;
    public static final List<GameRules.Key<GameRules.BooleanValue>> WORLD_RULES = new ArrayList<GameRules.Key<GameRules.BooleanValue>>(List.of(GameRules.f_46131_, LegacyGameRules.getTntExplodes(), GameRules.f_46140_, GameRules.f_46133_, GameRules.f_46134_, GameRules.f_46132_, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, LegacyGameRules.LEGACY_SWIMMING));
    public static final List<GameRules.Key<GameRules.BooleanValue>> OTHER_RULES = new ArrayList<GameRules.Key>(List.of(GameRules.f_46150_, GameRules.f_46135_, GameRules.f_46136_, GameRules.f_46139_, GameRules.f_46156_));

    public HostOptionsScreen(Component title) {
        super((Screen s) -> Panel.centered(s, LegacySprites.PANEL, 250, 190, 0, 20), HOST_OPTIONS);
        this.title = title;
        this.addPlayerButtons();
        this.renderableVList.layoutSpacing(l -> 0);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> this.f_96541_.m_91091_() ? (!this.f_96541_.m_91092_().m_6992_() ? PublishScreen.PUBLISH : (PublishScreen.hasWorldHost() ? WorldHostFriendsScreen.FRIENDS : null)) : null);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> this.f_96541_.m_168022_().m_142594_(this.f_96541_.m_91090_()) ? LegacyKeyMapping.of(Minecraft.m_91087_().f_91066_.f_92098_).getDisplayName() : null);
    }

    public HostOptionsScreen() {
        this(PLAYERS_INVITE);
    }

    public void reloadPlayerButtons() {
        int i = this.renderableVList.renderables.indexOf(this.m_7222_());
        this.renderableVList.renderables.clear();
        this.addPlayerButtons();
        this.m_232761_();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.m_7522_((GuiEventListener)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(LegacyKeyMapping.of(Legacy4JClient.keyHostOptions).getBinding()) && state.onceClick(true)) {
            this.m_7379_();
        }
    }

    @Override
    public boolean m_7933_(final int i, int j, int k) {
        if (Legacy4JClient.keyHostOptions.m_90832_(i, j)) {
            this.m_7379_();
            return true;
        }
        if (i == 79) {
            this.f_96541_.m_91152_((Screen)new ChatScreen(""){
                boolean released;
                {
                    super(string);
                    this.released = false;
                }

                public boolean m_5534_(char c, int i2) {
                    if (!this.released) {
                        return false;
                    }
                    return super.m_5534_(c, i2);
                }

                public boolean m_7920_(int i2, int j, int k) {
                    if (i2 == i) {
                        this.released = true;
                    }
                    return super.m_7920_(i2, j, k);
                }
            });
            return true;
        }
        if (i == 88 && this.f_96541_.m_91091_()) {
            if (!this.f_96541_.m_91092_().m_6992_()) {
                this.f_96541_.m_91152_((Screen)new PublishScreen(this, this.f_96541_.m_91092_().m_130008_(), s -> s.publish(this.f_96541_.m_91092_())){
                    boolean released;
                    {
                        super(parent, gameType, okAction);
                        this.released = false;
                    }

                    public boolean m_5534_(char c, int i2) {
                        if (!this.released) {
                            return false;
                        }
                        return super.m_5534_(c, i2);
                    }

                    public boolean m_7920_(int i2, int j, int k) {
                        if (i2 == i) {
                            this.released = true;
                        }
                        return super.m_7920_(i2, j, k);
                    }
                });
            } else if (PublishScreen.hasWorldHost()) {
                this.f_96541_.m_91152_((Screen)new WorldHostFriendsScreen(this));
            }
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public static void drawPlayerIcon(GameProfile profile, GuiGraphics guiGraphics, int x, int y) {
        LegacyPlayerInfo info = (LegacyPlayerInfo)Minecraft.m_91087_().m_91403_().m_104949_(profile.getId());
        float[] color = Legacy4JClient.getVisualPlayerColor(info);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(color[0], color[1], color[2], 1.0f);
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(PlayerIdentifier.of(info.getIdentifierIndex()).optionsMapSprite(), x, y, 20, 20);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
    }

    protected void addPlayerButtons() {
        this.addPlayerButtons(true, (profile, b) -> {
            if (!this.f_96541_.f_91074_.m_20310_(2)) {
                return;
            }
            PlayerInfo playerInfo = this.f_96541_.m_91403_().m_104949_(profile.getId());
            final HashMap COMMAND_MAP = new HashMap();
            boolean initialVisibility = !((LegacyPlayerInfo)playerInfo).isVisible();
            PanelVListScreen screen = new PanelVListScreen(this, s -> Panel.centered(s, LegacySprites.PANEL, 280, playerInfo.m_105325_().m_46409_() ? 120 : 88), HOST_OPTIONS, (GameProfile)profile){
                final /* synthetic */ GameProfile val$profile;
                {
                    this.val$profile = gameProfile;
                    super(parent, panelConstructor, component);
                }

                @Override
                public void renderableVListInit() {
                    this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 27, this.panel.width - 16, this.panel.height - 16);
                }

                @Override
                protected void panelInit() {
                    this.panel.init();
                }

                @Override
                public void m_7379_() {
                    COMMAND_MAP.values().forEach(Runnable::run);
                    super.m_7379_();
                }

                public boolean m_7043_() {
                    return false;
                }

                @Override
                public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                    this.panel.m_88315_(guiGraphics, i, j, f);
                    HostOptionsScreen.drawPlayerIcon(this.val$profile, guiGraphics, this.panel.x + 7, this.panel.y + 5);
                    guiGraphics.m_280056_(this.f_96547_, this.val$profile.getName(), this.panel.x + 31, this.panel.y + 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                }
            };
            List<GameType> gameTypes = Arrays.stream(GameType.values()).toList();
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, initialVisibility, b1 -> Component.m_237115_((String)"legacy.menu.host_options.player.invisible"), b1 -> null, b1 -> {
                if (initialVisibility != b1.selected) {
                    COMMAND_MAP.put(b1, () -> {
                        if (b1.selected) {
                            this.f_96541_.f_91074_.f_108617_.m_246623_("effect give %s minecraft:invisibility infinite 255 true".formatted(profile.getName()));
                            this.f_96541_.f_91074_.f_108617_.m_246623_("effect give %s minecraft:resistance infinite 255 true".formatted(profile.getName()));
                        } else {
                            this.f_96541_.f_91074_.f_108617_.m_246623_("effect clear %s minecraft:invisibility".formatted(profile.getName()));
                            this.f_96541_.f_91074_.f_108617_.m_246623_("effect clear %s minecraft:resistance".formatted(profile.getName()));
                        }
                    });
                }
            }));
            if (playerInfo.m_105325_().m_46409_()) {
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).mayFlySurvival(), b1 -> Component.m_237115_((String)"legacy.menu.host_options.player.mayFly"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.mayFlySurvival(b1.selected, profile))));
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).isExhaustionDisabled(), b1 -> Component.m_237115_((String)"legacy.menu.host_options.player.disableExhaustion"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.disableExhaustion(b1.selected, profile))));
            }
            screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<GameType>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b1.getObjectValue()).m_151499_()), b1 -> Tooltip.m_257550_((Component)Component.m_237115_((String)("selectWorld.gameMode." + playerInfo.m_105325_().m_46405_() + ".info"))), playerInfo.m_105325_(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.m_91403_().m_246623_("gamemode %s %s".formatted(((GameType)b1.getObjectValue()).m_46405_(), profile.getName())))));
            screen.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.host_options.set_player_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.f_91074_.f_108617_.m_246623_("spawnpoint %s ~ ~ ~".formatted(profile.getName())))).m_252987_(0, 0, 215, 20).m_253136_());
            this.f_96541_.m_91152_((Screen)screen);
        });
    }

    protected void addPlayerButtons(boolean includeLocal, final BiConsumer<GameProfile, AbstractButton> onPress) {
        for (GameProfile profile : HostOptionsScreen.getActualGameProfiles()) {
            if (!includeLocal && Objects.equals(profile.getName(), Minecraft.m_91087_().f_91074_.m_36316_().getName())) continue;
            this.renderableVList.addRenderable((Renderable)new PlayerButton(0, 0, 230, 30, profile){

                public void m_5691_() {
                    onPress.accept(this.profile, this);
                }
            });
        }
    }

    public static List<GameProfile> getActualGameProfiles() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91091_()) {
            return minecraft.m_91092_().m_6846_().m_11314_().stream().map(Player::m_36316_).toList();
        }
        if (minecraft.f_91074_ != null && !minecraft.f_91074_.f_108617_.m_105142_().isEmpty()) {
            return minecraft.f_91074_.f_108617_.m_105142_().stream().sorted(Comparator.comparingInt(p -> minecraft.m_91091_() && minecraft.m_91092_().m_7779_(p.m_105312_()) ? 0 : ((LegacyPlayerInfo)p).getIdentifierIndex())).map(PlayerInfo::m_105312_).toList();
        }
        return Collections.emptyList();
    }

    @Override
    protected void m_7856_() {
        CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.askAll((Player)this.f_96541_.f_91074_));
        super.m_7856_();
        this.addHostOptionsButton();
    }

    @Override
    protected void panelInit() {
        this.panel.init();
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 22, this.panel.width - 20, this.panel.height - 26);
    }

    protected void addHostOptionsButton() {
        if (!this.f_96541_.f_91074_.m_20310_(2) && !this.f_96541_.m_91091_()) {
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)HOST_OPTIONS, this::pressHostOptionsButton).m_252987_(this.panel.x, this.panel.y - 36, 250, 20).m_253136_());
    }

    protected void pressHostOptionsButton(Button b) {
        final HashMap nonOpGamerules = new HashMap();
        final HashMap COMMAND_MAP = new HashMap();
        PanelVListScreen screen = new PanelVListScreen(this, s -> Panel.centered(s, LegacySprites.PANEL, 265, this.f_96541_.f_91074_.m_20310_(2) ? 200 : 130), HOST_OPTIONS){

            @Override
            public void renderableVListInit() {
                this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 8, this.panel.width - 16, this.panel.height - 16);
            }

            @Override
            protected void panelInit() {
                this.panel.init();
            }

            @Override
            public void m_7379_() {
                super.m_7379_();
                COMMAND_MAP.values().forEach(Runnable::run);
                if (!nonOpGamerules.isEmpty()) {
                    CommonNetwork.sendToServer((CommonNetwork.Payload)new PlayerInfoSync.All(nonOpGamerules, PlayerInfoSync.All.ID_C2S));
                }
            }

            public boolean m_7043_() {
                return false;
            }

            @Override
            public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                this.panel.m_88315_(guiGraphics, i, j, f);
            }
        };
        if (!this.f_96541_.f_91074_.m_20310_(2)) {
            for (GameRules.Key<GameRules.BooleanValue> key : PlayerInfoSync.All.NON_OP_GAMERULES) {
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.m_46170_(key)).m_46223_(), b1 -> Component.m_237115_((String)key.m_46331_()), b1 -> null, b1 -> nonOpGamerules.put(key.m_46328_(), b1.selected)));
            }
            LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            this.f_96541_.m_91152_((Screen)screen);
            return;
        }
        List<String> weathers = List.of("clear", "rain", "thunder");
        int initialWeather = this.f_96541_.f_91073_.m_46470_() ? 2 : (this.f_96541_.f_91073_.m_46471_() ? 1 : 0);
        screen.renderableVList.layoutSpacing(l -> 2);
        for (GameRules.Key<GameRules.BooleanValue> key : WORLD_RULES) {
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.m_46170_(key)).m_46223_(), b1 -> Component.m_237115_((String)key.m_46331_()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.f_91074_.f_108617_.m_246623_("gamerule %s %s".formatted(key.m_46328_(), b1.selected)))));
        }
        screen.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.host_options.set_day"), b1 -> this.f_96541_.f_91074_.f_108617_.m_246623_("time set day")).m_252987_(0, 0, 215, 20).m_253136_());
        screen.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.host_options.set_night"), b1 -> this.f_96541_.f_91074_.f_108617_.m_246623_("time set 14000")).m_252987_(0, 0, 215, 20).m_253136_());
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<Difficulty>(0, 0, 230, 16, b1 -> b1.getDefaultMessage((Component)Component.m_237115_((String)"options.difficulty"), ((Difficulty)b1.getObjectValue()).m_19033_()), b1 -> Tooltip.m_257550_((Component)this.f_96541_.f_91073_.m_46791_().m_267622_()), this.f_96541_.f_91073_.m_46791_(), () -> Arrays.asList(Difficulty.values()), b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.m_91403_().m_246623_("difficulty " + ((Difficulty)b1.getObjectValue()).m_19036_()))));
        Supplier<GameType> gameType = () -> Legacy4JClient.defaultServerGameType == null ? this.f_96541_.f_91072_.m_105295_() : Legacy4JClient.defaultServerGameType;
        List<GameType> gameTypes = Arrays.stream(GameType.values()).toList();
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<GameType>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b1.getObjectValue()).m_151499_()), b1 -> Tooltip.m_257550_((Component)Component.m_237115_((String)("selectWorld.gameMode." + ((GameType)gameType.get()).m_46405_() + ".info"))), gameType.get(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.m_91403_().m_246623_("defaultgamemode " + ((GameType)b1.getObjectValue()).m_46405_()))));
        screen.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.host_options.set_world_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.f_91074_.f_108617_.m_246623_("setworldspawn"))).m_252987_(0, 0, 215, 20).m_253136_());
        screen.renderableVList.addRenderables(new Renderable[]{SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> {}), SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"soundCategory.weather"), l.x + 1, l.y + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false))});
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<String>(0, 0, 230, 16, b1 -> Component.m_237115_((String)("legacy.weather_state." + (String)b1.getObjectValue())), b1 -> null, weathers.get(initialWeather), () -> weathers, b1 -> {
            if (!Objects.equals(b1.getObjectValue(), weathers.get(initialWeather))) {
                COMMAND_MAP.put(b1, () -> this.f_96541_.m_91403_().m_246623_("weather " + (String)b1.getObjectValue()));
            }
        }));
        for (GameRules.Key<GameRules.BooleanValue> key : OTHER_RULES) {
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.m_46170_(key)).m_46223_(), b1 -> Component.m_237115_((String)key.m_46331_()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.f_96541_.f_91074_.f_108617_.m_246623_("gamerule %s %s".formatted(key.m_46328_(), b1.selected)))));
        }
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        this.f_96541_.m_91152_((Screen)screen);
        if (this.f_96541_.m_91091_() && !this.f_96541_.m_91092_().m_6992_()) {
            return;
        }
        BiFunction<Boolean, Component, AbstractButton> teleportButton = (bol, title) -> Button.m_253074_((Component)title, b1 -> this.f_96541_.m_91152_((Screen)new HostOptionsScreen((Component)title, (Boolean)bol){
            final /* synthetic */ Boolean val$bol;
            {
                this.val$bol = bl;
                super(title);
            }

            @Override
            protected void addHostOptionsButton() {
            }

            @Override
            protected void addPlayerButtons() {
                this.addPlayerButtons(false, (profile, b1) -> {
                    if (this.val$bol.booleanValue()) {
                        this.f_96541_.f_91074_.f_108617_.m_246623_("tp %s".formatted(profile.getName()));
                    } else {
                        this.f_96541_.f_91074_.f_108617_.m_246623_("tp %s ~ ~ ~".formatted(profile.getName()));
                    }
                });
            }

            @Override
            public boolean m_7043_() {
                return false;
            }
        })).m_252987_(0, 0, 215, 20).m_253136_();
        screen.renderableVList.addRenderable((Renderable)teleportButton.apply(true, (Component)Component.m_237115_((String)"legacy.menu.host_options.teleport_player")));
        screen.renderableVList.addRenderable((Renderable)teleportButton.apply(false, (Component)Component.m_237115_((String)"legacy.menu.host_options.teleport_me")));
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.oldAlpha = this.alpha;
        this.alpha = Mth.m_14179_((float)(f * 0.1f), (float)this.oldAlpha, (float)(this.shouldFade ? 1.0f : HostOptionsScreen.getDefaultOpacity()));
        this.shouldFade = false;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        this.panel.m_88315_(guiGraphics, i, j, f);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, this.title, this.panel.x + 11, this.panel.y + 8, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    protected static float getDefaultOpacity() {
        return 0.5f;
    }

    protected abstract class PlayerButton
    extends AbstractButton {
        public final GameProfile profile;

        public PlayerButton(int x, int y, int width, int height, GameProfile profile) {
            super(x, y, width, height, (Component)Component.m_237113_((String)profile.getName()));
            this.profile = profile;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.m_198029_()) {
                HostOptionsScreen.this.shouldFade = true;
            }
            super.m_87963_(guiGraphics, i, j, f);
            HostOptionsScreen.drawPlayerIcon(this.profile, guiGraphics, this.m_252754_() + 6, this.m_252907_() + 5);
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 68, this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), j, true);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

