/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.TabList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class Legacy4JSettingsScreen
extends OptionsScreen
implements TabList.Access {
    protected final TabList tabList = new TabList();
    protected final List<List<Renderable>> renderablesByTab = new ArrayList<List<Renderable>>();
    protected final EditBox editBox;

    public Legacy4JSettingsScreen(Screen screen) {
        super(screen, s -> Panel.centered(s, 250, 250, 50, 0), CommonComponents.f_237098_);
        this.editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Component.m_237115_((String)"legacy.menu.filter.search"));
        this.tabList.add(0, 0, 100, 25, 4, null, LegacyComponents.ALL, null, b -> this.resetElements());
        this.renderablesByTab.add(new ArrayList());
        OptionsScreen.Section.list.forEach(this::addOptionSection);
        this.addActualRenderables();
    }

    protected void addOptionSection(OptionsScreen.Section section) {
        this.tabList.add(0, 0, 100, 25, 4, null, section.title(), null, b -> this.resetElements());
        section.elements().forEach(c -> c.accept(this));
        section.advancedSection().ifPresent(s1 -> {
            this.getRenderableVList().addRenderable((Renderable)SimpleLayoutRenderable.createDrawString((Component)s1.title(), (int)0, (int)1, (int)200, (int)9, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), (boolean)false));
            if (s1 == OptionsScreen.Section.ADVANCED_USER_INTERFACE) {
                this.getRenderableVList().addOptions(LegacyOptions.advancedOptionsMode);
            }
            s1.elements().forEach(c -> c.accept(this));
        });
        List<Renderable> renderables = List.copyOf(this.getRenderableVList().renderables);
        this.getRenderableVList().renderables.clear();
        this.renderablesByTab.get(0).addAll(renderables);
        this.renderablesByTab.add(renderables);
    }

    protected void resetElements() {
        this.getRenderableVList().renderables.clear();
        this.addActualRenderables();
        this.getRenderableVList().scrolledList.set((Object)0);
        this.m_267719_();
    }

    protected void addActualRenderables() {
        String value = this.editBox.m_94155_().toLowerCase(Locale.ROOT);
        if (value.isBlank()) {
            this.getRenderableVList().renderables.addAll((Collection<Renderable>)this.renderablesByTab.get(this.getTabList().selectedTab));
        } else {
            for (Renderable renderable : this.renderablesByTab.get(this.getTabList().selectedTab)) {
                AbstractWidget w;
                if (!(renderable instanceof AbstractWidget) || !(w = (AbstractWidget)renderable).m_6035_().getString().toLowerCase(Locale.ROOT).contains(value)) continue;
                this.getRenderableVList().renderables.add((Renderable)w);
            }
        }
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void m_7856_() {
        this.m_142416_(this.tabList);
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.editBox);
        this.editBox.m_264152_(this.panel.m_252754_() + (this.panel.width - this.editBox.m_5711_()) / 2, this.panel.m_252907_() + 10);
        this.editBox.m_94151_(s -> this.resetElements());
        this.tabList.init((b, i) -> {
            b.m_252865_(this.panel.x - b.m_5711_() + 6);
            b.m_253211_(this.panel.y + i + 4);
            b.offset = t1 -> new Vec3(t1.selected ? 0.0 : 3.5, 0.5, 0.0);
        }, true);
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 40, this.panel.width - 20, this.panel.height - 50);
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (this.tabList.controlTab(i)) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }
}

