/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.PagedList;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TabList;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyAdvancementsScreen
extends PanelVListScreen
implements TabList.Access {
    public static final Component TITLE = Component.m_237115_((String)"gui.advancements");
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList tabList = new TabList((List<LegacyTabButton>)new PagedList(this.page, 10));
    protected final List<DisplayInfo> displayInfos = new ArrayList<DisplayInfo>();
    protected boolean showDescription = false;
    protected boolean oldLegacyTooltipsValue;
    public static final List<ResourceLocation> vanillaOrder = List.of(FactoryAPI.createVanillaLocation((String)"story/root"), FactoryAPI.createVanillaLocation((String)"adventure/root"), FactoryAPI.createVanillaLocation((String)"husbandry/root"), FactoryAPI.createVanillaLocation((String)"nether/root"), FactoryAPI.createVanillaLocation((String)"end/root"));

    public LegacyAdvancementsScreen(Screen parent) {
        super(parent, s -> Panel.createPanel(s, p -> p.centeredLeftPos((Screen)s), p -> p.centeredTopPos((Screen)s) + (((LegacyAdvancementsScreen)s).displayInfos.isEmpty() ? 0 : 18), 450, 252), TITLE);
        this.renderableVLists.clear();
        StreamSupport.stream(LegacyAdvancementsScreen.getActualAdvancements().m_139343_().spliterator(), false).sorted(Comparator.comparingInt(n -> vanillaOrder.contains(n.m_138327_()) ? vanillaOrder.indexOf(n.m_138327_()) : Integer.MAX_VALUE)).forEach(a -> {
            DisplayInfo displayInfo = a.m_138320_();
            if (displayInfo == null) {
                return;
            }
            this.tabList.addTabButton(43, 0, LegacyTabButton.iconOf(displayInfo.m_14990_()), displayInfo.m_14977_(), b -> this.m_267719_());
            RenderableVList renderableVList = new RenderableVList(this).layoutSpacing(l -> 4).forceWidth(false).cyclic(false);
            this.renderableVLists.add(renderableVList);
            this.displayInfos.add(displayInfo);
            LegacyAdvancementsScreen.getActualAdvancements().m_139344_().stream().filter(n1 -> !n1.equals(a) && n1.m_264348_().equals(a)).sorted(Comparator.comparingInt(LegacyAdvancementsScreen::getRootDistance)).forEach(node -> this.addAdvancementButton(renderableVList, (Advancement)node));
        });
    }

    public static int getRootDistance(Advancement advancement) {
        Advancement advancement3;
        Advancement advancement2 = advancement;
        int i = 0;
        while ((advancement3 = advancement2.m_138319_()) != null) {
            advancement2 = advancement3;
            ++i;
        }
        return i;
    }

    protected void addAdvancementButton(RenderableVList renderableVList, Advancement advancement) {
        if (advancement.m_138320_() != null) {
            renderableVList.addRenderable((Renderable)new AdvancementButton(0, 0, 38, 38, advancement, advancement.m_138320_()));
        }
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.tabList.selectedTab);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            if (s.pressed && s.canClick()) {
                this.tabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
            }
        }
    }

    @Override
    protected void panelInit() {
        this.m_142416_(this.tabList);
        super.panelInit();
        this.m_169394_((guiGraphics, i, j, f) -> {
            ResourceLocation background;
            guiGraphics.m_280614_(this.f_96547_, this.showDescription && !this.tabList.tabButtons.isEmpty() ? this.tabList.tabButtons.get(this.tabList.selectedTab).m_6035_() : this.m_96636_(), this.panel.x + (this.panel.width - this.f_96547_.m_92852_((FormattedText)(this.showDescription && !this.tabList.tabButtons.isEmpty() ? this.tabList.tabButtons.get(this.tabList.selectedTab).m_6035_() : this.m_96636_()))) / 2, this.panel.y + 10, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            if (!this.displayInfos.isEmpty() && (background = this.displayInfos.get(this.tabList.selectedTab).m_14991_()) != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(background, this.panel.x + 14, this.panel.y + 24, 0.0f, 0.0f, 422, 23, 16, 16);
            }
            ScreenUtil.renderPanelTranslucentRecess(guiGraphics, this.panel.x + 12, this.panel.y + 22, 426, 27);
            GuiEventListener patt0$temp = this.m_7222_();
            if (patt0$temp instanceof AdvancementButton) {
                AdvancementButton a = (AdvancementButton)patt0$temp;
                guiGraphics.m_280430_(this.f_96547_, a.info.m_14977_(), this.panel.x + (this.panel.width - this.f_96547_.m_92852_((FormattedText)a.info.m_14977_())) / 2, this.panel.y + 32, 0xFFFFFF);
            }
            FactoryScreenUtil.disableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 12, this.panel.y + 50, 426, 186);
        });
        this.tabList.init(this.panel.x, this.panel.y - 37, this.panel.width, (b, i) -> {
            int index = this.tabList.tabButtons.indexOf(b);
            b.type = index == 0 ? 0 : (index >= 9 ? 2 : 1);
            b.m_93674_(45);
            b.offset = t1 -> new Vec3(0.0, t1.selected ? 0.0 : 4.5, 0.0);
        });
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 17, this.panel.y + 55, 416, 176);
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (i == 88) {
            this.showDescription = !this.showDescription;
            return true;
        }
        if (this.tabList.controlTab(i)) {
            return true;
        }
        if (LegacyAdvancementsScreen.m_96638_()) {
            this.tabList.controlPage(this.page, i == 263, i == 262);
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.tooltips.remove(0);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> LegacyComponents.SHOW_DESCRIPTION).add(() -> this.page.max > 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)}) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public void m_86600_() {
        super.m_86600_();
        if (!this.getRenderableVLists().isEmpty()) {
            this.getRenderableVList().renderables.forEach(r -> {
                if (r instanceof AdvancementButton) {
                    AdvancementButton b = (AdvancementButton)((Object)r);
                    b.update();
                }
            });
        }
    }

    public void m_274333_() {
        super.m_274333_();
        this.oldLegacyTooltipsValue = (Boolean)LegacyOptions.legacyItemTooltips.get();
        LegacyOptions.legacyItemTooltipScaling.set((Object)false);
    }

    public void m_7861_() {
        super.m_7861_();
        LegacyOptions.legacyItemTooltipScaling.set((Object)this.oldLegacyTooltipsValue);
    }

    public void m_262861_(List<FormattedCharSequence> list, ClientTooltipPositioner clientTooltipPositioner, boolean bl) {
        if (!this.showDescription) {
            return;
        }
        super.m_262861_(list, clientTooltipPositioner, bl);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public static AdvancementList getActualAdvancements() {
        return FactoryAPIClient.hasModOnServer ? ClientAdvancementsPayload.advancements : LegacyAdvancementsScreen.getAdvancements().m_104396_();
    }

    public static ClientAdvancements getAdvancements() {
        return Minecraft.m_91087_().m_91403_().m_105145_();
    }

    public static class AdvancementButton
    extends AbstractWidget {
        public final ResourceLocation id;
        public final Advancement advancement;
        protected boolean lastUnlocked;
        protected boolean unlocked;
        public final DisplayInfo info;

        public AdvancementButton(int x, int y, int width, int height, Advancement advancement, DisplayInfo info) {
            super(x, y, width, height, info.m_14977_());
            this.info = info;
            this.id = advancement.m_138327_();
            this.advancement = advancement;
            this.update();
        }

        public void update() {
            AdvancementProgress p = null;
            this.lastUnlocked = this.unlocked;
            Advancement a = LegacyAdvancementsScreen.getAdvancements().m_104396_().m_139337_(this.id);
            boolean bl = this.unlocked = a != null && (p = (AdvancementProgress)LegacyAdvancementsScreen.getAdvancements().f_104390_.getOrDefault(a, null)) != null && p.m_8193_();
            if (this.lastUnlocked == this.unlocked && this.m_278622_() != null) {
                return;
            }
            MutableComponent progressText = p == null || p.m_8218_() == null ? null : Component.m_237113_((String)p.m_8218_());
            this.m_257544_((Tooltip)(progressText == null ? Tooltip.m_257550_((Component)this.info.m_14985_()) : new MultilineTooltip(List.of(this.info.m_14985_().m_7532_(), progressText.m_7532_()))));
        }

        public boolean isUnlocked() {
            return this.unlocked;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.m_93696_()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(-1.5f, -1.5f, 0.0f);
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_HIGHLIGHT, this.m_252754_(), this.m_252907_(), 41, 41);
                guiGraphics.m_280168_().m_85849_();
            }
            FactoryScreenUtil.enableBlend();
            if (!this.isUnlocked()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f);
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
            FactoryScreenUtil.disableDepthTest();
            if (!this.isUnlocked()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, this.m_252754_() + (this.m_5711_() - 32) / 2, this.m_252907_() + (this.m_93694_() - 32) / 2, 32, 32);
            }
            FactoryScreenUtil.enableDepthTest();
            FactoryScreenUtil.disableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (!this.isUnlocked()) {
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)(this.m_5711_() - 32) / 2.0f, (float)this.m_252907_() + (float)(this.m_93694_() - 32) / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
            guiGraphics.m_280203_(this.info.m_14990_(), 0, 0);
            guiGraphics.m_280168_().m_85849_();
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

