/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CustomRecipeIconHolder;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyLoomScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    private final Inventory inventory;
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    protected final List<Optional<Ingredient>> ingredientsGrid = new ArrayList(Collections.nCopies(9, Optional.empty()));
    protected final List<Optional<Ingredient>> selectedIngredients = new ArrayList<Optional<Ingredient>>();
    protected ItemStack resultStack = ItemStack.f_41583_;
    protected ItemStack selectedStack = ItemStack.f_41583_;
    protected ItemStack previewStack = ItemStack.f_41583_;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected final List<LoomTabListing> loomTabListings = List.copyOf(LoomTabListing.map.values());
    protected final List<RecipeIconHolder<BannerRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<BannerRecipe>>();
    protected final List<CustomRecipeIconHolder> selectBannerButton = Collections.singletonList(new CustomRecipeIconHolder(){

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.m_93696_() && this.hasItem() ? LegacyComponents.SELECT : null);
        }

        @Override
        public Component getDisplayName() {
            return LegacyComponents.SELECT_BANNER_TAB;
        }

        @Override
        public ItemStack nextItem() {
            return this.nextItem(LegacyLoomScreen.this.inventory, i -> i.m_41720_() instanceof BannerItem && Legacy4J.getItemPatternsCount(i) < 6);
        }

        @Override
        public ItemStack previousItem() {
            return this.previousItem(LegacyLoomScreen.this.inventory, i -> i.m_41720_() instanceof BannerItem && Legacy4J.getItemPatternsCount(i) < 6);
        }

        @Override
        public boolean applyNextItemIfAbsent() {
            return true;
        }

        @Override
        public boolean canCraft() {
            return true;
        }

        @Override
        public void craft() {
        }

        @Override
        public List<Optional<Ingredient>> getIngredientsGrid() {
            return LegacyLoomScreen.this.ingredientsGrid;
        }

        @Override
        int findInventoryMatchSlot() {
            for (int i = 0; i < ((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).f_97732_).f_38839_.size(); ++i) {
                if (((Slot)((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).f_97732_).f_38839_.get(i)).m_7993_() != this.itemIcon) continue;
                return i;
            }
            this.itemIcon = this.nextItem;
            return this.itemIcon.m_41619_() ? 0 : this.findInventoryMatchSlot();
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
            if (this.m_93696_()) {
                LegacyLoomScreen.this.selectedCraftingButton = LegacyLoomScreen.this.getCraftingButtons().indexOf(this);
            }
            super.m_88315_(graphics, i, j, f);
        }

        @Override
        public boolean m_7933_(int i, int j, int k) {
            if (i == 79 && !this.itemIcon.m_41619_() && this.hasItem()) {
                this.updateRecipe();
                LegacyLoomScreen.this.selectedStack = this.itemIcon.m_255036_(1);
                LegacyLoomScreen.this.craftingTabList.tabButtons.get(1).m_5691_();
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        @Override
        void updateRecipe() {
            LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
            LegacyLoomScreen.this.resultStack = this.itemIcon.m_255036_(1);
            LegacyLoomScreen.this.ingredientsGrid.set(4, LegacyLoomScreen.this.resultStack.m_41619_() ? Optional.empty() : Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.resultStack, (int)1)));
            LegacyLoomScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
        }

        @Override
        LegacyScrollRenderer getScrollRenderer() {
            return LegacyLoomScreen.this.scrollRenderer;
        }
    });
    protected List<RecipeInfo<BannerRecipe>> selectedPatterns = new ArrayList<RecipeInfo<BannerRecipe>>();
    protected List<List<RecipeInfo<BannerRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<BannerRecipe>>>();
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList((List<LegacyTabButton>)new PagedList(this.page, 7));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    private final boolean[] warningSlots = new boolean[9];
    protected final ContainerListener listener = new ContainerListener(){

        public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            LegacyIconHolder legacyIconHolder;
            LegacyLoomScreen.this.recipesByGroup.clear();
            LegacyLoomScreen.this.selectedIngredients.clear();
            if (LegacyLoomScreen.this.craftingTabList.selectedTab != 0 && !LegacyLoomScreen.this.selectedStack.m_41619_()) {
                LegacyLoomScreen.this.previewStack = LegacyLoomScreen.this.selectedStack.m_41777_();
                LegacyLoomScreen.this.selectedIngredients.add(Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.selectedStack, (int)1)));
                if (!LegacyLoomScreen.this.selectedPatterns.isEmpty()) {
                    CompoundTag beTag = LegacyLoomScreen.this.previewStack.m_41698_("BlockEntityTag");
                    ListTag patternsTag = beTag.m_128437_("Patterns", 10);
                    if (!beTag.m_128425_("Patterns", 9)) {
                        beTag.m_128365_("Patterns", (Tag)patternsTag);
                    }
                    LegacyLoomScreen.this.selectedPatterns.forEach(rcp -> {
                        CompoundTag patternTag = new CompoundTag();
                        patternsTag.add((Object)patternTag);
                        patternTag.m_128359_("Pattern", ((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(((BannerRecipe)rcp.get()).pattern())).m_58579_());
                        patternTag.m_128405_("Color", ((BannerRecipe)rcp.get()).color.m_41060_());
                        for (int i1 = 1; i1 < rcp.getOptionalIngredients().size(); ++i1) {
                            Optional<Ingredient> ing = rcp.getOptionalIngredients().get(i1);
                            if (ing.isEmpty()) continue;
                            LegacyLoomScreen.this.selectedIngredients.add(ing);
                        }
                    });
                }
                Optional<StackIngredient> previewIng = Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.previewStack, (int)1));
                LegacyLoomScreen.this.loomTabListings.get(LegacyLoomScreen.this.craftingTabList.selectedTab - 1).patterns().stream().filter(p -> Minecraft.m_91087_().m_91403_().m_105152_().m_255025_(Registries.f_256969_).m_255209_().anyMatch(arg_0 -> ((ResourceKey)p).equals(arg_0))).forEach(p -> LegacyLoomScreen.this.recipesByGroup.add(Arrays.stream(DyeColor.values()).map(color -> {
                    ItemStack result = LegacyLoomScreen.this.previewStack.m_41777_();
                    CompoundTag beTag = result.m_41698_("BlockEntityTag");
                    ListTag patternsTag = beTag.m_128437_("Patterns", 10);
                    if (!beTag.m_128425_("Patterns", 9)) {
                        beTag.m_128365_("Patterns", (Tag)patternsTag);
                    }
                    CompoundTag addPattern = new CompoundTag();
                    patternsTag.add((Object)addPattern);
                    addPattern.m_128359_("Pattern", ((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(p)).m_58579_());
                    addPattern.m_128405_("Color", color.m_41060_());
                    Optional<Ingredient> dye = Optional.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)color)}));
                    ArrayList<Optional<Ingredient>> previewIngs = new ArrayList<Optional<Ingredient>>(LegacyLoomScreen.this.selectedIngredients);
                    previewIngs.add(dye);
                    List<Optional<Ingredient>> ings = List.of(previewIng, dye);
                    ArrayList<Optional<Ingredient>> displayIngs = new ArrayList<Optional<Ingredient>>(ings);
                    Optional<Ingredient> extraIng = LegacyCraftingMenu.getBannerPatternExtraIngredient(Minecraft.m_91087_().m_91403_().m_105152_(), (ResourceKey<BannerPattern>)p);
                    if (extraIng.isPresent()) {
                        displayIngs.add(1, extraIng);
                        previewIngs.add(extraIng);
                    }
                    displayIngs.set(0, LegacyLoomScreen.this.selectedIngredients.get(0));
                    return RecipeInfo.create(p.m_135782_().m_246208_(color.m_41065_() + "_"), new BannerRecipe((List<Optional<Ingredient>>)previewIngs, LegacyCraftingMenu.updateShapedIngredients(new ArrayList<Optional<Ingredient>>(Collections.nCopies(9, Optional.empty())), displayIngs, 3, 2, 2), (ResourceKey<BannerPattern>)p, (DyeColor)color), ings, result);
                }).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                    Collections.reverse(l);
                    return l;
                }))));
                LegacyLoomScreen.this.craftingButtons.get(LegacyLoomScreen.this.selectedCraftingButton).updateRecipeDisplay();
            } else if (LegacyLoomScreen.this.getCraftingButtons().size() > LegacyLoomScreen.this.selectedCraftingButton && (legacyIconHolder = LegacyLoomScreen.this.getCraftingButtons().get(LegacyLoomScreen.this.selectedCraftingButton)) instanceof LegacyCraftingScreen.CustomCraftingIconHolder) {
                LegacyCraftingScreen.CustomCraftingIconHolder h = (LegacyCraftingScreen.CustomCraftingIconHolder)legacyIconHolder;
                h.updateRecipe();
            }
        }

        public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };
    protected int selectedCraftingButton;
    protected boolean inited;

    public LegacyLoomScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
        this.craftingTabList.addTabButton(43, 0, LegacyTabButton.iconOf(Items.f_42660_), (Component)Component.m_237119_(), t -> this.resetElements());
        for (LoomTabListing listing : this.loomTabListings) {
            this.craftingTabList.addTabButton(43, 0, listing.icon(), listing.name(), t -> this.resetElements());
        }
        this.craftingTabList.resetSelectedTab();
        this.inited = true;
        this.addCraftingButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> ControlTooltip.getKeyMessage(79, (Screen)this)).add(() -> ControlTooltip.EXTRA.get(), () -> {
            RecipeIconHolder r;
            GuiEventListener patt0$temp = this.m_7222_();
            return patt0$temp instanceof RecipeIconHolder && (r = (RecipeIconHolder)patt0$temp).getFocusedRecipe() != null && this.selectedPatterns.contains(r.getFocusedRecipe()) ? LegacyComponents.REMOVE : null;
        }).addCompound(() -> {
            ControlTooltip.Icon[] iconArray;
            if (this.getTabList().selectedTab == 0) {
                iconArray = new ControlTooltip.Icon[]{};
            } else {
                ControlTooltip.Icon[] iconArray2 = new ControlTooltip.Icon[3];
                iconArray2[0] = ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon();
                iconArray2[1] = ControlTooltip.SPACE_ICON;
                iconArray = iconArray2;
                iconArray2[2] = ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon();
            }
            return iconArray;
        }, () -> LegacyComponents.GROUP).add(() -> this.page.max > 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)}) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public void resetElements() {
        this.listener.m_7934_(this.f_97732_, -1, ItemStack.f_41583_);
        this.selectedCraftingButton = 0;
        this.craftingButtonsOffset.set(Integer.valueOf(0));
        if (this.inited) {
            this.m_267719_();
        }
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.m_7522_(guiEventListener);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        MutableComponent mutableComponent;
        if (this.craftingTabList.selectedTab != 0) {
            mutableComponent = this.craftingTabList.tabButtons.get(this.craftingTabList.selectedTab).m_6035_();
        } else {
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof CustomRecipeIconHolder) {
                CustomRecipeIconHolder h = (CustomRecipeIconHolder)guiEventListener;
                mutableComponent = h.getDisplayName();
            } else {
                mutableComponent = Component.m_237119_();
            }
        }
        MutableComponent title = mutableComponent;
        guiGraphics.m_280614_(this.f_96547_, (Component)title, ((this.craftingTabList.selectedTab != 0 ? this.f_97726_ : this.f_97726_ / 2) - this.f_96547_.m_92852_((FormattedText)title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        if (((LegacyCraftingMenu)this.f_97732_).inventoryActive) {
            guiGraphics.m_280614_(this.f_96547_, this.f_169604_, (515 - this.f_96547_.m_92852_((FormattedText)this.f_169604_)) / 2, 114, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, LegacyComponents.PREVIEW, (515 - this.f_96547_.m_92852_((FormattedText)LegacyComponents.PREVIEW)) / 2, 114, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        guiGraphics.m_280168_().m_252880_((float)(-this.f_97735_), (float)(-this.f_97736_), 0.0f);
        this.getCraftingButtons().forEach(b -> b.m_88315_(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.pressed && state.canClick() && state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            this.controlPage(s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
        }
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    protected void m_7856_() {
        this.resultStack = ItemStack.f_41583_;
        this.f_97726_ = 348;
        this.f_97727_ = 215;
        super.m_7856_();
        this.f_97736_ += 18;
        ((LegacyCraftingMenu)this.f_97732_).m_38893_(this.listener);
        this.craftingTabList.selectedTab = this.selectedStack.m_41619_() ? 0 : Math.max(this.craftingTabList.selectedTab, 1);
        ((LegacyCraftingMenu)this.f_97732_).inventoryActive = this.selectedStack.m_41619_();
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.m_7522_(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        if (this.craftingTabList.selectedTab != 0) {
            this.craftingButtonsOffset.max = Math.max(0, this.loomTabListings.get((Integer)this.page.get() * 7 + this.craftingTabList.selectedTab - 1).patterns().size() - 12);
            this.craftingButtons.forEach(b -> {
                b.setPos(this.f_97735_ + 13 + this.craftingButtons.indexOf(b) * 27, this.f_97736_ + 38);
                this.m_7787_((GuiEventListener)b);
            });
        } else {
            this.getCraftingButtons().forEach(b -> {
                b.setPos(this.f_97735_ + 77 + this.getCraftingButtons().indexOf(b) * 55, this.f_97736_ + 39);
                b.offset = new Vec3((double)this.getCraftingButtons().indexOf(b) * 0.5, 0.0, 0.0);
                b.init();
                this.m_7787_((GuiEventListener)b);
            });
        }
        this.m_7787_(this.craftingTabList);
        this.craftingTabList.init(this.f_97735_, this.f_97736_ - 37, this.f_97726_, (t, i) -> {
            int index = this.craftingTabList.tabButtons.indexOf(t);
            boolean bl = t.f_93623_ = index == 0 && this.selectedStack.m_41619_() || index != 0 && !this.selectedStack.m_41619_();
            t.type = index == 0 ? 0 : (index >= 6 ? 2 : 1);
            t.m_93674_(51);
            t.offset = t1 -> new Vec3(-1.5 * (double)this.craftingTabList.tabButtons.indexOf(t), t1.f_93623_ ? (t1.selected ? 0.0 : 4.5) : 26.5, 0.0);
        });
    }

    protected boolean canCraft() {
        return this.selectedIngredients.size() > 1 && this.canCraft(this.selectedIngredients, false);
    }

    protected boolean canCraft(List<Optional<Ingredient>> ingredients, boolean isFocused) {
        this.compactInventoryList.clear();
        RecipeMenu.handleCompactInventoryList(this.compactInventoryList, Minecraft.m_91087_().f_91074_.m_150109_(), ((LegacyCraftingMenu)this.f_97732_).m_142621_());
        return LegacyCraftingScreen.canCraft(this.compactInventoryList, ingredients, isFocused ? this.warningSlots : null);
    }

    public boolean m_6050_(double d, double e, double g) {
        if (super.m_6050_(d, e, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.m_267719_();
            return true;
        }
        return false;
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<BannerRecipe> h = new RecipeIconHolder<BannerRecipe>(this.f_97735_ + 13 + i * 27, this.f_97736_ + 38){

                @Override
                @Nullable
                public Component getAction(ControlTooltip.ActionHolder.Context context) {
                    return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.m_93696_() && LegacyLoomScreen.this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.m_93696_() && this.canCraft() ? LegacyComponents.ADD : null));
                }

                @Override
                public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
                    if (this.m_93696_()) {
                        LegacyLoomScreen.this.selectedCraftingButton = index;
                    }
                    super.m_88315_(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<BannerRecipe> rcp) {
                    if (rcp == null) {
                        return true;
                    }
                    return Legacy4J.getItemPatternsCount(LegacyLoomScreen.this.previewStack) < 6 && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).displayIngredients(), this.m_93696_() && this.getFocusedRecipe() == rcp) && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).previewIngredients, false);
                }

                @Override
                protected List<RecipeInfo<BannerRecipe>> getRecipes() {
                    return LegacyLoomScreen.this.recipesByGroup.size() <= (Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : LegacyLoomScreen.this.recipesByGroup.get((Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void toggleCraftableRecipes() {
                }

                @Override
                public boolean m_7933_(int i, int j, int k) {
                    if ((i == 79 || i == 88) && this.isValidIndex()) {
                        if (i == 79) {
                            if (this.canCraft()) {
                                LegacyLoomScreen.this.selectedPatterns.add(this.getFocusedRecipe());
                                ScreenUtil.playSimpleUISound(SoundEvents.f_12491_, 1.0f);
                            }
                        } else {
                            LegacyLoomScreen.this.selectedPatterns.remove(this.getFocusedRecipe());
                        }
                        int cycle = this.getFocusedRecipes().indexOf(this.getFocusedRecipe()) - this.getRecipes().indexOf(this.getFocusedRecipe());
                        this.focusedRecipes = null;
                        LegacyLoomScreen.this.listener.m_7934_(LegacyLoomScreen.this.f_97732_, -1, ItemStack.f_41583_);
                        Collections.rotate(this.getFocusedRecipes(), cycle);
                        this.updateRecipeDisplay();
                        return true;
                    }
                    if (this.controlCyclicNavigation(i, index, LegacyLoomScreen.this.craftingButtons, LegacyLoomScreen.this.craftingButtonsOffset, LegacyLoomScreen.this.scrollRenderer, (Screen)LegacyLoomScreen.this)) {
                        return true;
                    }
                    return super.m_7933_(i, j, k);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<BannerRecipe> rcp) {
                    LegacyLoomScreen.this.resultStack = this.getFocusedResult();
                    LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
                    if (rcp == null) {
                        return;
                    }
                    for (int i = 0; i < ((BannerRecipe)rcp.get()).displayIngredients().size(); ++i) {
                        LegacyLoomScreen.this.ingredientsGrid.set(i, ((BannerRecipe)rcp.get()).displayIngredients().get(i));
                    }
                }

                @Override
                public void onPress() {
                    if (this.m_93696_() && this.isValidIndex()) {
                        if (LegacyLoomScreen.this.canCraft()) {
                            ScreenUtil.playSimpleUISound(SoundEvents.f_12492_, 1.0f);
                            LegacyLoomScreen.this.selectedPatterns.forEach(b -> CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Optional.of(((BannerRecipe)b.get()).pattern.m_135782_()), b.getOptionalIngredients(), -1, Screen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)));
                            LegacyLoomScreen.this.selectedPatterns.clear();
                            LegacyLoomScreen.this.selectedStack = ItemStack.f_41583_;
                            LegacyLoomScreen.this.previewStack = ItemStack.f_41583_;
                            LegacyLoomScreen.this.craftingTabList.tabButtons.get(0).m_5691_();
                        } else {
                            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                        }
                    }
                }
            };
            this.craftingButtons.add(h);
            h.allowCraftableRecipesToggle = false;
            h.offset = new Vec3(0.5, 0.5, 0.0);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        this.craftingTabList.m_88315_(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 9, this.f_97736_ + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 176, this.f_97736_ + 103, 163, 105);
        if (!((LegacyCraftingMenu)this.f_97732_).inventoryActive && !this.previewStack.m_41619_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)this.f_97735_ + 220.5, (double)this.f_97736_ + 130.5, 0.0);
            guiGraphics.m_280168_().m_85841_(4.25f, 4.25f, 4.25f);
            guiGraphics.m_280480_(this.previewStack, 0, 0);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.craftingTabList.selectedTab == 0) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 176, this.f_97736_ + 8, 163, 93);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, this.f_97735_ + 97, this.f_97736_ + 161, 16, 13);
        if (this.craftingTabList.selectedTab != 0) {
            if ((Integer)this.craftingButtonsOffset.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.f_97735_ + 5, this.f_97736_ + 45);
            }
            if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.f_97735_ + 337, this.f_97736_ + 45);
            }
        }
    }

    public boolean m_7933_(int i, int j, int k) {
        if (LegacyLoomScreen.m_96638_() && this.controlPage(i == 263, i == 262)) {
            return true;
        }
        if (this.craftingTabList.controlTab(i)) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    protected boolean controlPage(boolean left, boolean right) {
        if ((left || right) && this.page.max > 0 && this.craftingTabList.selectedTab != 0) {
            int lastPage = (Integer)this.page.get();
            this.page.add(left ? -1 : 1);
            if (lastPage != (Integer)this.page.get()) {
                this.craftingTabList.resetSelectedTab();
                this.m_232761_();
                return true;
            }
        }
        return false;
    }

    public List<? extends LegacyIconHolder> getCraftingButtons() {
        return this.craftingTabList.selectedTab == 0 ? this.selectBannerButton : this.craftingButtons;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        RecipeIconHolder r;
        super.m_88315_(guiGraphics, i, j, f);
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            ScreenUtil.iconHolderRenderer.itemHolder(this.f_97735_ + 21 + index % 3 * 23, this.f_97736_ + 133 + index / 3 * 23, 23, 23, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), !RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).m_41619_() && this.warningSlots[index], new Vec3(0.5, 0.5, 0.0)).m_88315_(guiGraphics, i, j, f);
        }
        GuiEventListener guiEventListener = this.m_7222_();
        ScreenUtil.iconHolderRenderer.itemHolder(this.f_97735_ + 124, this.f_97736_ + 151, 36, 36, this.resultStack, guiEventListener instanceof RecipeIconHolder && (r = (RecipeIconHolder)guiEventListener).isValidIndex() && !r.canCraft(), new Vec3(0.5, 0.0, 0.0)).m_88315_(guiGraphics, i, j, f);
        if (!this.resultStack.m_41619_()) {
            Component resultName = this.resultStack.m_41786_();
            ScreenUtil.renderScrollingString(guiGraphics, this.f_96547_, resultName, this.f_97735_ + 11 + Math.max(163 - this.f_96547_.m_92852_((FormattedText)resultName), 0) / 2, this.f_97736_ + 114, this.f_97735_ + 170, this.f_97736_ + 125, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            if (this.craftingTabList.selectedTab == 0) {
                List<Component> list = ScreenUtil.getTooltip(this.resultStack);
                this.scrollableRenderer.scrolled.max = Math.max(0, list.size() - 6);
                this.scrollableRenderer.render(guiGraphics, this.f_97735_ + 180, this.f_97736_ + 15, 152, 72, () -> {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        guiGraphics.m_280614_(this.f_96547_, (Component)((Component)list.get(i1)).m_6881_().m_6270_(Style.f_131099_), this.f_97735_ + 180, this.f_97736_ + 15 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            }
            if (ScreenUtil.isMouseOver(i, j, this.f_97735_ + 124, this.f_97736_ + 151, 36, 36)) {
                guiGraphics.m_280153_(this.f_96547_, this.resultStack, i, j);
            }
        }
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            if (RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).m_41619_() || !ScreenUtil.isMouseOver(i, j, this.f_97735_ + 21 + index % 3 * 23, this.f_97736_ + 133 + index / 3 * 23, 23, 23)) continue;
            guiGraphics.m_280153_(this.f_96547_, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), i, j);
        }
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.f_96541_, guiGraphics, i, j));
        this.m_280072_(guiGraphics, i, j);
    }

    public record BannerRecipe(List<Optional<Ingredient>> previewIngredients, List<Optional<Ingredient>> displayIngredients, ResourceKey<BannerPattern> pattern, DyeColor color) {
    }
}

