/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.client.CommonColor;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyMerchantMenu;
import wily.legacy.inventory.LegacyMerchantOffer;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyMerchantScreen
extends AbstractContainerScreen<LegacyMerchantMenu>
implements Controller.Event,
ControlTooltip.Event {
    protected final boolean[] displaySlotsWarning = new boolean[3];
    protected final List<LegacyIconHolder> merchantTradeButtons = new ArrayList<LegacyIconHolder>();
    protected final ContainerListener listener;
    protected final Stocker.Sizeable tradingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    boolean initOffers = false;

    public LegacyMerchantScreen(LegacyMerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.listener = new ContainerListener(){

            public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                LegacyMerchantScreen.this.updateSlotsDisplay();
            }

            public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
            }
        };
        for (int index = 0; index < 10; ++index) {
            this.addTradeButton(index);
        }
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        super.m_7522_(guiEventListener);
        if (guiEventListener instanceof LegacyIconHolder) {
            this.updateSlotsDisplay();
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    private void updateSlotsDisplay() {
        this.tradingButtonsOffset.max = Math.max(0, ((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().size() - 10);
        ArrayList<ItemStack> compactList = new ArrayList<ItemStack>();
        RecipeMenu.handleCompactInventoryList(compactList, Minecraft.m_91087_().f_91074_.m_150109_(), ((LegacyMerchantMenu)this.f_97732_).m_142621_());
        this.merchantTradeButtons.forEach(b -> {
            b.allowFocusedItemTooltip = true;
            int i = (Integer)this.tradingButtonsOffset.get() + this.merchantTradeButtons.indexOf(b);
            boolean warning = false;
            if (i < ((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().size()) {
                MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().get(i);
                boolean matchesCostA = compactList.stream().anyMatch(item -> offer.m_45355_(item, offer.m_45364_()) && item.m_41613_() >= offer.m_45358_().m_41613_());
                boolean matchesCostB = offer.m_45364_().m_41619_() || compactList.stream().anyMatch(item -> offer.m_45355_(offer.m_45358_(), item) && item.m_41613_() >= offer.m_45364_().m_41613_());
                boolean bl = warning = !matchesCostA || !matchesCostB;
                if (offer == this.getSelectedMerchantOffer()) {
                    this.displaySlotsWarning[0] = !matchesCostA;
                    this.displaySlotsWarning[1] = !matchesCostB;
                    this.displaySlotsWarning[2] = warning;
                }
            }
            b.setWarning(warning);
        });
    }

    protected void addTradeButton(final int index) {
        LegacyIconHolder h = new LegacyIconHolder(27, 27){

            @Override
            @Nullable
            public Component getAction(ControlTooltip.ActionHolder.Context context) {
                return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && !LegacyMerchantScreen.this.displaySlotsWarning[2] && this.isValidIndex() && this.m_93696_() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).m_45380_() ? LegacyComponents.TRADE : null);
            }

            @Override
            public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
                this.itemIcon = this.isValidIndex() ? ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).m_45368_() : ItemStack.f_41583_;
                super.m_88315_(graphics, i, j, f);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 432.0f);
                if (this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchantLevel) {
                    this.renderIcon(LegacySprites.PADLOCK, graphics, false, 16, 16);
                } else if (this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).m_45380_()) {
                    this.renderIcon(LegacySprites.ERROR_CROSS, graphics, false, 15, 15);
                }
                graphics.m_280168_().m_85849_();
            }

            @Override
            public void renderItem(GuiGraphics graphics, int i, int j, float f) {
                if (this.itemIcon.m_41619_()) {
                    return;
                }
                ScreenUtil.secureTranslucentRender(graphics, this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).m_45380_(), 0.5f, u -> super.renderItem(graphics, i, j, f));
            }

            @Override
            public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                for (int index2 = 0; index2 < 3; ++index2) {
                    MerchantOffer offer = LegacyMerchantScreen.this.getSelectedMerchantOffer();
                    if (index2 == 1 && (offer == null || offer.m_45364_().m_41619_())) continue;
                    LegacyIconHolder iconHolder = ScreenUtil.iconHolderRenderer.itemHolder(LegacyMerchantScreen.this.f_97735_ + (index2 == 2 ? 86 : 17), LegacyMerchantScreen.this.f_97736_ + (index2 == 0 ? 114 + (offer == null || offer.m_45364_().m_41619_() ? 16 : 0) : (index2 == 1 ? 144 : 130)), 27, 27, offer == null || index2 == 0 ? ItemStack.f_41583_ : (index2 == 1 ? offer.m_45364_() : offer.m_45368_()), offer != null && LegacyMerchantScreen.this.displaySlotsWarning[index2], Vec3.f_82478_);
                    iconHolder.m_88315_(graphics, i, j, f);
                    if (offer == null || index2 != 0) continue;
                    iconHolder.renderItem(graphics, () -> {
                        ItemStack costA = offer.m_45358_();
                        ItemStack baseCostA = offer.m_45352_();
                        graphics.m_280203_(costA, 0, 0);
                        if (baseCostA.m_41613_() == costA.m_41613_()) {
                            graphics.m_280370_(LegacyMerchantScreen.this.f_96547_, costA, 0, 0);
                        } else {
                            graphics.m_280302_(LegacyMerchantScreen.this.f_96547_, baseCostA, -12, 0, baseCostA.m_41613_() == 1 ? "1" : null);
                            graphics.m_280302_(LegacyMerchantScreen.this.f_96547_, costA, 0, 0, costA.m_41613_() == 1 ? "1" : null);
                            graphics.m_280168_().m_85836_();
                            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.DISCOUNT_STRIKETHRUOGH_SPRITE, -5, 12, 0, 9, 2);
                            graphics.m_280168_().m_85849_();
                        }
                    }, iconHolder.m_252754_(), iconHolder.m_252907_(), iconHolder.isWarning());
                }
                super.renderSelection(graphics, i, j, f);
            }

            private int getIndex() {
                return (Integer)LegacyMerchantScreen.this.tradingButtonsOffset.get() + index;
            }

            @Override
            public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
                super.renderTooltip(minecraft, graphics, i, j);
                if (!this.m_93696_()) {
                    return;
                }
                MerchantOffer offer = LegacyMerchantScreen.this.getSelectedMerchantOffer();
                if (offer != null) {
                    for (int index2 = 0; index2 < 3; ++index2) {
                        ItemStack s;
                        ItemStack itemStack = index2 == 0 ? offer.m_45358_() : (s = index2 == 1 ? offer.m_45364_() : offer.m_45368_());
                        if (s.m_41619_() || !ScreenUtil.isMouseOver(i, j, LegacyMerchantScreen.this.f_97735_ + (index2 == 2 ? 86 : 17), LegacyMerchantScreen.this.f_97736_ + (index2 == 0 ? 114 + (offer.m_45364_().m_41619_() ? 16 : 0) : (index2 == 1 ? 144 : 130)), 27, 27)) continue;
                        this.renderTooltip(minecraft, graphics, s, i, j);
                    }
                }
            }

            @Override
            public boolean m_7933_(int i, int j, int k) {
                if (i == 263 && index == 0 || i == 262 && index == LegacyMerchantScreen.this.merchantTradeButtons.size() - 1) {
                    int oldOffset = (Integer)LegacyMerchantScreen.this.tradingButtonsOffset.get();
                    LegacyMerchantScreen.this.tradingButtonsOffset.add(i == 263 ? -1 : 1, true);
                    if (oldOffset == LegacyMerchantScreen.this.tradingButtonsOffset.max && i == 262 || oldOffset == 0 && i == 263) {
                        LegacyMerchantScreen.this.m_7522_(LegacyMerchantScreen.this.merchantTradeButtons.get(i == 263 ? LegacyMerchantScreen.this.merchantTradeButtons.size() - 1 : 0));
                    } else {
                        LegacyMerchantScreen.this.scrollRenderer.updateScroll(i == 263 ? ScreenDirection.LEFT : ScreenDirection.RIGHT);
                        LegacyMerchantScreen.this.updateSlotsDisplay();
                    }
                    ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                    return true;
                }
                return super.m_7933_(i, j, k);
            }

            @Override
            public ResourceLocation getIconHolderSprite() {
                return this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchantLevel ? LegacyIconHolder.GRAY_ICON_HOLDER : super.getIconHolderSprite();
            }

            @Override
            public boolean isWarning() {
                return super.isWarning() && this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex())).m_45380_();
            }

            private boolean isValidIndex() {
                return this.getIndex() < ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().size();
            }

            @Override
            public void onPress() {
                if (this.isValidIndex() && this.m_93696_()) {
                    MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchant.m_6616_().get(this.getIndex());
                    if (((LegacyMerchantOffer)offer).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).f_97732_).merchantLevel && !offer.m_45380_() && !LegacyMerchantScreen.this.displaySlotsWarning[2]) {
                        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Collections.emptyList(), this.getIndex(), Screen.m_96638_() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
                    } else {
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                    }
                }
            }
        };
        h.offset = new Vec3(0.5, 0.0, 0.0);
        this.merchantTradeButtons.add(h);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public void m_7856_() {
        this.f_97726_ = 294;
        this.f_97727_ = 181;
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97729_ = 12;
        this.f_97730_ = 128 + (153 - this.f_96547_.m_92852_((FormattedText)this.f_169604_)) / 2;
        this.f_97731_ = 87;
        super.m_7856_();
        this.updateSlotsDisplay();
        if (!(this.m_7222_() instanceof LegacyIconHolder)) {
            this.m_7522_(this.merchantTradeButtons.get(0));
        }
        this.merchantTradeButtons.forEach(holder -> {
            int i = this.merchantTradeButtons.indexOf(holder);
            holder.m_252865_(this.f_97735_ + 13 + 27 * i);
            holder.m_253211_(this.f_97736_ + 44);
            this.m_142416_((GuiEventListener)holder);
        });
        ((LegacyMerchantMenu)this.f_97732_).m_38893_(this.listener);
    }

    public void m_7861_() {
        super.m_7861_();
        ((LegacyMerchantMenu)this.f_97732_).m_38943_(this.listener);
    }

    public MerchantOffer getSelectedMerchantOffer() {
        return this.getSelectedOfferIndex() < ((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().size() ? (MerchantOffer)((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().get(this.getSelectedOfferIndex()) : null;
    }

    public int getSelectedOfferIndex() {
        int n;
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof LegacyIconHolder) {
            LegacyIconHolder h = (LegacyIconHolder)guiEventListener;
            n = this.merchantTradeButtons.indexOf(h);
        } else {
            n = 0;
        }
        return n + (Integer)this.tradingButtonsOffset.get();
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (!((LegacyMerchantMenu)this.f_97732_).merchant.m_6616_().isEmpty() && !this.initOffers) {
            this.initOffers = true;
            this.updateSlotsDisplay();
        }
        super.m_88315_(guiGraphics, i, j, f);
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof LegacyIconHolder) {
            LegacyIconHolder h = (LegacyIconHolder)guiEventListener;
            h.renderSelection(guiGraphics, i, j, f);
        }
        this.merchantTradeButtons.forEach(b -> b.renderTooltip(this.f_96541_, guiGraphics, i, j));
        this.m_280072_(guiGraphics, i, j);
    }

    public boolean m_6050_(double d, double e, double g) {
        if (super.m_6050_(d, e, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.tradingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.tradingButtonsOffset.max > 0) && this.tradingButtonsOffset.add(scroll, false) != 0) {
            this.updateSlotsDisplay();
            return true;
        }
        return false;
    }

    protected void renderProgressBar(GuiGraphics guiGraphics) {
        int p;
        int k = ((LegacyMerchantMenu)this.f_97732_).merchantLevel;
        int l = ((LegacyMerchantMenu)this.f_97732_).merchant.m_7809_();
        if (k >= 5) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_ + ((float)this.f_97726_ - 241.5f) / 2.0f, (float)(this.f_97736_ + 28), 0.0f);
        guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_BACKGROUND, 0, 0, 0, 161, 4);
        int m = VillagerData.m_35572_((int)k);
        if (l < m || !VillagerData.m_35582_((int)k)) {
            guiGraphics.m_280168_().m_85849_();
            return;
        }
        float f = 161.0f / (float)(VillagerData.m_35577_((int)k) - m);
        int o = Math.min(Mth.m_14143_((float)(f * (float)(l - m))), 161);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_CURRENT, 161, 4, 0, 0, 0, 0, 0, o, 4);
        int n = p = this.getSelectedMerchantOffer() != null ? this.getSelectedMerchantOffer().m_45379_() : 0;
        if (p > 0) {
            int q = Math.min(Mth.m_14143_((float)((float)p * f)), 161 - o);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_RESULT, 161, 4, o, 0, o, 0, 0, q, 4);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static MutableComponent getMerchantTile(Component title, int i) {
        return Component.m_237110_((String)"merchant.title", (Object[])new Object[]{title, Component.m_237115_((String)("merchant.level." + i))});
    }

    public void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        int level;
        int k = ((LegacyMerchantMenu)this.f_97732_).merchantLevel;
        if (k > 0 && k <= 5 && ((LegacyMerchantMenu)this.f_97732_).showProgressBar) {
            MutableComponent component = LegacyMerchantScreen.getMerchantTile(this.f_96539_, k);
            guiGraphics.m_280614_(this.f_96547_, (Component)component, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)component)) / 2, this.f_97729_, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        if (this.getSelectedMerchantOffer() != null && ((LegacyMerchantMenu)this.f_97732_).showProgressBar && (level = ((LegacyMerchantOffer)this.getSelectedMerchantOffer()).getRequiredLevel()) > 0) {
            MutableComponent c = Component.m_237115_((String)("merchant.level." + level));
            guiGraphics.m_280614_(this.f_96547_, (Component)c, 15 + (105 - this.f_96547_.m_92852_((FormattedText)c)) / 2, 100, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
    }

    public void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        LegacyMerchantOffer o;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 12, this.f_97736_ + 79, 110, 93);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 126, this.f_97736_ + 79, 157, 93);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(this.f_97735_ + 47), (float)(this.f_97736_ + 131), 0.0f);
        guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        if (this.getSelectedMerchantOffer() != null && this.getSelectedMerchantOffer().m_45380_()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 4, 0, 15, 15);
        }
        guiGraphics.m_280168_().m_85849_();
        MerchantOffer merchantOffer = this.getSelectedMerchantOffer();
        if (merchantOffer instanceof LegacyMerchantOffer && (o = (LegacyMerchantOffer)merchantOffer).getRequiredLevel() > ((LegacyMerchantMenu)this.f_97732_).merchantLevel) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, this.f_97735_ + 56, this.f_97736_ + 134, 16, 16);
        }
        if (UIAccessor.of((Screen)this).getBoolean("showProgressBar", Boolean.valueOf(((LegacyMerchantMenu)this.f_97732_).showProgressBar)).booleanValue()) {
            this.renderProgressBar(guiGraphics);
        }
        if ((Integer)this.tradingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.f_97735_ + 5, this.f_97736_ + 52);
        }
        if (this.tradingButtonsOffset.max > 0 && (Integer)this.tradingButtonsOffset.get() < this.tradingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.f_97735_ + 283, this.f_97736_ + 52);
        }
    }
}

