/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.client.ControlType;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class ModsScreen
extends PanelVListScreen {
    protected final Map<ModInfo, SizedLocation> modLogosCache = new ConcurrentHashMap<ModInfo, SizedLocation>();
    protected ScrollableRenderer scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
    protected final Panel tooltipBox = Panel.tooltipBoxOf(this.panel, 192);
    protected final Stocker.Sizeable sorting = new Stocker.Sizeable(Integer.valueOf(1), 1);
    protected ModInfo focusedMod;
    protected final LoadingCache<ModInfo, AdvancedTextWidget> modLabelsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ModInfo, AdvancedTextWidget>(){

        public AdvancedTextWidget load(ModInfo key) {
            ArrayList<Component> components = new ArrayList<Component>();
            SizedLocation logo = ModsScreen.this.modLogosCache.get(key);
            if (logo != null && logo.getScaledWidth(28) >= 120) {
                components.add((Component)Component.m_237113_((String)ModsScreen.this.focusedMod.getName()));
                components.add((Component)Component.m_237110_((String)"legacy.menu.mods.id", (Object[])new Object[]{ModsScreen.this.focusedMod.getId()}));
            }
            if (!key.getAuthors().isEmpty()) {
                components.add((Component)Component.m_237110_((String)"legacy.menu.mods.authors", (Object[])new Object[]{String.join((CharSequence)", ", key.getAuthors())}));
            }
            if (!key.getCredits().isEmpty()) {
                components.add((Component)Component.m_237110_((String)"legacy.menu.mods.credits", (Object[])new Object[]{String.join((CharSequence)", ", key.getCredits())}));
            }
            key.getHomepage().ifPresent(s -> components.add((Component)Component.m_237110_((String)"legacy.menu.mods.homepage", (Object[])new Object[]{s}).m_130948_(Style.f_131099_.m_131142_(ModsScreen.urlClickEvent(s)))));
            key.getIssues().ifPresent(s -> components.add((Component)Component.m_237110_((String)"legacy.menu.mods.issues", (Object[])new Object[]{s}).m_130948_(Style.f_131099_.m_131142_(ModsScreen.urlClickEvent(s)))));
            key.getSources().ifPresent(s -> components.add((Component)Component.m_237110_((String)"legacy.menu.mods.sources", (Object[])new Object[]{s}).m_130948_(Style.f_131099_.m_131142_(ModsScreen.urlClickEvent(s)))));
            if (key.getLicense() != null && !key.getLicense().isEmpty()) {
                components.add((Component)Component.m_237110_((String)"legacy.menu.mods.license", (Object[])new Object[]{String.join((CharSequence)", ", key.getLicense())}));
            }
            components.add((Component)Component.m_237113_((String)key.getDescription()));
            MultilineTooltip tooltip = new MultilineTooltip(components, ModsScreen.this.tooltipBox.m_5711_() - 16);
            return new AdvancedTextWidget(ModsScreen.this.accessor).withWidth(ModsScreen.this.tooltipBox.m_5711_() - 16).withLines(tooltip.m_257408_(ModsScreen.this.f_96541_));
        }
    });

    public static ClickEvent urlClickEvent(String url) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
    }

    public ModsScreen(Screen parent) {
        super(parent, 282, 243, (Component)Component.m_237119_());
        this.renderableVList.layoutSpacing(l -> 0);
        this.fillMods();
    }

    public void fillMods() {
        List<ModInfo> mods = FactoryAPIPlatform.getMods();
        if ((Integer)this.sorting.get() != 0) {
            mods = mods.stream().sorted(Comparator.comparing(ModInfo::getName)).toList();
        }
        mods.forEach(mod -> {
            if (mod.isHidden()) {
                return;
            }
            this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 30, (Component)Component.m_237113_((String)mod.getName()), (ModInfo)mod){
                final /* synthetic */ ModInfo val$mod;
                {
                    this.val$mod = modInfo;
                    super(i, j, k, l, arg);
                }

                public void m_5691_() {
                    Screen config;
                    if (this.m_93696_() && (config = FactoryAPIClient.getConfigScreen((ModInfo)this.val$mod, (Screen)ModsScreen.this)) != null) {
                        ModsScreen.this.f_96541_.m_91152_(config);
                    }
                }

                protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                    super.m_87963_(guiGraphics, i, j, f);
                    if (this.m_93696_()) {
                        ModsScreen.this.focusedMod = this.val$mod;
                    }
                    FactoryScreenUtil.enableBlend();
                    SizedLocation logo = ModsScreen.this.modLogosCache.computeIfAbsent(this.val$mod, m -> {
                        Optional opt = m.getLogoFile(100);
                        if (opt.isPresent() && this.val$mod.findResource((String)opt.get()).isPresent()) {
                            try {
                                NativeImage image = NativeImage.m_85058_((InputStream)Files.newInputStream((Path)this.val$mod.findResource((String)opt.get()).get(), new OpenOption[0]));
                                ResourceLocation location = FactoryAPI.createLocation((String)this.val$mod.getId(), (String)((String)opt.get()).toLowerCase(Locale.ENGLISH));
                                ModsScreen.this.f_96541_.m_91097_().m_118495_(location, (AbstractTexture)new DynamicTexture(image));
                                if (location != null) {
                                    return new SizedLocation(location, image.m_84982_(), image.m_85084_());
                                }
                            }
                            catch (IOException image) {
                                // empty catch block
                            }
                        }
                        ResourceLocation defaultLogo = PackAlbum.Selector.DEFAULT_ICON;
                        if (this.val$mod.getId().equals("minecraft")) {
                            defaultLogo = PackAlbum.Selector.getPackIcon(ModsScreen.this.f_96541_.m_91099_().m_10507_("vanilla"));
                        }
                        return new SizedLocation(defaultLogo, 1, 1);
                    });
                    if (logo != null) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(logo.location, this.m_252754_() + 5, this.m_252907_() + 5, 0.0f, 0.0f, logo.getScaledWidth(20), 20, logo.getScaledWidth(20), 20);
                    }
                    FactoryScreenUtil.disableBlend();
                }

                protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                    SizedLocation logo = ModsScreen.this.modLogosCache.get(this.val$mod);
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 10 + (logo == null ? 20 : logo.getScaledWidth(20)), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), j, true);
                }

                protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                    this.m_168802_(narrationElementOutput);
                }
            });
        });
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.tooltipBox.m_88315_(guiGraphics, i, j, f);
        if (this.focusedMod != null) {
            AdvancedTextWidget label = ((AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).withPos(this.panel.x + this.panel.width + 5, this.panel.y + 41);
            this.scrollableRenderer.scrolled.max = Math.max(0, Mth.m_14167_((float)((float)(label.m_93694_() - (this.tooltipBox.m_93694_() - 50)) / 12.0f)));
            SizedLocation logo = this.modLogosCache.get(this.focusedMod);
            int x = this.panel.x + this.panel.width + (logo == null ? 5 : logo.getScaledWidth(28) + 10);
            if (logo != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(logo.location, this.panel.x + this.panel.width + 5, this.panel.y + 10, 0.0f, 0.0f, logo.getScaledWidth(28), 28, logo.getScaledWidth(28), 28);
            }
            if (logo == null || logo.getScaledWidth(28) < 120) {
                ScreenUtil.renderScrollingString(guiGraphics, this.f_96547_, (Component)Component.m_237110_((String)"legacy.menu.mods.id", (Object[])new Object[]{this.focusedMod.getId()}), x, this.panel.y + 12, this.panel.x + this.panel.width + 185, this.panel.y + 24, 0xFFFFFF, true);
                ScreenUtil.renderScrollingString(guiGraphics, this.f_96547_, (Component)Component.m_237110_((String)"legacy.menu.mods.version", (Object[])new Object[]{this.focusedMod.getVersion()}), x, this.panel.y + 24, this.panel.x + this.panel.width + 185, this.panel.y + 36, 0xFFFFFF, true);
            }
            this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.m_5711_() - 16, this.tooltipBox.m_93694_() - 50, () -> label.m_88315_(guiGraphics, i, j + Math.round(this.scrollableRenderer.getYOffset()), f));
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        AdvancedTextWidget label;
        if (this.focusedMod != null && ScreenUtil.isMouseOver(d, e, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.m_5711_() - 16, this.tooltipBox.m_93694_() - 50) && (label = (AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).m_6375_(d, e + (double)this.scrollableRenderer.getYOffset(), i)) {
            return true;
        }
        return super.m_6375_(d, e, i);
    }

    @Override
    public boolean m_6050_(double d, double e, double g) {
        if ((this.tooltipBox.isHovered(d, e) || !ControlType.getActiveType().isKbm()) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.m_6050_(d, e, g);
    }

    @Override
    public void renderableVListInit() {
        this.m_169394_((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
        this.tooltipBox.init();
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 21);
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (i == 88 && this.sorting.add(1, true) != 0) {
            this.renderableVList.renderables.clear();
            this.fillMods();
            this.m_267719_();
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> Component.m_237110_((String)"legacy.menu.sorting", (Object[])new Object[]{(Integer)this.sorting.get() == 0 ? LegacyComponents.NONE : LegacyComponents.ALPHABETICAL}));
    }

    public record SizedLocation(ResourceLocation location, int width, int height) {
        public int getScaledWidth(int height) {
            return (int)((float)height * ((float)this.width / (float)this.height()));
        }
    }
}

