/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.screen.JoinGameScreen;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class FriendsServerRenderableList
extends ServerRenderableList {
    boolean ping = false;
    protected final FriendsListUpdate friendsListUpdate = friends -> this.updateServers();

    public FriendsServerRenderableList(UIAccessor accessor) {
        super(accessor);
    }

    @Override
    public void added() {
        WorldHost.ONLINE_FRIEND_UPDATES.add(this.friendsListUpdate);
    }

    @Override
    public void removed() {
        super.removed();
        WorldHost.ONLINE_FRIEND_UPDATES.remove(this.friendsListUpdate);
    }

    @Override
    public boolean hasOnlineFriends() {
        return !WorldHost.ONLINE_FRIENDS.isEmpty();
    }

    @Override
    public void updateLANServers() {
        if (!this.ping) {
            WorldHost.pingFriends();
            this.ping = true;
        }
        super.updateLANServers();
        Util.m_183991_().execute(() -> {
            WorldHost.ONLINE_FRIENDS.forEach((uuid, id) -> {
                final GameProfile profile = WorldHost.fetchProfile((MinecraftSessionService)this.minecraft.m_91108_(), (UUID)uuid);
                AbstractButton onlineButton = new AbstractButton(0, 0, 270, 30, (Component)Component.m_237113_((String)profile.getName()), (OnlineFriend)id){
                    final ServerData serverData;
                    final FaviconTexture icon;
                    private byte @Nullable [] lastIconBytes;
                    final /* synthetic */ OnlineFriend val$id;
                    {
                        this.val$id = onlineFriend;
                        super(i, j, k, l, arg);
                        this.serverData = new ServerData("", "", false);
                        this.icon = FaviconTexture.m_289187_((TextureManager)FriendsServerRenderableList.this.minecraft.m_91097_(), (String)this.serverData.f_105363_);
                    }

                    private boolean uploadServerIcon(@Nullable byte[] bs) {
                        if (bs == null) {
                            this.icon.m_289218_();
                        } else {
                            try {
                                this.icon.m_289201_(NativeImage.m_271751_((byte[])bs));
                            }
                            catch (Throwable throwable) {
                                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, throwable});
                                return false;
                            }
                        }
                        return true;
                    }

                    protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                        ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 35, this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), j, true);
                    }

                    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
                        super.m_87963_(guiGraphics, mouseX, mouseY, f);
                        this.updateServerInfo();
                        byte[] bs = this.serverData.m_271916_();
                        if (!Arrays.equals(bs, this.lastIconBytes)) {
                            if (this.uploadServerIcon(bs)) {
                                this.lastIconBytes = bs;
                            } else {
                                this.serverData.m_271813_(null);
                            }
                        }
                        if (this.serverData.m_271916_() == null) {
                            PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)FriendsServerRenderableList.this.minecraft.m_91109_().m_240306_(profile), (int)(this.m_252754_() + 5), (int)(this.m_252907_() + 5), (int)20);
                        } else {
                            ServerRenderableList.drawIcon(guiGraphics, this.m_252754_(), this.m_252907_(), this.icon.m_289196_());
                        }
                        if (((Boolean)((FriendsServerRenderableList)FriendsServerRenderableList.this).minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || this.f_93622_) {
                            guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                            int u = mouseX - this.m_252754_();
                            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(u < 30 && u > 5 ? LegacySprites.JOIN_HIGHLIGHTED : LegacySprites.JOIN, this.m_252754_(), this.m_252907_(), 32, 32);
                        }
                    }

                    public void m_5691_() {
                        if (this.m_93696_()) {
                            FriendsServerRenderableList.this.minecraft.m_91152_((Screen)new JoinGameScreen(FriendsServerRenderableList.this.getScreen(), this.serverData, b -> {
                                WorldHost.LOGGER.info("Requesting to join {}", (Object)profile.getId());
                                if (WorldHost.protoClient != null) {
                                    this.val$id.joinWorld(FriendsServerRenderableList.this.getScreen());
                                }
                            }));
                        }
                    }

                    private void updateServerInfo() {
                        this.serverData.f_105362_ = profile.getName();
                        ServerStatus metadata = (ServerStatus)WorldHost.ONLINE_FRIEND_PINGS.get(profile.getId());
                        if (metadata == null) {
                            this.serverData.f_105364_ = Component.m_237119_();
                            this.serverData.f_105365_ = Component.m_237119_();
                            return;
                        }
                        this.serverData.f_105365_ = metadata.f_134900_();
                        metadata.f_134902_().ifPresentOrElse(version -> {
                            this.serverData.f_105368_ = Component.m_237113_((String)version.f_134962_());
                            this.serverData.f_105367_ = version.f_134963_();
                        }, () -> {
                            this.serverData.f_105368_ = Component.m_237115_((String)"multiplayer.status.old");
                            this.serverData.f_105367_ = 0;
                        });
                        metadata.f_134901_().ifPresentOrElse(players -> {
                            this.serverData.f_105364_ = Component.m_237110_((String)"multiplayer.status.player_count", (Object[])new Object[]{Component.m_237113_((String)("" + players.f_271178_())).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)("" + players.f_271503_())).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY);
                            this.serverData.f_263840_ = players;
                            if (!players.f_134919_().isEmpty()) {
                                ArrayList<MutableComponent> playerList = new ArrayList<MutableComponent>(players.f_134919_().size());
                                for (GameProfile gameProfile : players.f_134919_()) {
                                    playerList.add(Component.m_237113_((String)gameProfile.getName()));
                                }
                                if (players.f_134919_().size() < players.f_271178_()) {
                                    playerList.add(Component.m_237110_((String)"multiplayer.status.and_more", (Object[])new Object[]{players.f_271178_() - players.f_134919_().size()}));
                                }
                                this.serverData.f_105370_ = playerList;
                            } else {
                                this.serverData.f_105370_ = List.of();
                            }
                        }, () -> {
                            this.serverData.f_105364_ = Component.m_237115_((String)"multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                        });
                        metadata.f_134903_().ifPresent(favicon -> {
                            if (!Arrays.equals(favicon.f_271462_(), this.serverData.m_271916_())) {
                                this.serverData.m_271813_(favicon.f_271462_());
                            }
                        });
                    }

                    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                        this.m_168802_(narrationElementOutput);
                    }
                };
                this.addRenderable((Renderable)onlineButton);
                if (this.accessor.getChildren().contains(onlineButton)) {
                    this.minecraft.m_240477_().m_263195_((Component)Component.m_237110_((String)"multiplayer.lan.server_found", (Object[])new Object[]{onlineButton.m_6035_()}));
                }
            });
            if (!WorldHost.ONLINE_FRIENDS.isEmpty()) {
                this.accessor.reloadUI();
            }
        });
    }
}

