/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.sounds.SoundEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.ScreenUtil;

@Mixin(value={Screen.class})
public abstract class ScreenMixin
extends AbstractContainerEventHandler {
    @Shadow
    public int f_96543_;
    @Shadow
    public int f_96544_;
    @Shadow
    protected Minecraft f_96541_;

    public Screen self() {
        return (Screen)this;
    }

    @Inject(method={"renderWithTooltip"}, at={@At(value="HEAD")})
    private void renderWithTooltip(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        LegacyTipManager.tipDiffPercentage = Math.max(-0.5f, Math.min(LegacyTipManager.tipDiffPercentage + (LegacyTipManager.getActualTip() == null ? -0.1f : 0.08f) * f, 1.5f));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(LegacyTipManager.getTipXDiff(), 0.0f, 0.0f);
    }

    @Inject(method={"renderWithTooltip"}, at={@At(value="RETURN")})
    private void renderWithTooltipReturn(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        guiGraphics.m_280168_().m_252880_(-LegacyTipManager.getTipXDiff(), 0.0f, 0.0f);
        guiGraphics.m_280262_();
        ControlTooltip.Renderer.of((Object)this).m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280168_().m_85849_();
    }

    @Inject(method={"changeFocus"}, at={@At(value="HEAD")})
    private void changeFocus(ComponentPath componentPath, CallbackInfo ci) {
        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
    }

    @Inject(method={"onClose"}, at={@At(value="HEAD")})
    private void onClose(CallbackInfo ci) {
        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.BACK.get(), 1.0f);
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
        if (UIAccessor.of((Screen)this.self()).getBoolean("hasBackground", Boolean.valueOf(true)).booleanValue() && (!(this.self() instanceof AbstractContainerScreen) || ((Boolean)LegacyOptions.menusWithBackground.get()).booleanValue())) {
            ScreenUtil.renderDefaultBackground(UIAccessor.of((Screen)this.self()), guiGraphics, false);
        }
    }

    @Inject(method={"hasShiftDown"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasShiftDown(CallbackInfoReturnable<Boolean> cir) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof KeyboardScreen) {
            KeyboardScreen s = (KeyboardScreen)screen;
            if (s.shift) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    private void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (Legacy4JClient.keyToggleCursor.m_90832_(i, j)) {
            Legacy4JClient.controllerManager.toggleCursor();
        }
    }

    @Redirect(method={"rebuildWidgets"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;clearFocus()V"))
    public void rebuildWidgets(Screen instance) {
    }

    @Inject(method={"setInitialFocus(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setInitialFocus(GuiEventListener guiEventListener, CallbackInfo ci) {
        if (this.m_7222_() == null) {
            this.m_7522_(guiEventListener);
        }
        ci.cancel();
    }

    @Inject(method={"rebuildWidgets"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init()V", shift=At.Shift.AFTER)})
    public void rebuildWidgetsInitialFocus(CallbackInfo ci) {
        Legacy4JClient.postScreenInit((Screen)this);
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init()V", shift=At.Shift.AFTER)})
    public void init(Minecraft minecraft, int i, int j, CallbackInfo ci) {
        Legacy4JClient.postScreenInit((Screen)this);
    }
}

