/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;

public record ClientMerchantTradingPayload(int entityID, Optional<UUID> player, CommonNetwork.Identifier<ClientMerchantTradingPayload> identifier) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ClientMerchantTradingPayload> ID_C2S = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_merchant_trading_c2s"), b -> new ClientMerchantTradingPayload((CommonNetwork.PlayBuf)b, ID_C2S));
    public static final CommonNetwork.Identifier<ClientMerchantTradingPayload> ID_S2C = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_merchant_trading_s2c"), b -> new ClientMerchantTradingPayload((CommonNetwork.PlayBuf)b, ID_S2C));

    public ClientMerchantTradingPayload(CommonNetwork.PlayBuf buf, CommonNetwork.Identifier<ClientMerchantTradingPayload> identifier) {
        this(((FriendlyByteBuf)buf.get()).m_130242_(), ((FriendlyByteBuf)buf.get()).m_236860_(b -> b.m_130259_()), identifier);
    }

    public static ClientMerchantTradingPayload of(AbstractVillager villager) {
        return new ClientMerchantTradingPayload(villager.m_19879_(), Optional.ofNullable(villager.m_7962_()).map(Entity::m_20148_), ID_S2C);
    }

    public static void sync(AbstractVillager entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            ClientMerchantTradingPayload packet = null;
            for (ServerPlayer player : l.m_7654_().m_6846_().m_11314_()) {
                if (player.m_9236_() != entity.m_9236_() || !(player.m_20270_((Entity)entity) < (float)(l.m_7654_().m_6846_().m_11312_() * 16))) continue;
                CommonNetwork.sendToPlayer((ServerPlayer)player, packet == null ? ClientMerchantTradingPayload.of(entity) : packet);
            }
        }
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).m_130130_(this.entityID());
        ((FriendlyByteBuf)buf.get()).m_236835_(this.player, (b, u) -> b.m_130077_(u));
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Entity entity = context.player().m_9236_().m_6815_(this.entityID);
        if (!(entity instanceof AbstractVillager)) {
            return;
        }
        AbstractVillager v = (AbstractVillager)entity;
        if (context.player().m_9236_().m_5776_()) {
            v.m_7189_((Player)this.player.map(u -> v.m_9236_().m_46003_(u)).orElse(null));
        } else {
            ClientMerchantTradingPayload.sync(v);
        }
    }
}

