/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.entity.LegacyPlayer;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;

public record PlayerInfoSync(Sync sync, UUID player) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<PlayerInfoSync> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_c2s"), PlayerInfoSync::new);

    public PlayerInfoSync(CommonNetwork.PlayBuf buf) {
        this((Sync)((FriendlyByteBuf)buf.get()).m_130066_(Sync.class), ((FriendlyByteBuf)buf.get()).m_130259_());
    }

    public PlayerInfoSync(Sync sync, Player player) {
        this(sync, player.m_20148_());
    }

    public PlayerInfoSync(Sync sync, GameProfile profile) {
        this(sync, profile.getId());
    }

    public static PlayerInfoSync askAll(Player player) {
        return new PlayerInfoSync(Sync.ASK_ALL, player);
    }

    public static PlayerInfoSync classicCrafting(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_CRAFTING : Sync.LEGACY_CRAFTING, player);
    }

    public static PlayerInfoSync classicTrading(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_TRADING : Sync.LEGACY_TRADING, player);
    }

    public static PlayerInfoSync classicStonecutting(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_STONECUTTING : Sync.LEGACY_STONECUTTING, player);
    }

    public static PlayerInfoSync classicLoom(boolean classic, Player player) {
        return new PlayerInfoSync(classic ? Sync.CLASSIC_LOOM : Sync.LEGACY_LOOM, player);
    }

    public static PlayerInfoSync disableExhaustion(boolean disableExhaustion, GameProfile profile) {
        return new PlayerInfoSync(disableExhaustion ? Sync.DISABLE_EXHAUSTION : Sync.ENABLE_EXHAUSTION, profile);
    }

    public static PlayerInfoSync mayFlySurvival(boolean mayFlySurvival, GameProfile profile) {
        return new PlayerInfoSync(mayFlySurvival ? Sync.ENABLE_MAY_FLY_SURVIVAL : Sync.DISABLE_MAY_FLY_SURVIVAL, profile);
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).m_130068_((Enum)this.sync);
        ((FriendlyByteBuf)buf.get()).m_130077_(this.player);
    }

    public static Map<String, Object> getWritableGameRules(final GameRules gameRules) {
        final HashMap<String, Object> rules = new HashMap<String, Object>();
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public void m_6891_(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                rules.put(key.m_46328_(), ((GameRules.BooleanValue)gameRules.m_46170_(key)).m_46223_());
            }

            public void m_6894_(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                rules.put(key.m_46328_(), ((GameRules.IntegerValue)gameRules.m_46170_(key)).m_46288_());
            }
        });
        return rules;
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp = sp.f_8924_.m_6846_().m_11259_(this.player);
            if (sp == null) {
                return;
            }
            switch (this.sync.ordinal()) {
                case 0: {
                    CommonNetwork.sendToPlayer((ServerPlayer)sp, (CommonNetwork.Payload)All.fromPlayerList(sp.f_8924_));
                    break;
                }
                case 1: 
                case 2: {
                    ((LegacyPlayer)sp).setCrafting(this.sync == Sync.CLASSIC_CRAFTING);
                    break;
                }
                case 7: 
                case 8: {
                    ((LegacyPlayer)sp).setTrading(this.sync == Sync.CLASSIC_TRADING);
                    break;
                }
                case 9: 
                case 10: {
                    ((LegacyPlayer)sp).setStonecutting(this.sync == Sync.CLASSIC_STONECUTTING);
                    break;
                }
                case 11: 
                case 12: {
                    ((LegacyPlayer)sp).setLoom(this.sync == Sync.CLASSIC_LOOM);
                }
            }
            if (sp.m_20310_(2)) {
                switch (this.sync.ordinal()) {
                    case 3: 
                    case 4: {
                        ((LegacyPlayerInfo)sp).setDisableExhaustion(this.sync == Sync.DISABLE_EXHAUSTION);
                        break;
                    }
                    case 5: 
                    case 6: {
                        LegacyPlayerInfo.updateMayFlySurvival(sp, this.sync == Sync.ENABLE_MAY_FLY_SURVIVAL, true);
                    }
                }
            }
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    public static enum Sync {
        ASK_ALL,
        CLASSIC_CRAFTING,
        LEGACY_CRAFTING,
        DISABLE_EXHAUSTION,
        ENABLE_EXHAUSTION,
        ENABLE_MAY_FLY_SURVIVAL,
        DISABLE_MAY_FLY_SURVIVAL,
        CLASSIC_TRADING,
        LEGACY_TRADING,
        CLASSIC_STONECUTTING,
        LEGACY_STONECUTTING,
        CLASSIC_LOOM,
        LEGACY_LOOM;

    }

    public record All(Map<UUID, LegacyPlayerInfo> players, Map<String, Object> gameRules, GameType defaultGameType, CommonNetwork.Identifier<All> identifier) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<All> ID_C2S = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_all_c2s"), b -> new All((CommonNetwork.PlayBuf)b, ID_C2S));
        public static final CommonNetwork.Identifier<All> ID_S2C = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("player_info_sync_all_s2c"), b -> new All((CommonNetwork.PlayBuf)b, ID_S2C));
        public static final List<GameRules.Key<GameRules.BooleanValue>> NON_OP_GAMERULES = new ArrayList<GameRules.Key>(List.of(GameRules.f_46131_, LegacyGameRules.getTntExplodes(), GameRules.f_46135_, GameRules.f_46136_, GameRules.f_46139_, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, LegacyGameRules.LEGACY_SWIMMING, GameRules.f_46156_));

        public All(Map<String, Object> gameRules, CommonNetwork.Identifier<All> identifier) {
            this(Collections.emptyMap(), gameRules, GameType.SURVIVAL, identifier);
        }

        public All(CommonNetwork.PlayBuf buf, CommonNetwork.Identifier<All> identifier) {
            this(((FriendlyByteBuf)buf.get()).m_236841_(HashMap::new, b -> b.m_130259_(), b -> LegacyPlayerInfo.decode(buf)), ((FriendlyByteBuf)buf.get()).m_236841_(HashMap::new, FriendlyByteBuf::m_130277_, b -> {
                int type = b.m_130242_();
                if (type == 0) {
                    return b.readBoolean();
                }
                return b.m_130242_();
            }), (GameType)((FriendlyByteBuf)buf.get()).m_130066_(GameType.class), identifier);
        }

        public static All fromPlayerList(MinecraftServer server) {
            return new All(server.m_6846_().m_11314_().stream().collect(Collectors.toMap(e -> e.m_36316_().getId(), e -> (LegacyPlayerInfo)e)), PlayerInfoSync.getWritableGameRules(server.m_129900_()), server.m_130008_(), ID_S2C);
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((FriendlyByteBuf)buf.get()).m_236831_(this.players, (b, u) -> b.m_130077_(u), (b, info) -> LegacyPlayerInfo.encode(buf, info));
            ((FriendlyByteBuf)buf.get()).m_236831_(this.gameRules, FriendlyByteBuf::m_130070_, (b, obj) -> {
                b.m_130130_(obj instanceof Boolean ? 0 : 1);
                if (obj instanceof Boolean) {
                    Boolean bol = (Boolean)obj;
                    b.writeBoolean(bol.booleanValue());
                } else if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    b.m_130130_(i.intValue());
                }
            });
            ((FriendlyByteBuf)buf.get()).m_130068_((Enum)this.defaultGameType);
        }

        public void apply(final CommonNetwork.Payload.Context context) {
            context.executor().executeWhen(() -> {
                if (context.isClient() && FactoryAPIClient.hasModOnServer) {
                    Legacy4JClient.defaultServerGameType = this.defaultGameType;
                    Legacy4JClient.updateLegacyPlayerInfos(this.players);
                    return true;
                }
                return false;
            });
            context.executor().execute(() -> {
                GameRules gameRules;
                Player player = context.player();
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    gameRules = sp.m_20194_().m_129900_();
                } else {
                    gameRules = Legacy4JClient.gameRules;
                }
                final GameRules displayRules = gameRules;
                GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                    public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> key, GameRules.Type<T> type) {
                        if (gameRules.containsKey(key.m_46328_()) && (context.player().m_9236_().f_46443_ || NON_OP_GAMERULES.contains(key) || context.player().m_20310_(2))) {
                            GameRules.BooleanValue v;
                            Object object = gameRules.get(key.m_46328_());
                            if (object instanceof Boolean) {
                                Boolean b = (Boolean)object;
                                object = displayRules.m_46170_(key);
                                if (object instanceof GameRules.BooleanValue) {
                                    v = (GameRules.BooleanValue)object;
                                    v.m_46246_(b.booleanValue(), null);
                                }
                            }
                            if ((object = gameRules.get(key.m_46328_())) instanceof Integer) {
                                Integer i = (Integer)object;
                                object = displayRules.m_46170_(key);
                                if (object instanceof GameRules.IntegerValue) {
                                    v = (GameRules.IntegerValue)object;
                                    v.m_151489_(i.intValue(), null);
                                }
                            }
                        }
                    }
                });
            });
        }
    }
}

