/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.io.FileUtils;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class CreationList
extends RenderableVList {
    protected final Minecraft minecraft;

    public CreationList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.getInstance();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/create_world"), (Component)Component.translatable((String)"legacy.menu.create_world"), c -> CreateWorldScreen.openFresh((Minecraft)this.minecraft, () -> this.minecraft.setScreen(this.getScreen())));
        LegacyWorldTemplate.list.forEach(t -> CreationList.addIconButton(this, t.icon(), t.buttonMessage(), c -> {
            if (t.isGamePath() && !Files.exists(t.getPath(), new LinkOption[0])) {
                this.minecraft.setScreen((Screen)ConfirmationScreen.createInfoScreen(this.getScreen(), LegacyComponents.MISSING_WORLD_TEMPLATE, (Component)Component.translatable((String)"legacy.menu.missing_world_template_message", (Object[])new Object[]{t.buttonMessage()})));
                return;
            }
            try (LevelStorageSource.LevelStorageAccess access = LegacySaveCache.getLevelStorageSource().createAccess(LegacySaveCache.importSaveFile(t.open(), arg_0 -> ((LevelStorageSource)this.minecraft.getLevelSource()).levelExists(arg_0), LegacySaveCache.getLevelStorageSource(), t.folderName()));){
                LevelSummary summary = access.getSummary(access.getDataTag());
                access.close();
                if (t.directJoin()) {
                    LoadSaveScreen.loadWorld(this.getScreen(), this.minecraft, LegacySaveCache.getLevelStorageSource(), summary);
                } else {
                    this.minecraft.setScreen((Screen)new LoadSaveScreen(this, this.getScreen(), summary, access, t.isLocked()){

                        @Override
                        public void onClose() {
                            if (!((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                                FileUtils.deleteQuietly((File)this.access.getDimensionPath(Level.OVERWORLD).toFile());
                            }
                            super.onClose();
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static void addIconButton(RenderableVList list, ResourceLocation iconSprite, Component message, Consumer<AbstractButton> onPress) {
        CreationList.addIconButton(list, iconSprite, message, onPress, null);
    }

    public static void addIconButton(RenderableVList list, final ResourceLocation iconSprite, Component message, final Consumer<AbstractButton> onPress, Tooltip tooltip) {
        ContentButton button = new ContentButton(list, 0, 0, 270, 30, message){

            @Override
            public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(iconSprite, this.getX() + x, this.getY() + y, width, height);
            }

            public void onPress(InputWithModifiers input) {
                onPress.accept(this);
            }
        };
        list.addRenderable((Renderable)button);
        button.setTooltip(tooltip);
    }

    public static abstract class ContentButton
    extends AbstractButton {
        protected final RenderableVList list;

        public ContentButton(RenderableVList list, int x, int y, int width, int height, Component component) {
            super(x, y, width, height, component);
            this.list = list;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            super.renderWidget(guiGraphics, i, j, f);
            if (this.list.accessor.getBoolean(this.list.name + ".buttonIcon.isVisible", Boolean.valueOf(true)).booleanValue()) {
                this.renderIcon(guiGraphics, i, j, f);
            }
        }

        public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            int iconWidth = this.list.accessor.getInteger(this.list.name + ".buttonIcon.width", 20);
            int iconHeight = this.list.accessor.getInteger(this.list.name + ".buttonIcon.height", 20);
            int iconPos = (this.height - iconHeight) / 2;
            this.renderIcon(guiGraphics, mouseX, mouseY, iconPos, iconPos, iconWidth, iconHeight);
            if (((Boolean)Minecraft.getInstance().options.touchscreen().get()).booleanValue() || this.isHovered) {
                this.renderIconHighlight(guiGraphics, mouseX, mouseY, iconPos, iconPos, iconWidth, iconHeight);
            }
        }

        public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
        }

        public void renderIconHighlight(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            guiGraphics.fill(this.getX() + x, this.getY() + y, this.getX() + x + width, this.getY() + y + height, -1601138544);
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + this.list.accessor.getInteger(this.list.name + ".buttonMessage.xOffset", 35), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), j, true));
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

