/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.client.LegacySoundUtil;

public class TabList
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final List<LegacyTabButton> tabButtons;
    protected final UIAccessor accessor;
    public LegacyTabButton selected = null;
    boolean focused = false;
    private int selectedIndex = 0;

    public TabList(UIAccessor uiAccessor) {
        this(uiAccessor, new ArrayList<LegacyTabButton>());
    }

    public TabList(UIAccessor accessor, List<LegacyTabButton> list) {
        this.accessor = accessor;
        this.tabButtons = list;
    }

    public LegacyTabButton addTabButton(LegacyTabButton button) {
        this.tabButtons.add(button);
        if (this.selected == null) {
            this.selected = button;
        }
        return button;
    }

    public LegacyTabButton addTabButton(int x, int y, int width, int height, LegacyTabButton.Type type, LegacyTabButton.Render icon, Component message, Tooltip tooltip, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(new LegacyTabButton(x, y, width, height, type, icon, message, tooltip, t -> {
            if (this.selected != t) {
                this.selectedIndex = this.tabButtons.indexOf(t);
                this.selected = t;
                onPress.accept((LegacyTabButton)((Object)t));
            }
        }));
    }

    public LegacyTabButton addTabButton(int height, LegacyTabButton.Type type, LegacyTabButton.Render icon, Component component, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(0, 0, 0, height, type, icon, component, null, onPress);
    }

    public TabList add(int x, int y, int width, int height, LegacyTabButton.Type type, LegacyTabButton.Render icon, Component message, Tooltip tooltip, Consumer<LegacyTabButton> onPress) {
        this.addTabButton(x, y, width, height, type, icon, message, tooltip, onPress);
        return this;
    }

    public TabList add(LegacyTabButton.Type type, LegacyTabButton.Render icon, Component component, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, 0, 0, type, icon, component, null, onPress);
    }

    public TabList add(LegacyTabButton.Type type, Component component, Consumer<LegacyTabButton> onPress) {
        return this.add(type, null, component, onPress);
    }

    public TabList add(int width, int height, LegacyTabButton.Type type, LegacyTabButton.Render icon, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, width, height, type, icon, message, null, onPress);
    }

    public TabList add(int x, int y, int height, LegacyTabButton.Type type, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(x, y, 0, height, type, null, message, null, onPress);
    }

    public TabList add(int width, int height, LegacyTabButton.Type type, Component message, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, width, height, type, null, message, null, onPress);
    }

    public void init(int leftPos, int topPos, int width, int height) {
        this.init(leftPos, topPos, width, height, (t, i) -> {});
    }

    public void init(int leftPos, int topPos, int width, int height, BiConsumer<LegacyTabButton, Integer> buttonManager) {
        this.init("tabList", leftPos, topPos, width, height, buttonManager);
    }

    public void init(String name, int leftPos, int topPos, int width, int height, BiConsumer<LegacyTabButton, Integer> buttonManager) {
        this.init((b, i) -> {
            b.setHeight(this.accessor.getInteger(name + ".height", height));
            b.setWidth(width / this.tabButtons.size());
            b.setX(this.accessor.getInteger(name + ".x", leftPos) + i);
            b.setY(this.accessor.getInteger(name + ".y", topPos));
            b.offset = (LegacyTabButton.Offset)this.accessor.getElementValue(name + ".offset", (Object)LegacyTabButton.StateOffset.DEFAULT, LegacyTabButton.StateOffset.class);
            b.spriteRender = (LegacyTabButton.Render)this.accessor.getElementValue(name + ".sprites", (Object)LegacyTabButton.ToggleableTabSprites.DEFAULT, LegacyTabButton.Render.class);
            buttonManager.accept((LegacyTabButton)((Object)b), (Integer)i);
        }, false);
    }

    public void init(BiConsumer<LegacyTabButton, Integer> buttonManager, boolean vertical) {
        int position = 0;
        for (LegacyTabButton b : this.tabButtons) {
            buttonManager.accept(b, position);
            position += vertical ? b.getHeight() : b.getWidth();
        }
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        for (LegacyTabButton tabButton : this.tabButtons) {
            boolean bl = tabButton.selected = tabButton == this.selected;
            if (tabButton == this.selected) continue;
            tabButton.render(graphics, i, j, f);
        }
    }

    public void renderSelected(GuiGraphics graphics, int i, int j, float f) {
        if (this.selected != null) {
            this.selected.render(graphics, i, j, f);
        }
    }

    public void resetSelectedTab() {
        if (!this.tabButtons.isEmpty()) {
            this.selected = null;
            this.tabButtons.get(0).onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
        }
    }

    public void setSelected(int selected) {
        if (!this.tabButtons.isEmpty() && selected < this.tabButtons.size()) {
            this.tabButtons.get(selected).onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.tabButtons.stream().anyMatch(t -> t.isHoveredOrFocused() && t.keyPressed(keyEvent));
    }

    public boolean controlTab(int i) {
        return this.controlTab(i, 91, 93);
    }

    public boolean directionalControlTab(int i) {
        return this.controlTab(i, 263, 262);
    }

    public boolean controlTab(int i, int leftButton, int rightButton) {
        return this.controlTab(i == leftButton, i == rightButton);
    }

    public boolean controlTab(boolean left, boolean right) {
        if (!left && !right || this.tabButtons.isEmpty()) {
            return false;
        }
        Optional<LegacyTabButton> opt = this.tabButtons.stream().filter(AbstractWidget::isActive).min(Comparator.comparingInt(t -> {
            int diff = this.tabButtons.indexOf(t) - this.getIndex();
            return left ? (diff < 0 ? -diff : this.tabButtons.size() * 2 - diff) : (diff > 0 ? diff : this.tabButtons.size() * 2 + diff);
        }));
        if (opt.isPresent() && this.tabButtons.indexOf((Object)opt.get()) != this.getIndex()) {
            opt.get().onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        return false;
    }

    protected boolean controlPage(Stocker.Sizeable page, boolean left, boolean right) {
        if ((left || right) && page.max > 0) {
            int lastPage = (Integer)page.get();
            page.add(left ? -1 : 1);
            if (lastPage != (Integer)page.get()) {
                this.resetSelectedTab();
                return true;
            }
        }
        return false;
    }

    public void numberControlTab(int i) {
        if (i <= 57 && i > 48 && i - 49 < this.tabButtons.size()) {
            this.tabButtons.get(i - 49).onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        return !this.tabButtons.stream().filter(t -> t.mouseClicked(event, bl)).toList().isEmpty();
    }

    public boolean isMouseOver(double d, double e) {
        return !this.tabButtons.stream().filter(t -> t.isMouseOver(d, e)).toList().isEmpty();
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.tabButtons.stream().map(AbstractWidget::narrationPriority).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        Optional<LegacyTabButton> optional = this.tabButtons.stream().filter(AbstractWidget::isHovered).findFirst().or(() -> Optional.ofNullable(this.tabButtons.get(this.getIndex())));
        optional.ifPresent(tabButton -> {
            narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.tab", (Object[])new Object[]{this.getIndex() + 1, this.tabButtons.size()}));
            tabButton.updateNarration(narrationElementOutput);
        });
        if (this.isFocused()) {
            narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.tab_navigation.usage"));
        }
    }

    public int getIndex() {
        return this.selectedIndex;
    }

    public static interface Access {
        public TabList getTabList();

        default public int getTabYOffset() {
            int offset = 0;
            for (LegacyTabButton tabButton : this.getTabList().tabButtons) {
                if (tabButton.getHeight() <= offset) continue;
                offset = tabButton.getHeight();
            }
            return offset / 2;
        }

        default public int getTabXOffset() {
            return 0;
        }
    }
}

