/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldDataConfiguration;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.DatapackRepositoryAccessor;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.mixin.base.client.AbstractWidgetAccessor;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;

public class WorldMoreOptionsScreen
extends PanelVListScreen
implements ControlTooltip.Event,
DatapackRepositoryAccessor {
    public static final Component ENTER_SEED = Component.translatable((String)"selectWorld.enterSeed");
    public static final Component SEED_INFO = Component.translatable((String)"selectWorld.seedInfo");
    protected final TabList tabList;
    protected final RenderableVList gameRenderables;
    protected final Panel tooltipBox;
    protected List<FormattedCharSequence> tooltipBoxLabel;
    protected ScrollableRenderer scrollableRenderer;
    protected Runnable onClose;

    public WorldMoreOptionsScreen(CreateWorldScreen parent, Bearer<Boolean> trustPlayers) {
        super((Screen)parent, 244, 199, (Component)Component.translatable((String)"createWorld.tab.more.title"));
        this.tabList = new TabList(this.accessor).add(LegacyTabButton.Type.LEFT, (Component)Component.translatable((String)"createWorld.tab.world.title"), t -> this.rebuildWidgets()).add(LegacyTabButton.Type.RIGHT, (Component)Component.translatable((String)"legacy.menu.game_options"), t -> this.rebuildWidgets());
        this.gameRenderables = new RenderableVList(this.accessor);
        this.tooltipBox = Panel.tooltipBoxOf(this.panel, 188);
        this.scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
        this.onClose = () -> {};
        this.renderableVLists.add(this.gameRenderables);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.createDrawString((Component)ENTER_SEED, (int)0, (int)1, (int)2, (int)9, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), (boolean)false));
        EditBox editBox = new EditBox(this, Minecraft.getInstance().font, 0, 0, 308, 20, ENTER_SEED){

            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(CommonComponents.NARRATION_SEPARATOR).append(SEED_INFO);
            }
        };
        editBox.setValue(parent.getUiState().getSeed());
        editBox.setResponder(string -> parent.getUiState().setSeed(editBox.getValue()));
        this.renderableVList.addRenderable((Renderable)editBox);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.drawString(Minecraft.getInstance().font, SEED_INFO, r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.getUiState().isGenerateStructures(), b -> Component.translatable((String)"selectWorld.mapFeatures"), b -> Tooltip.create((Component)Component.translatable((String)"selectWorld.mapFeatures.info")), b -> parent.getUiState().setGenerateStructures(b.selected)));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.getUiState().isBonusChest(), b -> Component.translatable((String)"selectWorld.bonusItems"), b -> null, b -> parent.getUiState().setBonusChest(b.selected)));
        this.renderableVList.addRenderable((Renderable)new LegacySliderButton<WorldCreationUiState.WorldTypeEntry>(0, 0, 0, 16, s -> s.getDefaultMessage((Component)Component.translatable((String)"selectWorld.mapType"), parent.getUiState().getWorldType().describePreset()), b -> parent.getUiState().getWorldType().isAmplified() ? Tooltip.create((Component)Component.translatable((String)"generator.minecraft.amplified.info")) : null, parent.getUiState().getWorldType(), () -> CycleButton.DEFAULT_ALT_LIST_SELECTOR.getAsBoolean() ? parent.getUiState().getAltPresetList() : parent.getUiState().getNormalPresetList(), b -> parent.getUiState().setWorldType((WorldCreationUiState.WorldTypeEntry)b.objectValue)));
        Button customizeButton = Button.builder((Component)Component.translatable((String)"selectWorld.customizeType"), button -> {
            PresetEditor presetEditor = parent.getUiState().getPresetEditor();
            if (presetEditor != null) {
                this.minecraft.setScreen(presetEditor.createEditScreen(parent, parent.getUiState().getSettings()));
            }
        }).build();
        parent.getUiState().addListener(s -> {
            customizeButton.active = !s.isDebug() && s.getPresetEditor() != null;
        });
        this.renderableVList.addRenderable((Renderable)customizeButton);
        this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> {}));
        TickBox hostPrivileges = new TickBox(0, 0, parent.getUiState().isAllowCommands(), b -> LegacyComponents.HOST_PRIVILEGES, b -> Tooltip.create((Component)LegacyComponents.HOST_PRIVILEGES_INFO), b -> parent.getUiState().setAllowCommands(b.selected));
        parent.getUiState().addListener(s -> {
            hostPrivileges.active = !s.isDebug() && !s.isHardcore();
        });
        GameRules gameRules = parent.getUiState().getGameRules();
        Pair pair = parent.getDataPackSelectionSettings(parent.getUiState().getSettings().dataConfiguration());
        if (pair != null) {
            this.renderableVList.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"selectWorld.experiments"), r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
            PackRepository dataRepository = (PackRepository)pair.getSecond();
            ArrayList selectedExperiments = new ArrayList(dataRepository.getSelectedIds());
            dataRepository.getAvailablePacks().forEach(p -> {
                if (p.getPackSource() != PackSource.FEATURE) {
                    return;
                }
                String id = "dataPack." + p.getId() + ".name";
                MutableComponent name = Language.getInstance().has(id) ? Component.translatable((String)id) : p.getTitle();
                this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, selectedExperiments.contains(p.getId()), arg_0 -> WorldMoreOptionsScreen.lambda$new$26((Component)name, arg_0), b -> new MultilineTooltip(this.tooltipBox.getWidth() - 10, p.getDescription()), b -> {
                    if (b.selected && !selectedExperiments.contains(p.getId())) {
                        selectedExperiments.add(p.getId());
                    } else if (!b.selected) {
                        selectedExperiments.remove(p.getId());
                    }
                }));
            });
            this.onClose = () -> {
                dataRepository.setSelected((Collection)selectedExperiments);
                parent.tryApplyNewDataPacks(dataRepository, false, w -> this.minecraft.setScreen((Screen)this));
            };
        }
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"selectWorld.dataPacks"), button -> this.openDataPackSelectionScreen(parent, parent.getUiState().getSettings().dataConfiguration())).build());
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, (Boolean)trustPlayers.get(), b -> Component.translatable((String)"legacy.menu.selectWorld.trust_players"), b -> null, t -> trustPlayers.set((Object)t.selected)));
        this.addGameRulesOptions(this.renderableVList, gameRules, k -> k.getCategory() == GameRules.Category.UPDATES);
        this.gameRenderables.addRenderable((Renderable)hostPrivileges);
        for (GameRules.Category value : GameRules.Category.values()) {
            if (value == GameRules.Category.UPDATES) continue;
            this.addGameRulesOptions(this.gameRenderables, gameRules, k -> k.getCategory() == value);
        }
        parent.getUiState().onChanged();
    }

    public WorldMoreOptionsScreen(LoadSaveScreen parent) {
        super(parent, 244, 199, (Component)Component.translatable((String)"createWorld.tab.more.title"));
        this.tabList = new TabList(this.accessor).add(LegacyTabButton.Type.LEFT, (Component)Component.translatable((String)"createWorld.tab.world.title"), t -> this.rebuildWidgets()).add(LegacyTabButton.Type.RIGHT, (Component)Component.translatable((String)"legacy.menu.game_options"), t -> this.rebuildWidgets());
        this.gameRenderables = new RenderableVList(this.accessor);
        this.tooltipBox = Panel.tooltipBoxOf(this.panel, 188);
        this.scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
        this.onClose = () -> {};
        this.renderableVLists.add(this.gameRenderables);
        this.tabList.setSelected(1);
        GameRules gameRules = parent.summary.getSettings().gameRules();
        LoadSaveScreen.RESETTABLE_DIMENSIONS.forEach(d -> this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.dimensionsToReset.contains(d), b -> Component.translatable((String)"legacy.menu.load_save.reset", (Object[])new Object[]{LegacyComponents.getDimensionName((ResourceKey<Level>)d)}), b -> null, t -> {
            if (t.selected) {
                parent.dimensionsToReset.add((ResourceKey<Level>)d);
            } else {
                parent.dimensionsToReset.remove(d);
            }
        })));
        this.renderableVList.addRenderable((Renderable)new TickBox(0, 0, parent.trustPlayers, b -> Component.translatable((String)"legacy.menu.selectWorld.trust_players"), b -> null, t -> {
            parent.trustPlayers = t.selected;
        }));
        this.addGameRulesOptions(this.renderableVList, gameRules, k -> k.getCategory() == GameRules.Category.UPDATES);
        this.gameRenderables.addRenderable((Renderable)new TickBox(0, 0, parent.hostPrivileges, b -> LegacyComponents.HOST_PRIVILEGES, b -> Tooltip.create((Component)LegacyComponents.HOST_PRIVILEGES_INFO), b -> {
            parent.hostPrivileges = b.selected;
        }));
        for (GameRules.Category value : GameRules.Category.values()) {
            if (value == GameRules.Category.UPDATES) continue;
            this.addGameRulesOptions(this.gameRenderables, gameRules, k -> k.getCategory() == value);
        }
        parent.applyGameRules = (g, s) -> {
            if (!g.equals(gameRules)) {
                g.assignFrom(gameRules, s);
            }
        };
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.CONTROL_TAB.get(), () -> this.tabList.getIndex() == 0 ? LegacyComponents.GAME_OPTIONS : LegacyComponents.WORLD_OPTIONS);
    }

    public void addGameRulesOptions(final RenderableVList list, final GameRules gameRules, final Predicate<GameRules.Key<?>> allowGamerule) {
        gameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public void visitBoolean(GameRules.Key<GameRules.BooleanValue> key, GameRules.Type<GameRules.BooleanValue> type) {
                if (!allowGamerule.test(key)) {
                    return;
                }
                GameRules.BooleanValue value = (GameRules.BooleanValue)gameRules.getRule(key);
                GameRules.BooleanValue defaultValue = (GameRules.BooleanValue)type.createRule();
                MutableComponent tooltip = Component.translatable((String)(key.getDescriptionId() + ".description"));
                MutableComponent valueTooltip = Component.translatable((String)"editGamerule.default", (Object[])new Object[]{defaultValue.serialize()}).withStyle(ChatFormatting.GRAY);
                list.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)gameRules.getRule(key)).get(), b -> Component.translatable((String)key.getDescriptionId()), arg_0 -> this.lambda$visitBoolean$1((Component)tooltip, (Component)valueTooltip, arg_0), b -> value.set(b.selected, null)));
            }

            public void visitInteger(GameRules.Key<GameRules.IntegerValue> key, GameRules.Type<GameRules.IntegerValue> type) {
                if (!allowGamerule.test(key)) {
                    return;
                }
                GameRules.IntegerValue value = (GameRules.IntegerValue)gameRules.getRule(key);
                GameRules.IntegerValue defaultValue = (GameRules.IntegerValue)type.createRule();
                MutableComponent tooltip = Component.translatable((String)(key.getDescriptionId() + ".description"));
                MutableComponent valueTooltip = Component.translatable((String)"editGamerule.default", (Object[])new Object[]{defaultValue.serialize()}).withStyle(ChatFormatting.GRAY);
                EditBox integerEdit = new EditBox(Minecraft.getInstance().font, 0, 0, 220, 20, (Component)Component.translatable((String)key.getDescriptionId()));
                integerEdit.setTooltip((Tooltip)new MultilineTooltip(WorldMoreOptionsScreen.this.tooltipBox.width - 10, new Component[]{tooltip, valueTooltip}));
                integerEdit.setValue(Integer.toString(value.get()));
                integerEdit.setResponder(string -> {
                    if (value.tryDeserialize(string)) {
                        integerEdit.setTextColor(-2039584);
                        value.set(Integer.parseInt(string), null);
                    } else {
                        integerEdit.setTextColor(-65536);
                    }
                });
                list.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)9, r -> (guiGraphics, i, j, f) -> guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)key.getDescriptionId()), r.x + 1, r.y + 2, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false)));
                list.addRenderable((Renderable)integerEdit);
            }

            private /* synthetic */ Tooltip lambda$visitBoolean$1(Component tooltip, Component valueTooltip, Boolean b) {
                return new MultilineTooltip(WorldMoreOptionsScreen.this.tooltipBox.width - 10, tooltip, valueTooltip);
            }
        });
    }

    @Override
    public void onClose() {
        super.onClose();
        this.onClose.run();
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.tooltipBox.isHovered(d, e) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        if (LegacyRenderUtil.hasTooltipBoxes(this.accessor)) {
            AbstractWidgetAccessor widget;
            Object object = this.getFocused();
            if (object instanceof AbstractWidgetAccessor && (widget = (AbstractWidgetAccessor)object).getTooltip() != null && widget.getTooltip().get() != null) {
                this.tooltipBoxLabel = widget.getTooltip().get().toCharSequence(this.minecraft);
            } else {
                AbstractWidgetAccessor widget2;
                Optional listener = this.getChildAt(i, j);
                if (listener.isPresent() && (object = listener.get()) instanceof AbstractWidgetAccessor && (widget2 = (AbstractWidgetAccessor)object).getTooltip() != null && widget2.getTooltip().get() != null) {
                    widget2.getTooltip().get().toCharSequence(this.minecraft);
                } else {
                    this.tooltipBoxLabel = null;
                }
            }
            if (this.tooltipBoxLabel == null) {
                this.scrollableRenderer.resetScrolled();
            } else {
                this.scrollableRenderer.scrolled.max = Math.max(0, this.tooltipBoxLabel.size() - (this.tooltipBox.getHeight() - 44) / 12);
            }
            this.tooltipBox.render(guiGraphics, i, j, f);
            if (this.tooltipBoxLabel != null) {
                this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 3, this.panel.y + 13, this.tooltipBox.width - 10, this.tooltipBox.getHeight() - 44, () -> this.tooltipBoxLabel.forEach(c -> guiGraphics.drawString(this.font, c, this.panel.x + this.panel.width + 3, this.panel.y + 13 + this.tooltipBoxLabel.indexOf(c) * 12, -1)));
            }
        }
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        this.tabList.controlTab(keyEvent.key());
        return super.keyPressed(keyEvent);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return (RenderableVList)this.renderableVLists.get(this.tabList.getIndex());
    }

    @Override
    protected void init() {
        this.addRenderableWidget(this.tabList);
        super.init();
        this.addRenderableOnly(this.tabList::renderSelected);
        this.tabList.init(this.panel.x, this.panel.y - 24, this.panel.width, 30);
    }

    @Override
    public void renderableVListInit() {
        if (LegacyRenderUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBox.init();
        }
        super.renderableVListInit();
    }

    protected void openDataPackSelectionScreen(CreateWorldScreen screen, WorldDataConfiguration worldDataConfiguration) {
        Pair pair = screen.getDataPackSelectionSettings(worldDataConfiguration);
        if (pair != null) {
            this.minecraft.setScreen((Screen)new PackSelectionScreen((PackRepository)pair.getSecond(), packRepository -> screen.tryApplyNewDataPacks(packRepository, true, d -> this.openDataPackSelectionScreen(screen, (WorldDataConfiguration)d)), (Path)pair.getFirst(), (Component)Component.translatable((String)"dataPack.title")));
        }
    }

    public PackRepository getDatapackRepository() {
        PackRepository packRepository;
        Screen screen = this.parent;
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            packRepository = (PackRepository)screen2.getDataPackSelectionSettings(screen2.getUiState().getSettings().dataConfiguration()).getSecond();
        } else {
            packRepository = null;
        }
        return packRepository;
    }

    public void tryApplyNewDataPacks(PackRepository packRepository) {
        Screen screen = this.parent;
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            screen2.tryApplyNewDataPacks(packRepository, false, w -> this.minecraft.setScreen((Screen)this));
        }
    }

    private static /* synthetic */ Component lambda$new$26(Component name, Boolean b) {
        return name;
    }
}

