/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.entity;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.mixin.base.ClientBoundAwardStatsPacketAccessor;

public interface LegacyPlayerInfo {
    public static LegacyPlayerInfo of(Object obj) {
        return (LegacyPlayerInfo)obj;
    }

    public static void updateMayFlySurvival(ServerPlayer player, boolean mayFlySurvival, boolean updateAbilities) {
        LegacyPlayerInfo.of(player).setMayFlySurvival(mayFlySurvival);
        if (player.getAbilities().mayfly != mayFlySurvival && player.gameMode.isSurvival()) {
            player.getAbilities().mayfly = mayFlySurvival;
            if (!player.getAbilities().mayfly && player.getAbilities().flying) {
                player.getAbilities().flying = false;
            }
            if (updateAbilities) {
                player.onUpdateAbilities();
            }
        }
    }

    public static LegacyPlayerInfo decode(CommonNetwork.PlayBuf buf) {
        return new Instance(((RegistryFriendlyByteBuf)buf.get()).readVarInt(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean(), (Object2IntMap)ClientBoundAwardStatsPacketAccessor.getStatsValueCodec().decode((Object)((RegistryFriendlyByteBuf)buf.get())));
    }

    public static void encode(CommonNetwork.PlayBuf buf, LegacyPlayerInfo info) {
        ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(info.getIdentifierIndex());
        ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(info.isVisible());
        ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(info.isExhaustionDisabled());
        ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(info.mayFlySurvival());
        ClientBoundAwardStatsPacketAccessor.getStatsValueCodec().encode((Object)((RegistryFriendlyByteBuf)buf.get()), info.getStatsMap());
    }

    default public GameProfile legacyMinecraft$getProfile() {
        return null;
    }

    public int getIdentifierIndex();

    public void setIdentifierIndex(int var1);

    public boolean isVisible();

    public void setVisibility(boolean var1);

    public boolean isExhaustionDisabled();

    public void setDisableExhaustion(boolean var1);

    public boolean mayFlySurvival();

    public void setMayFlySurvival(boolean var1);

    public Object2IntMap<Stat<?>> getStatsMap();

    public void setStatsMap(Object2IntMap<Stat<?>> var1);

    default public void copyFrom(LegacyPlayerInfo info) {
        this.setIdentifierIndex(info.getIdentifierIndex());
        this.setVisibility(info.isVisible());
        this.setDisableExhaustion(info.isExhaustionDisabled());
        this.setMayFlySurvival(info.mayFlySurvival());
        this.setStatsMap(info.getStatsMap());
    }

    public static class Instance
    implements LegacyPlayerInfo {
        int index = -1;
        boolean visibility = true;
        boolean disableExhaustion;
        boolean mayFlySurvival = false;
        Object2IntMap<Stat<?>> statsMap;

        public Instance(int index, boolean invisible, boolean disableExhaustion, boolean mayFlySurvival, Object2IntMap<Stat<?>> object2IntMap) {
            this.setIdentifierIndex(index);
            this.setVisibility(invisible);
            this.setDisableExhaustion(disableExhaustion);
            this.setMayFlySurvival(mayFlySurvival);
            this.setStatsMap(object2IntMap);
        }

        @Override
        public int getIdentifierIndex() {
            return this.index;
        }

        @Override
        public void setIdentifierIndex(int i) {
            this.index = i;
        }

        @Override
        public boolean isVisible() {
            return this.visibility;
        }

        @Override
        public void setVisibility(boolean visible) {
            this.visibility = visible;
        }

        @Override
        public boolean isExhaustionDisabled() {
            return this.disableExhaustion;
        }

        @Override
        public void setDisableExhaustion(boolean exhaustion) {
            this.disableExhaustion = exhaustion;
        }

        @Override
        public boolean mayFlySurvival() {
            return this.mayFlySurvival;
        }

        @Override
        public void setMayFlySurvival(boolean mayFly) {
            this.mayFlySurvival = mayFly;
        }

        @Override
        public Object2IntMap<Stat<?>> getStatsMap() {
            return this.statsMap;
        }

        @Override
        public void setStatsMap(Object2IntMap<Stat<?>> statsMap) {
            this.statsMap = statsMap;
        }
    }
}

