/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.AnimatedCharacterRenderer;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacySlotWidget;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen
implements LegacyMenuAccess,
ControlTooltip.Event {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    @Final
    protected AbstractContainerMenu menu;
    @Shadow
    @Final
    protected Set<Slot> quickCraftSlots;
    @Shadow
    protected boolean isQuickCrafting;
    @Shadow
    protected int imageWidth;
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    protected int imageHeight;
    @Shadow
    private Slot clickedSlot;
    @Shadow
    private ItemStack draggingItem;
    @Shadow
    private boolean isSplittingStack;
    @Shadow
    private int quickCraftingType;
    @Shadow
    private boolean skipNextRelease;
    @Shadow
    private boolean doubleclick;
    @Unique
    private long lastUpPressedTime;
    @Unique
    private final List<LegacySlotWidget> slotWidgets = new ArrayList<LegacySlotWidget>();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Shadow
    protected abstract void recalculateQuickCraftRemaining();

    @Shadow
    protected abstract boolean hasClickedOutside(double var1, double var3, int var5, int var6);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component, CallbackInfo ci) {
        for (Slot slot : abstractContainerMenu.slots) {
            this.slotWidgets.add(new LegacySlotWidget(slot));
        }
        UIAccessor.of((Screen)this).addStatic(UIDefinition.createAfterInit(accessor -> {
            for (LegacySlotWidget slotWidget : this.slotWidgets) {
                this.addWidget(slotWidget);
            }
        }));
    }

    @ModifyArg(method={"renderLabels"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"), index=4)
    private int renderLabels(int i) {
        return (Integer)CommonColor.INVENTORY_GRAY_TEXT.get();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (Legacy4JClient.keyCrafting.matches(keyEvent)) {
            this.onClose();
            cir.setReturnValue((Object)true);
        }
        if (keyEvent.key() == 87 && this.hoveredSlot != null && this.hoveredSlot.hasItem() && !this.minecraft.screen.isDragging() && LegacyTipManager.setTip(LegacyTipManager.getTip(this.hoveredSlot.getItem().copy()))) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")})
    private void mouseClicked(MouseButtonEvent event, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        boolean downPressed = Legacy4JClient.controllerManager.getButtonState(ControllerBinding.DOWN_BUTTON).justPressed;
        boolean upPressed = Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).justPressed;
        if (Util.getMillis() - this.lastUpPressedTime < 250L && downPressed) {
            this.doubleclick = false;
        }
        if (upPressed) {
            this.lastUpPressedTime = Util.getMillis();
        }
        if (!this.skipNextRelease) {
            boolean leftPressed = Legacy4JClient.controllerManager.getButtonState(ControllerBinding.LEFT_BUTTON).justPressed;
            if (downPressed || upPressed || leftPressed) {
                this.mouseReleased(new MouseButtonEvent(Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY(), new MouseButtonInfo(leftPressed ? 1 : 0, event.modifiers())));
                this.skipNextRelease = true;
            }
        }
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z")})
    private boolean mouseClickedWidgets(AbstractContainerScreen instance, MouseButtonEvent event, boolean b, Operation<Boolean> original) {
        if (((Boolean)original.call(new Object[]{instance, event, b})).booleanValue()) {
            return true;
        }
        LegacySoundUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        return false;
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    public void mouseReleasedNoDoubleClick(MouseButtonEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (Legacy4JClient.controllerManager.isControllerTheLastInput() && !((Boolean)LegacyOptions.controllerDoubleClick.get()).booleanValue()) {
            this.doubleclick = false;
        }
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFloatingItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)Legacy4JClient.controllerManager.getPointerX() - 10.0f, (float)Legacy4JClient.controllerManager.getPointerY() - 10.0f);
        if (!LegacyOptions.getUIMode().isSD()) {
            guiGraphics.pose().scale(1.5f, 1.5f);
        }
        guiGraphics.renderItem(itemStack, 0, 0);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemStack, 0, this.draggingItem.isEmpty() ? 0 : -8, string == null && this.isQuickCrafting && this.quickCraftSlots.size() > 1 && itemStack.getCount() == 1 ? String.valueOf(itemStack.getCount()) : string);
        guiGraphics.pose().popMatrix();
        ci.cancel();
    }

    @Inject(method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isHovering(Slot slot, double d, double e, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)LegacyRenderUtil.isHovering(slot, this.leftPos, this.topPos, d, e));
    }

    @Inject(method={"renderSlotHighlightFront"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSlotHighlightFront(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"renderSlotHighlightBack"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSlotHighlightBack(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
    }

    @ModifyExpressionValue(method={"renderSlots"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;isActive()Z")})
    private boolean renderSlots(boolean original, @Local Slot slot) {
        return original && LegacySlotDisplay.of(slot).isVisible();
    }

    @Inject(method={"renderSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSlot(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        ci.cancel();
        LegacySlotWidget widget = this.slotWidgets.get(slot.index);
        boolean bl = widget.isVisible = slot.isActive() && LegacySlotDisplay.of(slot).isVisible();
        if (!widget.isVisible) {
            return;
        }
        ItemStack itemStack = slot.getItem();
        boolean bl2 = false;
        boolean bl22 = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack itemStack2 = this.menu.getCarried();
        String string = null;
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                bl22 = true;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.menu.canDragTo(slot)) {
                bl2 = true;
                int k = Math.min(itemStack2.getMaxStackSize(), slot.getMaxStackSize(itemStack2));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int m = AbstractContainerMenu.getQuickCraftPlaceCount(this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack2) + l;
                if (m > k) {
                    m = k;
                    string = ChatFormatting.YELLOW.toString() + k;
                }
                itemStack = itemStack2.copyWithCount(m);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        widget.slotBounds(this.leftPos, this.topPos, slot, bl22 ? ItemStack.EMPTY : itemStack);
        widget.quickCraftHighlight = !bl22 && bl2;
        widget.isHovered = this.hoveredSlot == slot;
        widget.quickCraftText = string;
        widget.itemSeed = slot.x + slot.y * this.imageWidth;
        if (widget.iconSprite == null && widget.itemIcon.isEmpty()) {
            widget.iconSprite = slot.getNoItemIcon();
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(-this.leftPos), (float)(-this.topPos));
        widget.render(guiGraphics, 0, 0, 0.0f);
        guiGraphics.pose().popMatrix();
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderTooltip(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        if (this.hoveredSlot == null || !LegacySlotDisplay.isVisibleAndActive(this.hoveredSlot)) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/input/MouseButtonEvent;hasShiftDown()Z")})
    public boolean mouseClickedShift(boolean original) {
        return original || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).pressed;
    }

    @ModifyExpressionValue(method={"mouseReleased"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/input/MouseButtonEvent;hasShiftDown()Z")})
    public boolean mouseReleasedShift0(boolean original) {
        return original || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).released || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).justPressed;
    }

    @Inject(method={"onClose"}, at={@At(value="RETURN")})
    public void onClose(CallbackInfo ci) {
        if (LegacyItemUtil.anyArmorSlotMatch(this.minecraft.player.getInventory(), i -> !i.isEmpty())) {
            AnimatedCharacterRenderer.updateTime(1500L);
        }
        this.menu.slots.forEach(s -> LegacySlotDisplay.override(s, LegacySlotDisplay.VANILLA));
    }

    @Override
    public boolean isOutsideClick(int i) {
        return this.hasClickedOutside(Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY(), this.leftPos, this.topPos);
    }

    @Override
    public boolean isMouseDragging() {
        return this.isDragging();
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Override
    public ScreenRectangle getMenuRectangle() {
        return new ScreenRectangle(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    @Redirect(method={"renderTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))
    public boolean renderTooltip(ItemStack instance) {
        return true;
    }
}

