/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.loom;

import com.mojang.blaze3d.platform.Lighting;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.render.state.pip.GuiBannerResultRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.model.BannerFlagModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.MutablePIPRenderState;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={LoomScreen.class})
public abstract class LoomScreenMixin
extends AbstractContainerScreen<LoomMenu> {
    @Shadow
    private boolean hasMaxPatterns;
    @Shadow
    private boolean displayPatterns;
    @Shadow
    private int startRow;
    @Shadow
    private BannerFlagModel flag;
    @Shadow
    private boolean scrolling;
    @Shadow
    @Nullable
    private BannerPatternLayers resultBannerPatterns;
    private final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();

    public LoomScreenMixin(LoomMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Shadow
    protected abstract int totalRowCount();

    @Shadow
    protected abstract void renderBannerOnButton(GuiGraphics var1, int var2, int var3, TextureAtlasSprite var4);

    @Inject(method={"init"}, at={@At(value="HEAD")})
    public void init(CallbackInfo ci) {
        this.imageWidth = 215;
        this.imageHeight = 217;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 104;
        this.titleLabelX = 14;
        this.titleLabelY = 10;
        super.init();
        for (int i = 0; i < ((LoomMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((LoomMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 19, 41, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.BANNER_SLOT;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 45, 41, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.DYE_SLOT;
                    }
                });
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 32, 66, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.PATTERN_SLOT;
                    }
                });
                continue;
            }
            if (i == 3) {
                LegacySlotDisplay.override(s, 166, 75, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < ((LoomMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 115 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 185);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 72, this.topPos + 18, 75, 75);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.5f, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 164, this.topPos + 7, 32, 64);
        guiGraphics.pose().popMatrix();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.leftPos + 149.5f, (float)(this.topPos + 18));
        if (this.displayPatterns && ((LoomMenu)this.menu).getSelectablePatterns().size() > 4) {
            if (this.startRow != this.totalRowCount() - 4) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, 79);
            }
            if (this.startRow > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 0.5f);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 13, 75);
        guiGraphics.pose().translate(-2.0f, -1.0f + (((LoomMenu)this.menu).getSelectablePatterns().size() > 4 && this.displayPatterns ? 61.5f * (float)this.startRow / (float)(this.totalRowCount() - 4) : 0.0f));
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearBlitColor();
        guiGraphics.pose().popMatrix();
        if (this.resultBannerPatterns != null && !this.hasMaxPatterns) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate(0.5f, 0.0f);
            DyeColor dyeColor = ((BannerItem)((LoomMenu)this.menu).getResultSlot().getItem().getItem()).getColor();
            GuiBannerResultRenderState renderState = new GuiBannerResultRenderState(this.flag, dyeColor, this.resultBannerPatterns, this.leftPos, this.topPos, this.leftPos + 360, this.topPos + 69, guiGraphics.scissorStack.peek());
            MutablePIPRenderState.of((PictureInPictureRenderState)renderState).setScale(24.0f);
            MutablePIPRenderState.of((PictureInPictureRenderState)renderState).setPose((Matrix3x2f)guiGraphics.pose());
            guiGraphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)renderState);
            guiGraphics.pose().popMatrix();
        } else if (this.hasMaxPatterns) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOOM_ERROR, this.leftPos + ((Slot)((LoomMenu)this.menu).slots.get((int)3)).x - 5, this.topPos + ((Slot)((LoomMenu)this.menu).slots.get((int)3)).y - 5, 26, 26);
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.leftPos + 73.5f, (float)this.topPos + 19.5f);
        if (this.displayPatterns) {
            List list = ((LoomMenu)this.menu).getSelectablePatterns();
            block0: for (int p = 0; p < 4; ++p) {
                for (int q = 0; q < 4; ++q) {
                    int r = p + this.startRow;
                    int s = r * 4 + q;
                    if (s >= list.size()) break block0;
                    int t = q * 18;
                    int u = p * 18;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(s == ((LoomMenu)this.menu).getSelectedBannerPatternIndex() ? LegacySprites.BUTTON_SLOT_SELECTED : (LegacyRenderUtil.isMouseOver(i, j, (float)this.leftPos + 73.5f + (float)t, (float)this.topPos + 19.5f + (float)u, 18, 18) ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT), t, u, 18, 18);
                    TextureAtlasSprite sprite = guiGraphics.getSprite(Sheets.getBannerMaterial((Holder)((Holder)list.get(s))));
                    guiGraphics.pose().pushMatrix();
                    guiGraphics.pose().translate((float)t + 5.5f, (float)u + 1.5f);
                    float u0 = sprite.getU0();
                    float g = u0 + (sprite.getU1() - sprite.getU0()) * 21.0f / 64.0f;
                    float h = sprite.getV1() - sprite.getV0();
                    float k = sprite.getV0() + h / 64.0f;
                    float l = k + h * 40.0f / 64.0f;
                    guiGraphics.fill(0, 0, 7, 15, DyeColor.GRAY.getTextureDiffuseColor());
                    guiGraphics.blit(sprite.atlasLocation(), 0, 0, 7, 15, u0, g, k, l);
                    guiGraphics.pose().popMatrix();
                }
            }
        }
        guiGraphics.pose().popMatrix();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(MouseButtonEvent event, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        this.scrolling = false;
        if (this.displayPatterns) {
            double j = (float)this.leftPos + 73.5f;
            double k = (float)this.topPos + 19.5f;
            for (int l = 0; l < 4; ++l) {
                for (int m = 0; m < 4; ++m) {
                    double f = event.x() - (j + (double)(m * 18));
                    double g = event.y() - (k + (double)(l * 18));
                    int n = l + this.startRow;
                    int o = n * 4 + m;
                    if (!(f >= 0.0 && g >= 0.0 && f < 18.0 && g < 18.0 && ((LoomMenu)this.menu).clickMenuButton((Player)this.minecraft.player, o))) continue;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_LOOM_SELECT_PATTERN, (float)1.0f));
                    this.minecraft.gameMode.handleInventoryButtonClick(((LoomMenu)this.menu).containerId, o);
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            if (LegacyRenderUtil.isMouseOver(event.x(), event.y(), (double)this.leftPos + 149.5, this.topPos + 18, 13, 75)) {
                this.scrolling = true;
            }
        }
        cir.setReturnValue((Object)super.mouseClicked(event, bl));
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseDragged(MouseButtonEvent event, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        int j = this.totalRowCount() - 4;
        if (this.scrolling && this.displayPatterns && j > 0) {
            int oldRow = this.startRow;
            this.startRow = (int)Math.max(Math.round((double)j * Math.min(1.0, (event.y() - (double)(this.topPos + 18)) / 75.0)), 0L);
            if (oldRow != this.startRow) {
                this.scrollRenderer.updateScroll(oldRow - this.startRow > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.mouseDragged(event, f, g));
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/LoomScreen;startRow:I"))
    private void mouseScrolled(LoomScreen instance, int value) {
        if (this.startRow != value) {
            this.scrollRenderer.updateScroll(this.startRow - value > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            this.startRow = value;
        }
    }
}

