/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.block.entity.BannerPattern;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.util.JsonUtil;

public class LoomTabListing
implements LegacyTabInfo {
    public static final Codec<List<ResourceKey<BannerPattern>>> PATTERNS_CODEC = ResourceKey.codec((ResourceKey)Registries.BANNER_PATTERN).listOf().xmap(ArrayList::new, Function.identity());
    public static final Codec<LoomTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LoomTabListing::id), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(LoomTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.fieldOf("icon").forGetter(LoomTabListing::iconHolder), (App)PATTERNS_CODEC.fieldOf("listing").forGetter(LoomTabListing::patterns)).apply((Applicative)i, LoomTabListing::new));
    public static final ListMap<ResourceLocation, LoomTabListing> map = new ListMap();
    private static final String LOOM_TAB_LISTING = "loom_tab_listing.json";
    private final ResourceLocation id;
    private Component name;
    private LegacyTabButton.IconHolder<?> iconHolder;
    private final List<ResourceKey<BannerPattern>> patterns;

    @Deprecated
    public LoomTabListing(ResourceLocation id, Component displayName, LegacyTabButton.IconHolder<?> iconHolder) {
        this(id, displayName, iconHolder, new ArrayList<ResourceKey<BannerPattern>>());
    }

    public LoomTabListing(ResourceLocation id, Component displayName, LegacyTabButton.IconHolder<?> iconHolder, List<ResourceKey<BannerPattern>> patterns) {
        this.id = id;
        this.name = displayName;
        this.iconHolder = iconHolder;
        this.patterns = patterns;
    }

    @Override
    public boolean isValid() {
        return LegacyTabInfo.super.isValid() && !this.patterns.isEmpty();
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public LegacyTabButton.IconHolder<?> iconHolder() {
        return this.iconHolder;
    }

    public List<ResourceKey<BannerPattern>> patterns() {
        return this.patterns;
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public String getName() {
            return "legacy:loom_tab_listing";
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            map.clear();
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            JsonUtil.getOrderedNamespaces(manager).forEach(name -> manager.getResource(FactoryAPI.createLocation((String)name, (String)LoomTabListing.LOOM_TAB_LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.openAsReader();){
                    JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
                    if (element instanceof JsonObject) {
                        JsonObject obj = (JsonObject)element;
                        Legacy4J.LOGGER.warn("The Loom Tab Listing {} is using a deprecated syntax, please contact this resource creator or try updating it.", (Object)(name + ":loom_tab_listing.json"));
                        obj.asMap().forEach((c, ce) -> {
                            ResourceLocation id = FactoryAPI.createLocation((String)c);
                            if (ce instanceof JsonObject) {
                                JsonObject go = (JsonObject)ce;
                                JsonElement listingElement = go.get("listing");
                                if (map.containsKey((Object)id)) {
                                    LoomTabListing l = (LoomTabListing)map.get((Object)id);
                                    JsonUtil.ifJsonStringNotNull(go, "displayName", Component::translatable, n -> {
                                        l.name = n;
                                    });
                                    LegacyTabButton.DEPRECATED_ICON_HOLDER_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)go).result().ifPresent(icon -> {
                                        l.iconHolder = icon;
                                    });
                                    Manager.addBannerPatternsFromJson(l.patterns, listingElement);
                                } else {
                                    LoomTabListing listing = new LoomTabListing(id, (Component)JsonUtil.getJsonStringOrNull(go, "displayName", Component::translatable), LegacyTabButton.DEPRECATED_ICON_HOLDER_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)go).result().orElse(null));
                                    Manager.addBannerPatternsFromJson(listing.patterns, listingElement);
                                    map.put((Object)listing.id(), (Object)listing);
                                }
                            }
                        });
                    } else if (element instanceof JsonArray) {
                        JsonArray a = (JsonArray)element;
                        a.forEach(e -> CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(listing -> {
                            if (map.containsKey((Object)listing.id)) {
                                LoomTabListing l = (LoomTabListing)map.get((Object)listing.id);
                                if (listing.name != null) {
                                    l.name = listing.name;
                                }
                                if (listing.iconHolder != null) {
                                    l.iconHolder = listing.iconHolder;
                                }
                                l.patterns.addAll(listing.patterns);
                            } else if (listing.isValid()) {
                                map.put((Object)listing.id, listing);
                            }
                        }));
                    }
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public static void addBannerPatternsFromJson(List<ResourceKey<BannerPattern>> groups, JsonElement element) {
            if (element instanceof JsonArray) {
                JsonArray a = (JsonArray)element;
                a.forEach(e -> {
                    JsonPrimitive p;
                    if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isString()) {
                        groups.add(ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)FactoryAPI.createLocation((String)p.getAsString())));
                    }
                });
            }
        }
    }
}

