/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.util.JsonUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LeaderboardsScreen
extends PanelVListScreen {
    public static final List<StatsBoard> statsBoards = new ArrayList<StatsBoard>();
    public int selectedStatBoard = 0;
    protected int statsInScreen = 0;
    protected int lastStatsInScreen = 0;
    protected int page = 0;
    public static final Component RANK = Component.translatable((String)"legacy.menu.leaderboard.rank");
    public static final Component USERNAME = Component.translatable((String)"legacy.menu.leaderboard.username");
    public static final Component OVERALL = Component.translatable((String)"legacy.menu.leaderboard.filter.overall");
    public static final Component MY_SCORE = Component.translatable((String)"legacy.menu.leaderboard.filter.my_score");
    public static final Component NO_RESULTS = Component.translatable((String)"legacy.menu.leaderboard.no_results");
    protected final Stocker.Sizeable filter = new Stocker.Sizeable(Integer.valueOf(0), 1);
    protected List<LegacyPlayerInfo> actualRankBoard = Collections.emptyList();

    public LeaderboardsScreen(Screen parent) {
        super(parent, 568, 275, CommonComponents.EMPTY);
        this.rebuildRenderableVList(Minecraft.getInstance());
        this.renderableVList.layoutSpacing(l -> 1);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> LegacyComponents.CHANGE_FILTER);
    }

    public static void refreshStatsBoards(Minecraft minecraft) {
        if (minecraft.getConnection() == null) {
            return;
        }
        statsBoards.forEach(StatsBoard::clear);
        if (FactoryAPIClient.hasModOnServer) {
            minecraft.getConnection().getOnlinePlayers().stream().map(p -> ((LegacyPlayerInfo)p).getStatsMap()).forEach(o -> o.forEach((s, i) -> {
                if (i <= 0) {
                    return;
                }
                for (StatsBoard statsBoard : statsBoards) {
                    if (statsBoard.add((Stat<?>)s)) break;
                }
            }));
        } else {
            minecraft.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
            minecraft.player.getStats().stats.forEach((s, i) -> {
                for (StatsBoard statsBoard : statsBoards) {
                    if (statsBoard.add((Stat<?>)s)) break;
                }
            });
        }
    }

    public int changedPage(int count) {
        return Math.max(0, this.page + count >= LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.size() ? this.page : this.page + count);
    }

    public void changeStatBoard(boolean left) {
        int initialSelectedStatBoard = this.selectedStatBoard;
        while ((this.selectedStatBoard = Stocker.cyclic((int)0, (int)(this.selectedStatBoard + (left ? -1 : 1)), (int)statsBoards.size())) != this.selectedStatBoard && this.selectedStatBoard != initialSelectedStatBoard) {
            if (LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) continue;
            this.page = 0;
            this.rebuildRenderableVList(this.minecraft);
            this.repositionElements();
            return;
        }
    }

    @Override
    public boolean keyPressed(int i, int j, int k) {
        int newPage;
        if (i == 88) {
            this.filter.add(1, true);
            this.rebuildRenderableVList(this.minecraft);
            this.repositionElements();
        }
        if (i == 263 || i == 262) {
            this.changeStatBoard(i == 263);
            return true;
        }
        if (!(i != 91 && i != 93 || this.selectedStatBoard >= statsBoards.size() || LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.isEmpty() || (newPage = this.changedPage(i == 91 ? -this.lastStatsInScreen : this.statsInScreen)) == this.page)) {
            this.lastStatsInScreen = this.statsInScreen;
            this.page = newPage;
            return true;
        }
        if (this.renderableVList.keyPressed(i)) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        this.renderableVList.mouseScrolled(g);
        return super.mouseScrolled(d, e, f, g);
    }

    public void rebuildRenderableVList(final Minecraft minecraft) {
        this.renderableVList.renderables.clear();
        if (minecraft.getConnection() == null || LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) {
            return;
        }
        this.actualRankBoard = FactoryAPIClient.hasModOnServer && (Integer)this.filter.get() != 1 ? minecraft.getConnection().getOnlinePlayers().stream().map(p -> (LegacyPlayerInfo)p).filter(info -> info.getStatsMap().object2IntEntrySet().stream().filter(s -> LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.contains(s.getKey())).mapToInt(Object2IntMap.Entry::getIntValue).sum() > 0).sorted((Integer)this.filter.get() == 0 ? Comparator.comparingInt(info -> ((LegacyPlayerInfo)info).getStatsMap().object2IntEntrySet().stream().filter(s -> LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.contains(s.getKey())).mapToInt(Object2IntMap.Entry::getIntValue).sum()).reversed() : Comparator.comparing(l -> l.legacyMinecraft$getProfile().getName())).toList() : List.of((LegacyPlayerInfo)minecraft.getConnection().getPlayerInfo(minecraft.player.getUUID()));
        for (int i = 0; i < this.actualRankBoard.size(); ++i) {
            final LegacyPlayerInfo info2 = this.actualRankBoard.get(i);
            final String rank = "" + (i + 1);
            this.renderableVList.renderables.add((Renderable)new AbstractWidget(0, 0, 551, 20, (Component)Component.literal((String)info2.legacyMinecraft$getProfile().getName())){

                protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                    int n = this.getY();
                    int n2 = this.getHeight();
                    Objects.requireNonNull(LeaderboardsScreen.this.font);
                    int y = n + (n2 - 9) / 2 + 1;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.isHoveredOrFocused() ? LegacySprites.LEADERBOARD_BUTTON_HIGHLIGHTED : LegacySprites.LEADERBOARD_BUTTON, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                    guiGraphics.drawString(LeaderboardsScreen.this.font, rank, this.getX() + 40 - LeaderboardsScreen.this.font.width(rank) / 2, y, ScreenUtil.getDefaultTextColor(!this.isHoveredOrFocused()));
                    guiGraphics.drawString(LeaderboardsScreen.this.font, this.getMessage(), this.getX() + 120 - LeaderboardsScreen.this.font.width((FormattedText)this.getMessage()) / 2, y, ScreenUtil.getDefaultTextColor(!this.isHoveredOrFocused()));
                    guiGraphics.drawString(LeaderboardsScreen.this.font, this.getMessage(), this.getX() + 120 - LeaderboardsScreen.this.font.width((FormattedText)this.getMessage()) / 2, y, ScreenUtil.getDefaultTextColor(!this.isHoveredOrFocused()));
                    int added = 0;
                    Component hoveredValue = null;
                    for (int index = LeaderboardsScreen.this.page; index < LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).statsList.size() && added < LeaderboardsScreen.this.statsInScreen; ++added, ++index) {
                        Stat<?> stat = LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).statsList.get(index);
                        Component value = ControlTooltip.CONTROL_ICON_FUNCTION.apply(stat.format((FactoryAPIClient.hasModOnServer ? info2.getStatsMap() : minecraft.player.getStats().stats).getInt(stat)), Style.EMPTY).getComponent();
                        SimpleLayoutRenderable renderable = LeaderboardsScreen.statsBoards.get((int)LeaderboardsScreen.this.selectedStatBoard).renderables.get(index);
                        int w = LeaderboardsScreen.this.font.width((FormattedText)value);
                        ScreenUtil.renderScrollingString(guiGraphics, LeaderboardsScreen.this.font, value, renderable.getX() + Math.max(0, renderable.getWidth() - w) / 2, this.getY(), renderable.getX() + Math.min(renderable.getWidth(), (renderable.getWidth() - w) / 2 + this.getWidth()), this.getY() + this.getHeight(), ScreenUtil.getDefaultTextColor(!this.isHoveredOrFocused()), true);
                        if (!ScreenUtil.isMouseOver(i, j, renderable.getX() + Math.max(0, renderable.getWidth() - w) / 2, this.getY(), Math.min(renderable.getWidth(), w), this.getHeight())) continue;
                        hoveredValue = value;
                    }
                    if (hoveredValue != null) {
                        guiGraphics.renderTooltip(LeaderboardsScreen.this.font, hoveredValue, i, j);
                    }
                }

                protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                    this.defaultButtonNarrationText(narrationElementOutput);
                }
            });
        }
    }

    @Override
    protected void init() {
        if (FactoryAPIClient.hasModOnServer) {
            CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.askAll((Player)this.minecraft.player));
        } else {
            this.minecraft.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        }
        super.init();
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.addRenderableOnly((guiGraphics, i, j, f) -> {
            ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + 8, this.panel.y - 18, 166, 18);
            ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + (this.panel.width - 211) / 2, this.panel.y - 18, 211, 18);
            ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + this.panel.width - 174, this.panel.y - 18, 166, 18);
            if (!statsBoards.isEmpty() && this.selectedStatBoard < statsBoards.size()) {
                int newWidth;
                StatsBoard board = statsBoards.get(this.selectedStatBoard);
                Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                    guiGraphics.pose().pushPose();
                    MutableComponent filter = Component.translatable((String)"legacy.menu.leaderboard.filter", (Object[])new Object[]{(Integer)this.filter.get() == 0 ? OVERALL : MY_SCORE});
                    guiGraphics.pose().translate((float)(this.panel.x + 91) - (float)this.font.width((FormattedText)filter) / 3.0f, (float)(this.panel.y - 12), 0.0f);
                    if (!b.booleanValue()) {
                        guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                    }
                    guiGraphics.drawString(this.font, (Component)filter, 0, 0, 0xFFFFFF);
                    guiGraphics.pose().popPose();
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)this.panel.x + ((float)this.panel.width - (float)(this.font.width((FormattedText)board.displayName) * 2) / 3.0f) / 2.0f, (float)(this.panel.y - 12), 0.0f);
                    if (!b.booleanValue()) {
                        guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                    }
                    guiGraphics.drawString(this.font, board.displayName, 0, 0, 0xFFFFFF);
                    guiGraphics.pose().popPose();
                    guiGraphics.pose().pushPose();
                    MutableComponent entries = Component.translatable((String)"legacy.menu.leaderboard.entries", (Object[])new Object[]{this.actualRankBoard.size()});
                    guiGraphics.pose().translate((float)(this.panel.x + 477) - (float)this.font.width((FormattedText)entries) / 3.0f, (float)(this.panel.y - 12), 0.0f);
                    if (!b.booleanValue()) {
                        guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                    }
                    guiGraphics.drawString(this.font, (Component)entries, 0, 0, 0xFFFFFF);
                    guiGraphics.pose().popPose();
                });
                if (board.statsList.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)this.panel.x + ((float)this.panel.width - (float)this.font.width((FormattedText)NO_RESULTS) * 1.5f) / 2.0f, (float)this.panel.y + ((float)this.panel.height - 13.5f) / 2.0f, 0.0f);
                    guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                    guiGraphics.drawString(this.font, NO_RESULTS, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    guiGraphics.pose().popPose();
                    return;
                }
                guiGraphics.drawString(this.font, RANK, this.panel.x + 40, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                guiGraphics.drawString(this.font, USERNAME, this.panel.x + 108, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                int totalWidth = 0;
                this.statsInScreen = 0;
                for (int index = this.page; index < board.renderables.size() && (newWidth = totalWidth + board.renderables.get(index).getWidth()) <= 351; ++index) {
                    ++this.statsInScreen;
                    totalWidth = newWidth;
                }
                RenderSystem.enableBlend();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)this.panel.x + (float)(this.panel.width - 211) / 2.0f, (float)(this.panel.y - 12), 0.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                (ControlType.getActiveType().isKbm() ? ControlTooltip.ComponentIcon.compoundOf(ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)) : ControllerBinding.LEFT_STICK.getIcon()).render(guiGraphics, 4, 0, false, false);
                if (this.statsInScreen < LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).renderables.size()) {
                    ControlTooltip.ComponentIcon pageControl = ControlTooltip.ComponentIcon.compoundOf(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon());
                    pageControl.render(guiGraphics, 422 - pageControl.render(guiGraphics, 0, 0, false, true) - 8, 0, false, false);
                }
                guiGraphics.pose().popPose();
                RenderSystem.disableBlend();
                if (this.statsInScreen == 0) {
                    return;
                }
                int x = (351 - totalWidth) / (this.statsInScreen + 1);
                Integer hovered = null;
                for (int index = this.page; index < this.page + this.statsInScreen; ++index) {
                    SimpleLayoutRenderable r = board.renderables.get(index);
                    r.setPosition(this.panel.x + 182 + x, this.panel.y + 22 - r.height / 2);
                    r.render(guiGraphics, i, j, f);
                    if (r.isHovered((double)i, (double)j)) {
                        hovered = index;
                    }
                    x += r.getWidth() + (351 - totalWidth) / this.statsInScreen;
                }
                if (hovered != null) {
                    Component component;
                    Object patt0$temp = board.statsList.get(hovered).getValue();
                    if (patt0$temp instanceof EntityType) {
                        EntityType e = (EntityType)patt0$temp;
                        component = e.getDescription();
                    } else {
                        ItemLike item;
                        Object patt1$temp = board.statsList.get(hovered).getValue();
                        component = patt1$temp instanceof ItemLike && (item = (ItemLike)patt1$temp).asItem() != Items.AIR ? Component.translatable((String)item.asItem().getDescriptionId()) : ControlTooltip.getAction("stat." + board.statsList.get(hovered).getValue().toString().replace(':', '.'));
                    }
                    guiGraphics.renderTooltip(this.font, component, i, j);
                }
            }
        });
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 9, this.panel.y + 39, 551, 226);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public void onStatsUpdated() {
        if (!FactoryAPIClient.hasModOnServer) {
            LeaderboardsScreen.refreshStatsBoards(this.minecraft);
            if (LeaderboardsScreen.statsBoards.get((int)this.selectedStatBoard).statsList.isEmpty()) {
                this.minecraft.executeIfPossible(() -> this.changeStatBoard(false));
            }
        }
    }

    public static class StatsBoard {
        public final Component displayName;
        public final StatType<?> type;
        public final List<Stat<?>> statsList = new ArrayList();
        public List<SimpleLayoutRenderable> renderables = new ArrayList<SimpleLayoutRenderable>();
        public final Map<Predicate, LegacyIconHolder> statIconOverrides = new HashMap<Predicate, LegacyIconHolder>();

        public void clear() {
            this.statsList.clear();
            this.renderables.clear();
        }

        public SimpleLayoutRenderable getRenderable(Stat<?> stat) {
            for (Map.Entry<Predicate, LegacyIconHolder> entry : this.statIconOverrides.entrySet()) {
                if (!entry.getKey().test(stat.getValue())) continue;
                return entry.getValue();
            }
            Object object = stat.getValue();
            if (object instanceof ItemLike) {
                ItemLike i = (ItemLike)object;
                LegacyIconHolder h = new LegacyIconHolder(24, 24);
                h.itemIcon = i.asItem().getDefaultInstance();
                return h;
            }
            object = stat.getValue();
            if (object instanceof EntityType) {
                EntityType e = (EntityType)object;
                return LegacyIconHolder.entityHolder(0, 0, 24, 24, e);
            }
            MutableComponent name = Component.translatable((String)("stat." + stat.getValue().toString().replace(':', '.')));
            return SimpleLayoutRenderable.create((int)(Minecraft.getInstance().font.width((FormattedText)name) * 2 / 3 + 8), (int)7, arg_0 -> StatsBoard.lambda$getRenderable$2((Component)name, arg_0));
        }

        public StatsBoard(StatType<?> type, Component displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public static StatsBoard create(StatType<?> type, Component displayName) {
            return new StatsBoard(type, displayName);
        }

        public static StatsBoard create(StatType<?> type, Component displayName, final Predicate<Stat<?>> canAccept) {
            return new StatsBoard(type, displayName){

                @Override
                public boolean canAdd(Stat<?> stat) {
                    return super.canAdd(stat) && canAccept.test(stat);
                }
            };
        }

        public boolean canAdd(Stat<?> stat) {
            return stat.getType() == this.type;
        }

        public boolean add(Stat<?> stat) {
            if (this.canAdd(stat)) {
                if (!this.statsList.contains(stat)) {
                    this.statsList.add(stat);
                    this.renderables.add(this.getRenderable(stat));
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ Renderable lambda$getRenderable$2(Component name, SimpleLayoutRenderable l) {
            return (guiGraphics, i, j, f) -> Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(l.getX() + 4), (float)l.getY(), 0.0f);
                if (!b.booleanValue()) {
                    guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                }
                guiGraphics.drawString(Minecraft.getInstance().font, name, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                guiGraphics.pose().popPose();
            });
        }
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public static final String LEADERBOARD_LISTING = "leaderboard_listing.json";

        public void onResourceManagerReload(ResourceManager resourceManager) {
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)LEADERBOARD_LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.openAsReader();){
                    JsonObject obj = GsonHelper.parse((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("listing");
                    if (ioElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)ioElement;
                        array.forEach(e -> {
                            if (e instanceof JsonObject) {
                                JsonObject o = (JsonObject)e;
                                statsBoards.add(this.statsBoardFromJson(o));
                            }
                        });
                    }
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        protected StatsBoard statsBoardFromJson(JsonObject o) {
            StatsBoard statsBoard;
            StatType statType = (StatType)FactoryAPIPlatform.getRegistryValue((ResourceLocation)ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)o, (String)"type")), (Registry)BuiltInRegistries.STAT_TYPE);
            Component name = o.has("displayName") ? Component.translatable((String)GsonHelper.getAsString((JsonObject)o, (String)"displayName")) : statType.getDisplayName();
            JsonElement jsonElement = o.get("predicate");
            if (jsonElement instanceof JsonObject) {
                JsonObject predObj = (JsonObject)jsonElement;
                Predicate predicate = JsonUtil.registryMatches(statType.getRegistry(), predObj);
                statsBoard = StatsBoard.create(statType, name, s -> predicate.test(s.getValue()));
            } else {
                statsBoard = StatsBoard.create(statType, name);
            }
            jsonElement = o.get("overrides");
            if (jsonElement instanceof JsonArray) {
                JsonArray a = (JsonArray)jsonElement;
                a.forEach(e -> {
                    JsonObject override;
                    JsonElement patt0$temp;
                    if (e instanceof JsonObject && (patt0$temp = (override = (JsonObject)e).get("type")) instanceof JsonPrimitive) {
                        JsonPrimitive p = (JsonPrimitive)patt0$temp;
                        String type = p.getAsString();
                        Predicate predicate = JsonUtil.registryMatches(statType.getRegistry(), override.getAsJsonObject("predicate"));
                        switch (type) {
                            case "item": {
                                Item item = (Item)FactoryAPIPlatform.getRegistryValue((ResourceLocation)ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)override, (String)"id")), (Registry)BuiltInRegistries.ITEM);
                                LegacyIconHolder h = new LegacyIconHolder(24, 24);
                                h.itemIcon = item.getDefaultInstance();
                                statsBoard.statIconOverrides.put(predicate, h);
                                break;
                            }
                            case "entity_type": {
                                EntityType entityType = (EntityType)FactoryAPIPlatform.getRegistryValue((ResourceLocation)ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)override, (String)"id")), (Registry)BuiltInRegistries.ENTITY_TYPE);
                                statsBoard.statIconOverrides.put(predicate, LegacyIconHolder.entityHolder(0, 0, 24, 24, entityType));
                                break;
                            }
                            case "sprite": {
                                ResourceLocation sprite = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)override, (String)"id"));
                                LegacyIconHolder h = new LegacyIconHolder(24, 24);
                                h.iconSprite = sprite;
                                statsBoard.statIconOverrides.put(predicate, h);
                            }
                        }
                    }
                });
            }
            return statsBoard;
        }

        public String getName() {
            return "legacy:leaderboards_listing";
        }
    }
}

