/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyLoadingScreen
extends Screen
implements LegacyLoading {
    public static LegacyTip actualLoadingTip;
    private int progress;
    private Component loadingHeader;
    private Component loadingStage;
    private boolean genericLoading;
    private UIAccessor accessor = UIAccessor.of((Screen)this);
    protected RandomSource random = RandomSource.create();

    public LegacyLoadingScreen() {
        super(GameNarrator.NO_TITLE);
    }

    public LegacyLoadingScreen(Component loadingHeader, Component loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public void prepareRender(Minecraft minecraft, int width, int height, Component loadingHeader, Component loadingStage, int progress, boolean genericLoading) {
        this.resize(minecraft, width, height);
        this.minecraft = minecraft;
        this.accessor = UIAccessor.of((Screen)minecraft.screen);
        this.setLoadingHeader((Component)this.accessor.getElementValue("loadingHeader.component", (Object)loadingHeader, Component.class));
        this.setLoadingStage((Component)this.accessor.getElementValue("loadingStage.component", (Object)loadingStage, Component.class));
        this.setProgress(this.accessor.getInteger("progress", progress));
        this.setGenericLoading(this.accessor.getBoolean("genericLoading", Boolean.valueOf(genericLoading)));
    }

    public LegacyTip getLoadingTip() {
        if (usingLoadingTips.isEmpty()) {
            if (LegacyTipManager.loadingTips.isEmpty()) {
                return null;
            }
            usingLoadingTips.addAll(LegacyTipManager.loadingTips);
        }
        if (actualLoadingTip == null) {
            int i = this.random.nextInt(usingLoadingTips.size());
            actualLoadingTip = (LegacyTip)((Supplier)usingLoadingTips.get(i)).get();
            usingLoadingTips.remove(i);
        } else if (LegacyLoadingScreen.actualLoadingTip.visibility == Toast.Visibility.HIDE) {
            actualLoadingTip = null;
            return this.getLoadingTip();
        }
        return actualLoadingTip;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        RenderSystem.disableDepthTest();
        super.render(guiGraphics, i, j, f);
        int x = this.width / 2 - 160;
        int y = this.height / 2 + 16;
        ResourceLocation fontOverride = (ResourceLocation)this.accessor.getElementValue("fontOverride", null, ResourceLocation.class);
        if (!this.isGenericLoading()) {
            if (this.getProgress() != -1) {
                LegacyTip tip;
                if (this.getLoadingStage() != null) {
                    Legacy4JClient.applyFontOverrideIf(fontOverride != null, fontOverride, b -> guiGraphics.drawString(this.minecraft.font, this.getLoadingStage(), this.accessor.getInteger("loadingStage.x", x + 1), this.accessor.getInteger("loadingStage.y", this.height / 2 + 5), ((Integer)CommonColor.STAGE_TEXT.get()).intValue()));
                }
                try (SpriteContents contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BACKGROUND).contents();){
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BACKGROUND, x, y, 320, 320 * contents.height() / contents.width());
                }
                if (this.getProgress() >= 0) {
                    contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BAR).contents();
                    try {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BAR, 318, 318 * contents.height() / contents.width(), 0, 0, x + 1, y + 1, 0, (int)(318.0f * Math.max(0.0f, Math.min((float)this.getProgress() / 100.0f, 1.0f))), 318 * contents.height() / contents.width());
                    }
                    finally {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
                if ((tip = this.getLoadingTip()) != null) {
                    tip.setX((this.width - tip.width) / 2);
                    tip.setY(y + 8 + (this.height - (y + 8) - tip.height) / 2);
                    tip.render(guiGraphics, i, j, f);
                }
            }
        } else {
            ScreenUtil.drawGenericLoading(guiGraphics, (this.width - 75) / 2, this.height / 2);
        }
        if (this.getLoadingHeader() != null) {
            Legacy4JClient.applyFontOverrideIf(fontOverride != null, fontOverride, b -> {
                guiGraphics.pose().pushPose();
                float scaleX = this.accessor.getFloat("loadingHeader.scaleX", 2.0f);
                guiGraphics.pose().translate(this.accessor.getFloat("loadingHeader.x", ((float)this.width - (float)this.minecraft.font.width((FormattedText)this.getLoadingHeader()) * scaleX) / 2.0f), this.accessor.getFloat("loadingHeader.y", (float)(this.height / 2 - 23)), 0.0f);
                guiGraphics.pose().scale(scaleX, this.accessor.getFloat("loadingHeader.scaleY", 2.0f), 1.0f);
                ScreenUtil.drawOutlinedString(guiGraphics, this.minecraft.font, this.getLoadingHeader(), 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), this.accessor.getFloat("loadingHeader.outline", 0.5f));
                guiGraphics.pose().popPose();
            });
        }
        RenderSystem.enableDepthTest();
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(ClientLevel lastLevel, ClientLevel newLevel) {
        boolean lastOd = LegacyLoadingScreen.isOtherDimension((Level)lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension((Level)newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((Component)(od || lastOd ? Component.translatable((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName((ResourceKey<Level>)(lastOd ? lastLevel : newLevel).dimension())}) : Component.empty()), (Component)Component.empty());
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(Level level) {
        return level != null && level.dimension() != Level.OVERWORLD;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = Util.getMillis();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (Component)Component.empty()){

            public void tick() {
                if (levelReady.getAsBoolean() || Util.getMillis() - createdTime >= 30000L) {
                    this.minecraft.setScreen(null);
                }
            }

            public boolean isPauseScreen() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public Component getLoadingHeader() {
        return this.loadingHeader;
    }

    @Override
    public void setLoadingHeader(Component loadingHeader) {
        this.loadingHeader = loadingHeader;
    }

    @Override
    public Component getLoadingStage() {
        return this.loadingStage;
    }

    @Override
    public void setLoadingStage(Component loadingStage) {
        this.loadingStage = loadingStage;
    }

    @Override
    public boolean isGenericLoading() {
        return this.genericLoading;
    }

    @Override
    public void setGenericLoading(boolean genericLoading) {
        this.genericLoading = genericLoading;
    }
}

