/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerDetection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.ServerEditScreen;
import wily.legacy.client.screen.ServerOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class ServerRenderableList
extends RenderableVList {
    static final ResourceLocation INCOMPATIBLE = FactoryAPI.createVanillaLocation((String)"server_list/incompatible");
    static final ResourceLocation UNREACHABLE = FactoryAPI.createVanillaLocation((String)"server_list/unreachable");
    static final ResourceLocation PING_1 = FactoryAPI.createVanillaLocation((String)"server_list/ping_1");
    static final ResourceLocation PING_2 = FactoryAPI.createVanillaLocation((String)"server_list/ping_2");
    static final ResourceLocation PING_3 = FactoryAPI.createVanillaLocation((String)"server_list/ping_3");
    static final ResourceLocation PING_4 = FactoryAPI.createVanillaLocation((String)"server_list/ping_4");
    static final ResourceLocation PING_5 = FactoryAPI.createVanillaLocation((String)"server_list/ping_5");
    static final ResourceLocation PINGING_1 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_1");
    static final ResourceLocation PINGING_2 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_2");
    static final ResourceLocation PINGING_3 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_3");
    static final ResourceLocation PINGING_4 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_4");
    static final ResourceLocation PINGING_5 = FactoryAPI.createVanillaLocation((String)"server_list/pinging_5");
    protected static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_server.png");
    static final Component SCANNING_LABEL = Component.translatable((String)"lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.translatable((String)"multiplayer.status.cannot_resolve").withStyle(style -> style.withColor(-65536));
    static final Component CANT_CONNECT_TEXT = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(style -> style.withColor(-65536));
    static final Component INCOMPATIBLE_STATUS = Component.translatable((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_STATUS = Component.translatable((String)"multiplayer.status.no_connection");
    static final Component PINGING_STATUS = Component.translatable((String)"multiplayer.status.pinging");
    static final Component ONLINE_STATUS = Component.translatable((String)"multiplayer.status.online");
    private static final Component LAN_SERVER_HEADER = Component.translatable((String)"lanServer.title");
    private static final Component HIDDEN_ADDRESS_TEXT = Component.translatable((String)"selectServer.hiddenAddress");
    protected final Minecraft minecraft;
    public final ServerList servers;
    @Nullable
    public LanServerDetection.LanServerDetector lanServerDetector;
    public final LanServerDetection.LanServerList lanServerList;
    public List<LanServer> lanServers;

    public ServerRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = Minecraft.getInstance();
        this.servers = new ServerList(this.minecraft);
        this.servers.load();
        this.lanServerList = new LanServerDetection.LanServerList();
        this.updateServers();
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        try {
            this.lanServerDetector = new LanServerDetection.LanServerDetector(this.lanServerList);
            this.lanServerDetector.start();
        }
        catch (Exception exception) {
            Legacy4J.LOGGER.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    public boolean hasOnlineFriends() {
        return false;
    }

    public void added() {
    }

    public void removed() {
        if (this.lanServerDetector != null) {
            this.lanServerDetector.interrupt();
            this.lanServerDetector = null;
        }
    }

    private Component getMultiplayerDisabledReason() {
        if (this.minecraft.allowsMultiplayer()) {
            return null;
        }
        if (this.minecraft.isNameBanned()) {
            return Component.translatable((String)"title.multiplayer.disabled.banned.name");
        }
        BanDetails banDetails = this.minecraft.multiplayerBan();
        if (banDetails != null) {
            return banDetails.expires() != null ? Component.translatable((String)"title.multiplayer.disabled.banned.temporary") : Component.translatable((String)"title.multiplayer.disabled.banned.permanent");
        }
        return Component.translatable((String)"title.multiplayer.disabled");
    }

    public static void drawIcon(GuiGraphics guiGraphics, int i, int j, ResourceLocation resourceLocation) {
        RenderSystem.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(resourceLocation, i + 5, j + 5, 0.0f, 0.0f, 20, 20, 20, 20);
        RenderSystem.disableBlend();
    }

    public void updateServers() {
        this.renderables.clear();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/add_server"), (Component)Component.translatable((String)"legacy.menu.add_server"), c -> this.minecraft.setScreen((Screen)new ServerEditScreen(this.getScreen(PlayGameScreen.class), new ServerData(I18n.get((String)"selectServer.defaultName", (Object[])new Object[0]), "", ServerData.Type.OTHER), true)));
        Component component = this.getMultiplayerDisabledReason();
        Tooltip tooltip = component != null ? Tooltip.create((Component)component) : null;
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/realms"), (Component)Component.translatable((String)"menu.online"), b -> this.minecraft.setScreen((Screen)new RealmsMainScreen(this.getScreen())), tooltip);
        for (int i = 0; i < this.servers.size(); ++i) {
            this.addRenderable((Renderable)new ServerButton(0, 0, 0, 30, i));
        }
        this.updateLANServers();
    }

    public void updateLANServers() {
        if (this.lanServers != null) {
            for (final LanServer lanServer : this.lanServers) {
                AbstractButton lanButton = new AbstractButton(0, 0, 0, 30, (Component)Component.literal((String)lanServer.getMotd())){

                    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                        guiGraphics.drawString(ServerRenderableList.this.minecraft.font, LAN_SERVER_HEADER, this.getX() + 32 + 3, this.getY() + 1, 0xFFFFFF, false);
                        guiGraphics.drawString(ServerRenderableList.this.minecraft.font, lanServer.getMotd(), this.getX() + 32 + 3, this.getY() + 12, -8355712, false);
                        if (ServerRenderableList.this.minecraft.options.hideServerAddress) {
                            guiGraphics.drawString(ServerRenderableList.this.minecraft.font, HIDDEN_ADDRESS_TEXT, this.getX() + 32 + 3, this.getY() + 12 + 11, 0x303030, false);
                        } else {
                            guiGraphics.drawString(ServerRenderableList.this.minecraft.font, lanServer.getAddress(), this.getX() + 32 + 3, this.getY() + 12 + 11, 0x303030, false);
                        }
                    }

                    public void onPress() {
                        if (this.isFocused()) {
                            ServerRenderableList.this.joinLanServer(lanServer);
                        }
                    }

                    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                        this.defaultButtonNarrationText(narrationElementOutput);
                    }
                };
                this.addRenderable((Renderable)lanButton);
                if (!this.getScreen().children.contains(lanButton)) continue;
                this.minecraft.getNarrator().say((Component)Component.translatable((String)"multiplayer.lan.server_found", (Object[])new Object[]{Component.empty().append(LAN_SERVER_HEADER).append(CommonComponents.SPACE).append(lanServer.getMotd())}));
            }
        } else {
            this.addRenderable((Renderable)SimpleLayoutRenderable.create((int)0, (int)30, r -> (guiGraphics, i, j, f) -> {
                int n = r.y;
                int n2 = r.height;
                Objects.requireNonNull(this.minecraft.font);
                int p = n + (n2 - 9) / 2;
                guiGraphics.drawString(this.minecraft.font, SCANNING_LABEL, r.x + (this.listWidth - this.minecraft.font.width((FormattedText)SCANNING_LABEL)) / 2, p, 0xFFFFFF, false);
                String string = LoadingDotsText.get((long)Util.getMillis());
                Font font = this.minecraft.font;
                int n3 = r.x + (this.listWidth - this.minecraft.font.width(string)) / 2;
                Objects.requireNonNull(this.minecraft.font);
                guiGraphics.drawString(font, string, n3, p + 9, -8355712, false);
            }));
        }
    }

    public void joinSelectedServer() {
        Renderable r;
        int i;
        GuiEventListener guiEventListener = this.getScreen().getFocused();
        if (guiEventListener instanceof Renderable && (i = this.renderables.indexOf(r = (Renderable)guiEventListener)) > 0) {
            if (this.servers.size() > i) {
                this.join(this.servers.get(i));
            } else if (this.lanServers != null) {
                this.joinLanServer(this.lanServers.get(i - this.servers.size()));
            }
        }
    }

    private void joinLanServer(LanServer lanServer) {
        this.join(new ServerData(lanServer.getMotd(), lanServer.getAddress(), ServerData.Type.LAN));
    }

    private void join(ServerData serverData) {
        ConnectScreen.startConnecting((Screen)this.getScreen(), (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false, null);
    }

    public class ServerButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final ServerData server;
        public final int serverIndex;
        private byte @Nullable [] lastIconBytes;
        private boolean showOnlinePlayersTooltip;
        @Nullable
        private ResourceLocation statusIcon;
        @Nullable
        private Component statusIconTooltip;
        public final FaviconTexture icon;

        public ServerButton(int i, int j, int k, int l, int serverIndex) {
            super(i, j, k, l, (Component)Component.literal((String)ServerRenderableList.this.servers.get((int)serverIndex).name));
            this.serverIndex = serverIndex;
            this.server = ServerRenderableList.this.servers.get(serverIndex);
            this.icon = FaviconTexture.forServer((TextureManager)ServerRenderableList.this.minecraft.getTextureManager(), (String)this.server.ip);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            byte[] bs;
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.server.state() == ServerData.State.INITIAL) {
                this.server.setState(ServerData.State.PINGING);
                this.server.motd = CommonComponents.EMPTY;
                this.server.status = CommonComponents.EMPTY;
                THREAD_POOL.submit(() -> {
                    try {
                        ServerRenderableList.this.getScreen(PlayGameScreen.class).getPinger().pingServer(this.server, () -> ServerRenderableList.this.minecraft.execute(this::updateServerList), () -> {
                            this.server.setState(this.server.protocol == SharedConstants.getCurrentVersion().getProtocolVersion() ? ServerData.State.SUCCESSFUL : ServerData.State.INCOMPATIBLE);
                            ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                        });
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.server.setState(ServerData.State.UNREACHABLE);
                        this.server.motd = CANT_RESOLVE_TEXT;
                        ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception exception) {
                        this.server.setState(ServerData.State.UNREACHABLE);
                        this.server.motd = CANT_CONNECT_TEXT;
                        ServerRenderableList.this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            guiGraphics.drawString(ServerRenderableList.this.minecraft.font, this.getMessage(), this.getX() + 32 + 3, this.getY() + 3, 0xFFFFFF);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 35), (float)(this.getY() + 10), 0.0f);
            guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
            List list = ServerRenderableList.this.minecraft.font.split((FormattedText)this.server.motd, Math.max(this.width - 36, ServerRenderableList.this.minecraft.font.width((FormattedText)this.server.motd) / 2 + 20));
            for (int p = 0; p < Math.min(2, list.size()); ++p) {
                Font font = ServerRenderableList.this.minecraft.font;
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)list.get(p);
                Objects.requireNonNull(ServerRenderableList.this.minecraft.font);
                Objects.requireNonNull(ServerRenderableList.this.minecraft.font);
                ScreenUtil.renderScrollingString(guiGraphics, font, formattedCharSequence, 0, 9 * p, this.width - 36, 11 + 9 * p, -8355712, false, ServerRenderableList.this.minecraft.font.width((FormattedCharSequence)list.get(p)) * 2 / 3);
            }
            guiGraphics.pose().popPose();
            Component component = !this.isCompatible() ? this.server.version.copy().withStyle(ChatFormatting.RED) : this.server.status;
            int q = ServerRenderableList.this.minecraft.font.width((FormattedText)component);
            guiGraphics.drawString(ServerRenderableList.this.minecraft.font, component, this.getX() + this.width - q - 15 - 2, this.getY() + 3, -8355712, false);
            if (this.pingCompleted()) {
                int p = (int)(Util.getMillis() / 100L + (long)(this.serverIndex * 2) & 7L);
                if (p > 4) {
                    p = 8 - p;
                }
                switch (p) {
                    default: {
                        ResourceLocation resourceLocation = PINGING_1;
                        break;
                    }
                    case 1: {
                        ResourceLocation resourceLocation = PINGING_2;
                        break;
                    }
                    case 2: {
                        ResourceLocation resourceLocation = PINGING_3;
                        break;
                    }
                    case 3: {
                        ResourceLocation resourceLocation = PINGING_4;
                        break;
                    }
                    case 4: {
                        ResourceLocation resourceLocation = this.statusIcon = PINGING_5;
                    }
                }
            }
            if (this.statusIcon != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.statusIcon, this.getX() + this.width - 15, this.getY() + 3, 10, 8);
            }
            if (!Arrays.equals(bs = this.server.getIconBytes(), this.lastIconBytes)) {
                if (this.uploadServerIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.server.setIconBytes(null);
                    this.updateServerList();
                }
            }
            ServerRenderableList.drawIcon(guiGraphics, this.getX(), this.getY(), this.icon.textureLocation());
            int s = mouseX - this.getX();
            int t = mouseY - this.getY();
            if (this.statusIconTooltip != null && s >= this.width - 15 && s <= this.width - 5 && t >= 2 && t <= 10) {
                guiGraphics.renderTooltip(ServerRenderableList.this.minecraft.font, this.statusIconTooltip, mouseX, mouseY);
            } else if (this.showOnlinePlayersTooltip && s >= this.width - q - 15 - 2 && s <= this.width - 15 - 2 && t >= 2 && t <= 10) {
                guiGraphics.renderComponentTooltip(ServerRenderableList.this.minecraft.font, this.server.playerList, mouseX, mouseY);
            }
            if (((Boolean)ServerRenderableList.this.minecraft.options.touchscreen().get()).booleanValue() || this.isHovered) {
                guiGraphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 25, this.getY() + 25, -1601138544);
                int u = mouseX - this.getX();
                int v = mouseY - this.getY();
                if (u < 32 && u > 16) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN_HIGHLIGHTED, this.getX() + 5, this.getY() + 5, 20, 20);
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN, this.getX() + 5, this.getY() + 5, 20, 20);
                }
                if (this.serverIndex > 0) {
                    if (u < 16 && v < 16) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_UP_HIGHLIGHTED, this.getX(), this.getY(), 32, 32);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_UP, this.getX(), this.getY(), 32, 32);
                    }
                }
                if (this.serverIndex < ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().size() - 1) {
                    if (u < 16 && v > 16) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_DOWN_HIGHLIGHTED, this.getX(), this.getY(), 32, 32);
                    } else {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.MOVE_DOWN, this.getX(), this.getY(), 32, 32);
                    }
                }
            }
        }

        public boolean pingCompleted() {
            return this.server.state() == ServerData.State.PINGING;
        }

        public void refreshStatus() {
            this.showOnlinePlayersTooltip = false;
            switch (this.server.state()) {
                case INITIAL: 
                case PINGING: {
                    this.statusIcon = PING_1;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case INCOMPATIBLE: {
                    this.statusIcon = INCOMPATIBLE;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    this.showOnlinePlayersTooltip = true;
                    break;
                }
                case UNREACHABLE: {
                    this.statusIcon = UNREACHABLE;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case SUCCESSFUL: {
                    this.statusIcon = this.server.ping < 150L ? PING_5 : (this.server.ping < 300L ? PING_4 : (this.server.ping < 600L ? PING_3 : (this.server.ping < 1000L ? PING_2 : PINGING_1)));
                    this.statusIconTooltip = Component.translatable((String)"multiplayer.status.ping", (Object[])new Object[]{this.server.ping});
                    this.showOnlinePlayersTooltip = true;
                }
            }
        }

        private boolean isCompatible() {
            return this.server.protocol == SharedConstants.getCurrentVersion().getProtocolVersion();
        }

        public void updateServerList() {
            ServerRenderableList.this.getScreen(PlayGameScreen.class).getServers().save();
        }

        private boolean uploadServerIcon(@Nullable byte[] bs) {
            if (bs == null) {
                this.icon.clear();
            } else {
                try {
                    this.icon.upload(NativeImage.read((byte[])bs));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.server.name, this.server.ip, throwable});
                    return false;
                }
            }
            return true;
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
        }

        public void onClick(double d, double e) {
            double f = d - (double)this.getX();
            double g = e - (double)this.getY();
            if (f <= 32.0) {
                if (f < 16.0 && g < 16.0 && this.serverIndex > 0) {
                    this.swap(this.serverIndex, this.serverIndex - 1);
                    return;
                }
                if (f < 16.0 && g > 16.0 && this.serverIndex < ServerRenderableList.this.servers.size() - 1) {
                    this.swap(this.serverIndex, this.serverIndex + 1);
                    return;
                }
                ServerRenderableList.this.join(this.server);
            } else {
                super.onClick(d, e);
            }
        }

        public void onPress() {
            if (this.isFocused()) {
                ServerRenderableList.this.join(this.server);
            }
        }

        private void swap(int i, int j) {
            Object e;
            ServerRenderableList.this.servers.swap(i, j);
            ServerRenderableList.this.updateServers();
            ServerRenderableList.this.accessor.reloadUI();
            if (j < ServerRenderableList.this.renderables.size() && (e = ServerRenderableList.this.renderables.get(j)) instanceof GuiEventListener) {
                GuiEventListener l = (GuiEventListener)e;
                ServerRenderableList.this.getScreen().setFocused(l);
            }
        }

        public boolean keyPressed(int i, int j, int k) {
            if (Screen.hasShiftDown() && (i == 264 && this.serverIndex < ServerRenderableList.this.servers.size() - 1 || i == 265 && this.serverIndex > 0)) {
                this.swap(this.serverIndex, i == 264 ? this.serverIndex + 1 : this.serverIndex - 1);
                return true;
            }
            if (i == 79) {
                ServerRenderableList.this.minecraft.setScreen((Screen)new ServerOptionsScreen(ServerRenderableList.this.getScreen(PlayGameScreen.class), this.server));
                ServerRenderableList.this.getScreen().setFocused((GuiEventListener)this);
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        protected MutableComponent createNarrationMessage() {
            MutableComponent mutableComponent = Component.empty();
            mutableComponent.append((Component)Component.translatable((String)"narrator.select", (Object[])new Object[]{this.server.name}));
            mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
            switch (this.server.state()) {
                case INCOMPATIBLE: {
                    mutableComponent.append(INCOMPATIBLE_STATUS);
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append((Component)Component.translatable((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.server.version}));
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append((Component)Component.translatable((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.motd}));
                    break;
                }
                case UNREACHABLE: {
                    mutableComponent.append(NO_CONNECTION_STATUS);
                    break;
                }
                case PINGING: {
                    mutableComponent.append(PINGING_STATUS);
                    break;
                }
                default: {
                    mutableComponent.append(ONLINE_STATUS);
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append((Component)Component.translatable((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.server.ping}));
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append((Component)Component.translatable((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.server.motd}));
                    if (this.server.players == null) break;
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append((Component)Component.translatable((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.server.players.online(), this.server.players.max()}));
                    mutableComponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutableComponent.append(ComponentUtils.formatList((Collection)this.server.playerList, (Component)Component.literal((String)", ")));
                }
            }
            return mutableComponent;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.isFocused() ? LegacyComponents.SERVER_OPTIONS : ControlTooltip.getSelectAction((GuiEventListener)this, c));
        }
    }
}

