/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.network.ClientMerchantTradingPayload;

@Mixin(value={AbstractVillager.class})
public abstract class AbstractVillagerMixin
extends AgeableMob {
    @Shadow
    public abstract boolean isClientSide();

    protected AbstractVillagerMixin(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
    }

    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> list) {
        super.onSyncedDataUpdated(list);
        if (this.isClientSide()) {
            CommonNetwork.sendToServer((CommonNetwork.Payload)new ClientMerchantTradingPayload(this.getId(), Optional.empty(), ClientMerchantTradingPayload.ID_C2S));
        }
    }

    @Inject(method={"setTradingPlayer"}, at={@At(value="RETURN")})
    public void setTradingPlayer(Player player, CallbackInfo ci) {
        if (!this.isClientSide()) {
            ClientMerchantTradingPayload.sync((AbstractVillager)this);
        }
    }
}

