/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.util.ArmorStandPose;

@Mixin(value={ArmorStand.class})
public abstract class ArmorStandMixin
extends LivingEntity {
    protected int lastSignal = 0;

    @Shadow
    protected abstract byte setBit(byte var1, int var2, boolean var3);

    protected ArmorStandMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"interactAt"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactAt(Player player, Vec3 vec3, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player.isShiftKeyDown()) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            if (this.level().isClientSide) {
                return;
            }
            ArmorStandPose.getNextPose((ArmorStand)this).applyPose((ArmorStand)this);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        if (this.level().isClientSide) {
            return;
        }
        if (!this.level().isClientSide) {
            BlockPos onPos = this.getOnPos();
            for (Direction dir : Direction.values()) {
                int signal = this.level().getSignal(onPos.relative(dir), dir);
                if (signal <= 0) continue;
                if (this.lastSignal != signal) {
                    this.lastSignal = signal;
                    ArmorStandPose.getActualPose(this.lastSignal).applyPose((ArmorStand)this);
                }
                return;
            }
            this.lastSignal = 0;
        }
    }

    @Redirect(method={"defineSynchedData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData$Builder;define(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;)Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", ordinal=0))
    public SynchedEntityData.Builder defineSynchedData(SynchedEntityData.Builder instance, EntityDataAccessor<Object> i, Object arg) {
        Object object;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            object = this.setBit((Byte)arg, 4, l.getGameRules().getBoolean(LegacyGameRules.DEFAULT_SHOW_ARMOR_STANDS_ARMS));
        } else {
            object = arg;
        }
        return instance.define(i, object);
    }
}

